/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.interview.ErrorQuestion;
import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.interview.wizard.WizPane;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.exec.CE_View;
import com.sun.javatest.tool.UIFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.help.CSH;
import javax.help.JHelpContentViewer;
import javax.help.Map;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

class CE_FullView
extends CE_View {
    private JMenu searchMenu;
    private WizPane wizPane;
    private JTextField msgField;
    private String completeMsg;
    private String incompleteMsg;
    private JButton backBtn;
    private JButton nextBtn;
    private JButton lastBtn;
    private Listener localListener = new Listener();
    private static final String BACK = "back";
    private static final String NEXT = "next";
    private static final String LAST = "last";
    private static final String FIND = "find";
    private static final String FIND_NEXT = "findNext";

    CE_FullView(InterviewParameters config, JHelpContentViewer infoPanel, UIFactory uif, ActionListener l) {
        super(config, infoPanel, uif, l);
        this.initGUI();
    }

    JMenu getMarkerMenu() {
        return this.wizPane.getMarkerMenu();
    }

    JMenu getSearchMenu() {
        return this.searchMenu;
    }

    boolean isOKToClose() {
        return true;
    }

    void load() {
        this.wizPane.setMarkersEnabled(this.config.getMarkersEnabled());
        this.wizPane.setMarkersFilterEnabled(this.config.getMarkersFilterEnabled());
    }

    void save() {
        this.wizPane.prepareClosing();
        this.wizPane.save();
        this.config.setMarkersEnabled(this.wizPane.getMarkersEnabled());
        this.config.setMarkersFilterEnabled(this.wizPane.getMarkersFilterEnabled());
    }

    void refresh() {
        this.config.updatePath();
    }

    boolean isTagVisible() {
        return this.wizPane.isTagVisible();
    }

    void setTagVisible(boolean v) {
        this.wizPane.setTagVisible(v);
    }

    private void initGUI() {
        this.setName("full");
        CSH.setHelpIDString(this, "confEdit.fullView.csh");
        String[] searchMenuItems = new String[]{FIND, FIND_NEXT};
        this.searchMenu = this.uif.createMenu("ce.search", searchMenuItems, this.localListener);
        this.setLayout(new BorderLayout());
        this.initBody();
        this.initButtons();
    }

    private void initBody() {
        this.wizPane = new WizPane(this.config, false);
        this.wizPane.setHelpPrefix("confEdit.");
        this.wizPane.setHelpBroker(this.uif.getHelpBroker());
        this.wizPane.addAncestorListener(this.localListener);
        this.add((Component)this.wizPane, "Center");
    }

    protected void setCustomRenderers(Map customRenderers) {
        this.wizPane.setCustomRenderers(customRenderers);
    }

    private void initButtons() {
        JPanel btnPanel = this.uif.createPanel("ce.full.btns", new GridBagLayout(), false);
        GridBagConstraints c = new GridBagConstraints();
        c.insets.top = 5;
        c.insets.bottom = 11;
        c.insets.right = 5;
        c.insets.left = 11;
        c.fill = 2;
        c.weightx = 1.0;
        this.msgField = this.uif.createOutputField("ce.msgs");
        this.msgField.setBorder(null);
        this.msgField.setEnabled(false);
        this.completeMsg = this.uif.getI18NString("ce.msgs.complete");
        this.incompleteMsg = this.uif.getI18NString("ce.msgs.incomplete");
        btnPanel.add((Component)this.msgField, c);
        c.weightx = 0.0;
        c.insets.left = 0;
        this.backBtn = this.uif.createButton("ce.full.back", this.localListener, BACK);
        this.backBtn.setIcon(this.uif.createIcon("ce.full.back"));
        this.backBtn.setHorizontalTextPosition(11);
        btnPanel.add((Component)this.backBtn, c);
        this.nextBtn = this.uif.createButton("ce.full.next", this.localListener, NEXT);
        this.nextBtn.setIcon(this.uif.createIcon("ce.full.next"));
        this.nextBtn.setHorizontalTextPosition(10);
        btnPanel.add((Component)this.nextBtn, c);
        this.lastBtn = this.uif.createButton("ce.full.last", this.localListener, LAST);
        this.lastBtn.setIcon(this.uif.createIcon("ce.full.last"));
        this.lastBtn.setHorizontalTextPosition(10);
        btnPanel.add((Component)this.lastBtn, c);
        c.insets.left = 20;
        c.insets.right = 11;
        JButton doneBtn = this.uif.createButton("ce.done", this.listener, "done");
        btnPanel.add((Component)doneBtn, c);
        this.add((Component)btnPanel, "South");
    }

    private void showInfoForQuestion(Question q) {
        if (q instanceof ErrorQuestion) {
            return;
        }
        Map.ID id = q.getHelpID();
        if (id == null) {
            System.err.println("WARNING: no help for " + q.getKey());
        } else {
            this.showInfo(id);
        }
    }

    public void prepareClosing() {
        this.wizPane.prepareClosing();
    }

    private class Listener
    implements ActionListener,
    AncestorListener,
    Interview.Observer {
        private Listener() {
        }

        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (cmd.equals(CE_FullView.NEXT)) {
                if (CE_FullView.this.wizPane.getMarkersFilterEnabled()) {
                    CE_FullView.this.wizPane.nextVisible();
                } else {
                    CE_FullView.this.wizPane.next();
                }
            } else if (cmd.equals(CE_FullView.BACK)) {
                if (CE_FullView.this.wizPane.getMarkersFilterEnabled()) {
                    CE_FullView.this.wizPane.prevVisible();
                } else {
                    CE_FullView.this.wizPane.prev();
                }
            } else if (cmd.equals(CE_FullView.LAST)) {
                if (CE_FullView.this.wizPane.getMarkersFilterEnabled()) {
                    CE_FullView.this.wizPane.lastVisible();
                } else {
                    CE_FullView.this.wizPane.last();
                }
            } else if (cmd.equals(CE_FullView.FIND)) {
                CE_FullView.this.wizPane.find();
            } else if (cmd.equals(CE_FullView.FIND_NEXT)) {
                CE_FullView.this.wizPane.findNext();
            }
        }

        public void ancestorAdded(AncestorEvent e) {
            CE_FullView.this.config.addObserver(this);
            this.pathUpdated();
            this.currentQuestionChanged(CE_FullView.this.config.getCurrentQuestion());
        }

        public void ancestorMoved(AncestorEvent e) {
        }

        public void ancestorRemoved(AncestorEvent e) {
            CE_FullView.this.config.removeObserver(this);
        }

        public void pathUpdated() {
            String msg;
            String string = msg = CE_FullView.this.config.isFinishable() ? CE_FullView.this.completeMsg : CE_FullView.this.incompleteMsg;
            if (msg == null || msg.length() == 0) {
                CE_FullView.this.msgField.setEnabled(false);
                CE_FullView.this.msgField.setText("");
            } else {
                CE_FullView.this.msgField.setEnabled(true);
                CE_FullView.this.msgField.setText(msg);
            }
        }

        public void currentQuestionChanged(Question q) {
            boolean first = CE_FullView.this.config.isFirst(q);
            boolean last = CE_FullView.this.config.isLast(q);
            CE_FullView.this.backBtn.setEnabled(!first);
            CE_FullView.this.nextBtn.setEnabled(!last);
            CE_FullView.this.lastBtn.setEnabled(!last);
            if (CE_FullView.this.isInfoVisible()) {
                CE_FullView.this.showInfoForQuestion(q);
            }
        }
    }
}

