/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.services;

import com.sun.javatest.services.Term;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ParametrizeValue {
    private List<Term> terms = new LinkedList<Term>();
    private int varNumb = 0;

    public ParametrizeValue() {
    }

    public ParametrizeValue(String constValue) {
        this();
        Term t = new Term();
        t.setValue(constValue, false);
        this.terms.add(t);
    }

    public void setValue(List<Term> newValue) {
        this.terms = newValue;
        this.varNumb = 0;
        for (Term t : this.terms) {
            if (!t.isVariable()) continue;
            ++this.varNumb;
        }
    }

    public List<Term> getTerms() {
        return this.terms;
    }

    public void addTerm(Term t) {
        this.terms.add(t);
        this.varNumb += t.isVariable() ? 1 : 0;
    }

    public ParametrizeValue copy() {
        ParametrizeValue copy = new ParametrizeValue();
        copy.varNumb = this.varNumb;
        for (Term t : this.terms) {
            Term tcopy = new Term();
            tcopy.setValue(t.getValue(), t.isVariable());
            copy.terms.add(tcopy);
        }
        return copy;
    }

    public void replace(String key, String value) {
        for (Term t : this.terms) {
            if (!t.isVariable() || !t.getValue().equals(key)) continue;
            t.setValue(value, false);
            --this.varNumb;
        }
    }

    public boolean resolved() {
        return this.varNumb == 0;
    }

    public String stringValue() {
        if (this.varNumb != 0) {
            return null;
        }
        String res = "";
        for (Term t : this.terms) {
            res = res + t.getValue();
        }
        return res;
    }
}

