/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.InterviewParameters;
import com.sun.javatest.JavaTestError;
import com.sun.javatest.TestSuite;
import com.sun.javatest.tool.ColorPrefsPane;
import com.sun.javatest.tool.Command;
import com.sun.javatest.tool.CommandContext;
import com.sun.javatest.tool.DeskView;
import com.sun.javatest.tool.DesktopPrefsPane;
import com.sun.javatest.tool.FileOpener;
import com.sun.javatest.tool.MDIDeskView;
import com.sun.javatest.tool.ManagerLoader;
import com.sun.javatest.tool.Preferences;
import com.sun.javatest.tool.SDIDeskView;
import com.sun.javatest.tool.TabDeskView;
import com.sun.javatest.tool.Tool;
import com.sun.javatest.tool.ToolManager;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.BackupPolicy;
import com.sun.javatest.util.HTMLWriter;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.LogFile;
import com.sun.javatest.util.SortedProperties;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.help.CSH;
import javax.help.DefaultHelpBroker;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.help.JHelp;
import javax.help.WindowPresentation;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.ServiceUI;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;

public class Desktop {
    private static final int CLOSE = 0;
    private static final int EXIT = 1;
    private JDialog confirmDialog;
    public static final int TAB_STYLE = 0;
    public static final int MDI_STYLE = 1;
    public static final int SDI_STYLE = 2;
    static final int NUM_STYLES = 3;
    static final String[] styleNames = new String[]{"tab", "mdi", "sdi"};
    private static final String[] jt31StyleClassNames = new String[]{"com.sun.javatest.tool.TabDesktop", "com.sun.javatest.tool.MDIDesktop", "com.sun.javatest.tool.SDIDesktop"};
    private final UIFactory uif;
    private CommandContext commandContext;
    private DeskView currView;
    private int style;
    private Preferences.Pane prefsPane;
    private Preferences.Pane colorPane;
    private ToolManager[] toolManagers;
    private DefaultHelpBroker helpBroker;
    private LogFile logFile;
    private boolean firstTime;
    private boolean saveOnExit;
    private PrintRequestAttributeSet printAttrs;
    private LinkedList fileHistory = new LinkedList();
    private static final int FILE_HISTORY_MAX_SIZE = 10;
    private static Preferences preferences = Preferences.access();
    static final String STYLE_PREF = "tool.appearance.style";
    static final String TTIP_PREF = "tool.appearance.ttipToggle";
    static final String TTIP_DELAY = "tool.appearance.ttipDelay";
    static final String TTIP_DURATION = "tool.appearance.ttipDuration";
    static final int TTIP_DURATION_FOREVER = -1;
    static final int TTIP_DELAY_NONE = 0;
    static final int TTIP_DELAY_DEFAULT = 0;
    static final int TTIP_DURATION_DEFAULT = 5000;
    static final String SAVE_ON_EXIT_PREF = "tool.appearance.saveOnExit";
    private static final String TOOLMGRLIST = "JavaTest.toolMgrs.lst";
    private static final String defaultToolManager = System.getProperty("javatest.desktop.defaultToolManager", "com.sun.javatest.exec.ExecToolManager");

    public Desktop() {
        this(Desktop.getPreferredStyle());
    }

    public Desktop(CommandContext ctx) {
        this(Desktop.getPreferredStyle(), ctx);
    }

    public Desktop(int style, CommandContext ctx) {
        this.commandContext = ctx;
        String val = preferences.getPreference(TTIP_PREF);
        boolean t = val == null || val.equalsIgnoreCase("true");
        this.setTooltipsEnabled(t);
        int delay = Desktop.getTooltipDelay(preferences);
        this.setTooltipDelay(delay);
        int duration = Desktop.getTooltipDuration(preferences);
        this.setTooltipDuration(duration);
        String soe = preferences.getPreference(SAVE_ON_EXIT_PREF);
        this.setSaveOnExit(soe == null || "true".equalsIgnoreCase(soe));
        File f = Desktop.getDesktopFile();
        this.firstTime = f == null || !f.exists();
        this.initHelpBroker();
        if (System.getProperty("systemLAF") != null) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception e) {
                System.out.println("Error setting native LAF: " + e);
            }
        }
        this.uif = new UIFactory(this.getClass(), (HelpBroker)this.helpBroker);
        this.initToolManagers();
        this.style = style;
    }

    public Desktop(int style) {
        this(style, null);
    }

    public int getStyle() {
        return this.currView == null ? this.style : this.currView.getStyle();
    }

    public static int getPreferredStyle() {
        return 0;
    }

    public void setStyle(int style) {
        if (style == this.getStyle()) {
            return;
        }
        if (this.currView == null) {
            this.style = style;
            return;
        }
        DeskView oldView = this.currView;
        switch (style) {
            case 1: {
                this.currView = new MDIDeskView(oldView);
                break;
            }
            case 2: {
                this.currView = new SDIDeskView(oldView);
                break;
            }
            case 0: {
                this.currView = new TabDeskView(oldView);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        oldView.dispose();
    }

    public HelpBroker getHelpBroker() {
        return this.helpBroker;
    }

    public boolean isFirstTime() {
        return this.firstTime;
    }

    public void setFirstTime(boolean b) {
        this.firstTime = b;
    }

    public boolean isEmpty() {
        return this.currView == null ? true : this.currView.isEmpty();
    }

    public Tool[] getTools() {
        return this.currView == null ? new Tool[]{} : this.currView.getTools();
    }

    public void addTool(Tool t) {
        this.ensureViewInitialized();
        this.currView.addTool(t);
    }

    public void removeTool(Tool t) {
        if (this.currView != null) {
            this.currView.removeTool(t);
        }
    }

    public Tool getSelectedTool() {
        return this.currView == null ? null : this.currView.getSelectedTool();
    }

    public void setSelectedTool(Tool t) {
        this.ensureViewInitialized();
        this.currView.setSelectedTool(t);
    }

    public void addDefaultTool() {
        if (!EventQueue.isDispatchThread()) {
            Desktop.invokeOnEventThread(new Runnable(){

                public void run() {
                    Desktop.this.addDefaultTool();
                }
            });
            return;
        }
        for (int i = 0; i < this.toolManagers.length; ++i) {
            ToolManager m = this.toolManagers[i];
            if (!m.getClass().getName().equals(defaultToolManager)) continue;
            m.startTool();
            return;
        }
    }

    public void addDefaultTool(InterviewParameters ip) {
        for (int i = 0; i < this.toolManagers.length; ++i) {
            ToolManager mgr = this.toolManagers[i];
            if (!mgr.getClass().getName().equals(defaultToolManager)) continue;
            try {
                Method m = mgr.getClass().getMethod("startTool", InterviewParameters.class);
                m.invoke((Object)mgr, ip);
                return;
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                continue;
            }
            catch (InvocationTargetException e) {
                Desktop.unwrap(e).printStackTrace();
            }
        }
    }

    public boolean containsTool(Tool t) {
        Tool[] tools = this.getTools();
        for (int i = 0; i < tools.length; ++i) {
            if (t != tools[i]) continue;
            return true;
        }
        return false;
    }

    public ToolManager[] getToolManagers() {
        return this.toolManagers;
    }

    public ToolManager getToolManager(Class c) {
        for (int i = 0; i < this.toolManagers.length; ++i) {
            ToolManager m = this.toolManagers[i];
            if (!c.isInstance(m)) continue;
            return m;
        }
        return null;
    }

    public ToolManager getToolManager(String className) {
        for (int i = 0; i < this.toolManagers.length; ++i) {
            ToolManager m = this.toolManagers[i];
            if (!m.getClass().getName().equals(className)) continue;
            return m;
        }
        return null;
    }

    public JFrame[] getFrames() {
        this.ensureViewInitialized();
        return this.currView.getFrames();
    }

    public Component getDialogParent() {
        this.ensureViewInitialized();
        return this.currView.getDialogParent();
    }

    public void addToFileHistory(File f, FileOpener fo) {
        Iterator i = this.fileHistory.iterator();
        while (i.hasNext()) {
            FileHistoryEntry h = (FileHistoryEntry)i.next();
            if (h.fileOpener != fo || !h.file.equals(f)) continue;
            i.remove();
            break;
        }
        this.fileHistory.addFirst(new FileHistoryEntry(fo, f));
        while (this.fileHistory.size() > 10) {
            this.fileHistory.removeLast();
        }
    }

    List getFileHistory() {
        return this.fileHistory;
    }

    public boolean isVisible() {
        return this.currView == null ? false : this.currView.isVisible();
    }

    public void setVisible(final boolean b) {
        if (!EventQueue.isDispatchThread()) {
            Desktop.invokeOnEventThread(new Runnable(){

                public void run() {
                    Desktop.this.setVisible(b);
                }
            });
            return;
        }
        this.ensureViewInitialized();
        this.currView.setVisible(b);
    }

    public Container createDialog(Tool tool, String uiKey, String title, JMenuBar menuBar, Container body, Rectangle bounds) {
        this.ensureViewInitialized();
        return this.currView.createDialog(tool, uiKey, title, menuBar, body, bounds);
    }

    public boolean isToolOwnerForDialog(Tool tool, Container dialog) {
        this.ensureViewInitialized();
        return this.currView.isToolOwnerForDialog(tool, dialog);
    }

    public void checkToolsAndExitIfOK(JFrame parent) {
        if (this.isOKToExit(parent)) {
            boolean saveOnExit = this.getSaveOnExit();
            if (saveOnExit) {
                this.save();
            } else {
                File f = Desktop.getDesktopFile();
                if (f != null && f.exists()) {
                    f.delete();
                }
            }
            this.dispose();
        }
    }

    public boolean isOKToClose(Tool t, JFrame parent) {
        if (this.confirmDialog != null) {
            Toolkit.getDefaultToolkit().beep();
            this.confirmDialog.toFront();
            return false;
        }
        String[] alerts = t.getCloseAlerts();
        if (alerts == null || alerts.length == 0) {
            return true;
        }
        return this.isOKToExitOrClose(parent, alerts, 0);
    }

    public boolean isOKToExit(JFrame parent) {
        if (this.confirmDialog != null) {
            Toolkit.getDefaultToolkit().beep();
            this.confirmDialog.toFront();
            return false;
        }
        Vector<String> v = new Vector<String>();
        Tool[] tools = this.getTools();
        for (int ti = 0; ti < tools.length; ++ti) {
            String[] alerts = tools[ti].getCloseAlerts();
            if (alerts == null) continue;
            v.addAll(Arrays.asList(alerts));
        }
        if (v.size() == 0) {
            return true;
        }
        Object[] allAlerts = new String[v.size()];
        v.copyInto(allAlerts);
        return this.isOKToExitOrClose(parent, (String[])allAlerts, 1);
    }

    private boolean isOKToExitOrClose(JFrame parent, String[] alerts, int mode) {
        if (this.confirmDialog != null) {
            Toolkit.getDefaultToolkit().beep();
            this.confirmDialog.toFront();
            return false;
        }
        Integer m = new Integer(mode);
        if (alerts.length > 0) {
            StringWriter sw = new StringWriter();
            try {
                HTMLWriter out = new HTMLWriter((Writer)sw, this.uif.getI18NResourceBundle());
                out.startTag("html");
                out.startTag("body");
                out.writeStyleAttr("font-family: SansSerif");
                out.startTag("p");
                out.writeStyleAttr("margin-top:0");
                out.startTag("b");
                out.writeI18N("dt.confirm.head", m);
                out.endTag("b");
                out.endTag("p");
                out.startTag("p");
                out.startTag("i");
                out.writeI18N("dt.confirm.warn", m);
                out.endTag("i");
                out.endTag("p");
                out.startTag("ul");
                out.writeStyleAttr("margin-top:0; margin-bottom:0; margin-left:30");
                for (int i = 0; i < alerts.length; ++i) {
                    out.startTag("li");
                    out.write(alerts[i]);
                }
                out.endTag("ul");
                out.startTag("p");
                out.writeStyleAttr("margin-top:5");
                out.writeI18N("dt.confirm.warn2", m);
                out.endTag("p");
                out.startTag("p");
                out.writeStyleAttr("margin-bottom:0");
                out.writeI18N("dt.confirm.tail", m);
                out.endTag("p");
                out.endTag("body");
                out.endTag("html");
                out.close();
            }
            catch (IOException e) {
                JavaTestError.unexpectedException(e);
            }
            JEditorPane body = new JEditorPane();
            body.setOpaque(false);
            body.setContentType("text/html");
            body.setText(sw.toString());
            body.setEditable(false);
            body.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            body.setSize(new Dimension(5 * this.uif.getDotsPerInch(), Integer.MAX_VALUE));
            String title = this.uif.getI18NString("dt.confirm.title", m);
            final JOptionPane pane = new JOptionPane(body, 2);
            ActionListener l = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    pane.setValue(e.getSource());
                    pane.setVisible(false);
                }
            };
            JButton yesBtn = this.uif.createButton("dt.confirm.yes", l);
            JButton noBtn = this.uif.createButton("dt.confirm.no", l);
            pane.setOptions(new JComponent[]{yesBtn, noBtn});
            pane.setInitialValue(noBtn);
            this.confirmDialog = pane.createDialog(parent, title);
            this.confirmDialog.setVisible(true);
            this.confirmDialog.dispose();
            this.confirmDialog = null;
            if (pane.getValue() != yesBtn) {
                return false;
            }
        }
        return true;
    }

    public boolean isOKToAutoExit() {
        int delay = 30;
        final JTextArea body = new JTextArea();
        body.setOpaque(false);
        body.setText(this.uif.getI18NString("dt.autoExit.txt", new Integer(30)));
        body.setEditable(false);
        body.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        body.setSize(new Dimension(4 * this.uif.getDotsPerInch(), Integer.MAX_VALUE));
        final JOptionPane pane = new JOptionPane(body, 2, 2);
        String title = this.uif.getI18NString("dt.confirm.title", new Integer(1));
        final JDialog dialog = pane.createDialog(null, title);
        Timer timer = new Timer(1000, new ActionListener(){
            private int timeRemaining = 30;

            public void actionPerformed(ActionEvent e) {
                if (--this.timeRemaining == 0) {
                    pane.setValue(new Integer(0));
                    dialog.setVisible(false);
                } else {
                    body.setText(Desktop.this.uif.getI18NString("dt.autoExit.txt", new Integer(this.timeRemaining)));
                }
            }
        });
        timer.start();
        dialog.setVisible(true);
        timer.stop();
        Object value = pane.getValue();
        return value != null && value.equals(new Integer(0));
    }

    public void save() {
        this.save(Desktop.getDesktopFile());
    }

    public void save(File f) {
        if (f == null) {
            return;
        }
        SortedProperties p = new SortedProperties();
        int s = this.getStyle();
        if (s < 3) {
            p.put("dt.style", styleNames[s]);
            p.put("dt.class", jt31StyleClassNames[s]);
        }
        this.ensureViewInitialized();
        this.currView.saveDesktop(p);
        Preferences.access().save();
        p.put("file.count", String.valueOf(this.fileHistory.size()));
        int n = 0;
        for (FileHistoryEntry h : this.fileHistory) {
            p.put("fileHistory." + n + ".type", h.fileOpener.getFileType());
            p.put("fileHistory." + n + ".path", h.file.getPath());
            ++n;
        }
        if (this.helpBroker != null) {
            p.put("help.visible", String.valueOf(this.helpBroker.isDisplayed()));
            if (this.helpBroker.getCurrentView() != null) {
                p.put("help.view", this.helpBroker.getCurrentView());
            }
            if (this.helpBroker.getCurrentID() != null) {
                p.put("help.id", this.helpBroker.getCurrentID().id);
            }
        }
        try {
            File dir = f.getParentFile();
            if (dir != null && !dir.exists()) {
                dir.mkdirs();
            }
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(f));
            p.store(out, "JT Harness Desktop");
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            System.err.println(this.uif.getI18NString("dt.cantWriteDt.txt", e.getMessage()));
        }
    }

    public void restore() {
        this.restore(Desktop.getDesktopFile());
    }

    public void restore(File file) {
        Properties p = Desktop.getPreviousDesktop(file);
        this.restore0(p);
    }

    public void restoreHistory() {
        this.restoreHistory(Desktop.getPreviousDesktop(Desktop.getDesktopFile()));
    }

    private void restore0(final Properties p) {
        Tool[] tools;
        Tool t;
        int savedStyle;
        String s;
        if (!EventQueue.isDispatchThread()) {
            Desktop.invokeOnEventThread(new Runnable(){

                public void run() {
                    Desktop.this.restore0(p);
                }
            });
            return;
        }
        this.restoreHistory(p);
        if (this.helpBroker != null) {
            try {
                String id;
                String view = (String)p.get("help.view");
                if (view != null) {
                    this.helpBroker.setCurrentView(view);
                }
                if ((id = (String)p.get("help.id")) != null) {
                    this.helpBroker.setCurrentID(id);
                }
                this.helpBroker.setDisplayed("true".equals(p.get("help.visible")));
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        if (this.currView != null) {
            this.style = this.currView.getStyle();
            this.currView.dispose();
        }
        if ((s = (String)p.get("dt.style")) != null) {
            savedStyle = Desktop.indexOf(s, styleNames);
        } else {
            String c = (String)p.get("dt.class");
            int n = savedStyle = c == null ? -1 : Desktop.indexOf(c, jt31StyleClassNames);
        }
        if (savedStyle != -1) {
            this.style = savedStyle;
        }
        this.ensureViewInitialized();
        this.currView.restoreDesktop(p);
        if (this.getTools().length == 0) {
            this.addDefaultTool();
        }
        if ((t = this.getSelectedTool()) == null && (tools = this.getTools()).length > 0) {
            t = tools[0];
        }
        if (t != null) {
            this.setSelectedTool(t);
        }
        this.setVisible(true);
    }

    private void restoreHistory(Properties p) {
        FileOpener fo;
        HashMap<String, FileOpener> allOpeners = new HashMap<String, FileOpener>();
        for (int i = 0; i < this.toolManagers.length; ++i) {
            ToolManager m = this.toolManagers[i];
            FileOpener[] mgrOpeners = m.getFileOpeners();
            if (mgrOpeners == null) continue;
            for (int j = 0; j < mgrOpeners.length; ++j) {
                fo = mgrOpeners[j];
                allOpeners.put(fo.getFileType(), fo);
            }
        }
        try {
            this.fileHistory.clear();
            String c = (String)p.get("file.count");
            if (c != null) {
                int count = Integer.parseInt(c);
                for (int i = 0; i < count; ++i) {
                    try {
                        String path;
                        String ft = (String)p.get("fileHistory." + i + ".type");
                        fo = (FileOpener)allOpeners.get(ft);
                        if (fo == null || (path = (String)p.get("fileHistory." + i + ".path")) == null || path.length() <= 0) continue;
                        this.fileHistory.add(new FileHistoryEntry(fo, new File(path)));
                        continue;
                    }
                    catch (Throwable e) {
                        System.err.println(this.uif.getI18NString("dt.cantLoadHist.txt"));
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    static Properties getPreviousDesktop(File file) {
        if (file == null) {
            file = Desktop.getDesktopFile();
        }
        Properties p = new Properties();
        if (file != null && file.exists()) {
            try {
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
                p.load(in);
                ((InputStream)in).close();
            }
            catch (IOException e) {
                System.err.println("Error reading desktop file: " + e);
            }
        }
        return p;
    }

    public void showPreferences(JFrame parent) {
        if (this.prefsPane == null) {
            this.prefsPane = new DesktopPrefsPane(this, this.uif);
        }
        if (this.colorPane == null) {
            this.colorPane = new ColorPrefsPane(this.uif);
        }
        Vector<Preferences.Pane> v = new Vector<Preferences.Pane>();
        v.addElement(this.prefsPane);
        v.addElement(this.colorPane);
        for (int i = 0; i < this.toolManagers.length; ++i) {
            ToolManager m = this.toolManagers[i];
            Preferences.Pane p = m.getPrefsPane();
            if (p == null) continue;
            v.addElement(p);
        }
        Preferences.Pane[] custom = this.getCustomPreferences();
        if (custom != null) {
            for (int i = 0; i < custom.length; ++i) {
                v.add(custom[i]);
            }
        }
        Object[] panes = new Preferences.Pane[v.size()];
        v.copyInto(panes);
        preferences.showDialog(parent, (Preferences.Pane[])panes, this.helpBroker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Preferences.Pane[] getCustomPreferences() {
        ArrayList<Preferences.Pane> al = new ArrayList<Preferences.Pane>();
        HashSet<String> customPrefsClasses = new HashSet<String>();
        Tool[] tools = this.getTools();
        for (int i = 0; i < tools.length; ++i) {
            TestSuite[] tss = tools[i].getLoadedTestSuites();
            if (tss == null || tss.length <= 0) continue;
            for (int j = 0; j < tss.length; ++j) {
                if (customPrefsClasses.contains(tss[j].getID())) continue;
                customPrefsClasses.add(tss[j].getID());
                String cls = tss[j].getTestSuiteInfo("prefsPane");
                try {
                    if (cls == null) continue;
                    Preferences.Pane pane = (Preferences.Pane)Class.forName(cls, true, tss[j].getClassLoader()).newInstance();
                    al.add(pane);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                continue;
            }
        }
        if (al.size() > 0) {
            Preferences.Pane[] panes = new Preferences.Pane[al.size()];
            al.toArray(panes);
            return panes;
        }
        return null;
    }

    public Icon getLogo() {
        return this.uif.createIcon("dt.logo");
    }

    public void dispose() {
        if (this.currView != null) {
            this.currView.dispose();
        }
        if (this.helpBroker != null && this.helpBroker.isDisplayed()) {
            this.helpBroker.setDisplayed(false);
        }
    }

    public void log(I18NResourceBundle i18n, String key) {
        this.ensureLogFileInitialized();
        this.logFile.log(i18n, key);
    }

    public void log(I18NResourceBundle i18n, String key, Object arg) {
        this.ensureLogFileInitialized();
        this.logFile.log(i18n, key, arg);
    }

    public void log(I18NResourceBundle i18n, String key, Object[] args) {
        this.ensureLogFileInitialized();
        this.logFile.log(i18n, key, args);
    }

    private void ensureLogFileInitialized() {
        if (this.logFile == null) {
            File f;
            String s = System.getProperty("javatest.desktop.log");
            if (s == null) {
                File jtDir = Preferences.getPrefsDir();
                f = new File(jtDir, "log.txt");
            } else {
                f = s.equals("NONE") ? null : new File(s);
            }
            try {
                BackupPolicy p = BackupPolicy.simpleBackups(5);
                p.backup(f);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.logFile = f == null ? new LogFile() : new LogFile(f);
        }
    }

    public boolean getSaveOnExit() {
        return this.saveOnExit;
    }

    public void setSaveOnExit(boolean b) {
        this.saveOnExit = b;
    }

    static int getTooltipDelay(Preferences p) {
        String val = p.getPreference(TTIP_DELAY);
        int result = 0;
        try {
            result = Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            result = 0;
        }
        if (result < 0) {
            result = 0;
        }
        return result;
    }

    static int getTooltipDuration(Preferences p) {
        String val = p.getPreference(TTIP_DURATION);
        int result = 5000;
        try {
            result = Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            result = 5000;
        }
        if (result < 0) {
            result = result == -1 ? Integer.MAX_VALUE : 5000;
        }
        return result;
    }

    void setTooltipsEnabled(boolean state) {
        ToolTipManager.sharedInstance().setEnabled(state);
    }

    void setTooltipDelay(int delay) {
        ToolTipManager.sharedInstance().setInitialDelay(delay);
    }

    void setTooltipDuration(int duration) {
        if (duration == -1) {
            ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
        } else {
            ToolTipManager.sharedInstance().setDismissDelay(duration);
        }
    }

    public void printSetup() {
        this.ensurePrintAttrsInitialized();
        PrinterJob job = PrinterJob.getPrinterJob();
        job.pageDialog(this.printAttrs);
    }

    public void print(Printable printable) {
        DocFlavor.SERVICE_FORMATTED flavor = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
        PrintService[] services = PrintServiceLookup.lookupPrintServices(flavor, null);
        if (services.length > 0) {
            this.ensurePrintAttrsInitialized();
            Component parent = this.getDialogParent();
            int x = (int)parent.getLocationOnScreen().getX() + parent.getWidth() / 2 - 250;
            int y = (int)parent.getLocationOnScreen().getY() + parent.getHeight() / 2 - 250;
            PrintService service = ServiceUI.printDialog(null, x, y, services, services[0], flavor, this.printAttrs);
            if (service != null) {
                DocPrintJob job = service.createPrintJob();
                try {
                    SimpleDoc doc = new SimpleDoc(printable, flavor, null);
                    job.print(doc, this.printAttrs);
                }
                catch (PrintException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void ensurePrintAttrsInitialized() {
        if (this.printAttrs == null) {
            this.printAttrs = new HashPrintRequestAttributeSet();
        }
    }

    private void initHelpBroker() {
        URL u = null;
        ClassLoader theLoader = null;
        if (this.commandContext != null) {
            Command[] cmds = this.commandContext.getCommands();
            for (int i = 0; i < cmds.length && (u = HelpSet.findHelpSet(theLoader = cmds[i].getCustomHelpLoader(), "jthelp.hs")) == null; ++i) {
            }
        }
        if (u == null) {
            theLoader = this.getClass().getClassLoader();
            u = HelpSet.findHelpSet(theLoader, "com/sun/javatest/help/jthelp.hs");
        }
        if (u != null) {
            try {
                HelpSet helpSet = new HelpSet(theLoader, u);
                this.helpBroker = new DefaultHelpBroker(helpSet);
            }
            catch (HelpSetException helpSetException) {
                // empty catch block
            }
        }
    }

    private JHelp getJHelp() {
        WindowPresentation wp = this.helpBroker.getWindowPresentation();
        wp.createHelpWindow();
        JFrame f = (JFrame)wp.getHelpWindow();
        Container p = f.getContentPane();
        for (int i = 0; i < p.getComponentCount(); ++i) {
            Component c = p.getComponent(i);
            if (!(c instanceof JHelp)) continue;
            return (JHelp)c;
        }
        return null;
    }

    private void initToolManagers() {
        try {
            ManagerLoader ml = new ManagerLoader(ToolManager.class, System.err);
            ml.setManagerConstructorArgs(new Class[]{Desktop.class}, new Object[]{this});
            Set s = ml.loadManagers(TOOLMGRLIST);
            this.toolManagers = s.toArray(new ToolManager[s.size()]);
        }
        catch (IOException e) {
            throw new JavaTestError(this.uif.getI18NResourceBundle(), "dt.cantAccessResource", new Object[]{TOOLMGRLIST, e});
        }
    }

    private void ensureViewInitialized() {
        if (this.currView != null) {
            return;
        }
        switch (this.style) {
            case 1: {
                this.currView = new MDIDeskView(this);
                break;
            }
            case 2: {
                this.currView = new SDIDeskView(this);
                break;
            }
            default: {
                this.currView = new TabDeskView(this);
            }
        }
    }

    private static void appendStrings(StringBuffer sb, String[] msgs) {
        if (msgs != null) {
            for (int i = 0; i < msgs.length; ++i) {
                sb.append(msgs[i]);
                if (msgs[i].endsWith("\n")) continue;
                sb.append('\n');
            }
        }
    }

    private static File getDesktopFile() {
        String s = System.getProperty("javatest.desktop.file");
        if (s == null) {
            File jtDir = Preferences.getPrefsDir();
            return new File(jtDir, "desktop");
        }
        if (!s.equals("NONE")) {
            return new File(s);
        }
        return null;
    }

    static void addHelpDebugListener(Component c) {
        JRootPane root;
        if (c instanceof JFrame) {
            root = ((JFrame)c).getRootPane();
        } else if (c instanceof JDialog) {
            root = ((JDialog)c).getRootPane();
        } else {
            throw new IllegalArgumentException();
        }
        ActionListener showFocusListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Component src = (Component)e.getSource();
                Component comp = SwingUtilities.findFocusOwner(src);
                System.err.println("ALT-F2: source=" + src);
                System.err.println("ALT-F2:  focus=" + comp);
                System.err.println("ALT-F2: helpId=" + (comp == null ? "(none)" : CSH.getHelpIDString(comp)));
            }
        };
        root.registerKeyboardAction(showFocusListener, KeyStroke.getKeyStroke("alt F2"), 2);
    }

    static void addPreferredSizeDebugListener(Component c) {
        JRootPane root;
        if (c instanceof JFrame) {
            root = ((JFrame)c).getRootPane();
        } else if (c instanceof JDialog) {
            root = ((JDialog)c).getRootPane();
        } else {
            throw new IllegalArgumentException();
        }
        ActionListener showPrefSizeListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Component src = (Component)e.getSource();
                for (Component c = SwingUtilities.findFocusOwner(src); c != null; c = c.getParent()) {
                    Dimension d = c.getPreferredSize();
                    System.err.println("ALT-1: comp=" + c.getName() + "(" + c.getClass().getName() + ") " + "[w:" + d.width + ",h:" + d.height + "]");
                }
            }
        };
        root.registerKeyboardAction(showPrefSizeListener, KeyStroke.getKeyStroke("alt 1"), 2);
    }

    private static void invokeOnEventThread(Runnable r) {
        try {
            EventQueue.invokeAndWait(r);
        }
        catch (InterruptedException e) {
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw (Error)t;
        }
    }

    private static int indexOf(String s, String[] a) {
        for (int i = 0; i < a.length; ++i) {
            if (!(s == null ? a[i] == null : s.equals(a[i]))) continue;
            return i;
        }
        return -1;
    }

    private static Throwable unwrap(Throwable t) {
        if (t == null) {
            return t;
        }
        Throwable t1;
        while ((t1 = t.getCause()) != null) {
            t = t1;
        }
        return t;
    }

    static class FileHistoryEntry {
        FileOpener fileOpener;
        File file;

        FileHistoryEntry(FileOpener fo, File f) {
            this.fileOpener = fo;
            this.file = f;
        }
    }
}

