/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.I18NResourceBundle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class TreeSelectionPane
extends JComponent
implements Accessible {
    private AccessibleContext accessibleContext;
    private TQTree tree;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(TreeSelectionPane.class);
    private static final int NONE_SELECTED = 0;
    private static final int SOME_SELECTED = 1;
    private static final int ALL_SELECTED = 2;
    private UIFactory uif = new UIFactory(this.getClass(), null);
    private static Icon[] folderIcons;
    private static Icon[] leafIcons;

    TreeSelectionPane(Model model) {
        this.setLayout(new BorderLayout());
        this.tree = new TQTree(model);
        this.tree.setName("tsp.tree");
        AccessibleContext ac = this.tree.getAccessibleContext();
        ac.setAccessibleName(i18n.getString("tsp.tree.name"));
        ac.setAccessibleDescription(i18n.getString("tsp.tree.desc"));
        JScrollPane sp = this.uif.createScrollPane(this.tree);
        this.add(sp);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new JComponent.AccessibleJComponent(){};
        }
        return this.accessibleContext;
    }

    public String[] getSelection() {
        return this.tree.getSelection();
    }

    public void setSelection(String[] paths) {
        this.tree.setSelection(paths);
    }

    public boolean isSelectionEmpty() {
        return this.tree.isSelectionEmpty();
    }

    public void clear() {
        this.tree.setSelection(null);
    }

    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.tree.setEnabled(b);
    }

    private static String stringOf(TreePath p) {
        StringBuffer sb = new StringBuffer();
        Object[] path = p.getPath();
        for (int i = 0; i < path.length; ++i) {
            if (sb.length() > 0) {
                sb.append("/");
            }
            sb.append(((TQNode)path[i]).getName());
        }
        return sb.toString();
    }

    static /* synthetic */ Icon[] access$102(Icon[] x0) {
        folderIcons = x0;
        return x0;
    }

    static /* synthetic */ Icon[] access$202(Icon[] x0) {
        leafIcons = x0;
        return x0;
    }

    private static class LeafIcon
    implements Icon {
        private int style;
        private Image image;
        private static final int width = 16;
        private static final int height = 16;

        LeafIcon(int style) {
            this.style = style;
        }

        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 16;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.image == null) {
                this.image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
                Graphics imageG = this.image.getGraphics();
                this.paintMe(c, imageG);
                imageG.dispose();
            }
            g.drawImage(this.image, x, y, null);
        }

        private void paintMe(Component c, Graphics g) {
            int right = 15;
            int bottom = 15;
            g.setColor(MetalLookAndFeel.getWindowBackground());
            g.fillRect(4, 2, 9, 12);
            g.setColor(MetalLookAndFeel.getPrimaryControlInfo());
            g.drawLine(2, 0, 2, bottom);
            g.drawLine(2, 0, right - 4, 0);
            g.drawLine(2, bottom, right - 1, bottom);
            g.drawLine(right - 1, 6, right - 1, bottom);
            g.drawLine(right - 6, 2, right - 2, 6);
            g.drawLine(right - 5, 1, right - 4, 1);
            g.drawLine(right - 3, 2, right - 3, 3);
            g.drawLine(right - 2, 4, right - 2, 5);
            switch (this.style) {
                case 0: {
                    g.setColor(MetalLookAndFeel.getPrimaryControl());
                    g.drawLine(3, 1, 3, bottom - 1);
                    g.drawLine(3, 1, right - 6, 1);
                    g.drawLine(right - 2, 7, right - 2, bottom - 1);
                    g.drawLine(right - 5, 2, right - 3, 4);
                    g.drawLine(3, bottom - 1, right - 2, bottom - 1);
                    break;
                }
                case 2: {
                    g.setColor(MetalLookAndFeel.getPrimaryControl());
                    g.drawLine(4, 2, 9, 2);
                    g.drawLine(4, 3, 9, 3);
                    g.drawLine(4, 4, 10, 4);
                    g.drawLine(4, 5, 10, 5);
                    g.drawLine(4, 6, 11, 6);
                    g.fillRect(4, 6, 10, 9);
                }
            }
        }
    }

    static class FolderIcon
    implements Icon {
        private int style;
        private Image image;
        private static final int width = 16;
        private static final int height = 16;

        FolderIcon(int style) {
            this.style = style;
        }

        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 16;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.image == null) {
                this.image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
                Graphics imageG = this.image.getGraphics();
                this.paintMe(c, imageG);
                imageG.dispose();
            }
            g.drawImage(this.image, x, y - 1, null);
        }

        private void paintMe(Component c, Graphics g) {
            int right = 15;
            int bottom = 15;
            g.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            g.drawLine(right - 5, 3, right, 3);
            g.drawLine(right - 6, 4, right, 4);
            g.setColor(MetalLookAndFeel.getPrimaryControl());
            g.fillRect(2, 7, 13, 8);
            switch (this.style) {
                case 0: {
                    g.setColor(Color.white);
                    g.fillRect(2, 7, 13, 8);
                    break;
                }
                case 1: {
                    g.setColor(Color.white);
                    for (int i = 0; i < 8; ++i) {
                        g.drawLine(4 + i, 7 + i, 18, 7 + i);
                    }
                    break;
                }
            }
            g.setColor(MetalLookAndFeel.getPrimaryControlShadow());
            g.drawLine(right - 6, 5, right - 1, 5);
            g.setColor(MetalLookAndFeel.getPrimaryControlInfo());
            g.drawLine(0, 6, 0, bottom);
            g.drawLine(1, 5, right - 7, 5);
            g.drawLine(right - 6, 6, right - 1, 6);
            g.drawLine(right, 5, right, bottom);
            g.drawLine(0, bottom, right, bottom);
            g.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
            g.drawLine(1, 6, 1, bottom - 1);
            g.drawLine(1, 6, right - 7, 6);
            g.drawLine(right - 6, 7, right - 1, 7);
        }
    }

    private class TQListener
    implements TreeExpansionListener,
    TreeSelectionListener {
        private boolean ignoreEvents;
        private Vector vector;

        private TQListener() {
        }

        public void treeCollapsed(TreeExpansionEvent e) {
            TreePath p = e.getPath();
            TQNode node = (TQNode)p.getLastPathComponent();
            this.vector = new Vector();
            this.vector.add(p);
            TQTree tree = (TQTree)e.getSource();
            TreePath[] paths = tree.getSelectionPaths();
            for (int i = 0; i < paths.length; ++i) {
                if (!p.isDescendant(paths[i])) continue;
                this.vector.add(paths[i]);
            }
        }

        public void treeExpanded(TreeExpansionEvent e) {
            this.vector = null;
        }

        public void valueChanged(TreeSelectionEvent e) {
            if (this.ignoreEvents) {
                return;
            }
            TQTree tree = (TQTree)e.getSource();
            TreePath[] paths = e.getPaths();
            if (this.vector != null) {
                boolean contains = true;
                for (int i = 0; i < paths.length; ++i) {
                    if (this.vector.contains(paths[i])) continue;
                    contains = false;
                    break;
                }
                if (!contains) {
                    this.vector = null;
                } else {
                    HashSet<TreePath> added = new HashSet<TreePath>();
                    HashSet<TreePath> removed = new HashSet<TreePath>();
                    for (int i = 0; i < paths.length; ++i) {
                        if (!e.isAddedPath(paths[i])) {
                            added.add(paths[i]);
                            continue;
                        }
                        removed.add(paths[i]);
                    }
                    this.setIgnoreEvents(true);
                    tree.getSelectionModel().addSelectionPaths(added.toArray(new TreePath[0]));
                    tree.getSelectionModel().removeSelectionPaths(removed.toArray(new TreePath[0]));
                    this.setIgnoreEvents(false);
                    return;
                }
            }
            for (int i = 0; i < paths.length; ++i) {
                TreePath p = paths[i];
                TQNode node = (TQNode)p.getLastPathComponent();
                if (e.isAddedPath(p)) {
                    node.setSelected(true);
                    continue;
                }
                node.setSelected(false);
            }
            TreePath p = e.getNewLeadSelectionPath();
            if (p != null) {
                TQNode node = (TQNode)p.getLastPathComponent();
                node.setSelected(true);
            }
        }

        void setIgnoreEvents(boolean b) {
            this.ignoreEvents = b;
        }
    }

    private class TQRenderer
    extends DefaultTreeCellRenderer {
        private int style;

        TQRenderer() {
            if (folderIcons == null) {
                TreeSelectionPane.access$102(new FolderIcon[3]);
                folderIcons[0] = new FolderIcon(0);
                folderIcons[1] = new FolderIcon(1);
                folderIcons[2] = new FolderIcon(2);
            }
            if (leafIcons == null) {
                TreeSelectionPane.access$202(new LeafIcon[3]);
                leafIcons[0] = new LeafIcon(0);
                leafIcons[2] = new LeafIcon(2);
            }
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            TQModel model = (TQModel)tree.getModel();
            TQNode node = (TQNode)value;
            value = model.getName(node);
            this.style = node.selectState;
            return super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        }

        public Icon getOpenIcon() {
            return folderIcons[this.style];
        }

        public Icon getClosedIcon() {
            return folderIcons[this.style];
        }

        public Icon getLeafIcon() {
            return leafIcons[this.style];
        }
    }

    private class TQModel
    implements TreeModel {
        private TQNode root;
        private EventListenerList listenerList = new EventListenerList();

        TQModel(TQNode root) {
            this.root = root;
        }

        public String getName(Object node) {
            return ((TQNode)node).getName();
        }

        public Object getChild(Object parent, int index) {
            return ((TQNode)parent).getChild(index);
        }

        public int getChildCount(Object parent) {
            return ((TQNode)parent).getChildCount();
        }

        public int getIndexOfChild(Object parent, Object child) {
            return ((TQNode)parent).getIndexOfChild((TQNode)child);
        }

        public Object getRoot() {
            return this.root;
        }

        public boolean isLeaf(Object node) {
            return ((TQNode)node).isLeaf();
        }

        public void addTreeModelListener(TreeModelListener l) {
            this.listenerList.add(TreeModelListener.class, l);
        }

        public void removeTreeModelListener(TreeModelListener l) {
            this.listenerList.remove(TreeModelListener.class, l);
        }

        public void valueForPathChanged(TreePath path, Object newValue) {
            throw new UnsupportedOperationException();
        }

        void fireTreeNodesChanged(TQTree tree, TQNode node) {
            TreeModelEvent event = null;
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != TreeModelListener.class) continue;
                if (event == null) {
                    event = new TreeModelEvent((Object)tree, TQNode.getTreePath(node));
                }
                ((TreeModelListener)listeners[i + 1]).treeNodesChanged(event);
            }
        }
    }

    private static class TQNode
    implements Comparable {
        TQTree tree;
        TQNode parent;
        TQNode[] children;
        int selectState;
        Object clientNode;

        TQNode(TQTree tree, TQNode parent, Object clientNode) {
            if (tree == null || clientNode == null) {
                throw new NullPointerException();
            }
            this.tree = tree;
            this.parent = parent;
            this.clientNode = clientNode;
        }

        public int compareTo(Object o) {
            if (o instanceof TQNode) {
                TQNode other = (TQNode)o;
                int levelDiff = other.getLevel() - this.getLevel();
                int hashDiff = other.hashCode() - this.hashCode();
                return levelDiff == 0 ? hashDiff : levelDiff;
            }
            return -1;
        }

        public int getLevel() {
            int code = 1;
            TQNode grand = this.parent;
            while (grand != null) {
                grand = grand.parent;
                ++code;
            }
            return code;
        }

        public String toString() {
            return this.getName();
        }

        String getName() {
            return this.tree.clientModel.getName(this.clientNode);
        }

        int getChildCount() {
            return this.children == null ? this.tree.clientModel.getChildCount(this.clientNode) : this.children.length;
        }

        TQNode getChild(int index) {
            if (this.children == null) {
                this.initChildren();
            }
            return this.children[index];
        }

        boolean isLeaf() {
            return this.tree.clientModel.isLeaf(this.clientNode);
        }

        int getIndexOfChild(TQNode child) {
            if (this.children == null) {
                this.initChildren();
            }
            for (int i = 0; i < this.children.length; ++i) {
                if (child != this.children[i]) continue;
                return i;
            }
            return -1;
        }

        void setSelected(boolean b) {
            if (b && this.selectState == 2 || !b && this.selectState == 0) {
                return;
            }
            this.setSelectState(b ? 2 : 0);
            if (this.children != null) {
                for (int i = 0; i < this.children.length; ++i) {
                    this.children[i].setSelected(b);
                }
            }
            TQNode n = this;
            TQNode p = this.parent;
            while (p != null) {
                int state = p.children[0].selectState;
                for (int i = 1; i < p.children.length && state != 1; ++i) {
                    TQNode c = p.children[i];
                    if ((state != 2 || c.selectState == 2) && (state != 0 || c.selectState == 0)) continue;
                    state = 1;
                }
                if (p.selectState == state) break;
                p.setSelectState(state);
                n = p;
                p = n.parent;
            }
        }

        private void setSelectState(int newState) {
            if (this.selectState == newState) {
                return;
            }
            if (this.selectState == 2) {
                this.tree.removeFromSelection(this);
            }
            this.selectState = newState;
            ((TQModel)this.tree.getModel()).fireTreeNodesChanged(this.tree, this);
            if (this.selectState == 2) {
                this.tree.addToSelection(this);
            }
        }

        private void initChildren() {
            int i;
            this.children = new TQNode[this.getChildCount()];
            for (i = 0; i < this.children.length; ++i) {
                this.children[i] = new TQNode(this.tree, this, this.tree.clientModel.getChild(this.clientNode, i));
            }
            if (this.selectState == 2) {
                for (i = 0; i < this.children.length; ++i) {
                    this.children[i].setSelectState(2);
                }
            }
        }

        static Set getSubNodes(TQNode node) {
            HashSet<TQNode> children = new HashSet<TQNode>();
            if (node != null && node.children != null && node.children.length != 0) {
                for (int i = 0; i < node.children.length; ++i) {
                    if (node.children[i] == null) continue;
                    children.add(node.children[i]);
                    Set grandchildren = TQNode.getSubNodes(node.children[i]);
                    if (grandchildren == null) continue;
                    children.addAll(grandchildren);
                }
            }
            return children;
        }

        static Set getUpNodes(TQNode node) {
            TreeSet<TQNode> ancestry = new TreeSet<TQNode>();
            TQNode parent = node.parent;
            while (parent != null) {
                ancestry.add(parent);
                parent = parent.parent;
            }
            return ancestry;
        }

        static Set getSubNodes(Set nodes) {
            HashSet kids = new HashSet();
            if (nodes != null && !nodes.isEmpty()) {
                Iterator e = nodes.iterator();
                while (e.hasNext()) {
                    Set children = TQNode.getSubNodes((TQNode)e.next());
                    kids.addAll(children);
                }
            }
            return kids;
        }

        static Set getUpNodes(Set nodes) {
            TreeSet adults = new TreeSet();
            if (nodes != null && !nodes.isEmpty()) {
                Iterator e = nodes.iterator();
                while (e.hasNext()) {
                    Set parents = TQNode.getUpNodes((TQNode)e.next());
                    adults.addAll(parents);
                }
            }
            return adults;
        }

        static TreePath getTreePath(TQNode node) {
            if (node.parent == null) {
                return new TreePath(node);
            }
            return TQNode.getTreePath(node.parent).pathByAddingChild(node);
        }

        static TreePath[] getTreePaths(Collection s) {
            if (s == null || s.size() == 0) {
                return new TreePath[0];
            }
            TreePath[] result = new TreePath[s.size()];
            Iterator e = s.iterator();
            int i = 0;
            while (e.hasNext()) {
                TQNode tqn = (TQNode)e.next();
                result[i] = TQNode.getTreePath(tqn);
                ++i;
            }
            return result;
        }
    }

    private class TQTree
    extends JTree {
        Model clientModel;
        TQListener listener;
        TQNode root;

        TQTree(Model model) {
            this.clientModel = model;
            this.listener = new TQListener();
            this.addTreeSelectionListener(this.listener);
            this.addTreeExpansionListener(this.listener);
            this.root = new TQNode(this, null, this.clientModel.getRoot());
            this.setModel(new TQModel(this.root));
            this.setCellRenderer(new TQRenderer());
            this.setExpandsSelectedPaths(false);
        }

        public Dimension getPreferredScrollableViewportSize() {
            return new Dimension(200, 100);
        }

        String[] getSelection() {
            Vector v = new Vector();
            this.getSelection(this.root, v);
            Object[] paths = new String[v.size()];
            v.copyInto(paths);
            return paths;
        }

        private void getSelection(TQNode node, Vector v) {
            switch (node.selectState) {
                case 0: {
                    break;
                }
                case 1: {
                    for (int i = 0; i < node.getChildCount(); ++i) {
                        this.getSelection(node.getChild(i), v);
                    }
                    break;
                }
                case 2: {
                    v.add(this.getPath(node));
                }
            }
        }

        void setSelection(String[] paths) {
            Set all = TQNode.getSubNodes(this.root);
            all.add(this.root);
            TreePath[] tps = TQNode.getTreePaths(all);
            Iterator e = all.iterator();
            if (paths == null || paths.length == 0) {
                while (e.hasNext()) {
                    TQNode node = (TQNode)e.next();
                    node.selectState = 2;
                }
                this.getSelectionModel().addSelectionPaths(tps);
            } else {
                while (e.hasNext()) {
                    TQNode node = (TQNode)e.next();
                    node.selectState = 0;
                }
                this.getSelectionModel().removeSelectionPaths(tps);
                HashSet<TQNode> nodes = new HashSet<TQNode>();
                for (int i = 0; i < paths.length; ++i) {
                    TQNode node = this.getNode(this.root, paths[i]);
                    if (node == null || node.selectState == 2) continue;
                    nodes.add(node);
                }
                this.listener.setIgnoreEvents(true);
                Set subNodes = TQNode.getSubNodes(nodes);
                TreePath[] kids = TQNode.getTreePaths(subNodes);
                if (subNodes != null) {
                    e = subNodes.iterator();
                    while (e.hasNext()) {
                        ((TQNode)e.next()).selectState = 2;
                    }
                }
                TreePath[] tpaths = TQNode.getTreePaths(nodes);
                e = nodes.iterator();
                while (e.hasNext()) {
                    ((TQNode)e.next()).selectState = 2;
                }
                Set upNodes = TQNode.getUpNodes(nodes);
                TreePath[] adults = TQNode.getTreePaths(upNodes);
                if (upNodes != null) {
                    block5: for (TQNode up : upNodes) {
                        up.selectState = 2;
                        for (int i = 0; i < up.children.length; ++i) {
                            if (up.children[i].selectState != 0 && up.children[i].selectState != 1) continue;
                            up.selectState = 1;
                            continue block5;
                        }
                    }
                }
                this.getSelectionModel().addSelectionPaths(kids);
                this.getSelectionModel().addSelectionPaths(tpaths);
                this.getSelectionModel().addSelectionPaths(adults);
                this.listener.setIgnoreEvents(false);
            }
        }

        void addToSelection(TQNode node) {
            this.listener.setIgnoreEvents(true);
            TreePath p = TQNode.getTreePath(node);
            this.getSelectionModel().addSelectionPath(p);
            this.listener.setIgnoreEvents(false);
        }

        void removeFromSelection(TQNode node) {
            this.listener.setIgnoreEvents(true);
            TreePath p = TQNode.getTreePath(node);
            this.getSelectionModel().removeSelectionPath(p);
            this.listener.setIgnoreEvents(false);
        }

        private TQNode getNode(TQNode node, String path) {
            String tail;
            String head;
            if (node == null) {
                throw new NullPointerException();
            }
            if (path.length() == 0) {
                return node;
            }
            int sep = path.indexOf("/");
            if (sep == -1) {
                head = path;
                tail = null;
            } else {
                head = path.substring(0, sep);
                tail = path.substring(sep + 1);
            }
            for (int i = 0; i < node.getChildCount(); ++i) {
                TQNode c = node.getChild(i);
                if (!c.getName().equals(head)) continue;
                return tail == null ? c : this.getNode(c, tail);
            }
            return null;
        }

        String getPath(TQNode node) {
            return this.getPath(node, 0).toString();
        }

        private StringBuffer getPath(TQNode node, int length) {
            if (node.parent == null) {
                return new StringBuffer(length);
            }
            String nodeName = node.getName();
            StringBuffer sb = this.getPath(node.parent, 1 + nodeName.length() + length);
            if (sb.length() > 0) {
                sb.append("/");
            }
            sb.append(nodeName);
            return sb;
        }
    }

    public static interface Model {
        public Object getRoot();

        public int getChildCount(Object var1);

        public Object getChild(Object var1, int var2);

        public String getName(Object var1);

        public String getPath(Object var1);

        public boolean isLeaf(Object var1);
    }
}

