/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Properties
extends Hashtable {
    protected Properties defaults;
    private static char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public Properties() {
        this((Properties)null);
    }

    public Properties(Properties defaults) {
        this.defaults = defaults;
    }

    public synchronized void load(Reader in) throws IOException {
        Vector v = Properties.load0(in, false);
        for (int i = 0; i < v.size(); i += 2) {
            this.put(v.elementAt(i), v.elementAt(i + 1));
        }
    }

    static Vector load0(Reader in, boolean breakOnEmptyLine) throws IOException {
        Vector<String> v = new Vector<String>();
        int ch = 0;
        ch = 10;
        block9: while (true) {
            switch (ch) {
                case -1: {
                    break block9;
                }
                case 33: 
                case 35: {
                    while ((ch = in.read()) >= 0 && ch != 10 && ch != 13) {
                    }
                    continue block9;
                }
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    int lines = 0;
                    while (!breakOnEmptyLine || ch != 10 || ++lines <= 1) {
                        ch = in.read();
                        if (ch == 10 || ch == 13 || ch == 9 || ch == 32) continue;
                        continue block9;
                    }
                    break block9;
                }
                default: {
                    StringBuffer key = new StringBuffer();
                    StringBuffer val = new StringBuffer();
                    boolean hasSep = false;
                    boolean precedingBackslash = false;
                    while (ch >= 0 && ch != 10 && ch != 13) {
                        if (!(ch != 61 && ch != 58 || precedingBackslash)) {
                            ch = in.read();
                            hasSep = true;
                            break;
                        }
                        if (!(ch != 32 && ch != 9 && ch != 12 || precedingBackslash)) {
                            ch = in.read();
                            break;
                        }
                        precedingBackslash = ch == 92 ? !precedingBackslash : false;
                        key.append((char)ch);
                        ch = in.read();
                    }
                    block13: while (ch >= 0 && ch != 10 && ch != 13) {
                        if (ch == 92) {
                            ch = in.read();
                            switch (ch) {
                                case 13: {
                                    ch = in.read();
                                    if (ch != 10 && ch != 32 && ch != 9) continue block13;
                                }
                                case 10: {
                                    while ((ch = in.read()) == 32 || ch == 9) {
                                    }
                                    continue block13;
                                }
                            }
                            val.append('\\');
                        }
                        val.append((char)ch);
                        ch = in.read();
                    }
                    char[] cKey = new char[key.length()];
                    char[] cVal = new char[val.length()];
                    key.getChars(0, key.length(), cKey, 0);
                    val.getChars(0, val.length(), cVal, 0);
                    v.add(Properties.loadConvert(cKey));
                    v.add(Properties.loadConvert(cVal));
                    continue block9;
                }
            }
            break;
        }
        return v;
    }

    private static String loadConvert(char[] in) {
        int len = in.length;
        char[] out = new char[len];
        int outLen = 0;
        int off = 0;
        while (off < len) {
            int aChar;
            if ((aChar = in[off++]) == 92) {
                if ((aChar = in[off++]) == 117) {
                    int value = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        aChar = in[off++];
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                    }
                    out[outLen++] = (char)value;
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                out[outLen++] = aChar;
                continue;
            }
            out[outLen++] = aChar;
        }
        return new String(out, 0, outLen);
    }

    public synchronized void save(Writer out, String header) throws IOException {
        BufferedWriter bout = out instanceof BufferedWriter ? (BufferedWriter)out : new BufferedWriter(out);
        PrintWriter prnt = new PrintWriter(bout);
        if (header != null) {
            prnt.write(35);
            prnt.println(header);
        }
        prnt.write(35);
        prnt.println(new Date());
        Enumeration e = this.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String val = (String)this.get(key);
            key = Properties.saveConvert(key, true, false);
            val = Properties.saveConvert(val, false, false);
            bout.write(key + "=" + val);
            bout.newLine();
        }
        bout.flush();
    }

    static String saveConvert(String theString, boolean escapeSpace, boolean escapeUnicode) {
        int len = theString.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuffer outBuffer = new StringBuffer(bufLen);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue;
                }
                outBuffer.append(aChar);
                continue;
            }
            switch (aChar) {
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    outBuffer.append('\\');
                    outBuffer.append(aChar);
                    continue block8;
                }
                default: {
                    if ((aChar < ' ' || aChar > '~') & escapeUnicode) {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(Properties.toHex(aChar >> 12 & 0xF));
                        outBuffer.append(Properties.toHex(aChar >> 8 & 0xF));
                        outBuffer.append(Properties.toHex(aChar >> 4 & 0xF));
                        outBuffer.append(Properties.toHex(aChar & 0xF));
                        continue block8;
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    public String getProperty(String key) {
        Object oval = super.get(key);
        String sval = oval instanceof String ? (String)oval : null;
        return sval == null && this.defaults != null ? this.defaults.getProperty(key) : sval;
    }

    public String getProperty(String key, String defaultValue) {
        String val = this.getProperty(key);
        return val == null ? defaultValue : val;
    }

    public Enumeration propertyNames() {
        Hashtable h = new Hashtable();
        this.enumerate(h);
        return h.keys();
    }

    public void list(PrintWriter out) {
        out.println("-- listing properties --");
        Hashtable h = new Hashtable();
        this.enumerate(h);
        Enumeration e = h.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String val = (String)h.get(key);
            if (val.length() > 40) {
                val = val.substring(0, 37) + "...";
            }
            out.println(key + "=" + val);
        }
    }

    private synchronized void enumerate(Hashtable h) {
        if (this.defaults != null) {
            this.defaults.enumerate(h);
        }
        Enumeration e = this.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            h.put(key, this.get(key));
        }
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }
}

