/*
 * Decompiled with CFR 0.152.
 */
package com.sun.demots;

import com.sun.interview.Checklist;
import com.sun.interview.ChoiceQuestion;
import com.sun.interview.ErrorQuestion;
import com.sun.interview.FileQuestion;
import com.sun.interview.Interview;
import com.sun.interview.NullQuestion;
import com.sun.interview.Question;
import com.sun.interview.StringQuestion;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.interview.BasicInterviewParameters;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class DemoTSInterview
extends BasicInterviewParameters
implements Parameters.EnvParameters {
    private Question qPrecompile = new NullQuestion((Interview)this, "precompile"){

        public Question getNext() {
            return DemoTSInterview.this.qEnvEnd;
        }

        public void export(Map data) {
            data.put("script.mode", "precompile");
            data.put("command.compile.java", System.getProperty("command.compile.java"));
        }
    };
    private Question qDeveloper = new NullQuestion((Interview)this, "developer"){

        public Question getNext() {
            return DemoTSInterview.this.qName;
        }

        public void export(Map data) {
            data.put("script.mode", "developer");
            data.put("command.compile.java", System.getProperty("command.compile.java"));
        }
    };
    private StringQuestion qName = new StringQuestion((Interview)this, "name"){

        public Question getNext() {
            if (this.value == null || this.value.length() == 0) {
                return null;
            }
            return DemoTSInterview.this.qDesc;
        }
    };
    private Question qDesc = new StringQuestion((Interview)this, "desc"){

        public Question getNext() {
            if (this.value == null || this.value.length() == 0) {
                return null;
            }
            return DemoTSInterview.this.qCmdType;
        }

        public void export(Map data) {
            data.put("description", String.valueOf(this.value));
        }
    };
    private static final String AGENT = "agent";
    private static final String OTHER_VM = "otherVM";
    private Question qCmdType = new ChoiceQuestion((Interview)this, "cmdType"){
        {
            this.setChoices(new String[]{null, DemoTSInterview.OTHER_VM, DemoTSInterview.AGENT}, true);
        }

        public Question getNext() {
            if (this.value == null || this.value.length() == 0) {
                return null;
            }
            if (this.value.equals(DemoTSInterview.OTHER_VM)) {
                return DemoTSInterview.this.qJVM;
            }
            return DemoTSInterview.this.qTestVerboseLevel;
        }

        public Checklist.Item[] getChecklistItems() {
            if (this.value != DemoTSInterview.AGENT) {
                return null;
            }
            return new Checklist.Item[]{DemoTSInterview.this.createChecklistItem(DemoTSInterview.AGENT, "agent.needToStart")};
        }

        public void export(Map data) {
            String cmd = this.value != null && this.value.equals(DemoTSInterview.OTHER_VM) ? DemoTSInterview.this.getOtherVMExecuteCommand() : "com.sun.javatest.agent.ActiveAgentCommand com.sun.javatest.lib.ExecStdTestSameJVMCmd $testExecuteClass $testExecuteArgs";
            data.put("command.execute", cmd);
        }
    };
    private FileQuestion qJVM = new FileQuestion((Interview)this, "jvm"){

        public Question getNext() {
            if (this.value == null || this.value.getPath().length() == 0) {
                return null;
            }
            if (!(this.value.exists() && this.value.isFile() && this.value.canRead())) {
                return DemoTSInterview.this.qBadJVM;
            }
            return DemoTSInterview.this.qTestVerboseLevel;
        }
    };
    private Question qBadJVM = new ErrorQuestion((Interview)this, "badJVM"){

        public Object[] getTextArgs() {
            return new Object[]{DemoTSInterview.this.qJVM.getValue().getPath()};
        }
    };
    private static final String LOW = "low";
    private static final String MEDIUM = "medium";
    private static final String HIGH = "high";
    private Question qTestVerboseLevel = new ChoiceQuestion((Interview)this, "testVerboseLevel"){
        {
            this.setChoices(new String[]{null, DemoTSInterview.LOW, DemoTSInterview.MEDIUM, DemoTSInterview.HIGH}, true);
        }

        public Question getNext() {
            return DemoTSInterview.this.qEnvEnd;
        }

        public void export(Map data) {
            data.put("testVerboseLevel", String.valueOf(this.value));
        }
    };
    private Question qEnvEnd = new NullQuestion((Interview)this, "envEnd"){

        public Question getNext() {
            return DemoTSInterview.this.getEnvSuccessorQuestion();
        }
    };
    private static final int PRECOMPILE = 1;
    private static final int CERTIFY = 2;
    private static final int DEVELOPER = 3;
    private int mode;

    public DemoTSInterview() throws Interview.Fault {
        super("demoTS");
        this.setHelpSet("moreInfo/demots");
        this.setResourceBundle("i18n");
        String m = System.getProperty("interview.mode", "certify");
        if (m.equals("certify")) {
            this.mode = 2;
        } else if (m.equals("developer")) {
            this.mode = 3;
        } else if (m.equals("precompile")) {
            this.mode = 1;
        }
    }

    public TestEnvironment getEnv() {
        HashMap envProps = new HashMap();
        this.export(envProps);
        try {
            String name = this.qName.getValue();
            if (name == null || name.length() == 0) {
                name = "unknown";
            }
            return new TestEnvironment(name, envProps, "configuration interview");
        }
        catch (TestEnvironment.Fault e) {
            throw new Error("should not happen");
        }
    }

    public Parameters.EnvParameters getEnvParameters() {
        return this;
    }

    public Question getEnvFirstQuestion() {
        switch (this.mode) {
            case 1: {
                return this.qPrecompile;
            }
            case 3: {
                return this.qDeveloper;
            }
        }
        return this.qName;
    }

    private String getOtherVMExecuteCommand() {
        char fs = File.separatorChar;
        char ps = File.pathSeparatorChar;
        StringBuffer sb = new StringBuffer();
        sb.append("com.sun.javatest.lib.ExecStdTestOtherJVMCmd ");
        File jvm = this.qJVM.getValue();
        sb.append(jvm == null ? "unknown_jvm" : jvm.getPath());
        sb.append(" -classpath $testSuiteRootDir" + fs + "lib" + fs + "jtdemots.jar" + ps + "$testSuiteRootDir" + fs + "lib" + fs + "demoapi.jar" + ps + "$testSuiteRootDir" + fs + "lib" + fs + "javatest.jar ");
        sb.append("$testExecuteClass $testExecuteArgs");
        return sb.toString();
    }
}

