/*
 * Decompiled with CFR 0.152.
 */
package com.sun.demoapi;

public class BigNum {
    private int sign;
    private int[] data;
    private static final int[] POWERS_OF_10 = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000};
    private static final int DIGITS_PER_CELL = 6;
    private static final int MAX_PER_CELL = POWERS_OF_10[6];

    public BigNum(long n) {
        if (n == Integer.MIN_VALUE) {
            throw new IllegalArgumentException();
        }
        if (n < 0L) {
            this.sign = -1;
            n = -n;
        } else {
            if (n == 0L) {
                this.data = new int[0];
                this.sign = 0;
                return;
            }
            this.sign = 1;
        }
        int size = 0;
        for (long n1 = n; n1 > 0L; n1 /= (long)MAX_PER_CELL) {
            ++size;
        }
        this.data = new int[size];
        for (int i = 0; i < size; ++i) {
            this.data[i] = (int)(n % (long)MAX_PER_CELL);
            n /= (long)MAX_PER_CELL;
        }
    }

    public BigNum(String s) {
        if (s == null) {
            throw new NullPointerException();
        }
        int slen = s.length();
        if (slen == 0) {
            throw new NumberFormatException("empty string");
        }
        int i = 0;
        if (s.charAt(0) == '-') {
            this.sign = -1;
            i = 1;
        } else {
            this.sign = 1;
        }
        while (i < slen - 1 && s.charAt(i) == '0') {
            ++i;
        }
        if (i == slen - 1 && s.charAt(i) == '0') {
            this.sign = 0;
            this.data = new int[0];
            return;
        }
        if (i == slen) {
            throw new NumberFormatException("no digits");
        }
        int numDigits = slen - i;
        int numCells = (numDigits + 6 - 1) / 6;
        this.data = new int[numCells];
        while (i < slen) {
            char c = s.charAt(i);
            if (c < '0' || c > '9') {
                throw new NumberFormatException("bad char");
            }
            int d = (slen - 1 - i) / 6;
            this.data[d] = this.data[d] * 10 + (c - 48);
            ++i;
        }
    }

    public BigNum add(BigNum other) {
        if (this.sign == 0) {
            return other;
        }
        if (other.sign == 0) {
            return this;
        }
        if (this.sign == other.sign) {
            return new BigNum(this.sign, this.add(this.data, other.data));
        }
        switch (this.compare(this.data, other.data)) {
            case 1: {
                return new BigNum(this.sign, this.subtract(this.data, other.data));
            }
            case 0: {
                return new BigNum(0L);
            }
            case -1: {
                return new BigNum(other.sign, this.subtract(other.data, this.data));
            }
        }
        throw new Error("should not happen");
    }

    public BigNum subtract(BigNum other) {
        if (this.sign == 0) {
            return new BigNum(-other.sign, other.data);
        }
        if (other.sign == 0) {
            return this;
        }
        if (this.sign == other.sign) {
            switch (this.compare(this.data, other.data)) {
                case 1: {
                    return new BigNum(this.sign, this.subtract(this.data, other.data));
                }
                case 0: {
                    return new BigNum(0L);
                }
                case -1: {
                    return new BigNum(-other.sign, this.subtract(other.data, this.data));
                }
            }
            throw new Error("should not happen");
        }
        return new BigNum(this.sign, this.add(this.data, other.data));
    }

    public int compare(BigNum other) {
        if (this.sign == other.sign) {
            int cmp = this.compare(this.data, other.data);
            return this.sign < 0 ? -cmp : cmp;
        }
        return this.sign > other.sign ? 1 : -1;
    }

    public boolean equals(Object other) {
        if (!(other instanceof BigNum)) {
            return false;
        }
        BigNum o = (BigNum)other;
        if (this.sign != o.sign) {
            return false;
        }
        if (this.data.length != o.data.length) {
            return false;
        }
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] == o.data[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.sign == 0) {
            return "0";
        }
        StringBuffer sb = new StringBuffer();
        if (this.sign < 0) {
            sb.append('-');
        }
        boolean suppressZero = true;
        for (int i = this.data.length - 1; i >= 0; --i) {
            int d = this.data[i];
            for (int j = 5; j >= 0; --j) {
                int digit = d / POWERS_OF_10[j] % 10;
                if (digit > 0) {
                    suppressZero = false;
                    sb.append((char)(48 + digit));
                    continue;
                }
                if (suppressZero) continue;
                sb.append('0');
            }
        }
        return sb.toString();
    }

    private BigNum(int sign, int[] data) {
        this.sign = sign;
        this.data = data;
    }

    private int[] add(int[] d1, int[] d2) {
        int[] sum = new int[Math.max(d1.length, d2.length)];
        int carry = 0;
        for (int i = 0; i < sum.length; ++i) {
            int s = carry;
            if (i < d1.length) {
                s += d1[i];
            }
            if (i < d2.length) {
                s += d2[i];
            }
            sum[i] = s % MAX_PER_CELL;
            carry = s / MAX_PER_CELL;
        }
        if (carry > 0) {
            int[] x = new int[sum.length + 1];
            System.arraycopy(sum, 0, x, 0, sum.length);
            x[sum.length] = carry;
            sum = x;
        }
        return sum;
    }

    private int[] subtract(int[] d1, int[] d2) {
        int newSize;
        if (d1.length < d2.length) {
            throw new IllegalArgumentException();
        }
        int[] diff = new int[d1.length];
        int borrow = 0;
        for (int i = 0; i < diff.length; ++i) {
            int d = d1[i] - borrow;
            if (i < d2.length) {
                d -= d2[i];
            }
            if (d < 0) {
                d += MAX_PER_CELL;
                borrow = 1;
            } else {
                borrow = 0;
            }
            diff[i] = d;
        }
        if (borrow != 0) {
            throw new IllegalArgumentException();
        }
        for (newSize = diff.length; newSize > 0 && diff[newSize - 1] == 0; --newSize) {
        }
        if (newSize < diff.length) {
            int[] newDiff = new int[newSize];
            System.arraycopy(diff, 0, newDiff, 0, newDiff.length);
            diff = newDiff;
        }
        return diff;
    }

    private int compare(int[] d1, int[] d2) {
        if (d1.length > d2.length) {
            return 1;
        }
        if (d1.length < d2.length) {
            return -1;
        }
        for (int i = d1.length - 1; i >= 0; --i) {
            int n1 = d1[i];
            int n2 = d2[i];
            if (n1 > n2) {
                return 1;
            }
            if (n1 >= n2) continue;
            return -1;
        }
        return 0;
    }
}

