/*
 * Decompiled with CFR 0.152.
 */
package com.sun.demoapi.lists;

public class DoublyLinkedList {
    private Entry first;
    private Entry last;

    public boolean isEmpty() {
        return this.first == null;
    }

    public boolean contains(Object data) {
        Entry e = this.first;
        while (e != null) {
            if (e.data == data) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public Entry getFirst() {
        return this.first;
    }

    public Entry getLast() {
        return this.last;
    }

    public void insert(Object data) {
        Entry e = new Entry(data, null, this.first);
        if (this.first == null) {
            this.last = e;
        } else {
            this.first.prev = e;
        }
        this.first = e;
    }

    public void append(Object o) {
        Entry e = new Entry(o, this.last, null);
        if (this.first == null) {
            this.first = e;
        } else {
            this.last.next = e;
        }
        this.last = e;
    }

    public boolean remove(Object data) {
        Entry e = this.first;
        Entry prev = null;
        while (e != null) {
            if (e.data == data) {
                e.remove();
                return true;
            }
            prev = e;
            e = e.next;
        }
        return false;
    }

    public boolean equals(Object other) {
        if (!(other instanceof DoublyLinkedList)) {
            return false;
        }
        Entry e1 = this.first;
        Entry e2 = ((DoublyLinkedList)other).first;
        while (e1 != null && e2 != null) {
            boolean match;
            boolean bl = e1.data == null ? e2.data == null : (match = e1.data.equals(e2.data));
            if (!match) {
                return false;
            }
            e1 = e1.next;
            e2 = e2.next;
        }
        return e1 == null && e2 == null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("DoublyLinkedList[");
        Entry p = this.first;
        while (p != null) {
            if (p != this.first) {
                sb.append(",");
            }
            sb.append(String.valueOf(p.data));
            p = p.next;
        }
        sb.append("]");
        return sb.toString();
    }

    public class Entry {
        Object data;
        Entry prev;
        Entry next;

        Entry(Object data, Entry prev, Entry next) {
            this.data = data;
            this.prev = prev;
            this.next = next;
        }

        public Object getData() {
            return this.data;
        }

        public Entry getNext() {
            return this.next;
        }

        public Entry getPrevious() {
            return this.prev;
        }

        public void insertAfter(Object data) {
            Entry e = new Entry(data, this, this.next);
            if (this.next == null) {
                DoublyLinkedList.this.last = e;
            } else {
                this.next.prev = e;
            }
            this.next = e;
        }

        public void insertBefore(Object data) {
            Entry e = new Entry(data, this.prev, this);
            if (this.prev == null) {
                DoublyLinkedList.this.first = e;
            } else {
                this.prev.next = e;
            }
            this.prev = e;
        }

        public Entry remove() {
            if (this.prev == null) {
                DoublyLinkedList.this.first = this.next;
            } else {
                this.prev.next = this.next;
            }
            if (this.next == null) {
                DoublyLinkedList.this.last = this.prev;
            } else {
                this.next.prev = this.prev;
            }
            return this.next;
        }
    }
}

