/*
 * Decompiled with CFR 0.152.
 */
package com.sun.demoapi.lists;

public class SortedList {
    private Entry first;
    private Comparator comp;
    private boolean ignoreDuplicates;

    public SortedList(Comparator comp, boolean ignoreDuplicates) {
        this.comp = comp;
        this.ignoreDuplicates = ignoreDuplicates;
    }

    public boolean isEmpty() {
        return this.first == null;
    }

    public boolean contains(Object data) {
        Entry e = this.first;
        while (e != null) {
            if (this.comp.compare(e.data, data) == 0) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public Entry getFirst() {
        return this.first;
    }

    public boolean insert(Object data) {
        if (this.first == null) {
            this.first = new Entry(data, null);
            return true;
        }
        Entry prev = null;
        Entry e = this.first;
        while (e != null) {
            int c = this.comp.compare(data, e.data);
            if (c <= 0) {
                if (c != 0 || !this.ignoreDuplicates) break;
                return false;
            }
            prev = e;
            e = e.next;
        }
        if (prev == null) {
            this.first = new Entry(data, this.first);
        } else {
            prev.next = new Entry(data, prev.next);
        }
        return true;
    }

    public boolean remove(Object data) {
        Entry e = this.first;
        Entry prev = null;
        while (e != null) {
            if (this.comp.compare(e.data, data) == 0) {
                if (prev == null) {
                    this.first = e.next;
                } else {
                    prev.next = e.next;
                }
                return true;
            }
            prev = e;
            e = e.next;
        }
        return false;
    }

    public boolean equals(Object other) {
        if (!(other instanceof SortedList)) {
            return false;
        }
        Entry e1 = this.first;
        Entry e2 = ((SortedList)other).first;
        while (e1 != null && e2 != null) {
            boolean match;
            boolean bl = e1.data == null ? e2.data == null : (match = e1.data.equals(e2.data));
            if (!match) {
                return false;
            }
            e1 = e1.next;
            e2 = e2.next;
        }
        return e1 == null && e2 == null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("SortedList[");
        Entry p = this.first;
        while (p != null) {
            if (p != this.first) {
                sb.append(",");
            }
            sb.append(String.valueOf(p.data));
            p = p.next;
        }
        sb.append("]");
        return sb.toString();
    }

    public static interface Comparator {
        public int compare(Object var1, Object var2);
    }

    public class Entry {
        Object data;
        Entry next;

        Entry(Object data, Entry next) {
            this.data = data;
            this.next = next;
        }

        public Object getData() {
            return this.data;
        }

        public Entry getNext() {
            return this.next;
        }

        public void insertAfter(Object data) {
            this.next = new Entry(data, this.next);
        }

        public Entry remove() {
            Entry e = SortedList.this.first;
            Entry prev = null;
            while (e != null) {
                if (e == this) {
                    if (prev == null) {
                        SortedList.this.first = e.next;
                    } else {
                        prev.next = e.next;
                    }
                    return this.next;
                }
                prev = e;
                e = e.next;
            }
            throw new IllegalStateException();
        }
    }
}

