/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import java.util.Arrays;
import java.util.HashMap;

public class ResourceTable {
    private HashMap table;

    public ResourceTable() {
        this.table = new HashMap();
    }

    public ResourceTable(int initialSize) {
        this.table = new HashMap(initialSize);
    }

    public synchronized boolean acquire(String[] resourceNames, int timeout) throws InterruptedException {
        long start;
        if (timeout <= 0) {
            throw new IllegalArgumentException("timeout required");
        }
        if (resourceNames.length > 1) {
            Object[] s = new String[resourceNames.length];
            System.arraycopy(resourceNames, 0, s, 0, s.length);
            Arrays.sort(s);
            resourceNames = s;
        }
        long now = start = System.currentTimeMillis();
        try {
            for (int i = 0; i < resourceNames.length; ++i) {
                String resourceName = resourceNames[i];
                Object owner = null;
                while (true) {
                    Object v = this.table.get(resourceName);
                    owner = v;
                    if (v == null) break;
                    long remain = start + (long)timeout - now;
                    if (remain < 0L) {
                        this.release((String[])resourceNames);
                        return false;
                    }
                    this.wait(remain);
                    now = System.currentTimeMillis();
                }
                this.table.put(resourceName, Thread.currentThread());
            }
            return true;
        }
        catch (InterruptedException e) {
            this.release((String[])resourceNames);
            throw e;
        }
    }

    public synchronized void release(String[] resourceNames) {
        for (int i = 0; i < resourceNames.length; ++i) {
            Object owner = this.table.get(resourceNames[i]);
            if (owner != Thread.currentThread()) continue;
            this.table.remove(resourceNames[i]);
        }
        this.notifyAll();
    }
}

