/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.audit;

import com.sun.javatest.ExcludeList;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestFinder;
import com.sun.javatest.TestFinderQueue;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.StringArray;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;

public class Audit {
    private int testCount;
    private int[] checksumCounts = new int[3];
    private int[] envCounts = new int[2];
    private int[] statusCounts = new int[5];
    private boolean badDates = false;
    private TestDescription[] badTests;
    private TestResult[] badTestCaseTests;
    private TestResult[] badTestDescriptions;
    private TestResult[] badChecksumTests;
    private Date earliestStart;
    private Date latestStart;
    private DateFormat[] dateFormats;
    private Hashtable envTable = new Hashtable();
    private PrintStream out;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(Audit.class);

    public Audit(Parameters params) {
        this(Audit.getTestFinderQueue(params), params.getExcludeList(), params.getWorkDirectory());
    }

    private static TestFinderQueue getTestFinderQueue(Parameters params) {
        TestSuite ts = params.getTestSuite();
        TestFinder tf = ts.getTestFinder();
        TestFinderQueue tfq = new TestFinderQueue();
        tfq.setTestFinder(tf);
        String[] tests = params.getTests();
        tfq.setTests(tests);
        TestFilter[] filters = params.getFilters();
        tfq.setFilters(filters);
        return tfq;
    }

    public Audit(TestFinderQueue tfq, ExcludeList excludeList, WorkDirectory workDir) {
        TestDescription td;
        Vector<TestResult> badChecksumTestsV = new Vector<TestResult>();
        Vector<TestResult> badTestDescriptionsV = new Vector<TestResult>();
        Vector<TestResult> badTestCaseTestsV = new Vector<TestResult>();
        Vector<TestDescription> badTestsV = new Vector<TestDescription>();
        workDir.getTestResultTable().waitUntilReady();
        while ((td = tfq.next()) != null) {
            try {
                TestResult tr = new TestResult(workDir, TestResult.getWorkRelativePath(td));
                ++this.testCount;
                int n = tr.getStatus().getType();
                this.statusCounts[n] = this.statusCounts[n] + 1;
                byte by = tr.getChecksumState();
                this.checksumCounts[by] = this.checksumCounts[by] + 1;
                if (tr.getChecksumState() == 1) {
                    badChecksumTestsV.addElement(tr);
                }
                if (!Audit.equal(td, tr.getDescription())) {
                    badTestDescriptionsV.addElement(tr);
                }
                if (!this.checkTestCases(tr, excludeList)) {
                    badTestCaseTestsV.addElement(tr);
                }
                Map trEnv = tr.getEnvironment();
                for (Map.Entry e : trEnv.entrySet()) {
                    String key = (String)e.getKey();
                    String value = (String)e.getValue();
                    Vector<String> allValuesForKey = (Vector<String>)this.envTable.get(key);
                    if (allValuesForKey == null) {
                        allValuesForKey = new Vector<String>();
                        this.envTable.put(key, allValuesForKey);
                    }
                    if (allValuesForKey.contains(value)) continue;
                    allValuesForKey.addElement(value);
                }
                String start = tr.getProperty("start");
                if (start == null) {
                    this.badDates = true;
                    continue;
                }
                Date d = this.parseDate(start);
                if (d == null) {
                    this.badDates = true;
                    continue;
                }
                if (this.earliestStart == null || d.before(this.earliestStart)) {
                    this.earliestStart = d;
                }
                if (this.latestStart != null && !d.after(this.latestStart)) continue;
                this.latestStart = d;
            }
            catch (TestResult.Fault e) {
                badTestsV.addElement(td);
            }
        }
        Enumeration e = this.envTable.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            Vector allValuesForKey = (Vector)this.envTable.get(key);
            int n = allValuesForKey.size() == 1 ? 0 : 1;
            this.envCounts[n] = this.envCounts[n] + 1;
        }
        if (badChecksumTestsV.size() > 0) {
            this.badChecksumTests = new TestResult[badChecksumTestsV.size()];
            badChecksumTestsV.copyInto(this.badChecksumTests);
        }
        if (badTestDescriptionsV.size() > 0) {
            this.badTestDescriptions = new TestResult[badTestDescriptionsV.size()];
            badTestDescriptionsV.copyInto(this.badTestDescriptions);
        }
        if (badTestCaseTestsV.size() > 0) {
            this.badTestCaseTests = new TestResult[badTestCaseTestsV.size()];
            badTestCaseTestsV.copyInto(this.badTestCaseTests);
        }
        if (badTestsV.size() > 0) {
            this.badTests = new TestDescription[badTestsV.size()];
            badTestsV.copyInto(this.badTests);
        }
    }

    public TestResult[] getBadChecksumTests() {
        return this.badChecksumTests;
    }

    public TestResult[] getBadTestDescriptions() {
        return this.badTestDescriptions;
    }

    public TestDescription[] getBadTests() {
        return this.badTests;
    }

    public TestResult[] getBadTestCaseTests() {
        return this.badTestCaseTests;
    }

    public int[] getChecksumCounts() {
        return this.checksumCounts;
    }

    public int[] getEnvCounts() {
        return this.envCounts;
    }

    public Hashtable getEnvTable() {
        return this.envTable;
    }

    public int[] getStatusCounts() {
        return this.statusCounts;
    }

    public Date getEarliestStartTime() {
        return this.earliestStart;
    }

    public Date getLatestStartTime() {
        return this.latestStart;
    }

    public boolean hasBadStartTimes() {
        return this.badDates;
    }

    public boolean isOK() {
        return this.isStatusCountsOK() && this.isChecksumCountsOK() && this.isDateStampsOK() && this.isAllTestsOK() && this.isAllTestCasesOK() && this.isAllTestDescriptionsOK();
    }

    public boolean isAllTestsOK() {
        return this.badTests == null;
    }

    public boolean isAllTestCasesOK() {
        return this.badTestCaseTests == null;
    }

    public boolean isAllTestDescriptionsOK() {
        return this.badTestDescriptions == null;
    }

    public boolean isChecksumCountsOK() {
        return this.checksumCounts[1] == 0;
    }

    public boolean isDateStampsOK() {
        return this.earliestStart != null && this.latestStart != null && !this.badDates;
    }

    public boolean isStatusCountsOK() {
        if (this.testCount == 0) {
            return false;
        }
        for (int i = 0; i < this.statusCounts.length; ++i) {
            if (i == 0 || this.statusCounts[i] == 0) continue;
            return false;
        }
        return this.statusCounts[0] == this.testCount;
    }

    public synchronized void report(PrintStream out, boolean showAllEnvValues, boolean showMultipleEnvValues) {
        this.out = out;
        this.showResultCounts();
        this.showChecksumCounts();
        this.showDateStampInfo();
        this.showEnvCounts();
        this.showBadChecksums();
        this.showBadTestDescriptions();
        this.showBadTestCaseTests();
        this.showBadTests();
        if (showAllEnvValues || showMultipleEnvValues) {
            this.showEnvValues(showAllEnvValues);
        }
    }

    private void showBadChecksums() {
        if (this.badChecksumTests != null) {
            this.out.println("The following " + this.badChecksumTests.length + " tests had bad checksums.");
            for (int i = 0; i < this.badChecksumTests.length; ++i) {
                TestResult tr = this.badChecksumTests[i];
                this.out.println(tr.getWorkRelativePath());
            }
        }
    }

    private void showBadTestDescriptions() {
        if (this.badTestDescriptions != null) {
            this.out.println("The following " + this.badTestDescriptions.length + " tests had bad test descriptions.");
            for (int i = 0; i < this.badTestDescriptions.length; ++i) {
                TestResult tr = this.badTestDescriptions[i];
                this.out.println(tr.getWorkRelativePath());
            }
        }
    }

    private void showBadTestCaseTests() {
        if (this.badTestCaseTests != null) {
            this.out.println(i18n.getString("adt.tooManyTestCases", new Integer(this.badTestCaseTests.length)));
            for (int i = 0; i < this.badTestCaseTests.length; ++i) {
                TestResult tr = this.badTestCaseTests[i];
                this.out.println(tr.getWorkRelativePath());
            }
        }
    }

    private void showBadTests() {
        if (this.badTests != null) {
            this.out.println(i18n.getString("adt.badTests", new Integer(this.badTests.length)));
            for (int i = 0; i < this.badTests.length; ++i) {
                TestDescription td = this.badTests[i];
                this.out.println(TestResult.getWorkRelativePath(td));
            }
        }
    }

    private void showDateStampInfo() {
        if (this.earliestStart == null || this.latestStart == null) {
            this.out.println(i18n.getString("adt.noDateStamps"));
        } else {
            Integer b = new Integer(this.badDates ? 1 : 0);
            this.out.println(i18n.getString("adt.earliestResult", new Object[]{this.earliestStart, b}));
            this.out.println(i18n.getString("adt.latestResult", new Object[]{this.latestStart, b}));
            if (this.badDates) {
                this.out.println(i18n.getString("adt.badDateStamps"));
            }
        }
    }

    private void showEnvCounts() {
        int u = this.envCounts[0];
        int m = this.envCounts[1];
        if (u + m > 0) {
            if (m == 0) {
                this.out.println(i18n.getString("adt.env.allOK"));
            } else {
                this.out.println(i18n.getString("adt.env.count", new Object[]{new Integer(u), new Integer(u > 0 && m > 0 ? 1 : 0), new Integer(m)}));
            }
        }
    }

    private void showEnvValues(boolean showAll) {
        this.out.println();
        this.out.print(i18n.getString("adt.envList.title"));
        TreeSet<String> ss = new TreeSet<String>();
        Enumeration e = this.envTable.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            ss.add(key);
        }
        for (String key : ss) {
            Vector allValuesForKey = (Vector)this.envTable.get(key);
            if (allValuesForKey.size() == 1) {
                if (!showAll) continue;
                this.out.println(i18n.getString("adt.envKeyValue", new Object[]{key, allValuesForKey.elementAt(0)}));
                continue;
            }
            this.out.println(i18n.getString("adt.envKey", key));
            for (int j = 0; j < allValuesForKey.size(); ++j) {
                this.out.println(i18n.getString("adt.envValue", allValuesForKey.elementAt(j)));
            }
        }
    }

    private void showChecksumCounts() {
        if (this.testCount > 0) {
            int g = this.checksumCounts[2];
            int b = this.checksumCounts[1];
            int n = this.checksumCounts[0];
            if (b == 0 && n == 0) {
                this.out.println(i18n.getString("adt.cs.allOK"));
            } else {
                this.out.println(i18n.getString("adt.cs.count", new Object[]{new Integer(g), new Integer(g > 0 && b + n > 0 ? 1 : 0), new Integer(b), new Integer(b > 0 && n > 0 ? 1 : 0), new Integer(n)}));
            }
        }
    }

    private void showResultCounts() {
        if (this.testCount == 0) {
            this.out.println(i18n.getString("adt.status.noTests"));
        } else {
            int p = this.statusCounts[0];
            int f = this.statusCounts[1];
            int e = this.statusCounts[2];
            int nr = this.statusCounts[3];
            if (p == this.testCount) {
                this.out.println(i18n.getString("adt.status.allOK"));
            } else {
                this.out.println(i18n.getString("adt.status.count", new Object[]{new Integer(p), new Integer(p > 0 && f + e + nr > 0 ? 1 : 0), new Integer(f), new Integer(f > 0 && e + nr > 0 ? 1 : 0), new Integer(e), new Integer(e > 0 && nr > 0 ? 1 : 0), new Integer(nr)}));
            }
        }
    }

    private boolean showCount(String msg, boolean needSep, int count) {
        if (count == 0) {
            return needSep;
        }
        this.out.print(i18n.getString(msg, new Object[]{new Integer(needSep ? 1 : 0), new Integer(count)}));
        return true;
    }

    private boolean checkTestCases(TestResult tr, ExcludeList excludeList) throws TestResult.Fault {
        String etcTestProp = tr.getProperty("excludedTestCases");
        if (etcTestProp == null) {
            return true;
        }
        String[] etcTest = StringArray.split(etcTestProp);
        if (excludeList.excludesAllOf(tr.getDescription())) {
            return true;
        }
        String[] etcTable = excludeList.getTestCases(tr.getDescription());
        if (etcTable == null) {
            return false;
        }
        block0: for (int i = 0; i < etcTest.length; ++i) {
            for (int j = 0; j < etcTable.length; ++j) {
                if (etcTest[i].equals(etcTable[j])) continue block0;
            }
            return false;
        }
        return true;
    }

    private static boolean equal(TestDescription a, TestDescription b) {
        if (a == null || b == null) {
            return a == b;
        }
        Iterator eA = a.getParameterKeys();
        Iterator eB = b.getParameterKeys();
        while (eA.hasNext() && eB.hasNext()) {
            String valB;
            String keyB;
            String keyA = (String)eA.next();
            if (!keyA.equals(keyB = (String)eB.next())) {
                return false;
            }
            String valA = a.getParameter(keyA);
            if (valA.equals(valB = a.getParameter(keyB)) || keyA.equals("keywords") && Audit.keywordMatch(valA, valB)) continue;
            return false;
        }
        return true;
    }

    private static final boolean keywordMatch(String a, String b) {
        Object[] aa = StringArray.split(a);
        Arrays.sort(aa);
        Object[] bb = StringArray.split(b);
        Arrays.sort(bb);
        return aa.equals(bb);
    }

    private Date parseDate(String s) {
        if (this.dateFormats == null) {
            this.initDateFormats();
        }
        for (int i = 0; i < this.dateFormats.length; ++i) {
            try {
                Date d = this.dateFormats[i].parse(s);
                if (i > 0) {
                    DateFormat tmp = this.dateFormats[i];
                    System.arraycopy(this.dateFormats, 0, this.dateFormats, 1, i);
                    this.dateFormats[0] = tmp;
                }
                return d;
            }
            catch (ParseException parseException) {
                continue;
            }
        }
        return null;
    }

    private void initDateFormats() {
        Vector<DateFormat> v = new Vector<DateFormat>();
        v.addElement(DateFormat.getDateTimeInstance());
        v.addElement(DateFormat.getDateTimeInstance(2, 2, Locale.ENGLISH));
        v.addElement(new SimpleDateFormat("EEE, dd MMMM yyyy HH:mm:ss zzz"));
        v.addElement(new SimpleDateFormat("EEE, dd MMMM yyyy HH:mm:ss zzz", Locale.ENGLISH));
        v.addElement(new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy"));
        v.addElement(new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.ENGLISH));
        String s = System.getProperty("javatest.date.format");
        if (s != null) {
            v.addElement(new SimpleDateFormat(s));
        }
        this.dateFormats = new DateFormat[v.size()];
        v.copyInto(this.dateFormats);
    }
}

