/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.InterviewParameters;
import com.sun.javatest.exec.CE_EnvironmentPane;
import com.sun.javatest.exec.CE_ExcludeListPane;
import com.sun.javatest.exec.CE_ExecutionPane;
import com.sun.javatest.exec.CE_KeywordsPane;
import com.sun.javatest.exec.CE_PriorStatusPane;
import com.sun.javatest.exec.CE_StdPane;
import com.sun.javatest.exec.CE_TestsPane;
import com.sun.javatest.exec.CE_View;
import com.sun.javatest.tool.ToolDialog;
import com.sun.javatest.tool.UIFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.help.CSH;
import javax.help.HelpSet;
import javax.help.JHelpContentViewer;
import javax.help.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class CE_StdView
extends CE_View {
    static final int TESTS_PANE = 0;
    static final int EXCLUDE_LIST_PANE = 1;
    static final int KEYWORDS_PANE = 2;
    static final int PRIOR_STATUS_PANE = 3;
    static final int ENVIRONMENT_PANE = 4;
    static final int EXECUTION_PANE = 5;
    static final int CONCURRENCY_PANE = 6;
    static final int TIMEOUT_FACTOR_PANE = 7;
    private JTabbedPane tabs;
    private CE_StdPane[] panes;
    private JTextField msgField;
    private Listener localListener = new Listener();

    CE_StdView(InterviewParameters config, JHelpContentViewer infoPanel, UIFactory uif, ActionListener l) {
        super(config, infoPanel, uif, l);
        this.initGUI();
    }

    public Dimension getPreferredSize() {
        Insets tabInsets = this.tabs.getInsets();
        int w = tabInsets == null ? 0 : tabInsets.left + tabInsets.right;
        Graphics g = this.tabs.getGraphics();
        if (g != null) {
            FontMetrics fm = g.getFontMetrics();
            for (int i = 0; i < this.tabs.getTabCount(); ++i) {
                w += 15 + fm.stringWidth(this.tabs.getTitleAt(i));
            }
        }
        Dimension d = super.getPreferredSize();
        d.width = Math.max(d.width, w);
        return d;
    }

    public void setVisible(boolean b) {
        if (b) {
            this.load();
        }
        super.setVisible(b);
    }

    public void setParentToolDialog(ToolDialog d) {
        super.setParentToolDialog(d);
        for (CE_StdPane pane : this.panes) {
            pane.setParentToolDialog(d);
        }
    }

    void showTab(int id) {
        Class c;
        switch (id) {
            case 0: {
                c = CE_TestsPane.class;
                break;
            }
            case 1: {
                c = CE_ExcludeListPane.class;
                break;
            }
            case 2: {
                c = CE_KeywordsPane.class;
                break;
            }
            case 3: {
                c = CE_PriorStatusPane.class;
                break;
            }
            case 4: {
                c = CE_EnvironmentPane.class;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                c = CE_ExecutionPane.class;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        for (int i = 0; i < this.tabs.getTabCount(); ++i) {
            Component tab = this.tabs.getComponentAt(i);
            if (!c.isAssignableFrom(tab.getClass())) continue;
            this.tabs.setSelectedIndex(i);
            return;
        }
    }

    boolean isOKToClose() {
        CE_StdPane currPane = (CE_StdPane)this.tabs.getSelectedComponent();
        if (currPane == null) {
            return true;
        }
        return currPane.isOKToClose();
    }

    void load() {
        for (int i = 0; i < this.panes.length; ++i) {
            this.panes[i].load();
        }
    }

    void save() {
        for (int i = 0; i < this.panes.length; ++i) {
            this.panes[i].save();
        }
    }

    void setCheckExcludeListListener(ActionListener l) {
        for (int i = 0; i < this.panes.length; ++i) {
            CE_StdPane pane = this.panes[i];
            if (!(pane instanceof CE_ExcludeListPane)) continue;
            ((CE_ExcludeListPane)pane).setCheckExcludeListListener(l);
        }
    }

    private void initGUI() {
        this.setName("std");
        CSH.setHelpIDString(this, "confEdit.stdView.csh");
        this.setLayout(new BorderLayout());
        this.initBody();
        this.initButtons();
    }

    private void initBody() {
        CE_KeywordsPane kp = new CE_KeywordsPane(this.uif, this.config);
        kp.setParentToolDialog(this.toolDialog);
        this.panes = new CE_StdPane[]{new CE_TestsPane(this.uif, this.config), new CE_ExcludeListPane(this.uif, this.config), kp, new CE_PriorStatusPane(this.uif, this.config), new CE_EnvironmentPane(this.uif, this.config), new CE_ExecutionPane(this.uif, this.config)};
        this.tabs = new JTabbedPane(){

            public void setSelectedIndex(int index) {
                if (index == this.getSelectedIndex()) {
                    return;
                }
                CE_StdPane p = (CE_StdPane)this.getSelectedComponent();
                if (p != null && !p.isOKToClose()) {
                    return;
                }
                super.setSelectedIndex(index);
            }
        };
        this.tabs.setName("tabs");
        this.uif.setAccessibleName(this.tabs, "ce.tabs");
        this.uif.setToolTip(this.tabs, "ce.tabs");
        for (int i = 0; i < this.panes.length; ++i) {
            if (!this.panes[i].isEnabled()) continue;
            this.uif.addTab(this.tabs, "ce." + this.panes[i].getName(), this.panes[i]);
        }
        this.tabs.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.tabs.addChangeListener(this.localListener);
        this.add((Component)this.tabs, "Center");
        this.addAncestorListener(this.localListener);
    }

    private void initButtons() {
        JPanel btnPanel = this.uif.createPanel("ce.std.btns", new GridBagLayout(), false);
        GridBagConstraints c = new GridBagConstraints();
        c.insets.top = 5;
        c.insets.bottom = 11;
        c.insets.right = 5;
        c.insets.left = 11;
        c.fill = 2;
        c.weightx = 1.0;
        this.msgField = this.uif.createOutputField("ce.msgs");
        this.msgField.setBorder(null);
        this.msgField.setEnabled(false);
        btnPanel.add((Component)this.msgField, c);
        c.weightx = 0.0;
        c.insets.left = 0;
        c.insets.right = 11;
        JButton doneBtn = this.uif.createButton("ce.done", this.listener, "done");
        btnPanel.add((Component)doneBtn, c);
        this.add((Component)btnPanel, "South");
    }

    private void showInfoForTab(CE_StdPane p) {
        Map.ID id = (Map.ID)p.getClientProperty(this);
        if (id == null) {
            Map map;
            String s = "ConfigEditor.stdValues." + p.getName();
            HelpSet configHelpSet = this.config.getHelpSet();
            if (configHelpSet != null && (map = configHelpSet.getCombinedMap()).isValidID(s, configHelpSet)) {
                id = Map.ID.create(s, configHelpSet);
                p.putClientProperty(this, id);
            }
        }
        if (id == null) {
            System.err.println("CESV: no help for " + p);
        } else {
            this.showInfo(id);
        }
    }

    private class Listener
    implements AncestorListener,
    ChangeListener {
        private Listener() {
        }

        public void ancestorAdded(AncestorEvent e) {
            this.updateCSHAndInfo();
        }

        public void ancestorMoved(AncestorEvent e) {
        }

        public void ancestorRemoved(AncestorEvent e) {
        }

        public void stateChanged(ChangeEvent e) {
            this.updateCSHAndInfo();
        }

        private void updateCSHAndInfo() {
            CE_StdPane p = (CE_StdPane)CE_StdView.this.tabs.getSelectedComponent();
            CSH.setHelpIDString(CE_StdView.this.tabs, CSH.getHelpIDString(p));
            if (CE_StdView.this.isInfoVisible()) {
                CE_StdView.this.showInfoForTab(p);
            }
        }
    }
}

