/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.InterviewParameters;
import com.sun.javatest.TestFilter;
import com.sun.javatest.exec.ContextManager;
import com.sun.javatest.exec.ExecModel;
import com.sun.javatest.exec.FilterConfig;
import com.sun.javatest.exec.FilterSelectionHandler;
import com.sun.javatest.exec.ReportBrowser;
import com.sun.javatest.report.CustomReport;
import com.sun.javatest.report.Report;
import com.sun.javatest.report.ReportDirChooser;
import com.sun.javatest.tool.ToolDialog;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.DynamicArray;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;

class NewReportDialog
extends ToolDialog {
    private static final String ACTION_MAP_KEY = "listMnemonics";
    private ActionListener cbHtmlListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            if (src == NewReportDialog.this.cbHtml || src == NewReportDialog.this.cbConfig) {
                NewReportDialog.this.updateHtmlCheckboxStates();
            } else if (src == NewReportDialog.this.cbBak) {
                NewReportDialog.this.numBak.setEnabled(NewReportDialog.this.cbBak.isSelected());
            } else if (src == NewReportDialog.this.cbCof) {
                NewReportDialog.this.updateCofCheckboxStates();
            }
        }
    };
    private ActionListener listener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            if (src == NewReportDialog.this.browseBtn) {
                NewReportDialog.this.showReportChooserDialog();
            } else if (src == NewReportDialog.this.cancelBtn) {
                NewReportDialog.this.setState(NewReportDialog.this.lastSettings);
                NewReportDialog.this.setVisible(false);
            } else if (src == NewReportDialog.this.okBtn) {
                String s = NewReportDialog.this.dirField.getText();
                if (s == null || s.length() == 0) {
                    NewReportDialog.this.uif.showError("nrd.emptyInput");
                    return;
                }
                if (NewReportDialog.this.cbBak.isSelected() && NewReportDialog.this.numBak.getText().equals("")) {
                    NewReportDialog.this.uif.showError("nrd.emptyBak");
                    NewReportDialog.this.tabs.setSelectedIndex(NewReportDialog.this.tabs.getTabCount() - 1);
                    return;
                }
                for (CustomReport cr : NewReportDialog.this.getActiveCustomReports()) {
                    String error = cr.validateOptions();
                    if (error == null) continue;
                    for (int i = 0; i < NewReportDialog.this.listModel.getSize(); ++i) {
                        JCheckBox cb = (JCheckBox)NewReportDialog.this.listModel.elementAt(i);
                        if (!cb.getName().equals(cr.getReportId())) continue;
                        NewReportDialog.this.list.setSelectedIndex(i);
                    }
                    NewReportDialog.this.uif.showError("nrd.optionsErr", new Object[]{error});
                    return;
                }
                NewReportDialog.this.reportDir = new File(s);
                try {
                    if (!NewReportDialog.this.reportDir.isDirectory()) {
                        NewReportDialog.this.reportDir.mkdirs();
                    } else if (!Report.isReportDirectory(NewReportDialog.this.reportDir) && !NewReportDialog.this.isEmptyDirectory(NewReportDialog.this.reportDir)) {
                        NewReportDialog.this.uif.showError("nrd.cantUse", NewReportDialog.this.reportDir);
                        return;
                    }
                    NewReportDialog.this.setVisible(false);
                    NewReportDialog.this.lastSettings = NewReportDialog.this.captureState();
                    NewReportDialog.this.notifyStarting();
                    this.doBgReport(NewReportDialog.this.lastSettings);
                }
                catch (SecurityException se) {
                    NewReportDialog.this.uif.showError("nrd.cantCreate", se.getMessage());
                }
            }
        }

        private void doBgReport(final Report.Settings snap) {
            NewReportDialog.this.waitDialog = NewReportDialog.this.uif.createWaitDialog("nrd.wait", NewReportDialog.this.parent);
            final Stopper stopper = new Stopper();
            final Thread worker = new Thread(){

                public void run() {
                    try {
                        NewReportDialog.this.runReport(snap);
                        this.finishReport(NewReportDialog.this.waitDialog, snap, stopper);
                    }
                    catch (CustomReport.ReportException ie) {
                        this.showError("nrd.custom", ie.getMessage(), NewReportDialog.this.waitDialog);
                        NewReportDialog.this.notifyError(ie.getMessage());
                    }
                    catch (IOException ie) {
                        this.showError("nrd.cantWrite", ie.getMessage(), NewReportDialog.this.waitDialog);
                        NewReportDialog.this.notifyError(ie.getMessage());
                    }
                    catch (SecurityException se) {
                        this.showError("nrd.cantCreate", se.getMessage(), NewReportDialog.this.waitDialog);
                        NewReportDialog.this.notifyError(se.getMessage());
                    }
                    catch (RuntimeException re) {
                        this.showError("nrd.errorWriting", re.getMessage(), NewReportDialog.this.waitDialog);
                        NewReportDialog.this.notifyErrorWriting(re.getMessage());
                    }
                }
            };
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 0;
            gbc.anchor = 10;
            gbc.insets.bottom = 10;
            gbc.insets.top = 10;
            gbc.gridy = 2;
            gbc.gridx = 0;
            JButton cancelBtn = NewReportDialog.this.uif.createButton("nrd.cancel");
            NewReportDialog.this.waitDialog.getContentPane().add((Component)cancelBtn, gbc);
            NewReportDialog.this.waitDialog.pack();
            final String cancelling = NewReportDialog.this.uif.getI18NString("nrd.cancelling");
            cancelBtn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JButton butt = (JButton)e.getSource();
                    butt.setEnabled(false);
                    Component[] cmp = NewReportDialog.this.waitDialog.getContentPane().getComponents();
                    if (worker != null && worker.isAlive()) {
                        stopper.waitWasHidden = true;
                        worker.interrupt();
                    }
                    for (int i = 0; i < cmp.length; ++i) {
                        if (!"nrd.wait".equals(cmp[i].getName())) continue;
                        if (!(cmp[i] instanceof JTextComponent)) break;
                        ((JTextComponent)cmp[i]).setText(cancelling);
                        break;
                    }
                }
            });
            ActionListener al = new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    if (worker.isAlive()) {
                        NewReportDialog.this.waitDialog.show();
                    }
                }
            };
            Timer timer = new Timer(3000, al);
            timer.setRepeats(false);
            timer.start();
            worker.start();
        }

        private void finishReport(final JDialog waitDialog, final Report.Settings snap, final Stopper stopper) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    waitDialog.hide();
                    if (!stopper.waitWasHidden) {
                        int r = NewReportDialog.this.uif.showYesNoDialog("nrd.showReport");
                        switch (r) {
                            case 0: {
                                File index = new File(NewReportDialog.this.reportDir, "index.html");
                                if (index.exists() && index.canRead()) {
                                    NewReportDialog.this.showReportBrowser(index);
                                    break;
                                }
                                NewReportDialog.this.showReportBrowser(this.selectFileToShow(snap));
                                break;
                            }
                            case 1: {
                                break;
                            }
                        }
                    }
                    NewReportDialog.this.notifyDone();
                    NewReportDialog.this.notifyUpdate(NewReportDialog.this.getLastState());
                }
            });
        }

        private void showError(final String uiKey, final String msg, final JDialog waitDialog) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    waitDialog.hide();
                    NewReportDialog.this.uif.showError(uiKey, msg);
                }
            });
        }

        private File selectFileToShow(Report.Settings snap) {
            File result = new File(NewReportDialog.this.reportDir, "index.html");
            if (!result.exists()) {
                if (snap.isHtmlEnabled()) {
                    result = this.searchForFile(NewReportDialog.this.reportDir, Report.getHtmlReportFilenames());
                    if (result == null) {
                        result = NewReportDialog.this.reportDir;
                    }
                } else {
                    result = NewReportDialog.this.reportDir;
                }
            }
            return result;
        }

        private File searchForFile(File dir, String[] names) {
            for (int i = 0; i < names.length; ++i) {
                File f = new File(NewReportDialog.this.reportDir, names[i]);
                if (!f.exists()) continue;
                return f;
            }
            return null;
        }
    };
    private Observer[] obs = new Observer[0];
    private ExecModel model;
    private ReportDirChooser reportDirChooser;
    private DefaultListModel listModel;
    private JList list;
    private JTextArea infoArea;
    private CustomReport[] customReports;
    private HashMap customBoxes;
    private JComponent[] panes;
    private JCheckBox cbHtml;
    private JCheckBox cbPlain;
    private JCheckBox cbXml;
    private JCheckBox cbCof;
    private JCheckBox cbCofTestCases;
    private JCheckBox cbConfig;
    private JCheckBox cbQl;
    private JCheckBox cbEnv;
    private JCheckBox cbStd;
    private JCheckBox cbKfl;
    private JCheckBox cbResults;
    private JCheckBox cbKws;
    private JCheckBox cbPass;
    private JCheckBox cbFail;
    private JCheckBox cbErr;
    private JCheckBox cbNr;
    private JCheckBox cbHtmlRpt;
    private JCheckBox cbHtmlInd;
    private JCheckBox cbKflTc;
    private JCheckBox cbKflF2f;
    private JCheckBox cbKflF2e;
    private JCheckBox cbKflMissing;
    private JCheckBox cbBak;
    private JTextField numBak;
    private ArrayList htmlGroup = new ArrayList();
    private ArrayList configGroup = new ArrayList();
    private ArrayList kflGroup = new ArrayList();
    private File reportDir;
    private JButton browseBtn;
    private JButton okBtn;
    private JButton cancelBtn;
    private JTextField dirField;
    private JTabbedPane tabs;
    private Report.Settings lastSettings;
    private ReportBrowser reportBrowser;
    private InterviewParameters interviewParams;
    private FilterSelectionHandler filterHandler;
    static final String REPORT_DIR = "reportDir";
    private static final String FILTER = "filter";
    private static final int WAIT_DIALOG_DELAY = 3000;
    private JDialog waitDialog;

    NewReportDialog(Component parent, UIFactory uif, FilterConfig f, ReportBrowser reportBrowser, ExecModel model) {
        super(parent, uif, "nrd");
        this.model = model;
        this.filterHandler = f.createFilterSelectionHandler();
        this.reportBrowser = reportBrowser;
    }

    public void setInterviewParameters(InterviewParameters p) {
        this.interviewParams = p;
    }

    void setLastState(Map h) {
        String rd = (String)h.get(REPORT_DIR);
        String filter = (String)h.get(FILTER);
        if (this.dirField == null) {
            this.initGUI();
        }
        this.dirField.setText(rd);
        if (filter != null && filter.length() > 0) {
            this.filterHandler.setFilter(filter);
        }
        this.updateHtmlCheckboxStates();
        this.updateCofCheckboxStates();
    }

    Map getLastState() {
        String rd = this.dirField.getText();
        String filter = this.filterHandler.getActiveFilter().getName();
        HashMap<String, String> lastState = new HashMap<String, String>();
        if (rd != null && rd.length() > 0) {
            lastState.put(REPORT_DIR, rd);
        }
        if (filter != null && filter.length() > 0) {
            lastState.put(FILTER, filter);
        }
        return lastState;
    }

    void addObserver(Observer o) {
        this.obs = (Observer[])DynamicArray.append(this.obs, o);
    }

    void removeObserver(Observer o) {
        this.obs = (Observer[])DynamicArray.remove((Object[])this.obs, o);
    }

    private void notifyUpdate(Map s) {
        for (Observer o : this.obs) {
            o.update(s);
        }
    }

    private void notifyStarting() {
        for (Observer o : this.obs) {
            o.writingReport();
        }
    }

    private void notifyDone() {
        for (Observer o : this.obs) {
            o.wroteReport();
        }
    }

    private void notifyError(String problem) {
        for (Observer o : this.obs) {
            o.wroteReport();
        }
    }

    private void notifyErrorWriting(String problem) {
        for (Observer o : this.obs) {
            o.errorWriting(problem);
        }
    }

    protected void initGUI() {
        this.setHelp("report.newReport.csh");
        this.setI18NTitle("nrd.title");
        JPanel body = new JPanel(){

            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                int dpi = NewReportDialog.this.uif.getDotsPerInch();
                return new Dimension(Math.max(d.width, 5 * dpi), d.height);
            }
        };
        body.setName("nrd.body");
        body.setFocusable(false);
        body.setLayout(new GridBagLayout());
        body.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        int dpi = this.uif.getDotsPerInch();
        GridBagConstraints lc = new GridBagConstraints();
        lc.anchor = 13;
        lc.insets.right = 10;
        lc.insets.bottom = 11;
        lc.weighty = 0.0;
        lc.weightx = 0.0;
        lc.fill = 2;
        lc.gridwidth = 1;
        JLabel dirLabel = this.uif.createLabel("nrd.dir", true);
        body.add((Component)dirLabel, lc);
        this.dirField = this.uif.createInputField("nrd.dir.choice", dirLabel);
        lc.weightx = 3.0;
        body.add((Component)this.dirField, lc);
        this.browseBtn = this.uif.createButton("nrd.browse", this.listener);
        this.browseBtn.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(0, 3, 0, 3)));
        lc.gridwidth = 0;
        lc.insets.left = 11;
        lc.weightx = 0.0;
        body.add((Component)this.browseBtn, lc);
        lc.insets.left = 0;
        lc.gridwidth = 1;
        if (this.filterHandler != null) {
            JLabel filterLabel = this.uif.createLabel("nrd.filter", true);
            body.add((Component)filterLabel, lc);
            JComponent selector = this.filterHandler.getFilterSelector();
            filterLabel.setLabelFor(selector);
            lc.gridwidth = 0;
            lc.weightx = 4.0;
            lc.anchor = 17;
            lc.fill = 0;
            body.add((Component)selector, lc);
        }
        lc.anchor = 18;
        lc.gridwidth = 0;
        lc.fill = 1;
        lc.insets.bottom = 12;
        lc.weighty = 4.0;
        lc.weighty = 1.0;
        JPanel middle = this.uif.createPanel("nrd.middle", false);
        middle.setLayout(new BorderLayout());
        middle.setBorder(BorderFactory.createCompoundBorder(this.uif.createTitledBorder("nrd.middle"), BorderFactory.createEmptyBorder(12, 12, 12, 12)));
        this.panes = new JComponent[]{this.createHtmlBlock(), this.createFilesBlock(), this.createKflBlock()};
        this.tabs = this.uif.createTabbedPane("nrd.tabs", this.panes);
        this.tabs.setTabPlacement(1);
        this.tabs.setBorder(BorderFactory.createEmptyBorder());
        this.listModel = new DefaultListModel();
        CardLayout cards = new CardLayout();
        JPanel p = this.uif.createPanel("nrd.typecards", cards, false);
        this.cbHtml = this.uif.createCheckBox("nrd.type.html", true);
        this.listModel.addElement(this.cbHtml);
        p.add("nrd.type.html", this.tabs);
        this.cbPlain = this.uif.createCheckBox("nrd.type.pt", true);
        this.listModel.addElement(this.cbPlain);
        p.add("nrd.type.pt", this.uif.createPanel("nrd.blank", false));
        this.cbXml = this.uif.createCheckBox("nrd.type.xml", false);
        this.listModel.addElement(this.cbXml);
        p.add("nrd.type.xml", this.uif.createPanel("nrd.blank", false));
        this.cbCof = this.uif.createCheckBox("nrd.type.cof", false);
        this.listModel.addElement(this.cbCof);
        JPanel cofpanel = this.createCofPane();
        p.add("nrd.type.cof", cofpanel);
        this.getCustomReports(p);
        this.list = this.uif.createList("nrd.typel", this.listModel);
        this.list.setSelectionMode(0);
        SelectListener sl = new SelectListener(this.list, p, cards);
        this.list.addMouseListener(sl);
        this.list.addKeyListener(sl);
        this.list.addListSelectionListener(sl);
        this.list.setCellRenderer(new CheckBoxListCellRenderer());
        this.list.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(0, 3, 0, 3)));
        this.infoArea = this.uif.createMessageArea("nrd.info");
        this.infoArea.setRows(3);
        Font f = this.infoArea.getFont();
        f = f.deriveFont(0, f.getSize2D() - 1.0f);
        this.infoArea.setFont(f);
        JPanel right = this.uif.createPanel("nrd.rptright", false);
        right.setLayout(new BorderLayout());
        right.add((Component)this.infoArea, "First");
        right.add((Component)p, "Center");
        middle.add((Component)right, "Center");
        JScrollPane listPane = this.uif.createScrollPane(this.list);
        middle.add((Component)listPane, "West");
        body.add((Component)middle, lc);
        AbstractAction listMnemonics = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                int ord;
                try {
                    ord = Integer.parseInt(e.getActionCommand()) - 1;
                }
                catch (Exception ex) {
                    return;
                }
                if (ord == -1) {
                    ord = 9;
                }
                if (ord <= NewReportDialog.this.list.getModel().getSize()) {
                    NewReportDialog.this.list.requestFocusInWindow();
                    NewReportDialog.this.list.setSelectedIndex(ord);
                }
            }
        };
        this.list.getActionMap().put(ACTION_MAP_KEY, listMnemonics);
        int itemCount = this.listModel.size();
        if (itemCount > 9) {
            itemCount = 9;
        }
        for (int i = 1; i <= itemCount; ++i) {
            this.list.getInputMap(2).put(KeyStroke.getKeyStroke(i + 48, 512), ACTION_MAP_KEY);
            JCheckBox box = (JCheckBox)this.listModel.getElementAt(i - 1);
            box.setMnemonic(i + 48);
            box.setText(Character.toString((char)(48 + i)) + " " + box.getText());
        }
        if (this.listModel.size() == 10) {
            this.list.getInputMap(2).put(KeyStroke.getKeyStroke(48, 512), ACTION_MAP_KEY);
            JCheckBox box = (JCheckBox)this.listModel.getElementAt(9);
            box.setMnemonic('0');
            box.setText("0 " + box.getText());
        }
        JPanel bottom = this.createBackupOpsPane();
        bottom.setBorder(BorderFactory.createCompoundBorder(this.uif.createTitledBorder("nrd.backup"), BorderFactory.createEmptyBorder(12, 12, 12, 12)));
        body.add((Component)bottom, lc);
        this.setBody(body);
        this.okBtn = this.uif.createButton("nrd.ok", this.listener);
        sl.setOkBtn(this.okBtn);
        this.cancelBtn = this.uif.createCancelButton("nrd.cancel", this.listener);
        JButton helpBtn = this.uif.createHelpButton("nrd.help", "report.newReport.csh");
        this.setButtons(new JButton[]{this.okBtn, this.cancelBtn, helpBtn}, this.cancelBtn);
        this.list.setSelectedIndex(0);
        this.setState(Report.getSettingsPrefs());
    }

    private JComponent createHtmlBlock() {
        JCheckBox cb;
        JPanel p = this.uif.createPanel("nrd.htmlops", new GridBagLayout(), false);
        p.setName("htmlops");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.gridwidth = 2;
        gbc.gridy = 0;
        JTextArea info = this.uif.createMessageArea("nrd.htmlops");
        p.add((Component)info, gbc);
        this.cbConfig = cb = this.uif.createCheckBox("nrd.htmlops.config", true);
        this.cbConfig.addActionListener(this.cbHtmlListener);
        this.htmlGroup.add(cb);
        gbc.gridy = 1;
        p.add((Component)cb, gbc);
        gbc.gridwidth = 1;
        gbc.gridy = 2;
        cb = this.cbQl = this.uif.createCheckBox("nrd.htmlops.ql", true);
        this.configGroup.add(cb);
        this.htmlGroup.add(cb);
        p.add(this.uif.createHorizontalStrut(25), gbc);
        p.add((Component)cb, gbc);
        gbc.gridy = 3;
        cb = this.cbEnv = this.uif.createCheckBox("nrd.htmlops.env", false);
        this.configGroup.add(cb);
        this.htmlGroup.add(cb);
        p.add(this.uif.createHorizontalStrut(25), gbc);
        p.add((Component)cb, gbc);
        gbc.gridy = 4;
        cb = this.cbStd = this.uif.createCheckBox("nrd.htmlops.std", false);
        this.configGroup.add(cb);
        this.htmlGroup.add(cb);
        p.add(this.uif.createHorizontalStrut(25), gbc);
        p.add((Component)cb, gbc);
        gbc.gridy = 5;
        gbc.gridwidth = 2;
        cb = this.cbResults = this.uif.createCheckBox("nrd.htmlops.res", true);
        this.htmlGroup.add(cb);
        p.add((Component)cb, gbc);
        gbc.gridy = 6;
        gbc.gridwidth = 2;
        cb = this.cbKfl = this.uif.createCheckBox("nrd.htmlops.kfl", true);
        this.htmlGroup.add(cb);
        p.add((Component)cb, gbc);
        cb = this.cbKws = this.uif.createCheckBox("nrd.htmlops.kw", true);
        this.htmlGroup.add(cb);
        gbc.gridy = 7;
        p.add((Component)cb, gbc);
        JScrollPane sp = this.uif.createScrollPane(p, 20, 30);
        sp.setViewportBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5), this.uif.createTitledBorder("nrd.htmlops")));
        sp.addPropertyChangeListener("enabled", new PanelEnableListener(sp));
        return sp;
    }

    private JComponent createFilesBlock() {
        JPanel p = this.uif.createPanel("nrd.htmlf", new GridBagLayout(), false);
        p.setName("htmlf");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.anchor = 17;
        gbc.gridwidth = 3;
        gbc.gridy = 0;
        JTextArea info = this.uif.createMessageArea("nrd.htmlf");
        p.add((Component)info, gbc);
        JLabel lab = this.uif.createLabel("nrd.htmlf.main", false);
        gbc.gridy = 1;
        p.add((Component)lab, gbc);
        gbc.gridwidth = 1;
        gbc.gridy = 2;
        JCheckBox cb = this.cbHtmlRpt = this.uif.createCheckBox("nrd.htmlf.rpt", true);
        this.cbHtmlRpt.addActionListener(this.cbHtmlListener);
        this.htmlGroup.add(cb);
        p.add(this.uif.createHorizontalStrut(25), gbc);
        gbc.gridwidth = 2;
        p.add((Component)cb, gbc);
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        cb = this.cbHtmlInd = this.uif.createCheckBox("nrd.htmlf.idx", false);
        this.cbHtmlInd.addActionListener(this.cbHtmlListener);
        this.htmlGroup.add(cb);
        p.add(this.uif.createHorizontalStrut(25), gbc);
        gbc.gridwidth = 2;
        p.add((Component)cb, gbc);
        gbc.gridy = 4;
        gbc.gridwidth = 3;
        lab = this.uif.createLabel("nrd.htmlf.xtra", false);
        p.add((Component)lab, gbc);
        gbc.gridy = 5;
        cb = this.uif.createCheckBox("nrd.htmlf.pass", true);
        this.htmlGroup.add(cb);
        this.cbPass = cb;
        gbc.gridwidth = 1;
        p.add(this.uif.createHorizontalStrut(25), gbc);
        p.add((Component)cb, gbc);
        cb = this.cbErr = this.uif.createCheckBox("nrd.htmlf.err", true);
        this.htmlGroup.add(cb);
        p.add((Component)cb, gbc);
        gbc.gridy = 6;
        cb = this.cbFail = this.uif.createCheckBox("nrd.htmlf.fail", true);
        this.htmlGroup.add(cb);
        p.add(this.uif.createHorizontalStrut(25), gbc);
        p.add((Component)cb, gbc);
        cb = this.cbNr = this.uif.createCheckBox("nrd.htmlf.nr", true);
        this.htmlGroup.add(cb);
        p.add((Component)cb, gbc);
        JScrollPane sp = this.uif.createScrollPane(p, 20, 30);
        sp.setViewportBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5), this.uif.createTitledBorder("nrd.htmlf")));
        sp.addPropertyChangeListener("enabled", new PanelEnableListener(sp));
        return sp;
    }

    private JPanel createCofPane() {
        JPanel cofpanel = this.uif.createPanel("nrd.cofops");
        cofpanel.setLayout(new GridBagLayout());
        this.cbCofTestCases = this.uif.createCheckBox("nrd.cofops.allowtestcases", true);
        GridBagConstraints cb = new GridBagConstraints();
        cb.anchor = 18;
        cb.weightx = 1.0;
        cb.weighty = 1.0;
        cb.ipadx = 8;
        cb.ipady = 8;
        cofpanel.add((Component)this.cbCofTestCases, cb);
        cofpanel.addPropertyChangeListener("enabled", new PanelEnableListener(cofpanel));
        return cofpanel;
    }

    private JComponent createKflBlock() {
        JPanel p = this.uif.createPanel("nrd.htmlkfl", new GridBagLayout(), false);
        p.setName("htmlkfl");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.gridwidth = 3;
        gbc.gridy = 0;
        JTextArea info = this.uif.createMessageArea("nrd.htmlkfl");
        p.add((Component)info, gbc);
        JLabel lab = this.uif.createLabel("nrd.htmlkfl.ops", false);
        gbc.gridy = 1;
        p.add((Component)lab, gbc);
        gbc.gridwidth = 1;
        gbc.gridy = 2;
        JCheckBox cb = this.cbKflTc = this.uif.createCheckBox("nrd.htmlkfl.checktc", true);
        this.cbKflTc.addActionListener(this.cbHtmlListener);
        this.cbKflTc.setSelected(true);
        this.kflGroup.add(cb);
        p.add(this.uif.createHorizontalStrut(25), gbc);
        gbc.gridwidth = 2;
        p.add((Component)cb, gbc);
        gbc.gridy = 3;
        gbc.gridwidth = 3;
        lab = this.uif.createLabel("nrd.htmlkfl.xtra", false);
        p.add((Component)lab, gbc);
        gbc.gridy = 4;
        gbc.gridwidth = 1;
        cb = this.cbKflF2f = this.uif.createCheckBox("nrd.htmlkfl.f2f", true);
        this.cbKflF2f.addActionListener(this.cbHtmlListener);
        this.cbKflF2f.setSelected(true);
        this.kflGroup.add(cb);
        p.add(this.uif.createHorizontalStrut(25), gbc);
        gbc.gridwidth = 2;
        p.add((Component)cb, gbc);
        gbc.gridy = 5;
        gbc.gridwidth = 1;
        cb = this.cbKflF2e = this.uif.createCheckBox("nrd.htmlkfl.f2e", false);
        this.cbKflF2e.addActionListener(this.cbHtmlListener);
        this.cbKflF2e.setSelected(true);
        this.htmlGroup.add(cb);
        p.add(this.uif.createHorizontalStrut(25), gbc);
        gbc.gridwidth = 2;
        p.add((Component)cb, gbc);
        gbc.gridy = 6;
        gbc.gridwidth = 1;
        cb = this.cbKflMissing = this.uif.createCheckBox("nrd.htmlkfl.missing", false);
        this.cbKflMissing.addActionListener(this.cbHtmlListener);
        this.cbKflMissing.setSelected(true);
        this.htmlGroup.add(cb);
        p.add(this.uif.createHorizontalStrut(25), gbc);
        gbc.gridwidth = 2;
        p.add((Component)cb, gbc);
        JScrollPane sp = this.uif.createScrollPane(p, 20, 30);
        sp.setViewportBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5), this.uif.createTitledBorder("nrd.htmlkfl")));
        sp.addPropertyChangeListener("enabled", new PanelEnableListener(sp));
        return sp;
    }

    private JPanel createBackupOpsPane() {
        JPanel p = this.uif.createPanel("nrd.backup", new GridBagLayout(), false);
        p.setName("backup");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridwidth = 3;
        JTextArea info = this.uif.createMessageArea("nrd.backup");
        p.add((Component)info, gbc);
        JCheckBox cb = this.cbBak = this.uif.createCheckBox("nrd.backup.bak", true);
        this.cbBak.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (NewReportDialog.this.numBak != null) {
                    NewReportDialog.this.numBak.setEnabled(NewReportDialog.this.cbBak.isSelected());
                }
            }
        });
        p.add((Component)cb, gbc);
        gbc.gridwidth = 1;
        gbc.gridy = 2;
        gbc.gridx = -1;
        p.add(this.uif.createHorizontalStrut(25), gbc);
        JLabel lab = this.uif.createLabel("nrd.backup.bak.level", true);
        p.add((Component)lab, gbc);
        this.numBak = this.uif.createInputField("nrd.backup.bak.level", 2, lab);
        gbc.insets.left = 12;
        this.numBak.setText("1");
        AbstractAction action = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                JTextField src = (JTextField)e.getSource();
                String cmd = e.getActionCommand();
                char ch = cmd.charAt(0);
                int savedDot = src.getCaret().getDot();
                int savedMark = src.getCaret().getMark();
                String savedText = src.getText();
                if (Character.isDigit(ch) && ch != '0') {
                    DefaultEditorKit.InsertContentAction delegate = new DefaultEditorKit.InsertContentAction();
                    delegate.actionPerformed(e);
                    String newText = src.getText();
                    if (newText.length() > 1) {
                        src.setText(savedText);
                    }
                }
            }
        };
        Keymap keymap = JTextField.addKeymap("intField", this.numBak.getKeymap());
        keymap.setDefaultAction(action);
        this.numBak.setKeymap(keymap);
        p.add((Component)this.numBak, gbc);
        p.setMaximumSize(p.getPreferredSize());
        return p;
    }

    private int getCustomReports(JPanel p) {
        int result = 0;
        ContextManager cm = this.model.getContextManager();
        if (cm == null) {
            return 0;
        }
        this.customReports = cm.getCustomReports();
        if (this.customReports == null || this.customReports.length == 0) {
            this.customReports = null;
            return 0;
        }
        this.customBoxes = new HashMap();
        for (int i = 0; i < this.customReports.length; ++i) {
            JCheckBox cb = new JCheckBox(this.customReports[i].getName());
            cb.setName(this.customReports[i].getReportId());
            this.listModel.addElement(cb);
            this.customBoxes.put(cb, this.customReports[i]);
            CustomReport.ReportConfigPanel[] ops = this.customReports[i].getOptionPanes();
            if (ops == null || ops.length == 0) {
                p.add(this.customReports[i].getReportId(), this.uif.createPanel("nrd.blank", false));
            } else {
                JTabbedPane tp = this.uif.createTabbedPane("nrd.custom.tabs");
                for (int j = 0; j < ops.length; ++j) {
                    tp.addTab(ops[j].getPanelName(), ops[j]);
                }
                p.add(this.customReports[i].getReportId(), tp);
            }
            ++result;
        }
        return result;
    }

    private void showReportChooserDialog() {
        ReportDirChooser rdc = this.getReportDirChooser();
        rdc.setMode(0);
        int option = rdc.showDialog(this.dirField);
        if (option != 0) {
            return;
        }
        this.dirField.setText(rdc.getSelectedFile().getAbsolutePath());
    }

    private ReportDirChooser getReportDirChooser() {
        if (this.reportDirChooser == null) {
            this.reportDirChooser = new ReportDirChooser();
        }
        return this.reportDirChooser;
    }

    void showReportBrowser(File f) {
        if (f.equals(new File(this.reportDir, "index.html"))) {
            this.reportBrowser.show(f);
        } else {
            String[] names = Report.getHtmlReportFilenames();
            ArrayList<File> possible = new ArrayList<File>();
            for (int i = 0; i < names.length; ++i) {
                File rpt = new File(this.reportDir, names[i]);
                if (rpt.exists() && rpt.canRead()) {
                    possible.add(rpt);
                    continue;
                }
                rpt = null;
            }
            if (possible.size() > 0) {
                Object rpt = null;
                File newestF = null;
                long newestTime = 0L;
                for (int i = 0; i < possible.size(); ++i) {
                    File file = (File)possible.get(i);
                    if (file.lastModified() <= newestTime) continue;
                    newestF = file;
                    newestTime = file.lastModified();
                }
                this.reportBrowser.show(newestF);
            } else {
                this.reportBrowser.show(this.reportDir);
            }
        }
    }

    private void runReport(Report.Settings settings) throws IOException {
        Report r;
        if (this.interviewParams != null) {
            r = new Report();
            if (this.interviewParams.getWorkDirectory() == null) {
                throw new IOException(this.uif.getI18NString("nrd.noWorkDir.err"));
            }
        } else {
            throw new IOException(this.uif.getI18NString("nrd.nullParams.err"));
        }
        r.addStartGenListener(new ReportGenListener());
        r.writeReports(settings, this.reportDir, this.getActiveCustomReports());
    }

    private ArrayList getActiveCustomReports() {
        ArrayList customReps = new ArrayList();
        if (this.customBoxes != null && this.customBoxes.size() > 0) {
            for (JCheckBox box : this.customBoxes.keySet()) {
                if (!box.isSelected()) continue;
                customReps.add(this.customBoxes.get(box));
            }
        }
        return customReps;
    }

    private boolean isEmptyDirectory(File f) {
        return f.isDirectory() && f.list().length == 0;
    }

    private void updateHtmlCheckboxStates() {
        if (!this.cbHtml.isSelected()) {
            for (int i = 0; i < this.htmlGroup.size(); ++i) {
                ((JCheckBox)this.htmlGroup.get(i)).setEnabled(false);
            }
        } else {
            int i;
            for (i = 0; i < this.htmlGroup.size(); ++i) {
                ((JCheckBox)this.htmlGroup.get(i)).setEnabled(true);
            }
            for (i = 0; i < this.configGroup.size(); ++i) {
                ((JCheckBox)this.configGroup.get(i)).setEnabled(this.cbConfig.isSelected());
            }
        }
    }

    private void updateCofCheckboxStates() {
        if (!this.cbCof.isSelected()) {
            this.cbCofTestCases.setEnabled(false);
        } else {
            this.cbCofTestCases.setEnabled(true);
        }
    }

    private Report.Settings captureState() {
        Report.Settings snap = new Report.Settings(this.interviewParams);
        snap.setEnableHtmlReport(this.cbHtml.isSelected());
        snap.setEnableXmlReport(this.cbXml.isSelected());
        snap.setEnablePlainReport(this.cbPlain.isSelected());
        snap.setEnableCOFReport(this.cbCof.isSelected());
        snap.setUseTestCases(this.cbCofTestCases.isSelected());
        snap.setShowConfigSection(this.cbConfig.isSelected());
        snap.setShowEnvLog(this.cbEnv.isSelected());
        snap.setShowQuestionLog(this.cbQl.isSelected());
        snap.setShowStdValues(this.cbStd.isSelected());
        snap.setShowResults(this.cbResults.isSelected());
        snap.setShowKflReport(this.cbKfl.isSelected());
        snap.setShowKeywordSummary(this.cbKws.isSelected());
        snap.setHtmlMainReport(this.cbHtmlRpt.isSelected(), this.cbHtmlInd.isSelected());
        snap.setEnableHtmlStateFile(0, this.cbPass.isSelected());
        snap.setEnableHtmlStateFile(1, this.cbFail.isSelected());
        snap.setEnableHtmlStateFile(2, this.cbErr.isSelected());
        snap.setEnableHtmlStateFile(3, this.cbNr.isSelected());
        snap.setEnableKflF2e(this.cbKflF2e.isSelected());
        snap.setEnableKflF2f(this.cbKflF2f.isSelected());
        snap.setEnableKflMissing(this.cbKflMissing.isSelected());
        snap.setEnableKflTestCases(this.cbKflTc.isSelected());
        snap.setEnableBackups(this.cbBak.isSelected());
        try {
            int i = Integer.parseInt(this.numBak.getText());
            snap.setBackupLevels(i);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        TestFilter filter = this.filterHandler.getActiveFilter();
        snap.setFilter(filter);
        return snap;
    }

    private void setState(Report.Settings snap) {
        if (snap == null) {
            return;
        }
        this.lastSettings = snap;
        this.cbHtml.setSelected(snap.isHtmlEnabled());
        this.cbXml.setSelected(snap.isXmlEnabled());
        this.cbPlain.setSelected(snap.isPlainEnabled());
        boolean isCofEnabled = snap.isCOFEnabled();
        this.cbCof.setSelected(isCofEnabled);
        this.cbCofTestCases.setSelected(snap.isCOFTestCasesEnabled());
        this.cbCofTestCases.setEnabled(isCofEnabled);
        boolean section = snap.isConfigSectionEnabled();
        this.cbConfig.setSelected(section);
        this.cbEnv.setSelected(snap.isEnvEnabled());
        this.cbQl.setSelected(snap.isQuestionLogEnabled());
        this.cbStd.setSelected(snap.isStdEnabled());
        this.cbEnv.setEnabled(section);
        this.cbQl.setEnabled(section);
        this.cbStd.setEnabled(section);
        this.cbResults.setSelected(snap.isResultsEnabled());
        this.cbKfl.setSelected(snap.isKflEnabled());
        this.cbKws.setSelected(snap.isKeywordSummaryEnabled());
        this.cbHtmlRpt.setSelected(snap.isReportHtmlEnabled());
        this.cbHtmlInd.setSelected(snap.isIndexHtmlEnabled());
        this.cbPass.setSelected(snap.isStateFileEnabled(0));
        this.cbFail.setSelected(snap.isStateFileEnabled(1));
        this.cbErr.setSelected(snap.isStateFileEnabled(2));
        this.cbNr.setSelected(snap.isStateFileEnabled(3));
        this.cbKflF2e.setSelected(snap.isKflF2eEnabled());
        this.cbKflF2f.setSelected(snap.isKflF2fEnabled());
        this.cbKflMissing.setSelected(snap.isKflMissingEnabled());
        this.cbKflTc.setSelected(snap.isKflTestCasesEnabled());
        this.cbBak.setSelected(snap.isBackupsEnabled());
        this.numBak.setText(Integer.toString(snap.getBackupLevel()));
        this.filterHandler.setFilter(snap.getTestFilter());
    }

    private class CheckBoxListCellRenderer
    implements ListCellRenderer {
        private CheckBoxListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JComponent comp = (JComponent)value;
            if (isSelected) {
                comp.setOpaque(true);
                comp.setBackground(list.getSelectionBackground());
                comp.setForeground(list.getSelectionForeground());
            } else {
                comp.setOpaque(false);
                comp.setForeground(list.getForeground());
            }
            return comp;
        }
    }

    private class PanelEnableListener
    implements PropertyChangeListener {
        private Container theContainer;
        private HashSet enabledComp;

        PanelEnableListener(Container container) {
            this.theContainer = container;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            block2: {
                boolean newV;
                boolean oldV;
                block3: {
                    if (!"enabled".equals(evt.getPropertyName())) break block2;
                    oldV = (Boolean)evt.getOldValue();
                    newV = (Boolean)evt.getNewValue();
                    if (!oldV || newV) break block3;
                    Iterator chIt = this.collectChildren(this.theContainer, new ArrayList()).iterator();
                    this.enabledComp = new HashSet();
                    while (chIt.hasNext()) {
                        Component c = (Component)chIt.next();
                        if (!c.isEnabled()) continue;
                        this.enabledComp.add(c);
                        c.setEnabled(false);
                    }
                    break block2;
                }
                if (oldV || !newV || this.enabledComp == null) break block2;
                for (Component c : this.collectChildren(this.theContainer, new ArrayList())) {
                    if (!this.enabledComp.contains(c)) continue;
                    c.setEnabled(true);
                }
            }
        }

        private Collection collectChildren(Container comp, Collection c) {
            Component[] ch = comp.getComponents();
            for (int i = 0; i < ch.length; ++i) {
                c.add(ch[i]);
                if (!(ch[i] instanceof Container)) continue;
                this.collectChildren((Container)ch[i], c);
            }
            return c;
        }
    }

    private class SelectListener
    extends MouseInputAdapter
    implements KeyListener,
    ListSelectionListener {
        Object lastSelected;
        JList list;
        ListModel listModel;
        JPanel panel;
        CardLayout cards;
        JButton okBtn = null;
        double emptyCBW = new JCheckBox("").getPreferredSize().getWidth() + 2.0;

        SelectListener(JList lst, JPanel p, CardLayout cardLayout) {
            this.list = lst;
            this.listModel = this.list.getModel();
            this.lastSelected = this.listModel.getElementAt(0);
            this.panel = p;
            this.cards = cardLayout;
        }

        public void keyTyped(KeyEvent e) {
            if (e.getKeyChar() == ' ') {
                this.process(this.list.getSelectedIndex());
            }
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getPoint().getX() <= this.emptyCBW) {
                this.process(this.list.locationToIndex(e.getPoint()));
            }
        }

        public void valueChanged(ListSelectionEvent e) {
            int index = this.list.getSelectedIndex();
            if (index < 0) {
                return;
            }
            JCheckBox box = (JCheckBox)this.listModel.getElementAt(index);
            if (this.lastSelected != box) {
                this.cards.show(this.panel, box.getName());
                this.lastSelected = box;
            }
            this.enablePanel(box);
        }

        private void enablePanel(JCheckBox box) {
            CustomReport rep;
            for (int i = 0; i < this.panel.getComponentCount(); ++i) {
                JComponent tab = (JComponent)this.panel.getComponent(i);
                tab.setEnabled(box.isSelected());
            }
            if (NewReportDialog.this.customBoxes != null) {
                CustomReport rep2 = (CustomReport)NewReportDialog.this.customBoxes.get(box);
                if (rep2 != null && rep2.getOptionPanes() != null) {
                    for (int i = 0; i < rep2.getOptionPanes().length; ++i) {
                        rep2.getOptionPanes()[i].setEnabled(box.isSelected());
                    }
                } else if (box == NewReportDialog.this.cbHtml) {
                    for (int i = 0; i < NewReportDialog.this.panes.length; ++i) {
                        NewReportDialog.this.panes[i].setEnabled(box.isSelected());
                    }
                }
            }
            if (box == NewReportDialog.this.cbHtml) {
                NewReportDialog.this.infoArea.setText(NewReportDialog.this.uif.getI18NString("nrd.info.html.txt"));
            } else if (box == NewReportDialog.this.cbPlain) {
                NewReportDialog.this.infoArea.setText(NewReportDialog.this.uif.getI18NString("nrd.info.plain.txt"));
            } else if (box == NewReportDialog.this.cbXml) {
                NewReportDialog.this.infoArea.setText(NewReportDialog.this.uif.getI18NString("nrd.info.xml.txt"));
            } else if (box == NewReportDialog.this.cbCof) {
                NewReportDialog.this.infoArea.setText(NewReportDialog.this.uif.getI18NString("nrd.info.cof.txt"));
            } else if (NewReportDialog.this.customBoxes != null && (rep = (CustomReport)NewReportDialog.this.customBoxes.get(box)) != null) {
                NewReportDialog.this.infoArea.setText(rep.getDescription());
            }
        }

        private void process(int index) {
            if (index < 0) {
                return;
            }
            JCheckBox box = (JCheckBox)this.listModel.getElementAt(index);
            if (this.lastSelected == box) {
                box.doClick();
                if (this.okBtn != null) {
                    this.okBtn.setEnabled(this.hasSelectedCheckBox());
                }
                if (box == NewReportDialog.this.cbHtml) {
                    NewReportDialog.this.updateHtmlCheckboxStates();
                }
                if (box == NewReportDialog.this.cbCof) {
                    NewReportDialog.this.updateCofCheckboxStates();
                }
                this.list.repaint();
                this.enablePanel(box);
            }
            this.lastSelected = box;
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
        }

        private void setOkBtn(JButton okBtn) {
            this.okBtn = okBtn;
        }

        private boolean hasSelectedCheckBox() {
            for (int i = 0; i < this.listModel.getSize(); ++i) {
                if (!((JCheckBox)this.listModel.getElementAt(i)).isSelected()) continue;
                return true;
            }
            return false;
        }
    }

    private class ReportGenListener
    implements Report.StartGenListener {
        private ReportGenListener() {
        }

        public void startReportGeneration(Report.Settings s, String reportID) {
            String reportName = reportID.equals("xml") || reportID.equals("pt") || reportID.equals("html") ? NewReportDialog.this.uif.getI18NString("nrd.type." + reportID + ".ckb") : reportID;
            String status = NewReportDialog.this.uif.getI18NString("nrd.wait.report_gen", new String[]{reportName});
            Component[] cmp = NewReportDialog.this.waitDialog.getContentPane().getComponents();
            for (int i = 0; i < cmp.length; ++i) {
                if (!"nrd.wait".equals(cmp[i].getName())) continue;
                if (!(cmp[i] instanceof JTextComponent)) break;
                ((JTextComponent)cmp[i]).setText(status);
                break;
            }
        }
    }

    private static class Stopper {
        boolean waitWasHidden = false;

        private Stopper() {
        }
    }

    static interface Observer {
        public void update(Map var1);

        public void writingReport();

        public void wroteReport();

        public void errorWriting(String var1);
    }
}

