/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec.template;

import com.sun.javatest.InterviewParameters;
import com.sun.javatest.TemplateUtilities;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.exec.BasicSession;
import com.sun.javatest.exec.InterviewEditor;
import com.sun.javatest.exec.Session;
import com.sun.javatest.tool.FileHistory;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.File;
import java.util.Map;

public class TemplateSession
extends BasicSession {
    protected final InterviewParameters templ;
    static final String TEMPLATE_PROP_NAME = "Template";
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(TemplateSession.class);

    public TemplateSession(TestSuite ts) throws Session.Fault {
        super(ts);
        try {
            this.templ = ts.createInterview();
            this.templ.setTemplate(true);
        }
        catch (TestSuite.Fault f) {
            throw new Session.Fault(f);
        }
    }

    protected void initPropertyList() {
        super.initPropertyList();
        this.props.add(TEMPLATE_PROP_NAME);
    }

    public String getValue(String name) {
        if (TEMPLATE_PROP_NAME.equals(name)) {
            if (this.templ == null) {
                return null;
            }
            File f = this.templ.getFile();
            return f == null ? null : f.getPath();
        }
        return super.getValue(name);
    }

    public void dispose() {
        this.templ.dispose();
        super.dispose();
    }

    public void save(Map map) {
        if (this.templ.getFile() != null) {
            map.put("template", this.templ.getFile().getPath());
        }
        super.save(map);
    }

    public void restore(Map map) throws Session.Fault {
        super.restore(map);
        this.restoreTemplate(map);
    }

    protected void restoreTemplate(Map map) {
        String templPath = (String)map.get("template");
        if (templPath != null) {
            try {
                String oldWDpath;
                String[] begins;
                if (!new File(templPath).exists() && this.wd != null && (begins = WorkDirectory.getDiffInPaths(templPath, oldWDpath = this.wd.getPrevWDPath())) != null && templPath.startsWith(begins[1])) {
                    templPath = begins[0] + templPath.substring(begins[1].length());
                }
                this.templ.load(new File(templPath));
                if (this.wd != null) {
                    FileHistory.getFileHistory(this.wd, "templateHistory.jtl").add(this.templ.getFile());
                }
                this.templ.setTemplate(true);
                this.notifyObservers(new E_NewTemplate(this.templ));
            }
            catch (Exception ex) {
                System.err.println(i18n.getString("tcc.cantRestoreTemplate.err", templPath));
            }
        }
    }

    public void update(Session.Update u) throws Session.Fault {
        if (u instanceof U_NewTemplate) {
            this.updateTemplate(((U_NewTemplate)u).templ);
        } else {
            super.update(u);
        }
    }

    protected void updateNewConfig(InterviewParameters ip) throws Session.Fault {
        String newPath;
        String oldPath = this.templ.getTemplatePath();
        if (oldPath != (newPath = ip.getTemplatePath()) && oldPath != null && !oldPath.equals(newPath)) {
            try {
                File templateFile = new File(newPath);
                this.templ.load(templateFile);
                this.templ.setFile(templateFile);
                TemplateUtilities.setTemplateFile(this.wd, templateFile, true);
                this.notifyObservers(new E_NewTemplate(this.templ));
                super.updateNewConfig(ip);
            }
            catch (Exception ex) {
                throw new Session.Fault(ex);
            }
        } else {
            super.updateNewConfig(ip);
        }
    }

    protected void applyWorkDir(WorkDirectory wd) {
        super.applyWorkDir(wd);
        if (this.templ != null) {
            this.templ.setWorkDirectory(wd);
        }
    }

    protected void loadTemplateFromWD(WorkDirectory wd) throws Session.Fault {
        File templateFile = TemplateUtilities.getTemplateFile(wd);
        if (templateFile != null) {
            try {
                InterviewParameters newValue = InterviewParameters.open(templateFile, wd);
                InterviewEditor.copy(newValue, this.templ);
                this.templ.setFile(templateFile);
                TemplateUtilities.setTemplateFile(wd, templateFile, true);
                this.notifyObservers(new E_NewTemplate(this.templ));
            }
            catch (Exception ex) {
                throw new Session.Fault(ex);
            }
        }
    }

    public InterviewParameters getConfig() {
        return this.config;
    }

    public InterviewParameters getTemplate() {
        return this.templ;
    }

    protected void updateTemplate(InterviewParameters t) throws Session.Fault {
        if (InterviewEditor.equal(t, this.templ) && t.getFile() != null && t.getFile().equals(this.templ.getFile())) {
            return;
        }
        try {
            InterviewEditor.copy(t, this.templ);
            TemplateUtilities.setTemplateFile(this.wd, this.templ.getFile(), true);
        }
        catch (Exception e) {
            throw new Session.Fault(e);
        }
        if (!this.templ.getTemplatePath().equals(this.config.getTemplatePath())) {
            this.config.clear();
            this.notifyObservers(new BasicSession.E_NewConfig(this.config));
        }
        this.notifyObservers(new E_NewTemplate(this.templ));
    }

    public static class U_NewTemplate
    implements Session.Update {
        public final InterviewParameters templ;

        public U_NewTemplate(InterviewParameters templ) {
            this.templ = templ;
        }
    }

    public static class E_NewTemplate
    implements Session.Event {
        public final InterviewParameters templ;

        public E_NewTemplate(InterviewParameters templ) {
            this.templ = templ;
        }
    }
}

