/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.finder;

import com.sun.javatest.TestDescription;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestFinder;
import com.sun.javatest.finder.TagTestFinder;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.File;

public class ReverseTestFinder
extends TestFinder {
    private TestFinder delegate;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(TagTestFinder.class);

    public ReverseTestFinder() {
    }

    public ReverseTestFinder(TestFinder delegate) {
        this();
        this.delegate = delegate;
    }

    public synchronized void init(String[] args, File testSuiteRoot, TestEnvironment env) throws TestFinder.Fault {
        String delegateClassName = args[0];
        try {
            Class<?> delegateClass = Class.forName(delegateClassName);
            this.delegate = (TestFinder)delegateClass.newInstance();
            args = this.shift(args, 1);
            this.delegate.init(args, testSuiteRoot, env);
        }
        catch (Throwable t) {
            throw new TestFinder.Fault(i18n, "reverse.cantInitDelegate", t);
        }
    }

    public File getRoot() {
        return this.delegate.getRoot();
    }

    public File getRootDir() {
        return this.delegate.getRootDir();
    }

    public void read(File file) {
        this.delegate.read(file);
    }

    public TestDescription[] getTests() {
        TestDescription[] tds = this.delegate.getTests();
        if (tds != null) {
            int n = tds.length;
            for (int i = 0; i < n / 2; ++i) {
                TestDescription temp = tds[i];
                tds[i] = tds[n - 1 - i];
                tds[n - 1 - i] = temp;
            }
        }
        return tds;
    }

    public File[] getFiles() {
        File[] fs = this.delegate.getFiles();
        if (fs != null) {
            int n = fs.length;
            for (int i = 0; i < n / 2; ++i) {
                File temp = fs[i];
                fs[i] = fs[n - 1 - i];
                fs[n - 1 - i] = temp;
            }
        }
        return fs;
    }

    protected void scan(File file) {
        throw new Error("should not be called!");
    }

    private String[] shift(String[] args, int n) {
        String[] result = new String[args.length - n];
        System.arraycopy(args, n, result, 0, result.length);
        return result;
    }
}

