/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.moreInfo;

import com.sun.java.help.impl.ViewAwareComponent;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.View;
import javax.swing.text.html.HTMLDocument;

public class ShowFile
extends JComponent
implements ViewAwareComponent {
    private String title;
    private String path;
    private String startLine;
    private String text = "link";
    private Font font;
    private Color color = Color.blue;
    private View view;
    private static JFrame frame;
    private static JScrollPane scrollPane;
    private static JTextArea textArea;
    private static Highlighter.HighlightPainter highlightPainter;
    private static final int DEFAULT_WIDTH = 5;
    private static final int DEFAULT_HEIGHT = 7;

    public ShowFile() {
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                ShowFile.this.showFile();
            }
        });
        this.setCursor(new Cursor(12));
    }

    public Dimension getPreferredSize() {
        Graphics g = this.getGraphics();
        if (g == null) {
            return new Dimension(100, 10);
        }
        FontMetrics fm = this.font == null ? g.getFontMetrics() : g.getFontMetrics(this.font);
        int w = fm.stringWidth(this.text);
        int h = fm.getHeight();
        return new Dimension(w, h);
    }

    public float getAlignmentY() {
        Graphics g = this.getGraphics();
        if (g == null) {
            return super.getAlignmentY();
        }
        FontMetrics fm = this.font == null ? g.getFontMetrics() : g.getFontMetrics(this.font);
        float ascent = fm.getMaxAscent();
        float height = fm.getHeight();
        return ascent / height;
    }

    public void paintComponent(Graphics g) {
        g.setColor(this.color);
        if (this.font != null) {
            g.setFont(this.font);
        }
        FontMetrics fm = g.getFontMetrics();
        int baseLine = fm.getMaxAscent();
        g.drawString(this.text, 0, baseLine);
        g.drawLine(0, baseLine + 1, fm.stringWidth(this.text) - 1, baseLine + 1);
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getStartLine() {
        return this.startLine;
    }

    public void setStartLine(String startLine) {
        this.startLine = startLine;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getTextFont() {
        return this.font == null ? null : this.font.toString();
    }

    public void setTextFont(String fontName) {
        this.font = Font.decode(fontName);
        Graphics g = this.getGraphics();
        if (g == null) {
            return;
        }
        FontMetrics fm = this.font == null ? g.getFontMetrics() : g.getFontMetrics(this.font);
        int w = fm.stringWidth(this.text);
        int h = fm.getHeight();
        this.setPreferredSize(new Dimension(w, h));
    }

    public String getTextColor() {
        return this.color.toString();
    }

    public void setTextColor(String color) {
        this.color = Color.decode(color);
    }

    public void setViewData(View v) {
        this.view = v;
    }

    private synchronized void showFile() {
        int startLineIndex;
        if (frame == null) {
            Toolkit t = Toolkit.getDefaultToolkit();
            Dimension screenSize = t.getScreenSize();
            int dpi = t.getScreenResolution();
            frame = new JFrame();
            if (this.title != null) {
                frame.setTitle(this.title);
            }
            textArea = new JTextArea();
            textArea.setFont(new Font("Monospaced", 0, 12));
            textArea.setLineWrap(false);
            scrollPane = new JScrollPane(textArea);
            frame.setContentPane(scrollPane);
            Color highlightColor = new Color(0xFFFFB0);
            highlightPainter = new DefaultHighlighter.DefaultHighlightPainter(highlightColor);
            int w = 5 * dpi;
            int h = 7 * dpi;
            frame.setBounds(screenSize.width - w, 0, w, h);
        }
        try {
            int n;
            Document d = this.view.getDocument();
            URL base = ((HTMLDocument)d).getBase();
            URL p = new URL(base, this.path);
            BufferedReader r = new BufferedReader(new InputStreamReader(p.openStream()));
            StringBuffer sb = new StringBuffer();
            char[] buf = new char[1024];
            while ((n = r.read(buf, 0, buf.length)) != -1) {
                sb.append(buf, 0, n);
            }
            r.close();
            textArea.setText(sb.toString());
        }
        catch (IOException e) {
            textArea.setText(e.toString());
        }
        textArea.setSize(textArea.getPreferredSize());
        frame.validate();
        String text = textArea.getText();
        int n = startLineIndex = this.startLine == null ? -1 : text.indexOf(this.startLine);
        if (startLineIndex == -1) {
            textArea.setCaretPosition(0);
        } else {
            try {
                int start = this.getStartOfLine(text, startLineIndex);
                int end = this.getEndOfLine(text, startLineIndex);
                Highlighter h = textArea.getHighlighter();
                h.removeAllHighlights();
                h.addHighlight(start, end + 1, highlightPainter);
                textArea.setCaretPosition(start);
                Rectangle startRect = textArea.modelToView(start);
                JViewport vp = scrollPane.getViewport();
                int yOffset = 50;
                if (vp != null && startRect != null) {
                    vp.setViewPosition(new Point(startRect.x, Math.max(0, startRect.y - yOffset)));
                }
            }
            catch (BadLocationException e) {
                textArea.setCaretPosition(0);
            }
        }
        frame.setVisible(true);
    }

    int getStartOfLine(String text, int index) {
        int i;
        for (i = index; i > 0 && text.charAt(i - 1) != '\n'; --i) {
        }
        return i;
    }

    int getEndOfLine(String text, int index) {
        int i;
        for (i = index; i < text.length() - 1 && text.charAt(i + 1) != '\n'; ++i) {
        }
        return i;
    }
}

