/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.mrep;

import com.sun.javatest.mrep.TestResultDescr;
import com.sun.javatest.mrep.XMLReportWriter;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class XMLReportReader {
    private SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
    private IDHandler handler = new IDHandler();

    XMLReportReader() throws SAXException, ParserConfigurationException {
    }

    Map readIDs(File file) throws SAXException, IOException {
        this.parser.parse(file, (DefaultHandler)this.handler);
        return this.handler.getMap();
    }

    private static class IDHandler
    extends DefaultHandler {
        private Map map = new HashMap();
        private long time = 0L;

        private IDHandler() {
        }

        public void startElement(String namespaceUri, String localName, String qualifiedName, Attributes attributes) throws SAXException {
            if (qualifiedName.equals("TestResult")) {
                String url = attributes.getValue("url");
                int id = Integer.valueOf(attributes.getValue("workDirID"));
                String status = attributes.getValue("status");
                this.map.put(url, new TestResultDescr(status, id, this.time));
            }
            if (qualifiedName.equals("WorkDirectory")) {
                Integer id = Integer.valueOf(attributes.getValue("id"));
                this.map.put(id, id);
            }
            if (qualifiedName.equals("Report")) {
                String dateStr = attributes.getValue("generatedTime");
                try {
                    this.time = XMLReportWriter.ISO8601toDate(dateStr).getTime();
                }
                catch (ParseException e) {
                    throw new SAXException(e);
                }
            }
        }

        public Map getMap() {
            return this.map;
        }
    }
}

