/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.tool.Desktop;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.DynamicArray;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.SortedProperties;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class Preferences {
    private static Preferences theOne;
    private File prefsFile;
    private Properties props;
    private Hashtable observers = new Hashtable();
    private boolean isUpToDate;
    private long fileModifiedTime;
    private static I18NResourceBundle i18n;

    public static Preferences access() {
        if (theOne == null) {
            theOne = new Preferences(Preferences.getDefaultPrefsFile());
        }
        return theOne;
    }

    static File getPrefsDir() {
        File userDir = new File(System.getProperty("user.home"));
        String prefDir = System.getProperty("javatest.preferences.dir", ".javatest");
        return new File(userDir, prefDir);
    }

    private static File getDefaultPrefsFile() {
        String s = System.getProperty("javatest.preferences.file");
        if (s == null) {
            File jtDir = Preferences.getPrefsDir();
            return new File(jtDir, "preferences");
        }
        if (!s.equals("NONE")) {
            return new File(s);
        }
        return null;
    }

    private Preferences(File file) {
        this.prefsFile = file;
        this.isUpToDate = true;
        SortedProperties p = new SortedProperties();
        try {
            if (this.prefsFile != null) {
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.prefsFile));
                p.load(in);
                ((InputStream)in).close();
                this.fileModifiedTime = this.prefsFile.lastModified();
            }
        }
        catch (FileNotFoundException ignore) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.props = p;
    }

    public synchronized void save() {
        if (!(this.prefsFile == null || this.isUpToDate && this.fileModifiedTime == this.prefsFile.lastModified())) {
            try {
                File parentDir = new File(this.prefsFile.getParent());
                if (!parentDir.exists()) {
                    parentDir.mkdirs();
                }
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.prefsFile));
                this.props.store(out, "JT Harness Preferences");
                ((OutputStream)out).close();
                this.isUpToDate = true;
                this.fileModifiedTime = this.prefsFile.lastModified();
            }
            catch (IOException e) {
                System.err.println(i18n.getString("prefs.cannotSave", e));
            }
        }
    }

    public String getPreference(String name) {
        return this.getPreference(name, null);
    }

    public String getPreference(String name, String defaultValue) {
        String v = (String)this.props.get(name);
        if (v == null) {
            v = defaultValue;
        }
        return v;
    }

    public void setPreference(String name, String newValue) {
        this.isUpToDate = false;
        this.props.put(name, newValue);
        Enumeration e = this.observers.keys();
        while (e.hasMoreElements()) {
            String prefix = (String)e.nextElement();
            if (!name.startsWith(prefix)) continue;
            Observer[] obs = (Observer[])this.observers.get(prefix);
            for (int i = 0; i < obs.length; ++i) {
                obs[i].updated(name, newValue);
            }
        }
    }

    public void addObserver(String prefix, Observer o) {
        Object[] obs = (Observer[])this.observers.get(prefix);
        obs = obs == null ? new Observer[]{o} : (Observer[])DynamicArray.append(obs, o);
        this.observers.put(prefix, obs);
    }

    public void addObserver(String[] prefixes, Observer o) {
        for (int i = 0; i < prefixes.length; ++i) {
            this.addObserver(prefixes[i], o);
        }
    }

    public void removeObserver(String prefix, Observer o) {
        Object[] obs = (Observer[])this.observers.get(prefix);
        if (obs != null) {
            obs = (Observer[])DynamicArray.remove(obs, o);
            this.observers.put(prefix, obs);
        }
    }

    public void removeObserver(String[] prefixes, Observer o) {
        for (int i = 0; i < prefixes.length; ++i) {
            this.removeObserver(prefixes[i], o);
        }
    }

    public void showDialog(JFrame f, Pane[] panes, HelpBroker helpBroker) {
        PrefsDialog d = new PrefsDialog(f, panes, helpBroker);
        d.setVisible(true);
    }

    private void setPreferences(Pane[] panes) {
        Map m = new Map(){

            public void clear() {
                throw new UnsupportedOperationException();
            }

            public boolean containsKey(Object key) {
                return Preferences.this.props.containsKey(key);
            }

            public boolean containsValue(Object value) {
                return Preferences.this.props.containsValue(value);
            }

            public Set entrySet() {
                return Preferences.this.props.entrySet();
            }

            public boolean equals(Object o) {
                return Preferences.this.props.equals(o);
            }

            public Object get(Object key) {
                return Preferences.this.props.get(key);
            }

            public int hashCode() {
                return Preferences.this.props.hashCode();
            }

            public boolean isEmpty() {
                return Preferences.this.props.isEmpty();
            }

            public Set keySet() {
                return Preferences.this.props.keySet();
            }

            public Object put(Object key, Object value) {
                Object oldValue = Preferences.this.props.get(key);
                if (oldValue == null || !oldValue.equals(value)) {
                    Preferences.this.setPreference((String)key, (String)value);
                }
                return oldValue;
            }

            public void putAll(Map m) {
                throw new UnsupportedOperationException();
            }

            public Object remove(Object key) {
                throw new UnsupportedOperationException();
            }

            public int size() {
                return Preferences.this.props.size();
            }

            public Collection values() {
                return Preferences.this.props.values();
            }
        };
        for (int i = 0; i < panes.length; ++i) {
            panes[i].save(m);
        }
    }

    static {
        i18n = I18NResourceBundle.getBundleForClass(Preferences.class);
    }

    private class PrefsDialog
    extends JDialog
    implements ActionListener,
    TreeModel,
    TreeSelectionListener,
    WindowListener {
        private int cardNum;
        private JFrame owner;
        private HelpBroker helpBroker;
        private Pane[] panes;
        private UIFactory uif;
        private JPanel main;
        private JPanel deck;
        private JButton okBtn;
        private JButton cancelBtn;
        private JButton helpBtn;
        private JTree tree;

        PrefsDialog(JFrame f, Pane[] panes, HelpBroker helpBroker) {
            super((Frame)null, true);
            this.owner = f;
            this.panes = panes;
            this.helpBroker = helpBroker;
            this.uif = new UIFactory(this.getClass(), helpBroker);
            this.initGUI();
            this.owner.addWindowListener(this);
        }

        public void setVisible(boolean b) {
            if (b) {
                for (int i = 0; i < this.panes.length; ++i) {
                    this.panes[i].load(Preferences.this.props);
                }
            }
            super.setVisible(b);
            if (!b) {
                this.owner.removeWindowListener(this);
            }
        }

        private void initGUI() {
            this.setName("prefs");
            this.setTitle(this.uif.getI18NString("prefs.title"));
            if (this.helpBroker != null) {
                this.helpBroker.enableHelpKey(this.getRootPane(), "ui.prefs.dialog.csh", null);
            }
            Desktop.addHelpDebugListener(this);
            this.uif.setAccessibleDescription(this, "prefs");
            this.main = this.uif.createPanel("prefs.main", new BorderLayout(), false);
            this.initTree();
            this.initPanes();
            this.initButtons();
            this.setContentPane(this.main);
            Object[] path = new Object[]{this.tree.getModel().getRoot(), this.getChildren(this)[0]};
            this.tree.setSelectionPath(new TreePath(path));
            this.pack();
            this.setLocationRelativeTo(this.owner);
            this.getRootPane().setDefaultButton(this.okBtn);
        }

        private void initTree() {
            this.tree = new JTree(this);
            this.tree.setName("prefs.tree");
            this.tree.addTreeSelectionListener(this);
            this.tree.setEditable(false);
            this.tree.setShowsRootHandles(true);
            this.tree.setRootVisible(false);
            this.uif.setAccessibleInfo(this.tree, "prefs.tree");
            int dpi = this.uif.getDotsPerInch();
            this.tree.setPreferredSize(new Dimension(2 * dpi, dpi));
            this.tree.setVisibleRowCount(10);
            this.tree.setCellRenderer(new DefaultTreeCellRenderer(){

                public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                    if (value instanceof Pane) {
                        return super.getTreeCellRendererComponent(tree, ((Pane)value).getText(), selected, expanded, leaf, row, hasFocus);
                    }
                    return super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                }
            });
            this.tree.getSelectionModel().setSelectionMode(1);
            this.tree.expandRow(2);
            JScrollPane treeStuff = this.uif.createScrollPane(this.tree);
            treeStuff.setBorder(BorderFactory.createEtchedBorder());
            this.main.add((Component)treeStuff, "West");
        }

        private void initButtons() {
            int i;
            this.okBtn = this.uif.createButton("prefs.ok", this);
            this.cancelBtn = this.uif.createCancelButton("prefs.cancel", this);
            this.helpBtn = this.uif.createHelpButton("prefs.help", "ui.prefs.dialog.csh");
            JButton[] btns = new JButton[]{this.okBtn, this.cancelBtn, this.helpBtn};
            Dimension maxBtnDims = new Dimension();
            for (i = 0; i < btns.length; ++i) {
                Dimension d = btns[i].getPreferredSize();
                maxBtnDims.width = Math.max(maxBtnDims.width, d.width);
                maxBtnDims.height = Math.max(maxBtnDims.height, d.height);
            }
            for (i = 0; i < btns.length; ++i) {
                btns[i].setPreferredSize(maxBtnDims);
            }
            JPanel p = this.uif.createPanel("prefs.btns", false);
            p.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 13;
            c.insets.top = 5;
            c.insets.bottom = 11;
            c.insets.right = 11;
            c.weightx = 1.0;
            for (int i2 = 0; i2 < btns.length; ++i2) {
                p.add((Component)btns[i2], c);
                c.weightx = 0.0;
            }
            this.main.add((Component)p, "South");
            InputMap inputMap = p.getInputMap(2);
            ActionMap actionMap = p.getActionMap();
            inputMap.put(KeyStroke.getKeyStroke(27, 0), "cancel");
            actionMap.put("cancel", new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    PrefsDialog.this.cancelBtn.doClick(250);
                }
            });
        }

        private void initPanes() {
            this.deck = this.uif.createPanel("prefs.deck", new CardLayout(), false);
            this.addAllPanes(this.deck, this.panes);
            int dpi = this.uif.getDotsPerInch();
            Dimension maxPrefSize = new Dimension(3 * dpi, 2 * dpi);
            for (int i = 0; i < this.deck.getComponentCount(); ++i) {
                Dimension d = this.deck.getComponent(i).getPreferredSize();
                maxPrefSize.width = Math.max(maxPrefSize.width, d.width);
                maxPrefSize.height = Math.max(maxPrefSize.height, d.height);
            }
            this.deck.setPreferredSize(maxPrefSize);
            this.main.add((Component)this.deck, "Center");
        }

        private void addAllPanes(JPanel deck, Pane[] panes) {
            for (int i = 0; i < panes.length; ++i) {
                Pane pane = panes[i];
                JPanel p = this.uif.createPanel("prefs.card" + this.cardNum++, false);
                p.setLayout(new BorderLayout());
                JLabel head = new JLabel(pane.getText());
                head.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                p.add((Component)head, "North");
                pane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                p.add((Component)this.uif.createScrollPane(pane), "Center");
                deck.add((Component)p, pane.getText());
                if (pane.getChildPanes() == null) continue;
                this.addAllPanes(deck, pane.getChildPanes());
            }
        }

        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            if (src == this.okBtn) {
                boolean b = this.okToSave();
                if (!b) {
                    return;
                }
                Preferences.this.setPreferences(this.panes);
                Preferences.this.save();
                this.setVisible(false);
            } else if (src == this.cancelBtn) {
                for (int i = 0; i < this.panes.length; ++i) {
                    this.panes[i].load(Preferences.this.props);
                }
                this.setVisible(false);
            }
        }

        private boolean okToSave() {
            String reason = null;
            for (int i = 0; i < this.panes.length; ++i) {
                reason = this.panes[i].validateValues();
                if (reason != null) {
                    this.tree.setSelectionPath(new TreePath(new Object[]{this, this.panes[i]}));
                    break;
                }
                Pane[] p = this.panes[i].getChildPanes();
                if (p == null) continue;
                for (int j = 0; j < p.length; ++j) {
                    reason = p[j].validateValues();
                    if (reason == null) continue;
                    this.tree.setSelectionPath(new TreePath(new Object[]{this, this.panes[i], p[j]}));
                    break;
                }
                if (reason != null) break;
            }
            if (reason != null) {
                this.uif.showLiteralError(this.uif.getI18NString("prefs.badPref.title"), reason);
                return false;
            }
            return true;
        }

        public void valueChanged(TreeSelectionEvent e) {
            TreePath path = e.getNewLeadSelectionPath();
            if (path != null) {
                Pane pane = (Pane)path.getLastPathComponent();
                ((CardLayout)this.deck.getLayout()).show(this.deck, pane.getText());
            }
        }

        public Object getChild(Object parent, int index) {
            return this.getChildren(parent)[index];
        }

        public int getChildCount(Object parent) {
            return this.getChildren(parent).length;
        }

        public int getIndexOfChild(Object parent, Object child) {
            Pane[] children = this.getChildren(parent);
            for (int i = 0; i < children.length; ++i) {
                if (children[i] != child) continue;
                return i;
            }
            return -1;
        }

        public Object getRoot() {
            return this;
        }

        public boolean isLeaf(Object node) {
            Pane[] children = this.getChildren(node);
            return children == null || children.length == 0;
        }

        public void addTreeModelListener(TreeModelListener l) {
        }

        public void removeTreeModelListener(TreeModelListener l) {
        }

        public void valueForPathChanged(TreePath path, Object newValue) {
        }

        public void windowOpened(WindowEvent e) {
        }

        public void windowClosing(WindowEvent e) {
        }

        public void windowClosed(WindowEvent e) {
        }

        public void windowIconified(WindowEvent e) {
        }

        public void windowDeiconified(WindowEvent e) {
            if (e.getSource() == this.owner) {
                this.toFront();
            }
        }

        public void windowActivated(WindowEvent e) {
            if (e.getSource() == this.owner) {
                this.toFront();
            }
        }

        public void windowDeactivated(WindowEvent e) {
        }

        private Pane[] getChildren(Object parent) {
            return parent == this ? this.panes : ((Pane)parent).getChildPanes();
        }
    }

    public static abstract class Pane
    extends JPanel {
        protected void setHelp(String helpID) {
            CSH.setHelpIDString(this, helpID);
        }

        public abstract String getText();

        public void load(Map m) {
            Pane[] p = this.getChildPanes();
            if (p != null) {
                for (int i = 0; i < p.length; ++i) {
                    p[i].load(m);
                }
            }
        }

        public void save(Map m) {
            Pane[] p = this.getChildPanes();
            if (p != null) {
                for (int i = 0; i < p.length; ++i) {
                    p[i].save(m);
                }
            }
        }

        public String validateValues() {
            return null;
        }

        public Pane[] getChildPanes() {
            return null;
        }
    }

    public static interface Observer {
        public void updated(String var1, String var2);
    }
}

