/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.util;

import com.sun.javatest.util.I18NResourceBundle;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LogFile {
    private File file;
    private Writer out;
    private boolean logError;
    private static I18NResourceBundle local_i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$util$LogFile == null ? (class$com$sun$javatest$util$LogFile = LogFile.class$("com.sun.javatest.util.LogFile")) : class$com$sun$javatest$util$LogFile);
    static /* synthetic */ Class class$com$sun$javatest$util$LogFile;

    public LogFile() {
        this(new OutputStreamWriter(System.err));
    }

    public LogFile(Writer out) {
        if (out == null) {
            throw new NullPointerException();
        }
        this.out = out;
    }

    public LogFile(File file) {
        if (file == null) {
            throw new NullPointerException();
        }
        this.file = file;
    }

    public void log(I18NResourceBundle i18n, String key) {
        this.log(i18n.getString(key), null);
    }

    public void log(I18NResourceBundle i18n, String key, Object arg) {
        if (arg instanceof Throwable) {
            this.log(i18n.getString(key, arg), (Throwable)arg);
        } else {
            this.log(i18n.getString(key, arg), null);
        }
    }

    public void log(I18NResourceBundle i18n, String key, Object[] args) {
        if (args != null && args.length > 0 && args[0] instanceof Throwable) {
            this.log(i18n.getString(key, args), (Throwable)args[0]);
        } else {
            this.log(i18n.getString(key, args), null);
        }
    }

    private synchronized void log(String text, Throwable trace) {
        boolean closeWhenDone;
        PrintWriter pw;
        Date now = new Date();
        SimpleDateFormat format = new SimpleDateFormat("[ddMMMyyyy kk:mmz]");
        if (this.out != null) {
            pw = new PrintWriter(this.out);
            closeWhenDone = false;
        } else {
            FileWriter fw = null;
            try {
                fw = new FileWriter(this.file, true);
            }
            catch (IOException e) {
                if (!this.logError) {
                    String msg = local_i18n.getString("log.error", new Object[]{this.file, e.toString()});
                    System.err.println(msg);
                    this.logError = true;
                }
                return;
            }
            pw = new PrintWriter(fw);
            closeWhenDone = true;
        }
        pw.print(format.format(new Date()));
        pw.print("  ");
        pw.println(text);
        if (trace != null) {
            trace.printStackTrace(pw);
        }
        if (closeWhenDone) {
            pw.close();
        } else {
            pw.flush();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

