/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.junit;

import com.sun.javatest.Status;
import com.sun.javatest.junit.JUnitMultiTest;
import com.sun.javatest.lib.MultiStatus;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import junit.framework.TestCase;

public class JUnitBareMultiTest
extends JUnitMultiTest {
    protected TestCase testCaseClass;
    protected SortedMap<String, Method> tests;
    protected String[] testCases = null;
    protected Vector excludeTestCases = new Vector();

    public JUnitBareMultiTest(ClassLoader loader) {
        super(loader);
    }

    public Status run0(String[] argv) {
        MultiStatus ms = new MultiStatus(this.log);
        this.getListAllJunitTestCases();
        if (this.tests == null) {
            return Status.failed((String)"No test cases found in test.");
        }
        Iterator<Map.Entry<String, Method>> iterator = this.tests.entrySet().iterator();
        while (iterator.hasNext()) {
            Method method = iterator.next().getValue();
            Status status = null;
            try {
                status = this.invokeTestCase(method);
            }
            catch (Throwable e) {
                this.printStackTrace(e);
                status = Status.failed((String)("Error in test case: " + method.getName()));
            }
            ms.add(method.getName(), status);
        }
        return ms.getStatus();
    }

    public static void main(String[] args) {
        String executeClass = System.getProperty("javaTestExecuteClass");
        JUnitBareMultiTest multiTest = new JUnitBareMultiTest(ClassLoader.getSystemClassLoader());
        ((JUnitMultiTest)multiTest).setup(executeClass);
        ((JUnitMultiTest)multiTest).run0(args);
    }

    protected void setup(String executeClass) {
        try {
            Class<?> tc = this.getClassLoader().loadClass(executeClass);
            String name = tc.getName();
            String constructor = tc.getConstructors()[0].toGenericString();
            TestCase test = constructor.indexOf("java.lang.String") > -1 ? (TestCase)tc.getConstructors()[0].newInstance(name) : (TestCase)tc.newInstance();
            this.setTestCaseClass(test);
        }
        catch (InstantiationException e) {
            this.log.println("Cannot instantiate test: " + executeClass + " (" + JUnitBareMultiTest.exceptionToString(e) + ")");
        }
        catch (InvocationTargetException e) {
            this.log.println("Exception in constructor: " + executeClass + " (" + JUnitBareMultiTest.exceptionToString(e.getTargetException()) + ")");
        }
        catch (IllegalAccessException e) {
            this.log.println("Cannot access test: " + executeClass + " (" + JUnitBareMultiTest.exceptionToString(e) + ")");
        }
        catch (ClassNotFoundException e) {
            this.log.println("Cannot find test: " + executeClass + " (" + JUnitBareMultiTest.exceptionToString(e) + ")");
        }
    }

    protected void setTestCaseClass(TestCase test) {
        this.testCaseClass = test;
    }

    protected Status invokeTestCase(Method m) throws IllegalAccessException, InvocationTargetException {
        try {
            this.testCaseClass.setName(m.getName());
            this.testCaseClass.runBare();
        }
        catch (Throwable e) {
            e.printStackTrace(this.log);
            return Status.failed((String)("test case " + m.getName() + "in test " + this.testCaseClass.getName() + " failed: " + e));
        }
        return Status.passed((String)"OKAY");
    }

    protected void getListAllJunitTestCases() {
        this.tests = new TreeMap<String, Method>();
        try {
            Method[] methods;
            for (Method m : methods = this.testCaseClass.getClass().getMethods()) {
                if (m == null || this.excludeTestCases.contains(m.getName())) continue;
                Class<?>[] paramTypes = m.getParameterTypes();
                Class<?> returnType = m.getReturnType();
                String name = m.getName();
                if (paramTypes.length != 0 || !Void.TYPE.isAssignableFrom(returnType) || !name.startsWith("test")) continue;
                this.tests.put(name, m);
            }
        }
        catch (Throwable e) {
            this.tests = null;
        }
    }
}

