/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.junit;

import com.sun.javatest.Status;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestRunner;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.junit.JUnitAnnotationMultiTest;
import com.sun.javatest.junit.JUnitBareMultiTest;
import com.sun.javatest.junit.JUnitMultiTest;
import com.sun.javatest.lib.MultiTest;
import com.sun.javatest.util.BackupPolicy;
import java.io.IOException;
import java.util.Iterator;

public class JUnitTestRunner
extends TestRunner {
    protected BackupPolicy backupPolicy = BackupPolicy.noBackups();
    protected ClassLoader loader;
    private boolean jtrIfPassed = System.getProperty("javatest.script.jtrIfPassed", "true").equals("true");

    protected boolean runTests(Iterator testIter) throws InterruptedException {
        WorkDirectory wd = this.getWorkDirectory();
        TestDescription td = null;
        while (testIter.hasNext()) {
            td = (TestDescription)testIter.next();
            TestResult tr = new TestResult(td);
            TestResult.Section outSection = tr.createSection("Main");
            this.notifyStartingTest(tr);
            Status execStatus = this.getMultiTest(td).run(this.getTestArgs(td), outSection.createOutput("stdout"), outSection.createOutput("stderr"));
            tr.setStatus(execStatus);
            try {
                if (execStatus.getType() != 0 || this.jtrIfPassed) {
                    tr.writeResults(wd, this.backupPolicy);
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            this.notifyFinishedTest(tr);
        }
        return false;
    }

    public BackupPolicy getBackupPolicy() {
        return this.backupPolicy;
    }

    void setClassLoader(ClassLoader loader) {
        this.loader = loader;
        try {
            Class<?> c = loader.loadClass("com.sun.javatest.junit.JUnitMultiTest");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    protected MultiTest getMultiTest(TestDescription td) {
        String type = td.getParameter("junit.finderscantype");
        JUnitMultiTest mt = null;
        if (type != null) {
            mt = type.equals("superclass") ? new JUnitBareMultiTest(this.loader) : new JUnitAnnotationMultiTest(this.loader);
        }
        return mt;
    }

    private String[] getTestArgs(TestDescription td) {
        return new String[]{td.getParameter("executeClass")};
    }
}

