/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview;

import com.sun.interview.FileFilter;
import java.io.File;

public class ExtensionFileFilter
implements FileFilter {
    private String[] extns;
    private String description;
    private boolean caseSensitive;

    public ExtensionFileFilter(String extn, String description) {
        this.extns = new String[]{extn};
        this.description = description;
    }

    public ExtensionFileFilter(String[] extns, String description) {
        this.extns = extns;
        this.description = description;
    }

    public void setCaseSensitive(boolean b) {
        this.caseSensitive = b;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean accept(File f) {
        for (int i = 0; i < this.extns.length; ++i) {
            if (!this.endsWith(f.getName(), this.extns[i])) continue;
            return true;
        }
        return false;
    }

    public boolean acceptsDirectories() {
        return false;
    }

    public String getDescription() {
        return this.description;
    }

    public String ensureExtension(String path) {
        if (path == null || path.length() == 0) {
            return path;
        }
        for (int i = 0; i < this.extns.length; ++i) {
            if (!this.endsWith(path, this.extns[i])) continue;
            return path;
        }
        return path + this.extns[0];
    }

    public File ensureExtension(File file) {
        if (file == null) {
            return null;
        }
        String path = file.getPath();
        String newPath = this.ensureExtension(path);
        return newPath.equals(path) ? file : new File(newPath);
    }

    private boolean endsWith(String s, String sfx) {
        int sfxlen;
        if (this.caseSensitive) {
            return s.endsWith(sfx);
        }
        int slen = s.length();
        if (slen < (sfxlen = sfx.length())) {
            return false;
        }
        int offset = slen - sfxlen;
        for (int i = 0; i < sfxlen; ++i) {
            char c1 = s.charAt(offset + i);
            char c2 = sfx.charAt(i);
            if (Character.toLowerCase(c1) == Character.toLowerCase(c2)) continue;
            return false;
        }
        return true;
    }
}

