/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public abstract class IntQuestion
extends Question {
    protected int value = Integer.MIN_VALUE;
    protected int[] suggestions;
    private int defaultValue = Integer.MIN_VALUE;
    private String stringValue;
    private transient String newStringValue;
    private int min = -2147483647;
    private int max = Integer.MAX_VALUE;
    private int labelStart;
    private int labelIncrement;
    private static final String UNSET = "unset";
    private static final ResourceBundle i18n = Interview.i18n;

    protected IntQuestion(Interview interview, String tag) {
        super(interview, tag);
        this.clear();
        this.setDefaultValue(this.value);
    }

    protected IntQuestion(Interview interview, String tag, int min, int max) {
        super(interview, tag);
        this.setBounds(min, max);
        this.clear();
        this.setDefaultValue(this.value);
    }

    protected void setBounds(int min, int max) {
        if (min >= max) {
            throw new IllegalArgumentException("invalid bounds");
        }
        this.min = min;
        this.max = max;
    }

    public int getLowerBound() {
        return this.min;
    }

    public int getUpperBound() {
        return this.max;
    }

    public int[] getSuggestions() {
        return this.suggestions;
    }

    public void setSuggestions(int[] newSuggestions) {
        this.suggestions = newSuggestions;
    }

    public int getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(int v) {
        this.defaultValue = v;
    }

    public boolean isValid() {
        return (this.min == Integer.MIN_VALUE || this.min <= this.value) && this.value <= this.max;
    }

    public int getValue() {
        return this.value;
    }

    public int getValueOnPath() throws Interview.NotOnPathFault {
        this.interview.verifyPathContains(this);
        return this.getValue();
    }

    public String getStringValue() {
        if (this.stringValue == null) {
            if (this.value == Integer.MIN_VALUE) {
                this.stringValue = "";
            } else {
                NumberFormat fmt = NumberFormat.getIntegerInstance();
                this.stringValue = fmt.format(new Integer(this.value));
            }
        }
        return this.stringValue;
    }

    public void setValue(String s) throws Interview.Fault {
        this.setValue(s, Locale.getDefault());
    }

    public void setValue(String s, Locale l) throws Interview.Fault {
        int i;
        if (s != null) {
            s = s.trim();
        }
        if (s == null || s.length() == 0) {
            i = Integer.MIN_VALUE;
        } else {
            ParsePosition pos;
            NumberFormat fmt = NumberFormat.getIntegerInstance(l);
            Number num = fmt.parse(s, pos = new ParsePosition(0));
            if (num != null && pos.getIndex() == s.length()) {
                i = num.intValue();
                fmt = NumberFormat.getIntegerInstance();
                s = fmt.format(new Integer(i));
            } else {
                i = Integer.MIN_VALUE;
            }
        }
        this.newStringValue = s;
        this.setValue(i);
    }

    public void setValue(int newValue) {
        int oldValue = this.value;
        this.value = newValue;
        this.stringValue = this.newStringValue;
        this.newStringValue = null;
        if (this.value != oldValue) {
            this.interview.updatePath(this);
            this.interview.setEdited(true);
        }
    }

    public boolean isValueValid() {
        return this.isValid();
    }

    public boolean isValueAlwaysValid() {
        return false;
    }

    protected void setLabelHints(int start, int increment) {
        this.labelStart = start;
        this.labelIncrement = increment;
    }

    public int getLabelStartHint() {
        return this.labelStart;
    }

    public int getLabelIncrementHint() {
        return this.labelIncrement;
    }

    public void clear() {
        this.setValue(this.defaultValue);
    }

    protected void load(Map data) {
        Object o = data.get(this.tag);
        if (o == null) {
            this.clear();
        } else if (o instanceof Integer) {
            this.setValue((Integer)o);
        } else if (o instanceof String) {
            Locale l = Interview.readLocale(data);
            try {
                this.setValue((String)o, l);
            }
            catch (Interview.Fault e) {
                throw new Error(e);
            }
        }
    }

    protected void save(Map data) {
        data.put(this.tag, this.getStringValue());
    }
}

