/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.report;

import com.sun.javatest.JavaTestError;
import com.sun.javatest.Status;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.report.HTMLReport;
import com.sun.javatest.report.HTMLSection;
import com.sun.javatest.report.Report;
import com.sun.javatest.report.ReportWriter;
import com.sun.javatest.report.TestResultsByStatusAndTitleComparator;
import java.io.File;
import java.io.IOException;
import java.util.TreeSet;

class ResultSection
extends HTMLSection {
    private File workDirRoot;
    private TestResultTable resultTable;
    private File[] initFiles;
    private TestFilter[] paramFilters;
    TreeSet[] lists;
    private int totalFound;
    private final int[] fileCodes = new int[]{5, 6, 7, 8};
    private final String[] headings = new String[]{i18n.getString("result.heading.passed"), i18n.getString("result.heading.failed"), i18n.getString("result.heading.errors"), i18n.getString("result.heading.notRun")};

    ResultSection(HTMLReport parent, Report.Settings settings, File dir) {
        super(i18n.getString("result.title"), settings, dir, parent);
        TestResultTable.TreeIterator iter;
        String reportDirPath;
        String workPath;
        this.workDirRoot = settings.ip.getWorkDirectory().getRoot();
        try {
            workPath = this.workDirRoot.getCanonicalPath();
            reportDirPath = this.reportDir.getCanonicalPath();
        }
        catch (IOException e) {
            workPath = this.workDirRoot.getPath();
            reportDirPath = this.reportDir.getPath();
        }
        if (!workPath.endsWith(File.separator)) {
            workPath = workPath + File.separator;
        }
        if (reportDirPath.startsWith(workPath)) {
            File d;
            StringBuffer sb = new StringBuffer();
            try {
                for (d = this.reportDir; d != null && !d.getCanonicalPath().equals(this.workDirRoot.getCanonicalPath()); d = d.getParentFile()) {
                    sb.append("../");
                }
            }
            catch (IOException e) {
                d = null;
            }
            if (d != null) {
                this.workDirRoot = new File(sb.toString());
            }
        }
        this.resultTable = settings.ip.getWorkDirectory().getTestResultTable();
        this.initFiles = settings.getInitialFiles();
        this.lists = new TreeSet[4];
        for (int i = 0; i < this.lists.length; ++i) {
            this.lists[i] = new TreeSet(new TestResultsByStatusAndTitleComparator());
        }
        try {
            TestFilter[] fs = null;
            fs = settings.filter == null ? new TestFilter[]{} : new TestFilter[]{settings.filter};
            iter = this.initFiles == null ? this.resultTable.getIterator(fs) : this.resultTable.getIterator(this.initFiles, fs);
        }
        catch (TestResultTable.Fault f) {
            throw new JavaTestError(i18n.getString("result.testResult.err"));
        }
        while (iter.hasNext()) {
            TestResult tr = (TestResult)iter.next();
            Status s = tr.getStatus();
            TreeSet list = this.lists[s == null ? 3 : s.getType()];
            list.add(tr);
            ++this.totalFound;
        }
        parent.setResults(this.lists);
    }

    void writeSummary(ReportWriter out) throws IOException {
        super.writeSummary(out);
        out.startTag("table");
        out.writeAttr("border", 1);
        for (int i = 0; i < this.lists.length; ++i) {
            String reportFile = HTMLReport.files[this.fileCodes[i]];
            TreeSet l = this.lists[i];
            int n = l.size();
            if (n <= 0) continue;
            out.startTag("tr");
            out.writeTH(this.headings[i], "row");
            out.startTag("td");
            if (this.settings.isStateFileEnabled(i)) {
                out.writeLink(reportFile, Integer.toString(n));
            } else {
                out.write(Integer.toString(n));
            }
            out.endTag("td");
            out.endTag("tr");
        }
        out.startTag("tr");
        out.writeTH(i18n.getString("result.total"), "row");
        out.writeTD(Integer.toString(this.totalFound));
        out.endTag("tr");
        out.endTag("table");
    }

    void writeExtraFiles() throws IOException {
        this.writeStatusFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeStatusFiles() throws IOException {
        for (int i = 0; i < this.lists.length; ++i) {
            if (!this.settings.isStateFileEnabled(i)) continue;
            ReportWriter out = this.openAuxFile(this.fileCodes[i], this.headings[i], i18n);
            out.write(i18n.getString("result.groupByStatus"));
            try {
                TreeSet list = this.lists[i];
                if (list.size() <= 0) continue;
                boolean inList = false;
                String currentHead = null;
                for (TestResult e : list) {
                    String title;
                    try {
                        TestDescription e_td = e.getDescription();
                        title = e_td.getTitle();
                    }
                    catch (TestResult.Fault ex) {
                        title = null;
                    }
                    Status e_s = e.getStatus();
                    if (!e_s.getReason().equals(currentHead)) {
                        currentHead = e_s.getReason();
                        if (inList) {
                            inList = false;
                            out.endTag("ul");
                            out.newLine();
                        }
                        out.startTag("h4");
                        out.write(currentHead.length() == 0 ? i18n.getString("result.noReason") : currentHead);
                        out.endTag("h4");
                        out.newLine();
                    }
                    if (!inList) {
                        inList = true;
                        out.startTag("ul");
                    }
                    out.startTag("li");
                    String eWRPath = e.getWorkRelativePath();
                    File eFile = new File(this.workDirRoot, eWRPath.replace('/', File.separatorChar));
                    String eName = e.getTestName();
                    if (eFile == null || e_s.getType() == 3) {
                        out.write(eName);
                    } else {
                        out.writeLink(eFile, eName);
                    }
                    if (title != null) {
                        out.write(": " + title);
                    }
                    out.newLine();
                }
                if (!inList) continue;
                inList = false;
                out.endTag("ul");
                continue;
            }
            finally {
                out.close();
            }
        }
    }
}

