/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.tool.DeskView;
import com.sun.javatest.tool.Desktop;
import com.sun.javatest.tool.Tool;
import com.sun.javatest.tool.ToolDialog;
import com.sun.javatest.tool.ToolManager;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.PrefixMap;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRootPane;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.plaf.basic.BasicInternalFrameUI;

class MDIDeskView
extends DeskView {
    private JFrame mainFrame;
    private HashMap internalFrames = new HashMap(17);
    private JDesktopPane desktopPane;
    private Listener listener = new Listener();
    private static final String TILE = "tile";
    private static final String CASCADE = "cascade";
    private static final boolean useInternalDialogs = true;

    MDIDeskView(Desktop desktop) {
        this(desktop, MDIDeskView.getDefaultBounds());
    }

    MDIDeskView(DeskView other) {
        this(other.getDesktop(), other.getBounds());
        Tool[] tools = other.getTools();
        for (int i = 0; i < tools.length; ++i) {
            this.addTool(tools[i]);
        }
        this.setVisible(other.isVisible());
    }

    private MDIDeskView(Desktop desktop, Rectangle bounds) {
        super(desktop);
        this.initMainFrame(bounds);
        this.uif.setDialogParent(this.mainFrame);
        JDialog.setDefaultLookAndFeelDecorated(true);
    }

    public void dispose() {
        this.mainFrame.setVisible(false);
        this.mainFrame.dispose();
        super.dispose();
    }

    public boolean isVisible() {
        return this.mainFrame.isVisible();
    }

    public void setVisible(boolean v) {
        Window[] ww;
        if (v == this.mainFrame.isVisible()) {
            return;
        }
        this.mainFrame.setVisible(v);
        if (v && (ww = this.mainFrame.getOwnedWindows()) != null) {
            for (int i = 0; i < ww.length; ++i) {
                ww[i].toFront();
            }
        }
    }

    public boolean isEmpty() {
        return this.internalFrames.size() == 0;
    }

    public Tool[] getTools() {
        Tool[] tools = new Tool[this.internalFrames.size()];
        return this.internalFrames.keySet().toArray(tools);
    }

    public void addTool(Tool t) {
        DeskView view = t.getDeskView();
        if (view == this) {
            return;
        }
        ToolDialog[] tds = t.getToolDialogs();
        boolean[] vis = new boolean[tds.length];
        for (int i = 0; i < tds.length; ++i) {
            vis[i] = tds[i].isVisible();
        }
        if (view != null) {
            view.removeTool(t);
        }
        JInternalFrame f = new JInternalFrame(t.getTitle(), true, true, true, true);
        f.setName(t.getShortTitle());
        f.putClientProperty(this, t);
        f.setJMenuBar(t.getMenuBar());
        f.setContentPane(t);
        f.setDefaultCloseOperation(2);
        f.pack();
        f.addInternalFrameListener(this.listener);
        f.getAccessibleContext().setAccessibleDescription(t.getToolTipText());
        JRootPane root = f.getRootPane();
        root.setName("root");
        AccessibleContext f_ac = f.getAccessibleContext();
        AccessibleContext r_ac = root.getAccessibleContext();
        r_ac.setAccessibleName(f_ac.getAccessibleName());
        r_ac.setAccessibleDescription(f_ac.getAccessibleDescription());
        Dimension dtSize = this.desktopPane.getSize();
        if (dtSize.width == 0 || dtSize.height == 0) {
            dtSize = this.desktopPane.getPreferredSize();
        }
        Dimension size = f.getSize();
        f.setLocation(Math.max(0, dtSize.width / 2 - size.width / 2), Math.max(0, dtSize.height / 2 - size.height / 2));
        f.setVisible(true);
        this.internalFrames.put(t, f);
        this.desktopPane.add(f);
        f.toFront();
        t.addObserver(this.listener);
        t.setDeskView(this);
        for (int i = 0; i < tds.length; ++i) {
            tds[i].initDialog(this, vis[i]);
        }
    }

    public void removeTool(Tool t) {
        JInternalFrame f = (JInternalFrame)this.internalFrames.get(t);
        if (f != null) {
            this.desktopPane.remove(f);
            this.internalFrames.remove(t);
        }
        t.removeObserver(this.listener);
        t.setDeskView(null);
        KeyboardFocusManager fm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component fo = fm.getPermanentFocusOwner();
        if (fo == null || !fo.isShowing()) {
            this.desktopPane.requestFocusInWindow();
        }
    }

    public Tool getSelectedTool() {
        JInternalFrame f = this.desktopPane.getSelectedFrame();
        if (f == null) {
            return null;
        }
        Tool t = (Tool)f.getClientProperty(this);
        return t;
    }

    public void setSelectedTool(Tool t) {
        JInternalFrame f = (JInternalFrame)this.internalFrames.get(t);
        if (f != null) {
            try {
                f.setIcon(false);
                f.setSelected(true);
                this.desktopPane.moveToFront(f);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public int getStyle() {
        return 1;
    }

    public JFrame[] getFrames() {
        return new JFrame[]{this.mainFrame};
    }

    public Rectangle getBounds() {
        return this.mainFrame.getBounds();
    }

    public boolean isToolOwnerForDialog(Tool tool, Container dialog) {
        if (dialog == null) {
            return false;
        }
        return dialog.getParent() == this.desktopPane;
    }

    public Container createDialog(Tool tool, String uiKey, String title, JMenuBar menuBar, Container body, Rectangle bounds, int type) {
        UIFactory uif = tool.uif;
        JInternalFrame f = new JInternalFrame(title, true, true, false, false);
        f.putClientProperty(this, tool);
        f.setName(uiKey);
        uif.setAccessibleInfo(f, uiKey);
        JRootPane root = f.getRootPane();
        root.setName(uiKey + ".root");
        AccessibleContext f_ac = f.getAccessibleContext();
        AccessibleContext r_ac = root.getAccessibleContext();
        r_ac.setAccessibleName(f_ac.getAccessibleName());
        r_ac.setAccessibleDescription(f_ac.getAccessibleDescription());
        if (menuBar != null) {
            f.setJMenuBar(menuBar);
        }
        f.setContentPane(body);
        if (bounds == null) {
            f.pack();
            f.pack();
            Dimension size = f.getSize();
            JInternalFrame tf = (JInternalFrame)this.internalFrames.get(tool);
            Rectangle tb = tf.getBounds();
            f.setLocation(Math.max(0, tb.x + (tb.width - size.width) / 2), Math.max(0, tb.y + (tb.height - size.height) / 2));
        } else {
            f.setBounds(bounds);
        }
        JLayeredPane.putLayer(f, JLayeredPane.DEFAULT_LAYER + 1);
        this.desktopPane.add(f);
        return f;
    }

    protected void saveDesktop(Map m) {
        MDIDeskView.saveBounds(this.mainFrame, new PrefixMap(m, "dt"));
        this.saveTools(m);
    }

    protected void restoreDesktop(Map m) {
        MDIDeskView.restoreBounds(this.mainFrame, new PrefixMap(m, "dt"));
        this.restoreTools(m);
    }

    protected void saveTool(Map m, Tool t) {
        super.saveTool(m, t);
        JInternalFrame f = (JInternalFrame)this.internalFrames.get(t);
        MDIDeskView.saveBounds(f, new PrefixMap(m, "dt"));
    }

    protected Tool restoreTool(Map m, String name) throws DeskView.Fault, ToolManager.Fault {
        Tool t = super.restoreTool(m, name);
        JInternalFrame f = (JInternalFrame)this.internalFrames.get(t);
        MDIDeskView.restoreBounds(f, new PrefixMap(m, "dt"));
        f.setVisible(true);
        return t;
    }

    private void initMainFrame(Rectangle bounds) {
        this.mainFrame = this.createFrame(this.listener, "mdi.main");
        this.desktopPane = new JDesktopPane();
        this.desktopPane.setName("mdi.desk");
        this.uif.setAccessibleInfo(this.desktopPane, "mdi.desk");
        this.desktopPane.setPreferredSize(new Dimension(bounds.width, bounds.height));
        this.mainFrame.setContentPane(this.desktopPane);
        if (bounds == null) {
            this.mainFrame.pack();
            Dimension size = this.mainFrame.getSize();
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            this.mainFrame.setLocation(ge.getCenterPoint().x - size.width / 2, ge.getCenterPoint().y - size.height / 2);
        } else {
            this.mainFrame.setBounds(bounds);
        }
        this.mainFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                MDIDeskView.this.getDesktop().checkToolsAndExitIfOK(MDIDeskView.this.mainFrame);
            }
        });
    }

    private void doCascade() {
        Point p = new Point(0, 0);
        JInternalFrame[] frames = this.getVisibleInternalFrames();
        for (int i = 0; i < frames.length; ++i) {
            JInternalFrame f = frames[i];
            f.setLocation(p);
            this.desktopPane.moveToFront(f);
            if (i == frames.length - 1) {
                try {
                    f.setSelected(true);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            BasicInternalFrameUI ui = (BasicInternalFrameUI)f.getUI();
            int offset = ui.getNorthPane().getHeight();
            p.x += offset;
            p.y += offset;
        }
    }

    private void doTile() {
        JInternalFrame[] frames = this.getVisibleInternalFrames();
        int n = frames.length;
        int cols = (int)Math.sqrt(n);
        int rows = (n + cols - 1) / cols;
        Dimension dSize = this.desktopPane.getSize();
        Dimension tSize = new Dimension(dSize.width / cols, dSize.height / rows);
        for (int i = 0; i < frames.length; ++i) {
            JInternalFrame f = frames[i];
            int c = i % cols;
            int r = i / cols;
            f.setBounds(c * tSize.width, r * tSize.height, tSize.width, tSize.height);
        }
    }

    private JInternalFrame[] getVisibleInternalFrames() {
        Vector<Component> v = new Vector<Component>();
        for (int i = 0; i < this.desktopPane.getComponentCount(); ++i) {
            Component c = this.desktopPane.getComponent(i);
            if (!(c instanceof JInternalFrame) || !c.isVisible()) continue;
            v.add(c);
        }
        Object[] frames = new JInternalFrame[v.size()];
        v.copyInto(frames);
        return frames;
    }

    private class Listener
    implements ActionListener,
    AncestorListener,
    InternalFrameListener,
    MenuListener,
    Tool.Observer {
        private Listener() {
        }

        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (cmd.equals(MDIDeskView.CASCADE)) {
                MDIDeskView.this.doCascade();
            } else if (cmd.equals(MDIDeskView.TILE)) {
                MDIDeskView.this.doTile();
            } else {
                JMenuItem mi = (JMenuItem)e.getSource();
                Object o = mi.getClientProperty(this);
                if (o instanceof Window) {
                    ((Window)o).toFront();
                }
                if (o instanceof JInternalFrame) {
                    ((JInternalFrame)o).toFront();
                } else if (o instanceof Tool) {
                    MDIDeskView.this.setSelectedTool((Tool)o);
                }
            }
        }

        public void ancestorAdded(AncestorEvent event) {
            Tool[] tools = MDIDeskView.this.getTools();
            for (int i = 0; i < tools.length; ++i) {
                Tool t = tools[i];
                t.addObserver(MDIDeskView.this.listener);
            }
        }

        public void ancestorMoved(AncestorEvent event) {
        }

        public void ancestorRemoved(AncestorEvent event) {
            Tool[] tools = MDIDeskView.this.getTools();
            for (int i = 0; i < tools.length; ++i) {
                Tool t = tools[i];
                t.removeObserver(MDIDeskView.this.listener);
            }
        }

        public void internalFrameClosed(InternalFrameEvent e) {
            JInternalFrame f = (JInternalFrame)e.getSource();
            if (f.getContentPane() instanceof Tool) {
                Tool t = (Tool)f.getContentPane();
                MDIDeskView.this.removeTool(t);
                t.removeObserver(MDIDeskView.this.listener);
                t.dispose();
                f.getJMenuBar().removeAll();
                f.setContentPane(new Container());
            }
        }

        public void internalFrameClosing(InternalFrameEvent e) {
            JInternalFrame f = (JInternalFrame)e.getSource();
            Tool t = (Tool)f.getContentPane();
            if (MDIDeskView.this.getDesktop().isOKToClose(t, MDIDeskView.this.mainFrame)) {
                f.dispose();
            }
        }

        public void internalFrameActivated(InternalFrameEvent e) {
        }

        public void internalFrameDeactivated(InternalFrameEvent e) {
        }

        public void internalFrameDeiconified(InternalFrameEvent e) {
        }

        public void internalFrameIconified(InternalFrameEvent e) {
        }

        public void internalFrameOpened(InternalFrameEvent e) {
        }

        public void menuSelected(MenuEvent e) {
            Tool[] tools = MDIDeskView.this.getTools();
            JMenu m = (JMenu)e.getSource();
            m.removeAll();
            JMenuItem tmi = MDIDeskView.this.uif.createMenuItem("dt.windows", MDIDeskView.TILE, this);
            tmi.setEnabled(tools.length > 0);
            m.add(tmi);
            JMenuItem cmi = MDIDeskView.this.uif.createMenuItem("dt.windows", MDIDeskView.CASCADE, this);
            cmi.setEnabled(tools.length > 0);
            m.add(cmi);
            if (tools.length > 0) {
                m.addSeparator();
            }
            int n = 0;
            for (int i = 0; i < tools.length; ++i) {
                Tool tool = tools[i];
                this.addMenuItem(m, n++, tool.getTitle(), tool);
            }
            JInternalFrame[] frames = MDIDeskView.this.desktopPane.getAllFrames();
            for (int i = 0; i < frames.length; ++i) {
                JInternalFrame f = frames[i];
                if (!f.isVisible() || f.getContentPane() instanceof Tool) continue;
                this.addMenuItem(m, n++, f.getTitle(), f);
            }
            Window[] ownedWindows = MDIDeskView.this.mainFrame.getOwnedWindows();
            for (int i = 0; i < ownedWindows.length; ++i) {
                Window w = ownedWindows[i];
                if (!(w instanceof JDialog) || !w.isVisible()) continue;
                this.addMenuItem(m, n++, ((JDialog)w).getTitle(), w);
            }
        }

        private void addMenuItem(JMenu m, int n, String s, Object o) {
            JMenuItem mi = new JMenuItem(MDIDeskView.this.uif.getI18NString("dt.windows.toolX.mit", new Object[]{new Integer(n), s}));
            if (n < 10) {
                mi.setMnemonic(Character.forDigit(n, 10));
            }
            mi.addActionListener(this);
            mi.putClientProperty(this, o);
            m.add(mi);
        }

        public void menuDeselected(MenuEvent e) {
        }

        public void menuCanceled(MenuEvent e) {
        }

        public void shortTitleChanged(Tool src, String newValue) {
        }

        public void titleChanged(Tool src, String newValue) {
            JInternalFrame f = (JInternalFrame)MDIDeskView.this.internalFrames.get(src);
            f.setTitle(newValue);
        }

        public void toolDisposed(Tool src) {
        }
    }
}

