/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.Deprecated;
import com.sun.javatest.Script;
import com.sun.javatest.Status;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestRunner;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.util.BackupPolicy;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class DefaultTestRunner
extends TestRunner {
    private static final Integer EXCEPTION = new Integer(0);
    private static final Integer ERROR = new Integer(1);
    private static final Integer THROWABLE = new Integer(2);
    private Iterator testIter;
    private Set activeThreads;
    private boolean allPassed;
    private boolean stopping;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(DefaultTestRunner.class);

    public synchronized boolean runTests(Iterator testIter) throws InterruptedException {
        this.testIter = testIter;
        Thread[] threads = new Thread[this.getConcurrency()];
        this.activeThreads = new HashSet();
        this.allPassed = true;
        try {
            int i;
            int n = 0;
            while (!this.stopping) {
                for (i = 0; i < threads.length; ++i) {
                    Thread t = threads[i];
                    if (t != null && this.activeThreads.contains(t)) continue;
                    int prio = Math.max(1, Thread.currentThread().getPriority() - 1);
                    t = new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            try {
                                TestDescription td;
                                while ((td = DefaultTestRunner.this.nextTest()) != null) {
                                    if (DefaultTestRunner.this.runTest(td)) continue;
                                    DefaultTestRunner.this.allPassed = false;
                                }
                            }
                            finally {
                                DefaultTestRunner.this.threadExiting(this);
                            }
                        }
                    };
                    t.setName("DefaultTestRunner:Worker-" + i + ":" + n++);
                    t.start();
                    t.setPriority(prio);
                    this.activeThreads.add(t);
                    threads[i] = t;
                }
                this.wait();
            }
            for (i = 0; i < threads.length; ++i) {
                if (threads[i] == null) continue;
                while (this.activeThreads.contains(threads[i])) {
                    this.wait();
                }
                threads[i] = null;
            }
        }
        catch (InterruptedException ex) {
            this.stopping = true;
            for (Thread t : this.activeThreads) {
                t.interrupt();
            }
            long now = System.currentTimeMillis();
            try {
                while (this.activeThreads.size() > 0 && System.currentTimeMillis() - now < 2000L) {
                    this.wait(100L);
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            throw ex;
        }
        finally {
            for (int i = 0; i < threads.length; ++i) {
                if (threads[i] == null) continue;
                Deprecated.invokeThreadStop(threads[i]);
            }
        }
        return this.allPassed;
    }

    private synchronized void threadExiting(Thread t) {
        this.activeThreads.remove(t);
        this.notifyAll();
    }

    private synchronized TestDescription nextTest() {
        if (this.stopping) {
            return null;
        }
        if (this.testIter.hasNext()) {
            return (TestDescription)this.testIter.next();
        }
        this.stopping = true;
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean runTest(TestDescription td) {
        TestResult result;
        block19: {
            WorkDirectory workDir = this.getWorkDirectory();
            result = null;
            boolean scriptUsesNotifier = false;
            TestSuite testSuite = this.getTestSuite();
            TestEnvironment env = this.getEnvironment();
            BackupPolicy backupPolicy = this.getBackupPolicy();
            String[] exclTestCases = this.getExcludedTestCases(td);
            Script s = testSuite.createScript(td, exclTestCases, env.copy(), workDir, backupPolicy);
            scriptUsesNotifier = s.useNotifier();
            if (!scriptUsesNotifier) {
                this.notifyStartingTest(s.getTestResult());
            } else {
                this.delegateNotifier(s);
            }
            result = s.getTestResult();
            s.run();
            Object var11_14 = null;
            if (result == null) {
                String url2 = td.getRootRelativeURL();
                result = this.createErrorResult(td, i18n.getString("dtr.noResult", url2), null);
            }
            if (scriptUsesNotifier) break block19;
            try {
                this.notifyFinishedTest(result);
            }
            catch (ThreadDeath e2) {
                String url3 = td.getRootRelativeURL();
                workDir.log(i18n, "dtr.threadKilled", url3);
                throw e2;
            }
            catch (Throwable e2) {
                String url4 = td.getRootRelativeURL();
                workDir.log(i18n, "dtr.unexpectedThrowable", new Object[]{url4, e2, this.classifyThrowable(e2)});
            }
            {
                break block19;
                catch (ThreadDeath e) {
                    String url = td.getRootRelativeURL();
                    workDir.log(i18n, "dtr.threadKilled", url);
                    result = this.createErrorResult(td, i18n.getString("dtr.threadKilled", url), e);
                    throw e;
                }
                catch (Throwable e) {
                    String url = td.getRootRelativeURL();
                    workDir.log(i18n, "dtr.unexpectedThrowable", new Object[]{url, e, this.classifyThrowable(e)});
                    result = this.createErrorResult(td, i18n.getString("dtr.unexpectedThrowable", new Object[]{url, e, this.classifyThrowable(e)}), e);
                    Object var11_15 = null;
                    if (result == null) {
                        String url2 = td.getRootRelativeURL();
                        result = this.createErrorResult(td, i18n.getString("dtr.noResult", url2), null);
                    }
                    if (!scriptUsesNotifier) {
                        try {
                            this.notifyFinishedTest(result);
                        }
                        catch (ThreadDeath e2) {
                            String url3 = td.getRootRelativeURL();
                            workDir.log(i18n, "dtr.threadKilled", url3);
                            throw e2;
                        }
                        catch (Throwable e2) {
                            String url4 = td.getRootRelativeURL();
                            workDir.log(i18n, "dtr.unexpectedThrowable", new Object[]{url4, e2, this.classifyThrowable(e2)});
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                Object var11_16 = null;
                if (result == null) {
                    String url2 = td.getRootRelativeURL();
                    result = this.createErrorResult(td, i18n.getString("dtr.noResult", url2), null);
                }
                if (!scriptUsesNotifier) {
                    try {
                        this.notifyFinishedTest(result);
                    }
                    catch (ThreadDeath e2) {
                        String url3 = td.getRootRelativeURL();
                        workDir.log(i18n, "dtr.threadKilled", url3);
                        throw e2;
                    }
                    catch (Throwable e2) {
                        String url4 = td.getRootRelativeURL();
                        workDir.log(i18n, "dtr.unexpectedThrowable", new Object[]{url4, e2, this.classifyThrowable(e2)});
                    }
                }
                throw throwable;
            }
        }
        return result.getStatus().getType() == 0;
    }

    private TestResult createErrorResult(TestDescription td, String reason, Throwable t) {
        TestResult tr;
        Status s = Status.error(reason);
        if (t == null) {
            tr = new TestResult(td, s);
        } else {
            tr = new TestResult(td);
            TestResult.Section trs = tr.createSection(i18n.getString("dtr.details"));
            PrintWriter pw = trs.createOutput(i18n.getString("dtr.stackTrace"));
            t.printStackTrace(pw);
            pw.close();
            tr.setStatus(s);
        }
        WorkDirectory workDir = this.getWorkDirectory();
        BackupPolicy backupPolicy = this.getBackupPolicy();
        try {
            tr.writeResults(workDir, backupPolicy);
        }
        catch (Exception e) {
            workDir.log(i18n, "dtr.unexpectedThrowable", new Object[]{td.getRootRelativeURL(), e, EXCEPTION});
        }
        return tr;
    }

    private Integer classifyThrowable(Throwable t) {
        if (t instanceof Exception) {
            return EXCEPTION;
        }
        if (t instanceof Error) {
            return ERROR;
        }
        return THROWABLE;
    }
}

