/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.ExcludeListUpdateHandler;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.exec.BasicSession;
import com.sun.javatest.exec.ContextManager;
import com.sun.javatest.exec.ET_RunTestControl;
import com.sun.javatest.exec.ET_SessionControl;
import com.sun.javatest.exec.InterviewEditor;
import com.sun.javatest.exec.JavaTestMenuManager;
import com.sun.javatest.exec.Session;
import com.sun.javatest.exec.WorkDirChooseTool;
import com.sun.javatest.tool.FileHistory;
import com.sun.javatest.tool.ToolAction;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.Debug;
import com.sun.javatest.util.I18NResourceBundle;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicSessionControl
implements InterviewEditor.Observer,
ET_RunTestControl.Observer,
ET_SessionControl,
Session.Observer {
    protected final BasicSession session;
    protected final TestSuite testSuite;
    protected UIFactory uif;
    protected JComponent parent;
    protected JPanel sessionView;
    protected InterviewEditor interviewEditor;
    protected ContextManager cm;
    ChangeConfigMenu changeMenu;
    Action loadConfigAction;
    Action newConfigAction;
    Action showFullConfigAction;
    Action showStdConfigAction;
    Action newWorkDirAction;
    Action openWorkDirAction;
    FileHistory.Listener configHistoryListener;
    JMenu menuHistory;
    private static KeyStroke configEditorAccelerator = KeyStroke.getKeyStroke(69, 2);
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(BasicSessionControl.class);
    private static int debug = Debug.getInt(BasicSessionControl.class);
    private boolean doConfig = false;

    public BasicSessionControl(JComponent parent, UIFactory uif, TestSuite ts, ContextManager cm) throws Session.Fault {
        this.testSuite = ts;
        this.cm = cm;
        this.uif = uif;
        this.parent = parent;
        this.session = (BasicSession)this.createEmptySession();
        this.initActions();
        this.initHistoryListeners();
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public JComponent getViewComponent() {
        if (this.sessionView == null) {
            this.sessionView = this.createSessionView();
        }
        return this.sessionView;
    }

    Action[] getToolBarActions() {
        return new Action[]{this.showFullConfigAction, this.showStdConfigAction};
    }

    @Override
    public List<Action> getToolBarActionList() {
        return Arrays.asList(this.getToolBarActions());
    }

    @Override
    public void save(Map m) {
        if (this.testSuite != null && this.testSuite.getRoot() != null) {
            m.put("testSuite", this.testSuite.getRoot().getPath());
        }
        this.session.save(m);
    }

    @Override
    public void restore(Map m) {
        try {
            this.session.restore(m);
        }
        catch (Session.Fault e) {
            if (debug > 0) {
                e.printStackTrace(Debug.getWriter());
            }
            this.uif.showError("exec.cantRestoreSession", e.getMessage());
        }
    }

    @Override
    public void dispose() {
        this.session.dispose();
        if (this.interviewEditor != null) {
            this.interviewEditor.dispose();
            this.interviewEditor = null;
        }
    }

    protected Session createEmptySession() throws Session.Fault {
        return new BasicSession(this.testSuite);
    }

    public static Parameters clone(Parameters p) throws Session.Fault {
        if (p == null) {
            return null;
        }
        if (p instanceof InterviewParameters) {
            try {
                InterviewParameters ip = (InterviewParameters)p;
                InterviewParameters clone = ip.getWorkDirectory().getTestSuite().createInterview();
                clone.setWorkDirectory(ip.getWorkDirectory());
                HashMap data = new HashMap();
                ip.save(data);
                clone.load(data, false);
                return clone;
            }
            catch (Exception e) {
                throw new Session.Fault(e);
            }
        }
        throw new IllegalStateException(i18n.getString("bcc.cantClonParameters.err", p));
    }

    public void ensureInterviewUpToDate() {
        if (this.session instanceof BasicSession) {
            try {
                this.session.ensureInterviewUpToDate();
            }
            catch (Exception ex) {
                if (debug > 0) {
                    ex.printStackTrace(Debug.getWriter());
                }
                this.uif.showError("exec.loadInterview", ex.toString());
            }
        } else {
            throw new IllegalStateException(i18n.getString("bcc.notBasicConfigInstance.err", this.session.getClass()));
        }
    }

    @Override
    public void startTests(Parameters p) {
        if (this.getNeedToAutoCheckExcludeList(p)) {
            this.checkExcludeListUpdate(this.parent, false, p);
        }
    }

    @Override
    public void finishTests(Parameters p) {
    }

    public void whatToDoWhenConfigNotReadyButUserPressedStartButton(final Action startAction) {
        String errorMessage;
        if (!(this.session instanceof BasicSession)) {
            return;
        }
        final InterviewParameters ip = this.session.config;
        int option = !ip.isTemplate() && ip.isStarted() ? ((errorMessage = ip.getErrorMessage()) != null ? this.uif.showOKCancelDialog("rh.configError", errorMessage) : this.uif.showOKCancelDialog("rh.completeConfigure")) : this.uif.showOKCancelDialog("rh.startConfigure");
        if (option != 0) {
            startAction.setEnabled(true);
            return;
        }
        if (ip.isTemplate()) {
            this.newConfig();
        }
        this.showConfigEditor(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                if (ip.isTemplate() || !ip.isFinishable()) {
                    startAction.setEnabled(true);
                } else {
                    int option = BasicSessionControl.this.uif.showOKCancelDialog("rh.configDone");
                    if (option == 0) {
                        startAction.actionPerformed(null);
                    }
                }
            }
        });
    }

    void editConfigWithErrorMessage() {
        int option;
        if (!(this.session instanceof BasicSession)) {
            return;
        }
        InterviewParameters ip = this.session.config;
        String errorMessage = ip.getErrorMessage();
        int n = option = errorMessage == null ? this.uif.showOKCancelDialog("rh.mustConfigure") : this.uif.showOKCancelDialog("rh.configError", errorMessage);
        if (option == 0) {
            if (ip.isTemplate()) {
                this.newConfig();
            } else {
                this.showConfigEditor(null);
            }
        }
    }

    protected void checkExcludeListUpdate(JComponent parent, boolean quietIfNoUpdate, Parameters params) {
        if (params instanceof InterviewParameters) {
            InterviewParameters ip = (InterviewParameters)params;
            BasicSessionControl.checkExcludeListUpdate(parent, quietIfNoUpdate, ip, ip.getTestSuite(), ip.getWorkDirectory(), this.uif);
        }
    }

    static void checkExcludeListUpdate(JComponent parent, boolean quietIfNoUpdate, Parameters interviewParams, TestSuite testSuite, WorkDirectory workDir, UIFactory uif) {
        try {
            Parameters.ExcludeListParameters elp = interviewParams.getExcludeListParameters();
            if (!(elp instanceof Parameters.MutableExcludeListParameters)) {
                return;
            }
            URL remote = testSuite.getLatestExcludeList();
            File local = workDir.getSystemFile("latest.jtx");
            ExcludeListUpdateHandler eluh = new ExcludeListUpdateHandler(remote, local);
            if (quietIfNoUpdate && !eluh.isUpdateAvailable()) {
                return;
            }
            JPanel info = new JPanel(new GridBagLayout());
            info.setBorder(BorderFactory.createEmptyBorder(20, 10, 20, 10));
            GridBagConstraints lc = new GridBagConstraints();
            lc.anchor = 13;
            GridBagConstraints fc = new GridBagConstraints();
            fc.gridwidth = 0;
            fc.fill = 2;
            fc.weightx = 1.0;
            JLabel remoteLbl = uif.createLabel("ch.elu.remote");
            info.add((Component)remoteLbl, lc);
            JTextField remoteText = uif.createOutputField("ch.elu.remote", remoteLbl);
            remoteText.setBorder(null);
            long remoteDate = eluh.getRemoteURLLastModified();
            String remoteDateText = remoteDate <= 0L ? uif.getI18NString("ch.elu.notAvailable") : new Date(remoteDate).toString();
            remoteText.setText(remoteDateText);
            remoteText.setColumns(remoteDateText.length());
            info.add((Component)remoteText, fc);
            JLabel localLbl = uif.createLabel("ch.elu.local");
            info.add((Component)localLbl, lc);
            JTextField localText = uif.createOutputField("ch.elu.local", localLbl);
            localText.setBorder(null);
            long localDate = eluh.getLocalFileLastModified();
            String localDateText = localDate <= 0L ? uif.getI18NString("ch.elu.notAvailable") : new Date(localDate).toString();
            localText.setText(localDateText);
            localText.setColumns(localDateText.length());
            info.add((Component)localText, fc);
            if (eluh.isUpdateAvailable()) {
                String foot;
                String title = uif.getI18NString("ch.elu.update.title");
                String head = uif.getI18NString("ch.elu.update.head");
                int rc = JOptionPane.showConfirmDialog(parent, new Object[]{head, info, foot = uif.getI18NString("ch.elu.update.foot")}, title, 0);
                if (rc == 0) {
                    eluh.update();
                }
            } else {
                String title = uif.getI18NString("ch.elu.noUpdate.title");
                String head = uif.getI18NString("ch.elu.noUpdate.head");
                JOptionPane.showMessageDialog(parent, new Object[]{head, info}, title, 1);
            }
        }
        catch (IOException e) {
            workDir.log(uif.getI18NResourceBundle(), "ch.elu.logError", e);
            uif.showError("ch.elu.error", e);
        }
    }

    protected boolean getNeedToAutoCheckExcludeList(Parameters params) {
        WorkDirectory workDir = params.getWorkDirectory();
        Parameters.ExcludeListParameters elp = this.session.getParameters().getExcludeListParameters();
        if (!(elp instanceof Parameters.MutableExcludeListParameters)) {
            return false;
        }
        Parameters.MutableExcludeListParameters melp = (Parameters.MutableExcludeListParameters)elp;
        if (melp.getExcludeMode() != 3) {
            return false;
        }
        if (params.getTestSuite().getLatestExcludeList() == null) {
            return false;
        }
        if (!melp.isLatestExcludeAutoCheckEnabled()) {
            return false;
        }
        if (melp.getLatestExcludeAutoCheckMode() == 2) {
            return true;
        }
        File local = workDir.getSystemFile("latest.jtx");
        if (!local.exists()) {
            return true;
        }
        long localLastModified = local.lastModified();
        long now = System.currentTimeMillis();
        int ageInDays = melp.getLatestExcludeAutoCheckInterval();
        long ageInMillis = ageInDays * 24 * 60 * 60 * 1000;
        return ageInDays > 0 && now > localLastModified + ageInMillis;
    }

    @Override
    public JMenu getMenu() {
        int i;
        JMenuItem[] items;
        JMenu menu = this.uif.createMenu("ch");
        JMenuItem menuEdit = this.uif.createMenuItem(this.showFullConfigAction);
        menuEdit.setIcon(null);
        menuEdit.setAccelerator(configEditorAccelerator);
        menu.add(menuEdit);
        menu.add(this.changeMenu);
        menu.addSeparator();
        menu.add(this.uif.createMenuItem(this.newConfigAction));
        menu.add(this.uif.createMenuItem(this.loadConfigAction));
        JavaTestMenuManager menuManager = null;
        if (this.cm != null && (menuManager = this.cm.getMenuManager()) != null && (items = menuManager.getMenuItems(4)) != null) {
            for (i = 0; i < items.length; ++i) {
                menu.add(items[i]);
            }
        }
        menu.add(this.menuHistory);
        if (this.cm != null && (menuManager = this.cm.getMenuManager()) != null && (items = menuManager.getMenuItems(6)) != null) {
            menu.addSeparator();
            for (i = 0; i < items.length; ++i) {
                menu.add(items[i]);
            }
        }
        return menu;
    }

    protected boolean initEditor() {
        if (this.interviewEditor != null) {
            return true;
        }
        InterviewParameters ip = (InterviewParameters)this.session.getParameters();
        if (ip == null || ip.getWorkDirectory() == null) {
            return false;
        }
        this.interviewEditor = new InterviewEditor(this.parent, this.getUIFactory(), ip);
        if (this.cm != null) {
            this.interviewEditor.setCustomRenderers(this.cm.getCustomRenderersMap());
            this.interviewEditor.setContextManager(this.cm);
        }
        this.interviewEditor.setCheckExcludeListListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Object src = e.getSource();
                JComponent p = src instanceof JComponent ? (JComponent)src : BasicSessionControl.this.parent;
                BasicSessionControl.this.checkExcludeListUpdate(p, false, BasicSessionControl.this.session.getParameters());
            }
        });
        this.interviewEditor.addObserver(this);
        return true;
    }

    protected UIFactory getUIFactory() {
        return this.uif;
    }

    void newConfig() {
        if (!this.initEditor()) {
            return;
        }
        this.interviewEditor.newConfig();
    }

    void loadConfig() {
        if (!this.initEditor()) {
            return;
        }
        this.interviewEditor.loadConfig();
    }

    @Override
    public void edit() {
        if (this.session.wd == null) {
            this.createWD();
            if (this.session.wd == null) {
                return;
            }
        }
        this.showConfig(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configure() {
        this.doConfig = true;
        try {
            if (this.session.isReady()) {
                return;
            }
            if (this.session.wd == null) {
                this.showWorkDirDialog();
            }
            if (this.session.wd == null) {
                return;
            }
            if (!this.session.isReady()) {
                this.showConfigureDialog();
            }
        }
        finally {
            this.doConfig = false;
        }
    }

    @Override
    public boolean isConfiguring() {
        return this.doConfig || this.isEditorVisible();
    }

    protected void showWorkDirDialog() {
        ActionListener optionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Component c = (Component)e.getSource();
                JOptionPane op = (JOptionPane)SwingUtilities.getAncestorOfClass(JOptionPane.class, c);
                op.setValue(c);
                op.setVisible(false);
            }
        };
        JTextArea msg = this.uif.createMessageArea("exec.wd.need");
        String title = this.uif.getI18NString("exec.wd.need.title");
        Object[] options = new JButton[]{this.uif.createButton("exec.wd.open", optionListener), this.uif.createButton("exec.wd.new", optionListener), this.uif.createCancelButton("exec.wd.cancel", optionListener)};
        int option = JOptionPane.showOptionDialog(this.parent, msg, title, 1, 3, null, options, null);
        switch (option) {
            case 0: {
                this.setWD();
                break;
            }
            case 1: {
                this.createWD();
                break;
            }
            default: {
                return;
            }
        }
    }

    protected void showConfigureDialog() {
        String errorMessage;
        int option = this.session.config.isStarted() ? ((errorMessage = this.session.config.getErrorMessage()) != null ? this.uif.showOKCancelDialog("rh.configError", errorMessage) : this.uif.showOKCancelDialog("rh.completeConfigure")) : this.uif.showOKCancelDialog("rh.startConfigure");
        if (option == 0) {
            this.showConfig();
        } else {
            this.doConfig = false;
            this.session.notifyObservers(new E_EditorVisibility(this.isEditorVisible(), null));
        }
    }

    private void showConfig() {
        if (this.session.config.getFile() == null) {
            this.newConfig();
        } else {
            this.showConfig(1);
        }
    }

    void showConfig(int mode) {
        if (!this.initEditor()) {
            return;
        }
        this.interviewEditor.edit(mode);
    }

    void showConfigEditor(ActionListener actionListener) {
        if (!this.initEditor()) {
            return;
        }
        this.interviewEditor.edit(1);
    }

    void checkUpdate() {
        System.err.println("Temporary not implemented...");
    }

    void ensureConfigEditorInitialized() {
    }

    protected void initActions() {
        this.loadConfigAction = new ToolAction(this.uif, "ch.load"){

            public void actionPerformed(ActionEvent e) {
                if (BasicSessionControl.this.session.wd == null) {
                    BasicSessionControl.this.showWorkDirDialog();
                }
                BasicSessionControl.this.loadConfig();
            }
        };
        this.newConfigAction = new ToolAction(this.uif, "ch.new"){

            public void actionPerformed(ActionEvent e) {
                if (BasicSessionControl.this.session.wd == null) {
                    BasicSessionControl.this.showWorkDirDialog();
                }
                BasicSessionControl.this.newConfig();
            }

            public Object getValue(String key) {
                if ("actionName".equals(key)) {
                    return BasicSessionControl.this.uif.getI18NString("ch.new2.act");
                }
                return super.getValue(key);
            }
        };
        this.showFullConfigAction = new ConfigAction(this.uif, "ch.full", 1, true){

            public void actionPerformed(ActionEvent e) {
                if (BasicSessionControl.this.session.wd == null) {
                    BasicSessionControl.this.showWorkDirDialog();
                }
                BasicSessionControl.this.showConfig(1);
            }

            public Object getValue(String key) {
                if ("actionName".equals(key)) {
                    return BasicSessionControl.this.uif.getI18NString("ch.full2.act");
                }
                return super.getValue(key);
            }
        };
        this.showStdConfigAction = new ConfigAction(this.uif, "ch.std", 2, true){

            public void setEnabled(boolean newValue) {
                super.setEnabled(newValue);
                if (BasicSessionControl.this.changeMenu != null) {
                    BasicSessionControl.this.changeMenu.checkEnabled();
                }
            }

            public void actionPerformed(ActionEvent e) {
                if (!this.isEnabled()) {
                    return;
                }
                Object control = e.getSource();
                if (control instanceof JMenuItem) {
                    JMenuItem mi = (JMenuItem)control;
                    Integer miMode = (Integer)this.getValue(mi.getName());
                    this.performAction(miMode);
                } else {
                    this.performAction(this.mode);
                }
            }
        };
        this.changeMenu = new ChangeConfigMenu();
        this.newWorkDirAction = this.createNewWorkDirAction();
        this.openWorkDirAction = this.createSetWorkDirAction();
    }

    protected ToolAction createNewWorkDirAction() {
        return new ToolAction(this.uif, "ch.newWorkDir"){

            public void actionPerformed(ActionEvent e) {
                boolean editConfig = BasicSessionControl.this.createWD();
                if (editConfig) {
                    BasicSessionControl.this.showConfig();
                }
            }

            public Object getValue(String key) {
                if ("actionName".equals(key)) {
                    return BasicSessionControl.this.uif.getI18NString("ch.newWorkDir.act");
                }
                return super.getValue(key);
            }
        };
    }

    protected ToolAction createSetWorkDirAction() {
        return new ToolAction(this.uif, "ch.setWorkDir"){

            public void actionPerformed(ActionEvent e) {
                boolean editConfig = BasicSessionControl.this.setWD();
                if (editConfig) {
                    BasicSessionControl.this.showConfig(1);
                }
            }

            public Object getValue(String key) {
                if ("actionName".equals(key)) {
                    return BasicSessionControl.this.uif.getI18NString("ch.setWorkDir.act");
                }
                return super.getValue(key);
            }
        };
    }

    protected void initHistoryListeners() {
        this.configHistoryListener = new FileHistory.Listener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JMenuItem mi = (JMenuItem)e.getSource();
                File f = (File)mi.getClientProperty(FileHistory.FILE);
                if (f != null && BasicSessionControl.this.initEditor()) {
                    BasicSessionControl.this.interviewEditor.loadAndEdit(f);
                }
            }
        });
        this.menuHistory = this.uif.createMenu("ch.history");
        this.menuHistory.addMenuListener(this.configHistoryListener);
    }

    protected JPanel createSessionView() {
        return new SessionView(this.session);
    }

    @Override
    public void updateGUI() {
        Parameters params = this.session.getParameters();
        if (params != null) {
            this.ensureInterviewUpToDate();
        }
        boolean isWorkDirSet = this.session.wd != null;
        boolean configCreated = this.session.getValue("Configuration") != null;
        boolean editorNotVisible = !this.isEditorVisible();
        this.showFullConfigAction.setEnabled(params != null && configCreated && editorNotVisible);
        this.showStdConfigAction.setEnabled(params != null && configCreated && editorNotVisible);
        this.newWorkDirAction.setEnabled(!isWorkDirSet);
        this.openWorkDirAction.setEnabled(!isWorkDirSet);
        this.newConfigAction.setEnabled(editorNotVisible);
        this.loadConfigAction.setEnabled(editorNotVisible);
        this.changeMenu.checkEnabled();
        this.menuHistory.setEnabled(editorNotVisible);
        if (isWorkDirSet) {
            FileHistory h;
            if (this.configHistoryListener.getFileHistory() == null) {
                h = FileHistory.getFileHistory(this.session.wd, "configHistory.jtl");
                this.configHistoryListener.setFileHistory(h);
            } else {
                h = this.configHistoryListener.getFileHistory();
            }
            if (h.getLatestEntry() == null) {
                this.menuHistory.setEnabled(false);
            }
        } else {
            this.menuHistory.setEnabled(false);
        }
    }

    protected boolean isEditorVisible() {
        return this.interviewEditor != null && this.interviewEditor.isVisible();
    }

    @Override
    public void changed(InterviewParameters p) {
        try {
            this.session.update(new BasicSession.U_NewConfig(p));
        }
        catch (Session.Fault e) {
            e.printStackTrace();
            System.err.println(i18n.getString("bcc.internalError.err"));
        }
    }

    @Override
    public void changedVisibility(boolean isVisible, InterviewEditor editor) {
        this.updateGUI();
        this.session.notifyObservers(new E_EditorVisibility(isVisible, editor));
    }

    protected boolean createWD() {
        this.applyWorkDir(WorkDirChooseTool.chooseWD(this.parent, null, this.testSuite, 0));
        return false;
    }

    protected boolean setWD() {
        this.applyWorkDir(WorkDirChooseTool.chooseWD(this.parent, null, this.testSuite, 2));
        return false;
    }

    protected void applyWorkDir(WorkDirectory wd) {
        if (wd != null) {
            try {
                this.session.update(new BasicSession.U_NewWD(wd));
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
    }

    public void restoreConfigFromWD(WorkDirectory wd) throws Session.Fault {
        FileHistory h = FileHistory.getFileHistory(wd, "configHistory.jtl");
        File latestConfigFile = h.getRelativeLatestEntry(wd.getRoot().getPath(), wd.getPrevWDPath());
        if (latestConfigFile != null) {
            if (!this.cm.getAllowConfigLoadOutsideDefault()) {
                File defaultConfigLoadPath = InterviewEditor.checkLoadConfigFileDefaults(this.cm);
                File dir = new File(latestConfigFile.getAbsolutePath().substring(0, latestConfigFile.getAbsolutePath().lastIndexOf(File.separator)));
                boolean isMatch = true;
                if (dir != null && defaultConfigLoadPath != null) {
                    try {
                        isMatch = dir.getCanonicalPath().indexOf(defaultConfigLoadPath.getCanonicalPath()) == 0;
                    }
                    catch (IOException ioe) {
                        this.uif.showError("exec.internalError", ioe);
                        return;
                    }
                }
                if (!isMatch) {
                    this.uif.showError("ce.load.notAllowedDir", defaultConfigLoadPath);
                    return;
                }
            }
            this.loadInterviewFromFile(wd, latestConfigFile);
            h.add(latestConfigFile);
        }
    }

    void loadInterviewFromFile(WorkDirectory wd, File latestConfigFile) {
        try {
            this.session.loadInterviewFromFile(wd, latestConfigFile);
        }
        catch (Session.Fault e) {
            this.uif.showError("exec.internalError", e);
        }
    }

    @Override
    public void updated(Session.Event ev) {
        if (ev instanceof BasicSession.E_NewWD) {
            BasicSession.E_NewWD e_WD = (BasicSession.E_NewWD)ev;
            if (e_WD.doRestoreConfig) {
                try {
                    this.restoreConfigFromWD(e_WD.wd);
                }
                catch (Session.Fault f) {
                    f.printStackTrace();
                }
            }
        }
    }

    private class ConfigAction
    extends ToolAction {
        public int mode;

        public ConfigAction(UIFactory uif, String key, int mode, boolean needIcon) {
            super(uif, key, needIcon);
            this.mode = mode;
        }

        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            this.performAction(this.mode);
        }

        protected void performAction(Integer mode) {
            BasicSessionControl.this.showConfig(mode);
        }
    }

    private class ChangeConfigMenu
    extends JMenu
    implements MenuListener {
        private JMenuItem tests;
        private JMenuItem excludeList;
        private JMenuItem keywords;
        private JMenuItem priorStatus;
        private JMenuItem environment;
        private JMenuItem concurrency;
        private JMenuItem timeoutFactor;
        private static final String CHANGE_TESTS = "test";
        private static final String CHANGE_EXCLUDE_LIST = "excl";
        private static final String CHANGE_KEYWORDS = "keyw";
        private static final String CHANGE_PRIOR_STATUS = "stat";
        private static final String CHANGE_ENVIRONMENT = "envt";
        private static final String CHANGE_CONCURRENCY = "conc";
        private static final String CHANGE_TIMEOUT_FACTOR = "time";

        ChangeConfigMenu() {
            BasicSessionControl.this.uif.initMenu(this, "ch.change");
            this.tests = this.addMenuItem(CHANGE_TESTS, 3);
            this.excludeList = this.addMenuItem(CHANGE_EXCLUDE_LIST, 4);
            this.keywords = this.addMenuItem(CHANGE_KEYWORDS, 5);
            this.priorStatus = this.addMenuItem(CHANGE_PRIOR_STATUS, 6);
            this.environment = this.addMenuItem(CHANGE_ENVIRONMENT, 7);
            this.concurrency = this.addMenuItem(CHANGE_CONCURRENCY, 8);
            this.timeoutFactor = this.addMenuItem(CHANGE_TIMEOUT_FACTOR, 9);
            this.addMenuListener(this);
        }

        public void checkEnabled() {
            if (!(this.tests.isEnabled() || this.excludeList.isEnabled() || this.keywords.isEnabled() || this.priorStatus.isEnabled() || this.environment.isEnabled() || this.concurrency.isEnabled() || this.timeoutFactor.isEnabled())) {
                this.setEnabled(false);
            } else {
                this.setEnabled(!BasicSessionControl.this.isEditorVisible());
            }
        }

        private JMenuItem addMenuItem(String action, int configEditorMode) {
            JMenuItem mi = BasicSessionControl.this.uif.createMenuItem(BasicSessionControl.this.showStdConfigAction);
            mi.setIcon(null);
            mi.setName(action);
            mi.setText(BasicSessionControl.this.uif.getI18NString("ch.change." + action + ".mit"));
            mi.setMnemonic(BasicSessionControl.this.uif.getI18NMnemonic("ch.change." + action + ".mne"));
            BasicSessionControl.this.showStdConfigAction.putValue(action, configEditorMode);
            this.add(mi);
            return mi;
        }

        public void menuSelected(MenuEvent e) {
            Parameters c = BasicSessionControl.this.session.getParameters();
            if (c == null) {
                return;
            }
            this.update(this.tests, c.getTestsParameters(), Parameters.MutableTestsParameters.class);
            this.update(this.excludeList, c.getExcludeListParameters(), Parameters.MutableExcludeListParameters.class);
            this.update(this.keywords, c.getKeywordsParameters(), Parameters.MutableKeywordsParameters.class);
            this.update(this.priorStatus, c.getPriorStatusParameters(), Parameters.MutablePriorStatusParameters.class);
            this.update(this.environment, c.getEnvParameters(), Parameters.LegacyEnvParameters.class);
            this.update(this.concurrency, c.getConcurrencyParameters(), Parameters.MutableConcurrencyParameters.class);
            this.update(this.timeoutFactor, c.getTimeoutFactorParameters(), Parameters.MutableTimeoutFactorParameters.class);
        }

        private void update(JMenuItem mi, Object o, Class c) {
            mi.setVisible(o != null && c.isAssignableFrom(o.getClass()));
        }

        public void menuDeselected(MenuEvent e) {
        }

        public void menuCanceled(MenuEvent e) {
        }
    }

    protected class SessionView
    extends JPanel
    implements Session.Observer {
        protected Session session;
        protected JLabel wd_n;
        protected JLabel conf_n;
        protected JTextField wd_f;
        protected JTextField conf_f;
        public static final String ACTION_NAME = "actionName";
        protected final Color COLOR_NOT_READY;
        protected final Color COLOR_READY;

        protected SessionView(Session session) {
            this.COLOR_NOT_READY = BasicSessionControl.this.uif.getI18NColor("bcc.notready");
            this.COLOR_READY = BasicSessionControl.this.uif.getI18NColor("bcc.ready");
            this.session = session;
            this.session.addObserver(this);
            this.init();
            this.layoutComponents();
        }

        protected void init() {
            this.wd_n = BasicSessionControl.this.uif.createLabel("bcc.WorkDir");
            this.wd_f = BasicSessionControl.this.uif.createOutputField("bcc.WorkDir", this.wd_n, true);
            this.wd_f.setBorder(BorderFactory.createEmptyBorder());
            this.conf_n = BasicSessionControl.this.uif.createLabel("bcc.Configuration");
            this.conf_f = BasicSessionControl.this.uif.createOutputField("bcc.Configuration", this.conf_n, true);
            this.conf_f.setBorder(BorderFactory.createEmptyBorder());
        }

        protected void layoutComponents() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(0, 3, 0, 3);
            this.add((Component)this.wd_n, gridBagConstraints);
            boolean wdReady = this.session.getParameters().getWorkDirectory() != null;
            this.updateWD(this.wd_f, wdReady);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.1;
            gridBagConstraints.insets = new Insets(0, 3, 0, 3);
            this.add((Component)this.wd_f, gridBagConstraints);
            this.conf_n.setHorizontalAlignment(4);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(0, 3, 0, 3);
            this.add((Component)this.conf_n, gridBagConstraints);
            this.updateCfg(this.conf_f, wdReady);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.1;
            gridBagConstraints.insets = new Insets(0, 3, 0, 3);
            this.add((Component)this.conf_f, gridBagConstraints);
        }

        protected void updateField(JTextField fld, String text) {
            String tipText = null;
            if (text == null) {
                text = "NONE";
                tipText = "Not set yet";
            } else {
                tipText = text;
                int index = text.lastIndexOf(File.separator);
                if (index >= 0) {
                    text = text.substring(index + 1);
                }
            }
            fld.setText(text);
            fld.setToolTipText(tipText);
        }

        protected void updateWD(JTextField fld, boolean isReady) {
            String text = this.session.getValue("WorkDir");
            this.updateField(fld, text);
        }

        protected void updateCfg(JTextField fld, boolean isWDReady) {
            String text = this.session.getValue("Configuration");
            this.updateField(fld, text);
        }

        public void updated(Session.Event ev) {
            boolean wdReady = this.session.getParameters().getWorkDirectory() != null;
            this.updateWD(this.wd_f, wdReady);
            this.updateCfg(this.conf_f, wdReady);
        }
    }

    protected class E_EditorVisibility
    implements Session.Event {
        public final boolean isVisible;
        public final InterviewEditor source;

        E_EditorVisibility(boolean isVisible, InterviewEditor source) {
            this.isVisible = isVisible;
            this.source = source;
        }
    }
}

