/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.report;

import com.sun.javatest.KnownFailuresList;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.report.HTMLReport;
import com.sun.javatest.report.HTMLSection;
import com.sun.javatest.report.KflSorter;
import com.sun.javatest.report.Report;
import com.sun.javatest.report.ReportWriter;
import com.sun.javatest.tool.Preferences;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.SortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class KflSection
extends HTMLSection {
    private File workDirRoot;
    private TestResultTable resultTable;
    private File[] initFiles;
    private int totalFound;
    private KflSorter sorter;
    private KnownFailuresList kfl;
    static final String FAIL2PASS = "kfl_fail2pass.html";
    static final String FAIL2ERROR = "kfl_fail2error.html";
    static final String FAIL2MISSING = "kfl_fail2missing.html";
    static final String FAIL2NOTRUN = "kfl_fail2notrun.html";
    static final String FAIL2FAIL = "kfl_fail2fail.html";
    static final String NEWFAILURES = "kfl_newfailures.html";
    static final String TC_FAIL2PASS = "kfl_tc_fail2pass.html";
    static final String TC_FAIL2ERROR = "kfl_tc_fail2error.html";
    static final String TC_FAIL2MISSING = "kfl_tc_fail2missing.html";
    static final String TC_FAIL2NOTRUN = "kfl_tc_fail2notrun.html";
    static final String TC_NEWFAILURES = "kfl_tc_newfailures.html";

    KflSection(HTMLReport parent, Report.Settings settings, File dir) {
        super(i18n.getString("kfl.title"), settings, dir, parent);
        this.resultTable = settings.ip.getWorkDirectory().getTestResultTable();
        this.kfl = settings.ip.getKnownFailuresList();
        this.workDirRoot = settings.ip.getWorkDirectory().getRoot();
        i18n.getString("kfl.f2e.heading");
        i18n.getString("kfl.f2e.notes");
        i18n.getString("kfl.f2e.title");
        i18n.getString("kfl.f2m.heading");
        i18n.getString("kfl.f2m.notes");
        i18n.getString("kfl.f2m.title");
        i18n.getString("kfl.f2nr.heading");
        i18n.getString("kfl.f2nr.notes");
        i18n.getString("kfl.f2nr.title");
        i18n.getString("kfl.f2p.heading");
        i18n.getString("kfl.f2p.notes");
        i18n.getString("kfl.f2p.title");
        i18n.getString("kfl.new.heading");
        i18n.getString("kfl.new.notes");
        i18n.getString("kfl.new.title");
        i18n.getString("kfl.f2f.heading");
        i18n.getString("kfl.f2f.notes");
        i18n.getString("kfl.f2f.title");
        i18n.getString("kfl.tc_f2e.heading");
        i18n.getString("kfl.tc_f2e.notes");
        i18n.getString("kfl.tc_f2e.summary");
        i18n.getString("kfl.tc_f2e.title");
        i18n.getString("kfl.tc_f2m.heading");
        i18n.getString("kfl.tc_f2m.notes");
        i18n.getString("kfl.tc_f2m.summary");
        i18n.getString("kfl.tc_f2m.title");
        i18n.getString("kfl.tc_f2nr.heading");
        i18n.getString("kfl.tc_f2nr.notes");
        i18n.getString("kfl.tc_f2nr.summary");
        i18n.getString("kfl.tc_f2nr.title");
        i18n.getString("kfl.tc_f2p.heading");
        i18n.getString("kfl.tc_f2p.notes");
        i18n.getString("kfl.tc_f2p.summary");
        i18n.getString("kfl.tc_f2p.title");
        i18n.getString("kfl.tc_new.heading");
        i18n.getString("kfl.tc_new.notes");
        i18n.getString("kfl.tc_new.summary");
        i18n.getString("kfl.tc_new.title");
    }

    @Override
    void writeSummary(ReportWriter out) throws IOException {
        super.writeSummary(out);
        out.write(i18n.getString("kfl.files.list"));
        File[] kfls = this.settings.ip.getKnownFailureFiles();
        if (kfls != null && kfls.length > 0) {
            out.startTag("ul");
            for (File f : kfls) {
                out.startTag("li");
                out.writeLink(f.toURI().toString(), f.getCanonicalPath());
            }
        } else {
            out.write(i18n.getString("kfl.nofiles"));
            out.newLine();
            return;
        }
        out.endTag("ul");
        if (this.kfl == null) {
            out.startTag("p");
            out.write(i18n.getString("kfl.unable"));
            out.startTag("br");
            out.newLine();
            return;
        }
        this.sorter = new KflSorter(this.kfl, this.resultTable, this.settings.isKflTestCasesEnabled());
        this.sorter.setF2eEnabled(this.settings.isKflF2eEnabled());
        this.sorter.setF2fEnabled(this.settings.isKflF2fEnabled());
        this.sorter.setMissingEnabled(this.settings.isKflMissingEnabled());
        int errors = this.sorter.run(this.parent.getResults());
        out.startTag("table");
        out.writeAttr("border", 1);
        out.startTag("tr");
        out.writeTH(i18n.getString("kfl.changes.hdr"), "row");
        out.writeTH(i18n.getString("kfl.tests.hdr", Integer.toString(errors)), "row");
        if (this.settings.isKflTestCasesEnabled()) {
            out.writeTH(i18n.getString("kfl.tc.hdr", Integer.toString(this.sorter.getTestCasesErrorCount())), "row");
        }
        out.startTag("tr");
        out.writeTH(i18n.getString("kfl.f2p.summary"), "row");
        out.startTag("td");
        out.writeLink(FAIL2PASS, Integer.toString(this.sorter.getSet(KflSorter.Transitions.FAIL2PASS).size()));
        out.endTag("td");
        if (this.settings.isKflTestCasesEnabled()) {
            out.startTag("td");
            out.writeLink(TC_FAIL2PASS, Integer.toString(this.sorter.getSet(KflSorter.Transitions.TC_FAIL2PASS).size()));
            out.endTag("td");
        }
        if (this.settings.isKflF2eEnabled()) {
            out.startTag("tr");
            out.writeTH(i18n.getString("kfl.f2e.summary"), "row");
            out.startTag("td");
            out.writeLink(FAIL2ERROR, Integer.toString(this.sorter.getSet(KflSorter.Transitions.FAIL2ERROR).size()));
            out.endTag("td");
            if (this.settings.isKflTestCasesEnabled()) {
                out.startTag("td");
                out.writeLink(TC_FAIL2ERROR, Integer.toString(this.sorter.getSet(KflSorter.Transitions.TC_FAIL2ERROR).size()));
                out.endTag("td");
            }
        }
        out.startTag("tr");
        out.writeTH(i18n.getString("kfl.f2nr.summary"), "row");
        out.startTag("td");
        out.writeLink(FAIL2NOTRUN, Integer.toString(this.sorter.getSet(KflSorter.Transitions.FAIL2NOTRUN).size()));
        out.endTag("td");
        if (this.settings.isKflTestCasesEnabled()) {
            out.startTag("td");
            out.writeLink(TC_FAIL2NOTRUN, Integer.toString(this.sorter.getSet(KflSorter.Transitions.TC_FAIL2NOTRUN).size()));
            out.endTag("td");
        }
        if (this.settings.isKflMissingEnabled()) {
            out.startTag("tr");
            out.writeTH(i18n.getString("kfl.f2m.summary"), "row");
            out.startTag("td");
            out.writeLink(FAIL2MISSING, Integer.toString(this.sorter.getSet(KflSorter.Transitions.FAIL2MISSING).size()));
            out.endTag("td");
            if (this.settings.isKflTestCasesEnabled()) {
                out.startTag("td");
                out.writeLink(TC_FAIL2MISSING, Integer.toString(this.sorter.getSet(KflSorter.Transitions.TC_FAIL2MISSING).size()));
                out.endTag("td");
            }
        }
        out.startTag("tr");
        out.writeTH(i18n.getString("kfl.new.summary"), "row");
        out.startTag("td");
        out.writeLink(NEWFAILURES, Integer.toString(this.sorter.getSet(KflSorter.Transitions.NEWFAILURES).size()));
        out.endTag("td");
        if (this.settings.isKflTestCasesEnabled()) {
            out.startTag("td");
            out.writeLink(TC_NEWFAILURES, Integer.toString(this.sorter.getSet(KflSorter.Transitions.TC_NEWFAILURES).size()));
            out.endTag("td");
        }
        out.endTag("tr");
        if (this.settings.isKflF2fEnabled()) {
            out.startTag("tr");
            out.writeTH(i18n.getString("kfl.f2f.summary"), "row");
            out.startTag("td");
            out.writeLink(FAIL2FAIL, Integer.toString(this.sorter.getSet(KflSorter.Transitions.FAIL2FAIL).size()));
            out.endTag("td");
            if (this.settings.isKflTestCasesEnabled()) {
                out.startTag("td");
                out.write(i18n.getString("kfl.f2f.notc"));
                out.endTag("td");
            }
        }
        out.endTag("table");
    }

    @Override
    void writeExtraFiles() throws IOException {
        if (this.kfl == null || this.sorter == null) {
            return;
        }
        this.writeSet(FAIL2MISSING, "kfl.f2m", this.sorter.getSet(KflSorter.Transitions.FAIL2MISSING));
        this.writeSet(FAIL2PASS, "kfl.f2p", this.sorter.getSet(KflSorter.Transitions.FAIL2PASS));
        this.writeSet(FAIL2ERROR, "kfl.f2e", this.sorter.getSet(KflSorter.Transitions.FAIL2ERROR));
        this.writeSet(FAIL2NOTRUN, "kfl.f2nr", this.sorter.getSet(KflSorter.Transitions.FAIL2NOTRUN));
        this.writeSet(FAIL2FAIL, "kfl.f2f", this.sorter.getSet(KflSorter.Transitions.FAIL2FAIL));
        this.writeSet(NEWFAILURES, "kfl.new", this.sorter.getSet(KflSorter.Transitions.NEWFAILURES));
        if (this.settings.isKflTestCasesEnabled()) {
            this.writeSet(TC_FAIL2MISSING, "kfl.tc_f2m", this.sorter.getSet(KflSorter.Transitions.TC_FAIL2MISSING));
            this.writeSet(TC_FAIL2PASS, "kfl.tc_f2p", this.sorter.getSet(KflSorter.Transitions.TC_FAIL2PASS));
            this.writeSet(TC_FAIL2ERROR, "kfl.tc_f2e", this.sorter.getSet(KflSorter.Transitions.TC_FAIL2ERROR));
            this.writeSet(TC_FAIL2NOTRUN, "kfl.tc_f2nr", this.sorter.getSet(KflSorter.Transitions.TC_FAIL2NOTRUN));
            this.writeSet(TC_NEWFAILURES, "kfl.tc_new", this.sorter.getSet(KflSorter.Transitions.TC_NEWFAILURES));
        }
    }

    void writeSet(String file, String prefix, SortedSet<KflSorter.TestDiff> tests) throws IOException {
        ReportWriter out = new ReportWriter(this.openWriter(file), i18n.getString(prefix + ".title"), i18n);
        out.write(i18n.getString(prefix + ".notes"));
        out.startTag("p");
        if (tests == null || tests.size() == 0) {
            out.write(i18n.getString("kfl.noItemsInSet"));
            out.newLine();
            out.close();
            return;
        }
        out.startTag("table");
        out.writeAttr("border", "1");
        out.startTag("tr");
        out.startTag("th");
        out.write(i18n.getString("kfl.table.bugs.txt"));
        out.endTag("th");
        out.startTag("th");
        out.write(i18n.getString("kfl.table.URL.txt"));
        out.endTag("th");
        out.endTag("tr");
        for (KflSorter.TestDiff diff : tests) {
            TestResult tr = diff.getTestResult();
            out.startTag("tr");
            out.startTag("td");
            this.writeBugs(diff, out);
            out.newLine();
            out.endTag("td");
            out.startTag("td");
            if (tr != null && tr.isReloadable()) {
                String eWRPath = tr.getWorkRelativePath();
                File eFile = new File(this.workDirRoot, eWRPath.replace('/', File.separatorChar));
                out.writeLink(eFile, diff.getName());
            } else {
                out.write(diff.getName());
            }
            out.endTag("td");
            out.endTag("tr");
        }
        out.endTag("table");
        out.close();
    }

    void writeBugs(KflSorter.TestDiff diff, ReportWriter writer) throws IOException {
        KnownFailuresList.Entry[] e = null;
        if (diff.getTestCase() == null) {
            e = this.kfl.find(diff.getTestName());
        } else {
            KnownFailuresList.Entry ee = this.kfl.find(diff.getTestName(), diff.getTestCase());
            if (ee != null) {
                e = new KnownFailuresList.Entry[]{ee};
            }
        }
        if (e == null || e.length == 0) {
            if (diff.getKflEntry() != null) {
                e = new KnownFailuresList.Entry[]{diff.getKflEntry()};
            } else {
                return;
            }
        }
        String urlPrefix = Preferences.access().getPreference("exec.report.bugurl", null);
        HashSet<String> hs = new HashSet<String>();
        for (int i = 0; i < e.length; ++i) {
            String[] bugs = e[i].getBugIdStrings();
            if (bugs == null || bugs.length == 0) {
                return;
            }
            for (int j = 0; j < bugs.length; ++j) {
                if (bugs[j].equals("0000000") || bugs[j].equals("0") || hs.contains(bugs[j])) continue;
                hs.add(bugs[j]);
                if (urlPrefix != null && urlPrefix.length() > 0) {
                    writer.writeLink(urlPrefix + bugs[j], bugs[j]);
                    writer.newLine();
                } else {
                    writer.write(bugs[j]);
                    writer.newLine();
                }
                if (bugs.length == j + 1) continue;
                writer.write(",");
            }
        }
        writer.newLine();
    }

    Writer openWriter(String file) throws IOException {
        return new BufferedWriter(new FileWriter(new File(this.reportDir, file)));
    }
}

