/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.util;

import java.util.Vector;

public class Timer {
    private static int threadInitNumber;
    private Vector entries = new Vector();
    private boolean acceptingRequests = true;

    public Timer() {
        Thread t = new Thread(){

            public void run() {
                try {
                    Entry e;
                    while ((e = Timer.this.getNextEntry()) != null) {
                        e.obj.timeout();
                        e = null;
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        t.setName("Timer" + Timer.nextThreadNum());
        t.setDaemon(true);
        t.start();
    }

    private static synchronized int nextThreadNum() {
        return threadInitNumber++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Entry requestDelayedCallback(Timeable obj, long delay) {
        try {
            long absCallbackTime = System.currentTimeMillis() + delay;
            Entry e = new Entry(obj, absCallbackTime);
            for (int i = 0; i < this.entries.size(); ++i) {
                Entry ee = (Entry)this.entries.elementAt(i);
                if (e.expiration >= ee.expiration) continue;
                this.entries.insertElementAt(e, i);
                Entry entry = e;
                return entry;
            }
            this.entries.addElement(e);
            Entry entry = e;
            return entry;
        }
        finally {
            this.notify();
        }
    }

    public synchronized void cancel(Entry e) {
        this.entries.removeElement(e);
        this.notify();
    }

    public synchronized void finished() {
        this.acceptingRequests = false;
        this.notify();
    }

    private synchronized Entry getNextEntry() throws InterruptedException {
        while (this.acceptingRequests) {
            if (this.entries.size() == 0) {
                this.wait();
                continue;
            }
            long now = System.currentTimeMillis();
            Entry e = (Entry)this.entries.elementAt(0);
            if (e.expiration <= now) {
                this.entries.removeElementAt(0);
                return e;
            }
            this.wait(e.expiration - now);
            long l = System.currentTimeMillis();
        }
        return null;
    }

    public class Entry {
        Timeable obj;
        long expiration;

        Entry(Timeable obj, long expiration) {
            this.obj = obj;
            this.expiration = expiration;
        }
    }

    public static interface Timeable {
        public void timeout();
    }
}

