/*
 * Decompiled with CFR 0.152.
 */
package com.sun.demots.tests.bignum;

import com.sun.demoapi.BigNum;
import com.sun.javatest.Status;
import com.sun.javatest.Test;
import java.io.PrintWriter;

public class EqualsTest
implements Test {
    private PrintWriter err;

    public static void main(String[] args) {
        PrintWriter err = new PrintWriter(System.err, true);
        EqualsTest t = new EqualsTest();
        Status s = t.run(args, null, err);
        s.exit();
    }

    public Status run(String[] args, PrintWriter out, PrintWriter err) {
        this.err = err;
        boolean ok = true;
        ok &= this.test("-12345678901234567890", "-12345678901234567891");
        ok &= this.test("-12345678901234567890", "-12345678901234567890");
        ok &= this.test("-12345678901234567890", "-12345678901234567889");
        ok &= this.test("-12345678901234567890", "-1234567890");
        ok &= this.test("-12345678901234567890", "-123");
        ok &= this.test("-12345678901234567890", "0");
        ok &= this.test("-12345678901234567890", "123");
        ok &= this.test("-12345678901234567890", "1234567890");
        ok &= this.test("-12345678901234567890", "12345678901234567890");
        ok &= this.test("-1234567890", "-12345678901234567890");
        ok &= this.test("-1234567890", "-1234567891");
        ok &= this.test("-1234567890", "-1234567890");
        ok &= this.test("-1234567890", "-1234567889");
        ok &= this.test("-1234567890", "-123");
        ok &= this.test("-1234567890", "0");
        ok &= this.test("-1234567890", "123");
        ok &= this.test("-1234567890", "1234567890");
        ok &= this.test("-1234567890", "12345678901234567890");
        ok &= this.test("-123", "-12345678901234567890");
        ok &= this.test("-123", "-1234567890");
        ok &= this.test("-123", "-124");
        ok &= this.test("-123", "-123");
        ok &= this.test("-123", "-122");
        ok &= this.test("-123", "0");
        ok &= this.test("-123", "123");
        ok &= this.test("-123", "1234567890");
        ok &= this.test("-123", "12345678901234567890");
        ok &= this.test("0", "-12345678901234567890");
        ok &= this.test("0", "-1234567890");
        ok &= this.test("0", "-123");
        ok &= this.test("0", "-1");
        ok &= this.test("0", "0");
        ok &= this.test("0", "1");
        ok &= this.test("0", "123");
        ok &= this.test("0", "1234567890");
        ok &= this.test("0", "12345678901234567890");
        ok &= this.test("123", "-12345678901234567890");
        ok &= this.test("123", "-1234567890");
        ok &= this.test("123", "-123");
        ok &= this.test("123", "0");
        ok &= this.test("123", "122");
        ok &= this.test("123", "123");
        ok &= this.test("123", "124");
        ok &= this.test("123", "1234567890");
        ok &= this.test("123", "12345678901234567890");
        ok &= this.test("1234567890", "-12345678901234567890");
        ok &= this.test("1234567890", "-1234567890");
        ok &= this.test("1234567890", "-123");
        ok &= this.test("1234567890", "0");
        ok &= this.test("1234567890", "123");
        ok &= this.test("1234567890", "1234567889");
        ok &= this.test("1234567890", "1234567890");
        ok &= this.test("1234567890", "1234567891");
        ok &= this.test("1234567890", "12345678901234567890");
        ok &= this.test("12345678901234567890", "-12345678901234567890");
        ok &= this.test("12345678901234567890", "-1234567890");
        ok &= this.test("12345678901234567890", "-123");
        ok &= this.test("12345678901234567890", "0");
        ok &= this.test("12345678901234567890", "123");
        ok &= this.test("12345678901234567890", "1234567890");
        ok &= this.test("12345678901234567890", "12345678901234567889");
        ok &= this.test("12345678901234567890", "12345678901234567890");
        if (ok &= this.test("12345678901234567890", "12345678901234567891")) {
            return Status.passed((String)"OK");
        }
        return Status.failed((String)"one or more test cases failed");
    }

    boolean test(String s1, String s2) {
        boolean expectedResult;
        BigNum bn1 = new BigNum(s1);
        BigNum bn2 = new BigNum(s2);
        boolean actualResult = bn1.equals((Object)bn2);
        if (actualResult == (expectedResult = s1.equals(s2))) {
            return true;
        }
        this.err.println("s1: " + s1 + " s2: " + s2 + " expected result: " + expectedResult + " actual result: " + actualResult);
        return false;
    }
}

