/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview;

import com.sun.interview.Checklist;
import com.sun.interview.ErrorQuestion;
import com.sun.interview.FinalQuestion;
import com.sun.interview.InterviewQuestion;
import com.sun.interview.ListQuestion;
import com.sun.interview.NullQuestion;
import com.sun.interview.Question;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.help.HelpSet;
import javax.help.HelpSetException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Interview {
    public static final int EXPORT_IGNORE_ALL_EXCEPTIONS = 0;
    public static final int EXPORT_IGNORE_RUNTIME_EXCEPTIONS = 1;
    public static final int EXPORT_IGNORE_NO_EXCEPTIONS = 2;
    private static final int EXPORT_NUM_IGNORE_POLICIES = 3;
    private int exportIgnoreExceptionPolicy = 1;
    private Observer[] observers = new Observer[0];
    private static final Object[] empty = new Object[0];
    private final Interview parent;
    private final Interview root;
    private String baseTag;
    private String tag;
    private String title;
    private Question firstQuestion;
    private Vector children = new Vector();
    private Map allQuestions = new LinkedHashMap();
    private URL defaultImage;
    private String helpSetName;
    private HelpSet helpSet;
    private String bundleName;
    private ResourceBundle bundle;
    private Path path;
    private Path rawPath;
    private ArrayList<Question> hiddenPath;
    private int currIndex;
    private InterviewQuestion caller;
    private boolean updateEnabled;
    private boolean edited;
    private Map allMarkers;
    private HashMap<String, String> extraValues;
    private HashMap<String, String> templateValues;
    private int semantics = 0;
    static final ResourceBundle i18n = ResourceBundle.getBundle("com.sun.interview.i18n");
    public static final int SEMANTIC_PRE_32 = 0;
    public static final int SEMANTIC_VERSION_32 = 1;
    public static final int SEMANTIC_VERSION_43 = 2;
    public static final int SEMANTIC_MAX_VERSION = 2;
    protected static final String QUESTION = "QUESTION";
    protected static final String INTERVIEW = "INTERVIEW";
    protected static final String LOCALE = "LOCALE";
    protected static final String CHECKSUM = "CHECKSUM";
    protected static final String MARKERS = "MARKERS";
    protected static final String MARKERS_PREF = "MARKERS.";
    protected static final String EXTERNAL_PREF = "EXTERNAL.";
    protected static final String TEMPLATE_PREF = "TEMPLATE.";

    protected Interview(String tag) {
        this(null, tag);
    }

    protected Interview(Interview parent, String baseTag) {
        this.parent = parent;
        this.setBaseTag(baseTag);
        if (parent == null) {
            this.root = this;
        } else {
            parent.add(this);
            this.root = parent.root;
            this.semantics = parent.getInterviewSemantics();
        }
    }

    public Interview getParent() {
        return this.parent;
    }

    public String getTag() {
        return this.tag;
    }

    protected void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        if (this.title == null) {
            String titleKey = "title";
            this.title = this.getI18NString(titleKey).trim();
        }
        return this.title;
    }

    protected void setDefaultImage(URL u) {
        this.defaultImage = u;
    }

    public URL getDefaultImage() {
        if (this.defaultImage == null && this.parent != null) {
            return this.parent.getDefaultImage();
        }
        return this.defaultImage;
    }

    protected void setResourceBundle(String name) throws MissingResourceException {
        if (name != this.bundleName) {
            if (name != null) {
                String rn;
                Class<?> c = this.getClass();
                ClassLoader cl = c.getClassLoader();
                if (name.startsWith("/")) {
                    rn = name.substring(1);
                } else {
                    String cn = c.getName();
                    String pn = cn.substring(0, cn.lastIndexOf(46));
                    rn = pn + "." + name;
                }
                this.bundle = ResourceBundle.getBundle(rn, Locale.getDefault(), cl);
            }
            this.bundleName = name;
        }
    }

    protected void setResourceBundle(String name, File file) throws MissingResourceException {
        if (name == this.bundleName) {
            return;
        }
        try {
            URL[] url = new URL[]{new URL("file:" + file.getAbsolutePath() + "/")};
            URLClassLoader cl = new URLClassLoader(url);
            this.bundle = ResourceBundle.getBundle(name, Locale.getDefault(), cl);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public ResourceBundle getResourceBundle() {
        if (this.bundle == null && this.parent != null) {
            return this.parent.getResourceBundle();
        }
        return this.bundle;
    }

    protected void setHelpSet(String name) throws HelpNotFoundFault, BadHelpFault {
        try {
            String hsn;
            Class<?> c = this.getClass();
            ClassLoader cl = c.getClassLoader();
            if (name.startsWith("/")) {
                hsn = name.substring(1);
            } else {
                String cn = c.getName();
                String pn = cn.substring(0, cn.lastIndexOf(46));
                hsn = pn.replace('.', '/') + "/" + name;
            }
            URL u = HelpSet.findHelpSet(cl, hsn);
            if (u == null) {
                throw new HelpNotFoundFault(i18n, "interview.cantFindHelp", hsn);
            }
            HelpSet hs = new HelpSet(cl, u);
            this.setHelpSet(hs);
        }
        catch (HelpSetException e) {
            throw new BadHelpFault(i18n, "interview.badHelp", e);
        }
    }

    protected void setHelpSet(HelpSet hs) {
        if (this.parent == null) {
            if (this.helpSet == null) {
                for (Interview i : this.getInterviews()) {
                    HelpSet ihs = i.getHelpSet();
                    if (ihs == null) continue;
                    hs.add(ihs);
                }
            } else {
                ArrayList<HelpSet> helpSetsToRemove = new ArrayList<HelpSet>();
                Enumeration e = this.helpSet.getHelpSets();
                while (e.hasMoreElements()) {
                    HelpSet entry = (HelpSet)e.nextElement();
                    helpSetsToRemove.add(entry);
                    hs.add(entry);
                }
                for (HelpSet helpToRemove : helpSetsToRemove) {
                    this.helpSet.remove(helpToRemove);
                }
            }
        } else {
            Interview i = this;
            while (i.parent != null) {
                i = i.parent;
            }
            HelpSet rootHelpSet = i.helpSet;
            if (rootHelpSet != null) {
                if (this.helpSet != null) {
                    rootHelpSet.remove(this.helpSet);
                }
                rootHelpSet.add(hs);
            }
        }
        this.helpSet = hs;
    }

    protected void setHelpSet(String name, File file) throws HelpNotFoundFault, BadHelpFault {
        try {
            URL[] urls = new URL[]{new URL("file:" + file.getAbsolutePath() + "/")};
            URLClassLoader cl = new URLClassLoader(urls);
            URL url = HelpSet.findHelpSet(cl, name);
            if (url == null) {
                throw new HelpNotFoundFault(i18n, "interview.cantFindHelp", file.getPath());
            }
            HelpSet helpset = new HelpSet(cl, url);
            this.setHelpSet(helpset);
        }
        catch (HelpSetException helpsetexception) {
            throw new BadHelpFault(i18n, "interview.badHelp", helpsetexception);
        }
        catch (MalformedURLException e) {
            throw new HelpNotFoundFault(i18n, "interview.cantFindHelp", file.getPath());
        }
    }

    public HelpSet getHelpSet() {
        if (this.helpSet == null && this.parent != null) {
            return this.parent.getHelpSet();
        }
        return this.helpSet;
    }

    public void setEdited(boolean edited) {
        Interview i = this;
        while (i.parent != null) {
            i = i.parent;
        }
        i.edited = edited;
    }

    public boolean isEdited() {
        Interview i = this;
        while (i.parent != null) {
            i = i.parent;
        }
        return i.edited;
    }

    public Question getFirstQuestion() {
        return this.firstQuestion;
    }

    protected void setFirstQuestion(Question q) {
        if (this.path != null) {
            throw new IllegalStateException();
        }
        this.firstQuestion = q;
    }

    public Interview getInterview(String tag) throws Fault {
        if (tag == null) {
            throw new NullPointerException();
        }
        Interview i = this.getInterview0(tag);
        if (i != null) {
            return i;
        }
        throw new Fault(i18n, "interview.cantFindInterview", tag);
    }

    private Interview getInterview0(String t) {
        if (t.equals(this.tag)) {
            return this;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            Interview c = (Interview)this.children.elementAt(i);
            Interview iv = c.getInterview0(t);
            if (iv == null) continue;
            return iv;
        }
        return null;
    }

    private Set getInterviews() {
        HashSet s = new HashSet();
        this.getInterviews0(s);
        return s;
    }

    private void getInterviews0(Set s) {
        s.add(this);
        for (int i = 0; i < this.children.size(); ++i) {
            Interview child = (Interview)this.children.elementAt(i);
            child.getInterviews0(s);
        }
    }

    public boolean isFirst(Question q) {
        return q == this.firstQuestion;
    }

    public boolean isLast(Question q) {
        return q instanceof FinalQuestion && q.interview.caller == null;
    }

    public boolean hasNext(Question q) {
        return q.getNext() != null;
    }

    public boolean hasValidNext(Question q) {
        Question qn = q.getNext();
        return qn != null && !(qn instanceof ErrorQuestion);
    }

    public void reset() {
        this.ensurePathInitialized();
        this.updateEnabled = true;
        this.caller = null;
        this.currIndex = 0;
        this.path.clear();
        this.path.addQuestion(this.firstQuestion);
        if (this.root == this) {
            this.rawPath.clear();
            this.rawPath.addQuestion(this.firstQuestion);
        }
        this.hiddenPath.clear();
        this.updatePath(this.firstQuestion);
        this.notifyCurrentQuestionChanged(this.firstQuestion);
    }

    private void reset(Question q) {
        this.ensurePathInitialized();
        this.updateEnabled = true;
        this.caller = null;
        this.currIndex = 0;
        this.path.clear();
        this.hiddenPath.clear();
        if (this.root == this) {
            this.rawPath.clear();
            this.rawPath.addQuestion(this.firstQuestion);
        }
        this.path.addQuestion(this.firstQuestion);
        this.updatePath(this.firstQuestion);
        if (q == this.firstQuestion || q == null) {
            this.notifyCurrentQuestionChanged(this.firstQuestion);
        } else {
            try {
                this.setCurrentQuestion(q);
            }
            catch (Fault e) {
                this.notifyCurrentQuestionChanged(this.firstQuestion);
            }
        }
    }

    public void next() throws Fault {
        Question q;
        this.ensurePathInitialized();
        Interview i = this;
        while (i.path.questionAt(i.currIndex) instanceof InterviewQuestion) {
            InterviewQuestion iq = (InterviewQuestion)i.path.questionAt(i.currIndex);
            i = iq.getTargetInterview();
        }
        ++i.currIndex;
        while (true) {
            if (i.currIndex == i.path.size()) {
                --i.currIndex;
                throw new Fault(i18n, "interview.noMoreQuestions");
            }
            q = i.path.questionAt(i.currIndex);
            if (q instanceof InterviewQuestion) {
                InterviewQuestion iq = (InterviewQuestion)q;
                i = iq.getTargetInterview();
                i.currIndex = 0;
                continue;
            }
            if (!(q instanceof FinalQuestion) || i.caller == null) break;
            i = i.caller.getInterview();
            ++i.currIndex;
        }
        q = i.path.questionAt(i.currIndex);
        this.notifyCurrentQuestionChanged(q);
    }

    public void prev() throws Fault {
        InterviewQuestion iq;
        this.ensurePathInitialized();
        Interview i = this;
        while (i.path.questionAt(i.currIndex) instanceof InterviewQuestion) {
            iq = (InterviewQuestion)i.path.questionAt(i.currIndex);
            i = iq.getTargetInterview();
        }
        --i.currIndex;
        while (true) {
            if (i.currIndex < 0) {
                if (i.caller == null) {
                    i.currIndex = 0;
                    throw new Fault(i18n, "interview.noMoreQuestions");
                }
                i = i.caller.getInterview();
                --i.currIndex;
                continue;
            }
            if (i.path.questionAt(i.currIndex) instanceof InterviewQuestion) {
                iq = (InterviewQuestion)i.path.questionAt(i.currIndex);
                i = iq.getTargetInterview();
                i.currIndex = i.path.size() - 1;
                continue;
            }
            if (!(i.path.questionAt(i.currIndex) instanceof FinalQuestion)) break;
            --i.currIndex;
        }
        Question q = i.path.questionAt(i.currIndex);
        this.notifyCurrentQuestionChanged(q);
    }

    public void last() throws Fault {
        Question cq;
        this.ensurePathInitialized();
        Interview i = this;
        while (i.path.questionAt(i.currIndex) instanceof InterviewQuestion) {
            InterviewQuestion iq = (InterviewQuestion)i.path.questionAt(i.currIndex);
            i = iq.getTargetInterview();
        }
        int index = i.currIndex;
        Question lq = cq = i.path.questionAt(index);
        ++index;
        while (index < i.path.size()) {
            Question q = i.path.questionAt(index);
            if (q instanceof InterviewQuestion) {
                i = ((InterviewQuestion)q).getTargetInterview();
                index = 0;
                continue;
            }
            if (q instanceof FinalQuestion && i.caller != null) {
                Interview callInterview = i.caller.getInterview();
                int callIndex = callInterview.path.indexOf(i);
                if (callIndex == -1) {
                    throw new IllegalStateException();
                }
                i = callInterview;
                index = callIndex + 1;
                continue;
            }
            lq = q;
            ++index;
        }
        if (lq == cq) {
            if (!(lq instanceof FinalQuestion)) {
                throw new Fault(i18n, "interview.noMoreQuestions");
            }
        } else {
            this.setCurrentQuestion(lq);
        }
    }

    public boolean isStarted() {
        Question[] path = this.root.getPath();
        for (int i = 0; i < path.length - 1; ++i) {
            Question q = path[i];
            if (q instanceof NullQuestion) continue;
            return true;
        }
        return false;
    }

    public boolean isFinishable() {
        this.ensurePathInitialized();
        Interview i = this.root;
        return i.path.lastQuestion() instanceof FinalQuestion;
    }

    protected boolean isInterviewFinishable() {
        return this.path != null && this.path.lastQuestion() instanceof FinalQuestion;
    }

    public void setCurrentQuestion(Question q) throws Fault {
        if (q == null) {
            throw new NullPointerException();
        }
        if (q == this.getCurrentQuestion()) {
            return;
        }
        boolean ok = this.root.setCurrentQuestion0(q);
        if (!ok) {
            throw new NotOnPathFault(q);
        }
        this.notifyCurrentQuestionChanged(q);
    }

    private boolean setCurrentQuestion0(Question q) {
        this.ensurePathInitialized();
        for (int i = 0; i < this.path.size(); ++i) {
            Question qq = this.path.questionAt(i);
            if (qq.equals(q)) {
                this.currIndex = i;
                return true;
            }
            if (!(qq instanceof InterviewQuestion) || !((InterviewQuestion)qq).getTargetInterview().setCurrentQuestion0(q)) continue;
            this.currIndex = i;
            return true;
        }
        return false;
    }

    public Question getCurrentQuestion() {
        this.ensurePathInitialized();
        Interview i = this.root;
        Question q = i.path.questionAt(i.currIndex);
        while (q instanceof InterviewQuestion) {
            i = ((InterviewQuestion)q).getTargetInterview();
            q = i.path.questionAt(i.currIndex);
        }
        return q;
    }

    private void setCurrentQuestionFromPath(Question[] path) {
        this.root.setCurrentQuestionFromPath0(path);
    }

    private void setCurrentQuestionFromPath0(Question[] path) {
        for (int i = path.length - 1; i >= 0; --i) {
            if (!this.setCurrentQuestion0(path[i])) continue;
            this.notifyCurrentQuestionChanged(path[i]);
            return;
        }
    }

    public Question[] getPath() {
        Vector v = new Vector();
        this.iteratePath0(v, true, true, true);
        Object[] p = new Question[v.size()];
        v.copyInto(p);
        return p;
    }

    public Question[] getPathToCurrent() {
        Vector v = new Vector();
        this.iteratePath0(v, true, false, true);
        Object[] p = new Question[v.size()];
        v.copyInto(p);
        return p;
    }

    public Question[] getRawPath(boolean includeFinals) {
        if (this.rawPath == null) {
            return null;
        }
        return this.rawPath.getQuestions();
    }

    public Iterator iteratePath(boolean flattenNestedInterviews) {
        Vector v = new Vector();
        this.iteratePath0(v, flattenNestedInterviews, true, true);
        return v.iterator();
    }

    public Iterator iteratePathToCurrent(boolean flattenNestedInterviews) {
        Vector v = new Vector();
        this.iteratePath0(v, flattenNestedInterviews, false, true);
        return v.iterator();
    }

    private void iteratePath0(List l, boolean flattenNestedInterviews, boolean all, boolean addFinal) {
        this.ensurePathInitialized();
        int n = all ? this.path.size() : this.currIndex + 1;
        for (int i = 0; i < n; ++i) {
            Question q = this.path.questionAt(i);
            if (q instanceof InterviewQuestion) {
                if (flattenNestedInterviews) {
                    ((InterviewQuestion)q).getTargetInterview().iteratePath0(l, true, all, false);
                    continue;
                }
                l.add(q);
                continue;
            }
            if (!addFinal && q instanceof FinalQuestion) {
                return;
            }
            l.add(q);
        }
    }

    public void verifyPathContains(Question q) throws NotOnPathFault {
        if (!this.pathContains(q)) {
            throw new NotOnPathFault(q);
        }
    }

    public boolean pathContains(Question q) {
        return this.root.pathContains0(q);
    }

    public boolean pathContains(Interview i) {
        return this.root.pathContains0(i);
    }

    private boolean pathContains0(Object o) {
        this.ensurePathInitialized();
        for (int index = 0; index < this.path.size(); ++index) {
            Question q = this.path.questionAt(index);
            if (o == q) {
                return true;
            }
            if (!(q instanceof InterviewQuestion)) continue;
            InterviewQuestion iq = (InterviewQuestion)q;
            Interview i = iq.getTargetInterview();
            if (o == i) {
                return true;
            }
            if (!i.pathContains0(o)) continue;
            return true;
        }
        return false;
    }

    public Set getQuestions() {
        HashSet s = new HashSet();
        this.getQuestions0(s);
        return s;
    }

    private void getQuestions0(Set s) {
        s.addAll(this.allQuestions.values());
        for (int i = 0; i < this.children.size(); ++i) {
            Interview child = (Interview)this.children.elementAt(i);
            child.getQuestions0(s);
        }
    }

    public Map getAllQuestions() {
        LinkedHashMap m = new LinkedHashMap();
        this.getAllQuestions0(m);
        return m;
    }

    private void getAllQuestions0(Map m) {
        m.putAll(this.allQuestions);
        for (int i = 0; i < this.children.size(); ++i) {
            Interview child = (Interview)this.children.elementAt(i);
            child.getAllQuestions0(m);
        }
    }

    public boolean isChecklistEmpty() {
        Iterator iter = this.iteratePath(true);
        while (iter.hasNext()) {
            Question q = (Question)iter.next();
            Checklist.Item[] items = q.getChecklistItems();
            if (items == null || items.length <= 0) continue;
            return false;
        }
        return true;
    }

    public Checklist createChecklist() {
        Checklist c = new Checklist();
        Iterator iter = this.iteratePath(true);
        while (iter.hasNext()) {
            Question q = (Question)iter.next();
            Checklist.Item[] items = q.getChecklistItems();
            if (items == null) continue;
            for (int i = 0; i < items.length; ++i) {
                c.add(items[i]);
            }
        }
        return c;
    }

    public Checklist.Item createChecklistItem(String sectionKey, String textKey) {
        String section = this.getI18NString(sectionKey);
        String text = this.getI18NString(textKey);
        return new Checklist.Item(section, text);
    }

    public Checklist.Item createChecklistItem(String sectionKey, String textKey, Object textArg) {
        String section = this.getI18NString(sectionKey);
        String text = this.getI18NString(textKey, textArg);
        return new Checklist.Item(section, text);
    }

    public Checklist.Item createChecklistItem(String sectionKey, String textKey, Object[] textArgs) {
        String section = this.getI18NString(sectionKey);
        String text = this.getI18NString(textKey, textArgs);
        return new Checklist.Item(section, text);
    }

    void addMarker(Question q, String name) {
        HashSet<Question> markersForName;
        if (this.root != this) {
            this.root.addMarker(q, name);
            return;
        }
        if (q == null) {
            throw new NullPointerException();
        }
        if (this.allMarkers == null) {
            this.allMarkers = new HashMap();
        }
        if ((markersForName = (HashSet<Question>)this.allMarkers.get(name)) == null) {
            markersForName = new HashSet<Question>();
            this.allMarkers.put(name, markersForName);
        }
        markersForName.add(q);
    }

    void removeMarker(Question q, String name) {
        if (this.root != this) {
            this.root.removeMarker(q, name);
            return;
        }
        if (q == null) {
            throw new NullPointerException();
        }
        if (this.allMarkers == null) {
            return;
        }
        Set markersForName = (Set)this.allMarkers.get(name);
        if (markersForName == null) {
            return;
        }
        markersForName.remove(q);
        if (markersForName.size() == 0) {
            this.allMarkers.remove(name);
        }
    }

    boolean hasMarker(Question q, String name) {
        if (this.root != this) {
            return this.root.hasMarker(q, name);
        }
        if (q == null) {
            throw new NullPointerException();
        }
        if (this.allMarkers == null) {
            return false;
        }
        Set markersForName = (Set)this.allMarkers.get(name);
        if (markersForName == null) {
            return false;
        }
        return markersForName.contains(q);
    }

    public void removeMarkers(String name) {
        if (this.root != this) {
            this.root.removeMarkers(name);
            return;
        }
        if (this.allMarkers != null) {
            this.allMarkers.remove(name);
        }
    }

    public void removeAllMarkers() {
        if (this.root != this) {
            this.root.removeAllMarkers();
            return;
        }
        this.allMarkers = null;
    }

    public void clearMarkedResponses(String name) {
        if (this.root != this) {
            this.root.clearMarkedResponses(name);
            return;
        }
        if (this.allMarkers == null) {
            return;
        }
        Set markersForName = (Set)this.allMarkers.get(name);
        if (markersForName == null) {
            return;
        }
        this.updateEnabled = false;
        Question oldCurrentQuestion = this.getCurrentQuestion();
        for (Question q : markersForName) {
            q.clear();
        }
        this.updateEnabled = true;
        this.updatePath(this.firstQuestion);
        Question newCurrentQuestion = this.getCurrentQuestion();
        if (newCurrentQuestion != oldCurrentQuestion) {
            this.notifyCurrentQuestionChanged(newCurrentQuestion);
        }
    }

    private void loadMarkers(Map data) {
        String s = (String)data.get(MARKERS);
        int count = 0;
        if (s != null) {
            try {
                count = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        this.allMarkers = null;
        for (int i = 0; i < count; ++i) {
            String name = (String)data.get(MARKERS_PREF + i + ".name");
            String tags = (String)data.get(MARKERS_PREF + i);
            if (tags == null) continue;
            this.loadMarkers(name, tags);
        }
    }

    private void loadMarkers(String name, String tags) {
        int start = -1;
        for (int i = 0; i < tags.length(); ++i) {
            if (tags.charAt(i) == '\n') {
                if (start == -1) continue;
                String tag = tags.substring(start, i).trim();
                this.loadMarker(name, tag);
                start = -1;
                continue;
            }
            if (start != -1) continue;
            start = i;
        }
        if (start != -1) {
            String tag = tags.substring(start).trim();
            this.loadMarker(name, tag);
        }
    }

    private void loadMarker(String name, String tag) {
        Question q;
        if (tag.length() > 0 && (q = this.lookup(tag)) != null) {
            this.addMarker(q, name);
        }
    }

    private void saveMarkers(Map data) {
        if (this.allMarkers == null) {
            return;
        }
        int i = 0;
        for (Map.Entry e : this.allMarkers.entrySet()) {
            String name = (String)e.getKey();
            Set markersForName = (Set)e.getValue();
            if (name != null) {
                data.put(MARKERS_PREF + i + ".name", name);
            }
            StringBuffer sb = new StringBuffer();
            for (Question q : markersForName) {
                if (sb.length() > 0) {
                    sb.append('\n');
                }
                sb.append(q.getTag());
            }
            data.put(MARKERS_PREF + i, sb.toString());
            ++i;
        }
        if (i > 0) {
            data.put(MARKERS, String.valueOf(i));
        }
    }

    protected Question callInterview(Interview i, Question q) {
        return new InterviewQuestion(this, i, q);
    }

    public void clear() {
        this.updateEnabled = false;
        for (Question q : this.allQuestions.values()) {
            q.clear();
        }
        for (int i = 0; i < this.children.size(); ++i) {
            Interview child = (Interview)this.children.elementAt(i);
            child.clear();
        }
        if (this.parent == null) {
            this.extraValues = null;
            this.templateValues = null;
            this.reset();
        }
    }

    public void load(Map data) throws Fault {
        this.load(data, true);
    }

    public void load(Map data, boolean checkChecksum) throws Fault {
        if (checkChecksum && !Interview.isChecksumValid(data, true)) {
            throw new Fault(i18n, "interview.checksumError");
        }
        if (this.parent == null) {
            String iTag = (String)data.get(INTERVIEW);
            if (iTag != null && !iTag.equals(this.getClass().getName())) {
                throw new Fault(i18n, "interview.classMismatch");
            }
            this.loadExternalValues(data);
            this.loadTemplateValues(data);
        }
        this.updateEnabled = false;
        for (Question q : this.allQuestions.values()) {
            q.clear();
        }
        for (Question q : this.allQuestions.values()) {
            q.load(data);
        }
        for (int i = 0; i < this.children.size(); ++i) {
            Interview child = (Interview)this.children.elementAt(i);
            child.load(data, false);
        }
        if (this.parent == null) {
            Question q;
            String qTag = (String)data.get(QUESTION);
            q = qTag == null ? null : this.lookup(qTag);
            this.reset(q == null ? this.firstQuestion : q);
        }
        this.loadMarkers(data);
    }

    public static boolean isChecksumValid(Map data, boolean okIfOmitted) {
        try {
            String s = (String)data.get(CHECKSUM);
            if (s == null) {
                return okIfOmitted;
            }
            return Long.parseLong(s, 16) == Interview.computeChecksum(data);
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public void save(Map data) {
        if (this.parent == null) {
            Set<String> keys;
            data.put(INTERVIEW, this.getClass().getName());
            data.put(QUESTION, this.getCurrentQuestion().getTag());
            Interview.writeLocale(data);
            if (this.extraValues != null && this.extraValues.size() > 0) {
                keys = this.getPropertyKeys();
                for (Object e : keys) {
                    data.put(EXTERNAL_PREF + e, this.extraValues.get(e));
                }
            }
            if (this.templateValues != null && this.templateValues.size() > 0) {
                keys = this.templateValues.keySet();
                for (String string : keys) {
                    data.put(TEMPLATE_PREF + string, this.retrieveTemplateProperty(string));
                }
            }
        }
        for (Question q : this.allQuestions.values()) {
            try {
                q.save(data);
            }
            catch (RuntimeException runtimeException) {
                System.err.println("warning: " + runtimeException.toString());
                System.err.println("while saving value for question " + q.getTag() + " in interview " + this.getTag());
            }
        }
        for (int i = 0; i < this.children.size(); ++i) {
            Interview child = (Interview)this.children.elementAt(i);
            child.save(data);
        }
        this.saveMarkers(data);
        data.put(CHECKSUM, Long.toString(Interview.computeChecksum(data), 16));
    }

    protected static void writeLocale(Map data) {
        data.put(LOCALE, Locale.getDefault().toString());
    }

    protected static Locale readLocale(Map data) {
        Locale result = null;
        Object o = data.get(LOCALE);
        if (o != null) {
            if (o instanceof Locale) {
                result = (Locale)o;
            } else if (o instanceof String) {
                String s = ((String)o).trim();
                String language = "";
                String country = "";
                String variant = "";
                if (s.length() != 0) {
                    try {
                        int i = s.indexOf(95);
                        language = i == -1 ? s : (i == 0 ? "" : s.substring(0, i));
                        if (i < s.length() - 1) {
                            country = (i = (s = s.substring(i + 1)).indexOf(95)) == -1 ? s : (i == 0 ? "" : s.substring(0, i));
                            if (i < s.length() - 1) {
                                variant = s.substring(i + 1);
                            }
                        }
                        result = new Locale(language, country, variant);
                    }
                    catch (Exception e) {
                        result = null;
                    }
                }
            }
        }
        if (result == null) {
            result = Locale.getDefault();
        }
        return result;
    }

    private static long computeChecksum(Map data) {
        long cs = 0L;
        for (Map.Entry e : data.entrySet()) {
            String key = (String)e.getKey();
            String value = (String)e.getValue();
            if (key.equals(CHECKSUM)) continue;
            cs += Interview.computeChecksum(key) * Interview.computeChecksum(value);
        }
        return cs == Long.MIN_VALUE ? 0L : (cs < 0L ? -cs : cs);
    }

    private static long computeChecksum(String s) {
        if (s == null) {
            return 1L;
        }
        long cs = 0L;
        for (int i = 0; i < s.length(); ++i) {
            cs = cs * 37L + (long)s.charAt(i);
        }
        return cs;
    }

    public void export(Map data) {
        ArrayList<Question> path = new ArrayList<Question>();
        if (this.semantics >= 2) {
            this.iteratePath0(path, false, true, true);
        } else {
            this.iteratePath0(path, true, true, true);
        }
        this.export0(data, path, false);
        if (this.semantics >= 2 && this.hiddenPath != null) {
            this.export0(data, this.hiddenPath, true);
        }
    }

    private void export0(Map data, ArrayList<Question> path, boolean processHidden) {
        block11: for (int i = 0; i < path.size(); ++i) {
            try {
                if (path.get(i) instanceof InterviewQuestion) {
                    if (processHidden) continue;
                    ((InterviewQuestion)path.get(i)).getTargetInterview().export(data);
                    continue;
                }
                path.get(i).export(data);
                continue;
            }
            catch (RuntimeException e) {
                switch (this.exportIgnoreExceptionPolicy) {
                    case 0: 
                    case 1: {
                        break;
                    }
                    case 2: {
                        throw e;
                    }
                }
                continue;
            }
            catch (Error e) {
                switch (this.exportIgnoreExceptionPolicy) {
                    case 0: {
                        continue block11;
                    }
                    case 1: 
                    case 2: {
                        throw e;
                    }
                }
            }
        }
    }

    public int getExportIgnoreExceptionPolicy() {
        return this.exportIgnoreExceptionPolicy;
    }

    public void setExportIgnoreExceptionPolicy(int policy) {
        if (policy < 0 || policy >= 3) {
            throw new IllegalArgumentException();
        }
        this.exportIgnoreExceptionPolicy = policy;
    }

    public synchronized void addObserver(Observer o) {
        if (o == null) {
            throw new NullPointerException();
        }
        Observer[] newObs = new Observer[this.observers.length + 1];
        System.arraycopy(this.observers, 0, newObs, 0, this.observers.length);
        newObs[this.observers.length] = o;
        this.observers = newObs;
    }

    public synchronized void removeObserver(Observer o) {
        if (o == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < this.observers.length; ++i) {
            if (this.observers[i] != o) continue;
            Observer[] newObs = new Observer[this.observers.length - 1];
            System.arraycopy(this.observers, 0, newObs, 0, i);
            System.arraycopy(this.observers, i + 1, newObs, i, this.observers.length - i - 1);
            this.observers = newObs;
            return;
        }
    }

    public synchronized boolean containsObserver(Observer o) {
        if (o == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < this.observers.length; ++i) {
            if (this.observers[i] != o) continue;
            return true;
        }
        return false;
    }

    private void notifyCurrentQuestionChanged(Question q) {
        for (int i = 0; i < this.observers.length && q == this.getCurrentQuestion(); ++i) {
            this.observers[i].currentQuestionChanged(q);
        }
    }

    private void notifyPathUpdated() {
        for (int i = 0; i < this.observers.length; ++i) {
            this.observers[i].pathUpdated();
        }
    }

    protected void setBaseTag(String newBaseTag) {
        this.baseTag = newBaseTag;
        this.updateTags();
    }

    private void updateTags() {
        this.tag = this.parent == null || this.parent.tag == null ? this.baseTag : (this.baseTag == null ? this.parent.getTag() : this.parent.getTag() + "." + this.baseTag);
        LinkedHashMap<String, Question> newAllQuestions = new LinkedHashMap<String, Question>();
        for (Question q : this.allQuestions.values()) {
            q.updateTag();
            newAllQuestions.put(q.getTag(), q);
        }
        this.allQuestions = newAllQuestions;
        for (Interview i : this.children) {
            i.updateTags();
        }
    }

    void add(Interview child) {
        this.children.add(child);
    }

    void add(Question question) {
        String qTag = question.getTag();
        Question prev = this.allQuestions.put(qTag, question);
        if (prev != null) {
            throw new IllegalArgumentException("duplicate questions for tag: " + qTag);
        }
    }

    public void setInterviewSemantics(int value) {
        if (value <= 2) {
            this.semantics = value;
        }
    }

    public int getInterviewSemantics() {
        return this.semantics;
    }

    public String storeProperty(String key, String value) {
        if (this.getParent() != null) {
            return this.getParent().storeProperty(key, value);
        }
        if (value == null) {
            if (this.extraValues == null) {
                return null;
            }
            return this.extraValues.remove(key);
        }
        if (this.extraValues == null) {
            this.extraValues = new HashMap();
        }
        return this.extraValues.put(key, value);
    }

    public String storeTemplateProperty(String key, String value) {
        if (this.getParent() != null) {
            return this.getParent().storeTemplateProperty(key, value);
        }
        this.ensureTemValuesInitialized();
        return this.templateValues.put(key, value);
    }

    public void storeTemplateProperties(Properties props) {
        if (this.getParent() != null) {
            this.getParent().storeTemplateProperties(props);
        } else {
            this.ensureTemValuesInitialized();
            this.templateValues.clear();
            this.templateValues.putAll(props);
        }
    }

    public String retrieveProperty(String key) {
        if (this.getParent() != null) {
            return this.getParent().retrieveProperty(key);
        }
        if (this.extraValues == null) {
            return null;
        }
        return this.extraValues.get(key);
    }

    public String retrieveTemplateProperty(String key) {
        if (this.getParent() != null) {
            return this.getParent().retrieveTemplateProperty(key);
        }
        this.ensureTemValuesInitialized();
        return this.templateValues.get(key);
    }

    public Set retrieveTemplateKeys() {
        if (this.getParent() != null) {
            return this.getParent().retrieveTemplateKeys();
        }
        this.ensureTemValuesInitialized();
        return this.templateValues.keySet();
    }

    public Set getPropertyKeys() {
        if (this.getParent() != null) {
            return this.parent.getPropertyKeys();
        }
        if (this.extraValues == null || this.extraValues.size() == 0) {
            return null;
        }
        return this.extraValues.keySet();
    }

    public Map<String, String> getExternalProperties() {
        if (this.extraValues != null) {
            return (Map)this.extraValues.clone();
        }
        return null;
    }

    private void loadExternalValues(Map data) {
        if (this.extraValues != null) {
            this.extraValues.clear();
        }
        Set keys = data.keySet();
        for (String key : keys) {
            if (!key.startsWith(EXTERNAL_PREF)) continue;
            if (this.extraValues == null) {
                this.extraValues = new HashMap();
            }
            String val = (String)data.get(key);
            this.extraValues.put(key.substring(EXTERNAL_PREF.length()), val);
        }
    }

    private void loadTemplateValues(Map data) {
        if (this.templateValues != null) {
            this.templateValues.clear();
        }
        Set keys = data.keySet();
        for (String key : keys) {
            if (!key.startsWith(TEMPLATE_PREF)) continue;
            this.ensureTemValuesInitialized();
            String val = (String)data.get(key);
            this.templateValues.put(key.substring(TEMPLATE_PREF.length()), val);
        }
    }

    public void propagateTemplateForAll() {
        this.ensureTemValuesInitialized();
        for (Question q : this.getAllQuestions().values()) {
            q.load(this.templateValues);
        }
    }

    private void ensureTemValuesInitialized() {
        if (this.templateValues == null) {
            this.templateValues = new HashMap();
        }
    }

    private void ensurePathInitialized() {
        if (this.path == null) {
            this.path = new Path();
            this.hiddenPath = new ArrayList();
            if (this.parent == null) {
                this.rawPath = new Path();
            }
            this.reset();
        }
        if (this.parent == null && this.rawPath == null) {
            this.rawPath = new Path();
        }
    }

    private Question lookup(String tag) {
        Question q = (Question)this.allQuestions.get(tag);
        for (int i = 0; i < this.children.size() && q == null; ++i) {
            Interview child = (Interview)this.children.elementAt(i);
            q = child.lookup(tag);
        }
        return q;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public Interview getRoot() {
        return this.root;
    }

    public void updatePath() {
        this.root.updatePath0(this.root.firstQuestion);
    }

    public void updatePath(Question q) {
        this.root.updatePath0(q);
    }

    private void updatePath0(Question q) {
        Interview.ASSERT(this.root == this);
        if (!this.updateEnabled) {
            return;
        }
        if (this.path == null) {
            return;
        }
        if (this.semantics < 2 && !this.pathContains(q)) {
            return;
        }
        Question[] currPath = this.getPathToCurrent();
        this.trimPath(q);
        this.predictPath(q);
        if (!this.pathContains(currPath[currPath.length - 1])) {
            this.setCurrentQuestionFromPath(currPath);
        }
        this.notifyPathUpdated();
    }

    private void trimPath(Question q) {
        Object o = q;
        Interview i = q.getInterview();
        while (i != null) {
            i.ensurePathInitialized();
            Path iPath = i.path;
            int oIndex = -1;
            for (int pi = 0; pi < iPath.size(); ++pi) {
                Question qq = iPath.questionAt(pi);
                if (qq != o && (!(qq instanceof InterviewQuestion) || ((InterviewQuestion)qq).getTargetInterview() != o)) continue;
                oIndex = pi;
                break;
            }
            if (oIndex == -1) {
                return;
            }
            iPath.setSize(oIndex + 1);
            o = i;
            i = i.caller == null ? null : i.caller.getInterview();
        }
    }

    private void predictPath(Question q) {
        Interview i = q.getInterview();
        i.ensurePathInitialized();
        q = this.predictNext(q);
        while (q != null && !this.pathContains(q)) {
            if (q instanceof FinalQuestion) {
                i.path.addQuestion(q);
                i.root.rawPath.addQuestion(q);
                if (i.caller == null) break;
                q = i.caller.getNext();
                i = i.caller.getInterview();
                continue;
            }
            if (q instanceof InterviewQuestion) {
                InterviewQuestion iq = (InterviewQuestion)q;
                Interview i2 = iq.getTargetInterview();
                if (this.pathContains(i2)) break;
                if (i2 instanceof ListQuestion.Body) {
                    i2.caller = iq;
                    i.path.addQuestion(iq);
                    i.root.rawPath.addQuestion(iq);
                    q = i2.path.lastQuestion() instanceof FinalQuestion ? iq.getNext() : null;
                    continue;
                }
                i2.caller = iq;
                if (i2.path == null) {
                    i2.path = new Path();
                    i2.hiddenPath = new ArrayList();
                } else {
                    i2.path.clear();
                    i2.hiddenPath.clear();
                }
                i.path.addQuestion(iq);
                i.root.rawPath.addQuestion(iq);
                i = i2;
                q = i2.firstQuestion;
                continue;
            }
            if (q.isEnabled()) {
                i.path.addQuestion(q);
            } else if (q.isHidden() && !this.root.hiddenPath.contains(q)) {
                this.root.hiddenPath.add(q);
            }
            if (this.root.rawPath.indexOf(q) == -1) {
                i.root.rawPath.addQuestion(q);
            }
            q = this.predictNext(q);
        }
    }

    private Question predictNext(Question q) {
        if (q.isEnabled() && !q.isValueValid()) {
            return null;
        }
        if (q instanceof ListQuestion && q.isEnabled()) {
            ListQuestion lq = (ListQuestion)q;
            if (lq.isEnd()) {
                return q.getNext();
            }
            for (int index = 0; index < lq.getBodyCount(); ++index) {
                ListQuestion.Body b = lq.getBody(index);
                if (b.path == null) {
                    b.path = new Path();
                } else {
                    b.path.clear();
                }
                b.path.addQuestion(b.firstQuestion);
                b.caller = null;
                super.predictPath(b.firstQuestion);
            }
            ListQuestion.Body lqBody = lq.getSelectedBody();
            ListQuestion lqOther = lq.getOther();
            if (lqBody == null) {
                return lqOther.getNext();
            }
            Interview lqInt = lq.getInterview();
            return new InterviewQuestion(lqInt, lqBody, lqOther);
        }
        return q.getNext();
    }

    private String getI18NString(String key) {
        return this.getI18NString(key, empty);
    }

    private String getI18NString(String key, Object arg) {
        return this.getI18NString(key, new Object[]{arg});
    }

    private String getI18NString(String key, Object[] args) {
        try {
            ResourceBundle b = this.getResourceBundle();
            if (b != null) {
                return MessageFormat.format(b.getString(key), args);
            }
        }
        catch (MissingResourceException e) {
            System.err.println("WARNING: missing resource: " + key);
        }
        StringBuffer sb = new StringBuffer(key);
        for (int i = 0; i < args.length; ++i) {
            sb.append('\n');
            sb.append(args.toString());
        }
        return sb.toString();
    }

    protected String getResourceString(String key) {
        return this.getResourceString(key, true);
    }

    protected String getResourceString(String key, boolean checkAncestorsFirst) {
        try {
            String s = null;
            if (checkAncestorsFirst) {
                ResourceBundle b;
                if (this.parent != null) {
                    s = this.parent.getResourceString(key, checkAncestorsFirst);
                }
                if (s == null && (b = this.getResourceBundle()) != null) {
                    s = b.getString(key);
                }
            } else {
                ResourceBundle b = this.getResourceBundle();
                if (b != null) {
                    s = b.getString(key);
                }
                if (s == null && this.parent != null) {
                    s = this.parent.getResourceString(key, checkAncestorsFirst);
                }
            }
            return s;
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    private static final void ASSERT(boolean b) {
        if (!b) {
            throw new IllegalStateException();
        }
    }

    static class Path {
        private Question[] questions;
        private int numQuestions;

        Path() {
        }

        void addQuestion(Question q) {
            if (this.questions == null) {
                this.questions = new Question[10];
            } else if (this.numQuestions == this.questions.length) {
                Question[] newQuestions = new Question[2 * this.questions.length];
                System.arraycopy(this.questions, 0, newQuestions, 0, this.questions.length);
                this.questions = newQuestions;
            }
            this.questions[this.numQuestions++] = q;
        }

        Question questionAt(int index) throws ArrayIndexOutOfBoundsException {
            if (index < 0 || index >= this.numQuestions) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return this.questions[index];
        }

        Question lastQuestion() {
            return this.questionAt(this.numQuestions - 1);
        }

        Question[] getQuestions() {
            if (this.questions == null) {
                return null;
            }
            Question[] copy = new Question[this.questions.length];
            System.arraycopy(this.questions, 0, copy, 0, this.questions.length);
            return copy;
        }

        int indexOf(Interview interview) {
            for (int index = 0; index < this.numQuestions; ++index) {
                Question q = this.questions[index];
                if (!(q instanceof InterviewQuestion) || ((InterviewQuestion)q).getTargetInterview() != interview) continue;
                return index;
            }
            return -1;
        }

        int indexOf(Question target) {
            for (int index = 0; index < this.numQuestions; ++index) {
                Question q = this.questions[index];
                if (q != target) continue;
                return index;
            }
            return -1;
        }

        int size() {
            return this.numQuestions;
        }

        void setSize(int newSize) {
            if (this.questions != null) {
                if (newSize > this.questions.length) {
                    Question[] newQuestions = new Question[newSize];
                    System.arraycopy(this.questions, 0, newQuestions, 0, this.questions.length);
                    this.questions = newQuestions;
                }
                for (int i = newSize; i < this.numQuestions; ++i) {
                    this.questions[i] = null;
                }
            } else if (newSize > 0) {
                this.questions = new Question[newSize];
            }
            this.numQuestions = newSize;
        }

        void clear() {
            for (int i = 0; i < this.numQuestions; ++i) {
                this.questions[i] = null;
            }
            this.numQuestions = 0;
        }
    }

    public static interface Observer {
        public void currentQuestionChanged(Question var1);

        public void pathUpdated();
    }

    public static class NotOnPathFault
    extends Fault {
        NotOnPathFault(Question q) {
            super(i18n, "interview.questionNotOnPath", q.getTag());
        }
    }

    public static class HelpNotFoundFault
    extends Fault {
        public final String name;

        HelpNotFoundFault(ResourceBundle i18n, String s, String name) {
            super(i18n, s, name);
            this.name = name;
        }
    }

    public static class BadHelpFault
    extends Fault {
        public final HelpSetException exc;

        BadHelpFault(ResourceBundle i18n, String s, HelpSetException e) {
            super(i18n, s, e.getMessage());
            this.exc = e;
        }
    }

    public static class Fault
    extends Exception {
        public Fault(ResourceBundle i18n, String s) {
            super(i18n.getString(s));
        }

        public Fault(ResourceBundle i18n, String s, Object o) {
            super(MessageFormat.format(i18n.getString(s), o));
        }

        public Fault(ResourceBundle i18n, String s, Object[] o) {
            super(MessageFormat.format(i18n.getString(s), o));
        }
    }
}

