/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.agent;

import com.sun.javatest.JavaTestSecurityManager;
import com.sun.javatest.Status;
import com.sun.javatest.agent.Agent;
import com.sun.javatest.agent.Connection;
import com.sun.javatest.agent.ConnectionFactory;
import com.sun.javatest.agent.Map;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class AgentMain {
    private boolean helpRequested = false;
    private int mode = 0;
    private int modeCheck = 0;
    private String activeHost = null;
    private int activePort = 1907;
    private int passivePort = 1908;
    private String serialPort = null;
    private int concurrency = 1;
    private String mapFile = null;
    private String observerClassName;
    private static final int ACTIVE = 1;
    private static final int PASSIVE = 2;
    private static final int SERIAL = 3;
    static /* synthetic */ Class class$com$sun$javatest$agent$AgentMain;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$sun$javatest$agent$Agent$Observer;

    public static void main(String[] args) {
        AgentMain m = new AgentMain();
        m.runAndExit(args);
    }

    protected void runAndExit(String[] args) {
        int rc;
        JavaTestSecurityManager.install();
        try {
            this.run(args);
            rc = 0;
        }
        catch (BadArgs e) {
            System.err.println("Error: Bad arguments");
            String[] msgs = e.getMessages();
            for (int i = 0; i < msgs.length; ++i) {
                System.err.println(msgs[i]);
            }
            System.err.println();
            this.usage(System.err);
            rc = 1;
        }
        catch (Fault e) {
            String[] msgs = e.getMessages();
            for (int i = 0; i < msgs.length; ++i) {
                System.err.println(msgs[i]);
            }
            rc = 2;
        }
        catch (Throwable t) {
            t.printStackTrace();
            rc = 3;
        }
        SecurityManager sc = System.getSecurityManager();
        if (sc instanceof JavaTestSecurityManager) {
            ((JavaTestSecurityManager)sc).setAllowExit(true);
        }
        System.exit(rc);
    }

    public void run(String[] args) throws BadArgs, Fault {
        this.decodeAllArgs(args);
        if (this.helpRequested) {
            this.usage(System.err);
            return;
        }
        this.validateArgs();
        Agent agent = this.createAgent();
        agent.addObserver(new ErrorObserver());
        agent.run();
    }

    protected void decodeAllArgs(String[] args) throws BadArgs, Fault {
        int used;
        for (int i = 0; i < args.length; i += used) {
            used = this.decodeArg(args, i);
            if (used != 0) continue;
            throw new BadArgs("Unrecognised option: " + args[i]);
        }
    }

    protected int decodeArg(String[] args, int index) throws BadArgs, Fault {
        int i = index;
        try {
            if (args[i].equalsIgnoreCase("-active")) {
                this.mode = 1;
                this.modeCheck |= 1 << this.mode;
                return 1;
            }
            if (args[i].equalsIgnoreCase("-passive")) {
                this.mode = 2;
                this.modeCheck |= 1 << this.mode;
                return 1;
            }
            if (args[i].equalsIgnoreCase("-activeHost")) {
                this.mode = 1;
                this.modeCheck |= 1 << this.mode;
                this.activeHost = args[++i];
                return 2;
            }
            if (args[i].equalsIgnoreCase("-activePort")) {
                this.mode = 1;
                this.modeCheck |= 1 << this.mode;
                this.activePort = Integer.parseInt(args[++i]);
                return 2;
            }
            if (args[i].equalsIgnoreCase("-passivePort")) {
                this.mode = 2;
                this.modeCheck |= 1 << this.mode;
                this.passivePort = Integer.parseInt(args[++i]);
                return 2;
            }
            if (args[i].equalsIgnoreCase("-serialPort")) {
                this.mode = 3;
                this.modeCheck = this.modeCheck |= 1 << this.mode;
                this.serialPort = args[++i];
                return 2;
            }
            if (args[i].equalsIgnoreCase("-concurrency")) {
                this.concurrency = Integer.parseInt(args[++i]);
                return 2;
            }
            if (args[i].equalsIgnoreCase("-map")) {
                this.mapFile = args[++i];
                return 2;
            }
            if (args[i].equalsIgnoreCase("-trace")) {
                Agent.tracing = true;
                return 1;
            }
            if ("-observer".equalsIgnoreCase(args[i]) && i < args.length - 1) {
                if (this.observerClassName != null) {
                    throw new BadArgs("duplicate use of -observer");
                }
                this.observerClassName = args[++i];
                return 2;
            }
            if (args[i].equalsIgnoreCase("-help") || args[i].equalsIgnoreCase("-usage")) {
                this.helpRequested = true;
                return args.length - index;
            }
            return 0;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new BadArgs("Missing argument for " + args[args.length - 1]);
        }
        catch (NumberFormatException e) {
            throw new BadArgs("Number expected: " + args[i]);
        }
    }

    protected void validateArgs() throws BadArgs, Fault {
        if (this.modeCheck == 0) {
            throw new BadArgs("no connection options given");
        }
        if (this.modeCheck != 1 << this.mode) {
            throw new BadArgs("conflicting options for connection to JT Harness harness");
        }
        switch (this.mode) {
            case 1: {
                if (this.activeHost == null || this.activeHost.length() == 0) {
                    throw new BadArgs("no active host specified");
                }
                if (this.activePort > 0) break;
                throw new BadArgs("no active port specified");
            }
            case 3: {
                if (this.serialPort != null) break;
                throw new BadArgs("no serial port specified");
            }
        }
        if (this.concurrency <= 0 || this.concurrency > 100) {
            throw new BadArgs("Bad value for concurrency: " + this.concurrency);
        }
    }

    protected ConnectionFactory createConnectionFactory() throws Fault {
        String s = (class$com$sun$javatest$agent$AgentMain == null ? (class$com$sun$javatest$agent$AgentMain = AgentMain.class$("com.sun.javatest.agent.AgentMain")) : class$com$sun$javatest$agent$AgentMain).getName();
        String pkg = s.substring(0, s.lastIndexOf(46));
        switch (this.mode) {
            case 1: {
                try {
                    Class<?> c = Class.forName(pkg + ".ActiveConnectionFactory");
                    Constructor<?> m = c.getConstructor(class$java$lang$String == null ? (class$java$lang$String = AgentMain.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE);
                    Object[] args = new Object[]{this.activeHost, new Integer(this.activePort)};
                    return (ConnectionFactory)m.newInstance(args);
                }
                catch (Throwable e) {
                    Throwable t = AgentMain.unwrapInvocationTargetException(e);
                    String[] msgs = new String[]{"Error occurred while trying to start an active agent", t.toString(), "Are the java.net classes available?"};
                    throw new Fault(msgs);
                }
            }
            case 2: {
                try {
                    Class<?> c = Class.forName(pkg + ".PassiveConnectionFactory");
                    Constructor<?> m = c.getConstructor(Integer.TYPE, Integer.TYPE);
                    Object[] args = new Object[]{new Integer(this.passivePort), new Integer(this.concurrency + 1)};
                    return (ConnectionFactory)m.newInstance(args);
                }
                catch (Throwable e) {
                    Throwable t = AgentMain.unwrapInvocationTargetException(e);
                    if (t instanceof IOException) {
                        throw new Fault("Cannot create socket on port " + this.passivePort);
                    }
                    String[] msgs = new String[]{"Error occurred while trying to start a passive agent", t.toString(), "Are the java.net classes available?"};
                    throw new Fault(msgs);
                }
            }
            case 3: {
                try {
                    Class<?> c = Class.forName(pkg + ".SerialPortConnectionFactory");
                    Constructor<?> m = c.getConstructor(class$java$lang$String == null ? (class$java$lang$String = AgentMain.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = AgentMain.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE);
                    Object[] args = new Object[]{this.serialPort, "JT Harness Agent", new Integer(10000)};
                    return (ConnectionFactory)m.newInstance(args);
                }
                catch (InvocationTargetException e) {
                    Throwable t = e.getTargetException();
                    if (t instanceof IllegalArgumentException || t.getClass().getName().equals("gnu.io.NoSuchPortException")) {
                        throw new Fault(this.serialPort + " is not a valid port");
                    }
                    String[] msgs = new String[]{"Error occurred while trying to access the communication ports", t.toString(), "Is the gnu.io extension installed?"};
                    throw new Fault(msgs);
                }
                catch (Throwable e) {
                    String[] msgs = new String[]{"Error occurred while trying to access the communication ports", e.toString(), "Is the gnu.io extension installed?"};
                    throw new Fault(msgs);
                }
            }
        }
        throw new Error("unexpected mode");
    }

    protected Agent createAgent() throws Fault {
        Integer delay;
        ConnectionFactory cf = this.createConnectionFactory();
        Agent agent = new Agent(cf, this.concurrency);
        if (this.observerClassName != null) {
            try {
                Class<?> observerClass = Class.forName(this.observerClassName);
                Agent.Observer observer = (Agent.Observer)observerClass.newInstance();
                agent.addObserver(observer);
            }
            catch (ClassCastException e) {
                throw new Fault("observer is not of type " + (class$com$sun$javatest$agent$Agent$Observer == null ? (class$com$sun$javatest$agent$Agent$Observer = AgentMain.class$("com.sun.javatest.agent.Agent$Observer")) : class$com$sun$javatest$agent$Agent$Observer).getName() + ": " + this.observerClassName);
            }
            catch (ClassNotFoundException e) {
                throw new Fault("cannot find observer class: " + this.observerClassName);
            }
            catch (IllegalAccessException e) {
                throw new Fault("problem instantiating observer: " + e);
            }
            catch (InstantiationException e) {
                throw new Fault("problem instantiating observer: " + e);
            }
        }
        if (this.mapFile != null) {
            try {
                agent.setMap(Map.readFileOrURL(this.mapFile));
            }
            catch (IOException e) {
                String[] msgs = new String[]{"Problem reading map file", e.toString()};
                throw new Fault(msgs);
            }
        }
        if ((delay = Integer.getInteger("agent.retry.delay")) != null) {
            agent.setRetryDelay(delay);
        }
        return agent;
    }

    public void usage(PrintStream out) {
        String className = this.getClass().getName();
        out.println("Usage:");
        out.println("    java " + className + " [options]");
        out.println("        -help             print this message");
        out.println("        -usage            print this message");
        out.println("        -active           set mode to be active");
        out.println("        -activeHost host  set the host for active connections (implies -active)");
        out.println("        -activePort port  set the port for active connections (implies -active)");
        out.println("        -passive          set mode to be passive");
        out.println("        -passivePort port set the port for passive connections (implies -passive)");
        out.println("        -serialPort port  set the port for serial port connections");
        out.println("        -map file         map file for translating arguments of incoming requests");
        out.println("        -concurrency num  set the maximum number of simultaneous connections");
        out.println("        -trace            trace the execution of the agent");
        out.println("        -observer class   add an observer to the agent");
    }

    protected static Throwable unwrapInvocationTargetException(Throwable t) {
        if (t instanceof InvocationTargetException) {
            return ((InvocationTargetException)t).getTargetException();
        }
        return t;
    }

    private static final int max(int a, int b) {
        return a > b ? a : b;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ int access$000(int x0, int x1) {
        return AgentMain.max(x0, x1);
    }

    private static class ErrorObserver
    implements Agent.Observer {
        private long lastNotRespondMsgTime = 0L;
        private int lastNotRespondMsgInterval = AgentMain.access$000(Integer.getInteger("notResponding.message.interval", 60), 10) * 1000;
        private Class connectExceptionClass;
        private Class unknownHostExceptionClass;

        ErrorObserver() {
            try {
                this.connectExceptionClass = Class.forName("java.net.ConnectException");
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                this.unknownHostExceptionClass = Class.forName("java.net.UnknownHostException");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public void started(Agent agent) {
        }

        public void errorOpeningConnection(Agent agent, Exception e) {
            if (this.connectExceptionClass != null && this.connectExceptionClass.isInstance(e)) {
                long now = System.currentTimeMillis();
                if (this.lastNotRespondMsgTime + (long)this.lastNotRespondMsgInterval < now) {
                    System.err.println("host not responding: " + e.getMessage());
                    this.lastNotRespondMsgTime = now;
                }
            } else if (this.unknownHostExceptionClass != null && this.unknownHostExceptionClass.isInstance(e)) {
                System.err.println("unknown host: " + e.getMessage());
            } else {
                System.err.println("error connecting to host: " + e);
            }
        }

        public void finished(Agent agent) {
        }

        public void openedConnection(Agent agent, Connection c) {
        }

        public void execTest(Agent agent, Connection c, String tag, String className, String[] args) {
        }

        public void execCommand(Agent agent, Connection c, String tag, String className, String[] args) {
        }

        public void execMain(Agent agent, Connection c, String tag, String className, String[] args) {
        }

        public void result(Agent agent, Connection c, Status result) {
        }

        public void exception(Agent agent, Connection c, Throwable e) {
        }

        public void completed(Agent agent, Connection c) {
        }
    }

    public static class Fault
    extends Exception {
        private String[] msgs;

        public Fault(String msg) {
            this(new String[]{msg});
        }

        public Fault(String[] msgs) {
            super(msgs[0]);
            this.msgs = msgs;
        }

        public String[] getMessages() {
            return this.msgs;
        }
    }

    public static class BadArgs
    extends Exception {
        private String[] msgs;

        public BadArgs(String msg) {
            this(new String[]{msg});
        }

        public BadArgs(String[] msgs) {
            super(msgs[0]);
            this.msgs = msgs;
        }

        public String[] getMessages() {
            return this.msgs;
        }
    }
}

