/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.tool.Preferences;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.border.BevelBorder;

public class JavaTestToolBar
extends JToolBar {
    static final String USER_TOOLBAR_PREF = "JavaTestToolBar.toolbar_";
    private boolean inMenu = false;
    private ResourceBundle theBundle;
    private String id;
    private Map state = new HashMap();

    public JavaTestToolBar(ResourceBundle bundle, String resourceID, boolean menuControlled) {
        this.theBundle = bundle;
        this.id = resourceID;
        this.inMenu = menuControlled;
        this.setUpStyle();
    }

    public JavaTestToolBar(ResourceBundle bundle, String resourceID) {
        this(bundle, resourceID, true);
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.theBundle.getString(this.getId() + ".tb.desc");
    }

    public String getName() {
        return this.theBundle.getString(this.getId() + ".tb.name");
    }

    public boolean isMenuControlled() {
        return this.inMenu;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.saveVisibleState(visible);
    }

    void setVisibleNoStateAffect(boolean visible) {
        super.setVisible(visible);
    }

    boolean readVisibleState() {
        Object o = this.state.get(USER_TOOLBAR_PREF + this.getId());
        if (o instanceof String) {
            return "true".equals(o);
        }
        return true;
    }

    void saveVisibleState(boolean visible) {
        this.state.put(USER_TOOLBAR_PREF + this.getId(), Boolean.toString(visible));
    }

    void save(Map map) {
        map.putAll(this.state);
    }

    void load(Map map) {
        for (Object okey : map.keySet()) {
            String tbKey;
            String key = (String)okey;
            if (!key.contains(tbKey = USER_TOOLBAR_PREF + this.getId())) continue;
            this.state.put(okey, map.get(okey));
        }
        Preferences prefs = Preferences.access();
        String visPref = prefs.getPreference("exec.toolbar");
        boolean generalVisibleState = "true".equals(visPref);
        this.setVisibleNoStateAffect(generalVisibleState && this.readVisibleState());
    }

    private void setUpStyle() {
        this.setFloatable(false);
        this.setRollover(true);
        this.setBorder(new ToolBarBorder());
    }

    class ToolBarBorder
    extends BevelBorder {
        private int lIn;

        public ToolBarBorder() {
            super(0);
            this.lIn = 5;
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(2, 2, 2, this.lIn);
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            insets.right = this.lIn;
            insets.bottom = 2;
            insets.left = 2;
            insets.top = 2;
            return insets;
        }

        protected void paintRaisedBevel(Component c, Graphics g, int x, int y, int width, int height) {
            JComponent jc;
            Boolean paint;
            int gap = 4;
            int hlen = 12;
            if (c instanceof JComponent && (paint = (Boolean)(jc = (JComponent)c).getClientProperty("PAINT_BORDER")) != null && paint.booleanValue()) {
                Color oldColor = g.getColor();
                int h = height;
                int w = width;
                if (h > hlen * 2) {
                    int mid = y + h / 2;
                    y = mid - hlen;
                    h = hlen * 2;
                }
                g.setColor(this.getShadowInnerColor(c));
                g.drawLine(x, y + gap, x, y + h - gap - 1);
                g.setColor(this.getHighlightInnerColor(c));
                g.drawLine(x + 1, y + gap, x + 1, y + h - gap - 1);
            }
        }
    }
}

