/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.finder;

import com.sun.javatest.finder.CommentStream;
import java.io.IOException;

public class HTMLCommentStream
extends CommentStream {
    private static final String LINESEP = System.getProperty("line.separator");

    public String readComment() throws IOException {
        String comment;
        int endComment;
        String line;
        int startComment;
        boolean endFound = false;
        do {
            startComment = 0;
            endComment = 0;
            line = this.cs.readLine();
            if (line != null) continue;
            return null;
        } while ((startComment = line.indexOf("<!--")) < 0);
        String tail = line.substring(startComment + 4);
        endComment = tail.indexOf("-->");
        if (endComment >= 0) {
            comment = tail.substring(0, endComment);
            endFound = true;
        } else {
            comment = tail + LINESEP;
        }
        while (!endFound) {
            line = this.cs.readLine();
            if (line == null) {
                throw new IOException("Comment not properly terminated");
            }
            endComment = line.indexOf("-->");
            if (endComment >= 0) {
                comment = comment + line.substring(0, endComment) + LINESEP;
                endFound = true;
                continue;
            }
            comment = comment + line + LINESEP;
        }
        return comment.replace('\n', ' ').replace('\r', ' ').trim();
    }
}

