/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.interview;

import com.sun.interview.ChoiceArrayQuestion;
import com.sun.interview.FinalQuestion;
import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.interview.YesNoQuestion;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.Parameters;
import com.sun.javatest.StatusFilter;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.WorkDirectory;

public class PriorStatusInterview
extends Interview
implements Parameters.MutablePriorStatusParameters {
    private YesNoQuestion qNeedStatus = new YesNoQuestion(this, "needStatus", "No"){

        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            if (this.value == "Yes") {
                return PriorStatusInterview.this.qStatus;
            }
            return PriorStatusInterview.this.qEnd;
        }
    };
    private static final String PASSED = "passed";
    private static final String FAILED = "failed";
    private static final String ERROR = "error";
    private static final String NOT_RUN = "not_run";
    private static int[] choiceToStatus = new int[]{2, 1, 3, 0};
    private ChoiceArrayQuestion qStatus = new ChoiceArrayQuestion(this, "status"){
        {
            this.setChoices(new String[]{PriorStatusInterview.ERROR, PriorStatusInterview.FAILED, PriorStatusInterview.NOT_RUN, PriorStatusInterview.PASSED}, true);
        }

        public boolean isValueValid() {
            for (int i = 0; i < this.value.length; ++i) {
                if (!this.value[i]) continue;
                return true;
            }
            return false;
        }

        protected Question getNext() {
            return PriorStatusInterview.this.qEnd;
        }
    };
    private StatusFilter cachedStatusFilter;
    private Question qEnd = new FinalQuestion(this);
    private InterviewParameters parent;

    public PriorStatusInterview(InterviewParameters parent) throws Interview.Fault {
        super(parent, "priorStatus");
        this.parent = parent;
        this.setResourceBundle("i18n");
        this.setHelpSet("/com/sun/javatest/moreInfo/moreInfo.hs");
        this.setFirstQuestion(this.qNeedStatus);
    }

    public boolean[] getPriorStatusValues() {
        if (this.qNeedStatus.getValue() == "Yes") {
            return this.getMatchPriorStatusValues();
        }
        return null;
    }

    public void setPriorStatusValues(boolean[] b) {
        if (b == null) {
            this.setPriorStatusMode(1);
        } else {
            this.setPriorStatusMode(2);
            this.setMatchPriorStatusValues(b);
        }
    }

    public int getPriorStatusMode() {
        return this.qNeedStatus.getValue() == "Yes" ? 2 : 1;
    }

    public void setPriorStatusMode(int mode) {
        this.qNeedStatus.setValue(mode == 2 ? "Yes" : "No");
    }

    public boolean[] getMatchPriorStatusValues() {
        boolean[] choices = this.qStatus.getValue();
        boolean[] b = new boolean[4];
        b[2] = choices[0];
        b[1] = choices[1];
        b[3] = choices[2];
        b[0] = choices[3];
        return b;
    }

    public void setMatchPriorStatusValues(boolean[] b) {
        if (b.length != 4) {
            throw new IllegalArgumentException();
        }
        boolean[] choices = new boolean[]{b[2], b[1], b[3], b[0]};
        this.qStatus.setValue(choices);
    }

    public TestFilter getStatusFilter() {
        this.updateCachedStatusFilter();
        return this.cachedStatusFilter;
    }

    private void updateCachedStatusFilter() {
        WorkDirectory wd = this.parent.getWorkDirectory();
        TestResultTable r = wd == null ? null : wd.getTestResultTable();
        boolean[] s = this.getPriorStatusValues();
        if (r == null || s == null) {
            this.cachedStatusFilter = null;
        } else if (this.cachedStatusFilter == null || this.cachedStatusFilter.getTestResultTable() != r || !PriorStatusInterview.equal(this.cachedStatusFilter.getStatusValues(), s)) {
            this.cachedStatusFilter = new StatusFilter(s, r);
        }
    }

    private static boolean equal(boolean[] b1, boolean[] b2) {
        if (b1 == null || b2 == null) {
            return b1 == b2;
        }
        if (b1.length != b2.length) {
            return false;
        }
        for (int i = 0; i < b1.length; ++i) {
            if (b1[i] == b2[i]) continue;
            return false;
        }
        return true;
    }
}

