/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.interview;

import com.sun.interview.ChoiceQuestion;
import com.sun.interview.ErrorQuestion;
import com.sun.interview.FileQuestion;
import com.sun.interview.FinalQuestion;
import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.interview.TreeQuestion;
import com.sun.interview.YesNoQuestion;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.WorkDirectory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.TreeSet;
import java.util.Vector;

public class TestsInterview
extends Interview
implements Parameters.MutableTestsParameters {
    private YesNoQuestion qNeedTests = new YesNoQuestion(this, "needTests", "No"){

        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            if (this.value == "Yes") {
                return TestsInterview.this.qTreeOrFile;
            }
            return TestsInterview.this.qEnd;
        }
    };
    private static final String FILE = "file";
    private static final String TREE = "tree";
    protected TreeOrFileChoiceQuestion qTreeOrFile = this.createTreeOrFileChoiceQuestion(this, "treeOrFile");
    private FileQuestion qTestFile = new FileQuestion(this, "testFile"){

        public boolean isValueValid() {
            return this.value != null && this.value.getPath().length() > 0;
        }

        protected Question getNext() {
            if (this.value == null || this.value.getPath().length() == 0) {
                return null;
            }
            String[] tests = TestsInterview.this.getTests(this.value);
            if (tests == null) {
                return TestsInterview.this.cachedTestsError;
            }
            TestsInterview.this.validateTests(tests);
            if (TestsInterview.this.cachedTestsError != null) {
                return TestsInterview.this.cachedTestsError;
            }
            return TestsInterview.this.qEnd;
        }
    };
    private Question qCantFindFileError = new ErrorQuestion(this, "cantFindFile"){

        protected Object[] getTextArgs() {
            return TestsInterview.this.cachedTestsErrorArgs;
        }
    };
    private Question qCantReadFileError = new ErrorQuestion(this, "cantReadFile"){

        protected Object[] getTextArgs() {
            return TestsInterview.this.cachedTestsErrorArgs;
        }
    };
    private TreeQuestion.Model model = new TreeQuestion.Model(){

        public Object getRoot() {
            return TestsInterview.this.parent.getWorkDirectory().getTestResultTable().getRoot();
        }

        public int getChildCount(Object node) {
            if (node == null) {
                throw new NullPointerException();
            }
            if (node instanceof TestResultTable.TreeNode) {
                return ((TestResultTable.TreeNode)node).getChildCount();
            }
            if (node instanceof TestResult) {
                return 0;
            }
            throw new IllegalArgumentException();
        }

        public Object getChild(Object node, int index) {
            if (node == null) {
                throw new NullPointerException();
            }
            if (node instanceof TestResultTable.TreeNode) {
                return ((TestResultTable.TreeNode)node).getChild(index);
            }
            if (node instanceof TestResult) {
                return null;
            }
            throw new IllegalArgumentException();
        }

        public String getName(Object node) {
            if (node == null) {
                throw new NullPointerException();
            }
            if (node instanceof TestResultTable.TreeNode) {
                return ((TestResultTable.TreeNode)node).getName();
            }
            if (node instanceof TestResult) {
                TestResult tr = (TestResult)node;
                String fullName = tr.getTestName();
                int lastSlash = fullName.lastIndexOf("/");
                return lastSlash == -1 ? fullName : fullName.substring(lastSlash + 1);
            }
            throw new IllegalArgumentException();
        }

        public String getPath(Object node) {
            if (node == null) {
                throw new NullPointerException();
            }
            if (node instanceof TestResult) {
                return ((TestResult)node).getTestName();
            }
            if (node instanceof TestResultTable.TreeNode) {
                TestResultTable.TreeNode tn = (TestResultTable.TreeNode)node;
                if (tn.isRoot()) {
                    return tn.getName();
                }
                return this.getPath(tn.getParent() + "/" + tn.getName());
            }
            throw new IllegalArgumentException();
        }

        public boolean isLeaf(Object node) {
            if (node == null) {
                throw new NullPointerException();
            }
            if (node instanceof TestResult) {
                return true;
            }
            if (node instanceof TestResultTable.TreeNode) {
                return false;
            }
            throw new IllegalArgumentException();
        }
    };
    protected TreeQuestion qTestTree = new TreeQuestion(this, "tests", this.model){

        protected Question getNext() {
            TestsInterview.this.validateTests(this.value);
            if (TestsInterview.this.cachedTestsError != null) {
                return TestsInterview.this.cachedTestsError;
            }
            return TestsInterview.this.qEnd;
        }
    };
    private Question qNoTestsError = new ErrorQuestion(this, "noTests");
    private ErrorQuestion qBadTestsError = new ErrorQuestion(this, "badTests"){

        protected Object[] getTextArgs() {
            return TestsInterview.this.cachedTestsErrorArgs;
        }
    };
    private String[] cachedTestsValue;
    private Question cachedTestsError;
    private Object[] cachedTestsErrorArgs;
    protected Question qEnd = new FinalQuestion(this);
    private InterviewParameters parent;

    public TestsInterview(InterviewParameters parent) throws Interview.Fault {
        super(parent, "tests");
        this.parent = parent;
        this.setResourceBundle("i18n");
        this.setHelpSet("/com/sun/javatest/moreInfo/moreInfo.hs");
        this.setFirstQuestion(this.qNeedTests);
    }

    public String[] getTests() {
        if (this.qNeedTests.getValue() == "Yes") {
            if (this.qTreeOrFile.getValue() == TREE) {
                return this.qTestTree.getValue();
            }
            if (this.qTreeOrFile.getValue() == FILE) {
                return this.getTests(this.qTestFile.getValue());
            }
            return null;
        }
        return null;
    }

    public void setTests(String[] tests) {
        if (tests == null) {
            this.setTestsMode(1);
        } else {
            this.setTestsMode(2);
            this.setSpecifiedTests(tests);
        }
    }

    public int getTestsMode() {
        return this.qNeedTests.getValue() == "Yes" ? 2 : 1;
    }

    public void setTestsMode(int mode) {
        switch (mode) {
            case 1: {
                this.qNeedTests.setValue("No");
                break;
            }
            case 2: {
                this.qNeedTests.setValue("Yes");
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public String[] getSpecifiedTests() {
        Object v = this.qTreeOrFile.getValue() == TREE ? this.qTestTree.getValue() : (this.qTreeOrFile.getValue() == FILE ? this.getTests(this.qTestFile.getValue()) : null);
        if (v == null) {
            return null;
        }
        TreeSet<String> ts = new TreeSet<String>(Arrays.asList(v));
        return ts.toArray(new String[ts.size()]);
    }

    public void setSpecifiedTests(String[] tests) {
        this.qTreeOrFile.setValue(TREE);
        this.qTestTree.setValue(tests);
    }

    protected TreeOrFileChoiceQuestion createTreeOrFileChoiceQuestion(Interview interview, String tag) {
        return new TreeOrFileChoiceQuestion(interview, tag);
    }

    private String[] getTests(File file) {
        Vector<String> paths = new Vector<String>();
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(file));
            while ((line = in.readLine()) != null) {
                if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
                int sp = line.indexOf(32);
                paths.add(sp == -1 ? line : line.substring(0, sp));
            }
            in.close();
        }
        catch (FileNotFoundException e) {
            this.cachedTestsError = this.qCantFindFileError;
            this.cachedTestsErrorArgs = new Object[]{file};
            return null;
        }
        catch (IOException e) {
            this.cachedTestsError = this.qCantFindFileError;
            this.cachedTestsErrorArgs = new Object[]{file, e.toString()};
            return null;
        }
        return paths.toArray(new String[paths.size()]);
    }

    private void validateTests(String[] tests) {
        if (TestsInterview.equal(tests, this.cachedTestsValue)) {
            return;
        }
        this.cachedTestsValue = tests;
        this.cachedTestsError = null;
        WorkDirectory wd = this.parent.getWorkDirectory();
        if (wd == null) {
            return;
        }
        TestResultTable trt = wd.getTestResultTable();
        if (tests == null || tests.length == 0) {
            return;
        }
        Vector<String> v = new Vector<String>();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < tests.length; ++i) {
            String test = tests[i];
            if (v.contains(test) || trt.validatePath(test)) continue;
            if (sb.length() > 32) {
                sb.append("...");
                break;
            }
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(test);
            v.add(test);
        }
        if (sb.length() > 0) {
            this.cachedTestsError = this.qBadTestsError;
            this.cachedTestsErrorArgs = new Object[]{new Integer(v.size()), sb.toString()};
        }
    }

    private static boolean equal(String[] s1, String[] s2) {
        if (s1 == null || s2 == null) {
            return s1 == s2;
        }
        if (s1.length != s2.length) {
            return false;
        }
        for (int i = 0; i < s1.length; ++i) {
            if (s1[i] == s2[i]) continue;
            return false;
        }
        return true;
    }

    public class TreeOrFileChoiceQuestion
    extends ChoiceQuestion {
        public TreeOrFileChoiceQuestion(Interview interview, String tag) {
            super(interview, tag);
            this.setChoices(this.getTestSelectionChoices(), true);
        }

        protected String[] getTestSelectionChoices() {
            return new String[]{TestsInterview.TREE, TestsInterview.FILE};
        }

        protected Question getNext() {
            if (this.value == TestsInterview.TREE) {
                return TestsInterview.this.qTestTree;
            }
            return TestsInterview.this.qTestFile;
        }
    }
}

