/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.report;

import com.sun.javatest.Status;
import com.sun.javatest.report.XMLReport;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.text.ParseException;
import java.util.Date;
import java.util.Properties;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public class XMLReportMaker {
    private TransformerHandler ser;
    private final AttributesImpl emptyAttr = new AttributesImpl();
    public static String XML_CHARSET = "UTF-8";

    XMLReportMaker(Writer w) throws IOException {
        Properties outputProps = new Properties();
        outputProps.put("indent", "yes");
        outputProps.put("encoding", XML_CHARSET);
        SAXTransformerFactory stf = (SAXTransformerFactory)TransformerFactory.newInstance();
        stf.setAttribute("indent-number", 4);
        try {
            this.ser = stf.newTransformerHandler();
        }
        catch (TransformerConfigurationException ex) {
            ex.printStackTrace();
        }
        this.ser.getTransformer().setOutputProperties(outputProps);
        this.ser.setResult(new StreamResult(w));
    }

    void sDocument() throws SAXException {
        this.ser.startDocument();
    }

    void eDocument() throws SAXException, IOException {
        this.ser.endDocument();
    }

    void sReport() throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "", "xmlns:xsi", "String", "http://www.w3.org/2001/XMLSchema-instance");
        atts.addAttribute("", "", "xsi:noNamespaceSchemaLocation", "String", "Report.xsd");
        atts.addAttribute("", "", "formatVersion", "String", "v1");
        atts.addAttribute("", "", "generatedTime", "String", XMLReport.Utils.dateToISO8601(new Date()));
        this.sE("Report", atts);
    }

    void eReport() throws SAXException {
        this.eE("Report");
    }

    void sSummary() throws SAXException {
        this.sE("Summary");
    }

    void eSummary() throws SAXException {
        this.eE("Summary");
    }

    void sWorkdirectories() throws SAXException {
        this.sE("WorkDirectories");
    }

    void eWorkdirectories() throws SAXException {
        this.eE("WorkDirectories");
    }

    void sEnvironment(String name, String descr) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        if (name != null && !"".equals(name.trim())) {
            atts.addAttribute("", "", "name", "String", name);
        }
        if (descr != null && !"".equals(descr.trim())) {
            atts.addAttribute("", "", "description", "String", descr);
        }
        this.sE("Environment", atts);
    }

    void eEnvironment() throws SAXException {
        this.eE("Environment");
    }

    void conCur(int val) throws SAXException {
        this.sE("Concurrency");
        String sVal = Integer.toString(val);
        this.ser.characters(sVal.toCharArray(), 0, sVal.length());
        this.eE("Concurrency");
    }

    void timeOut(float val) throws SAXException {
        this.sE("TimeOut");
        String sVal = Float.toString(val);
        this.ser.characters(sVal.toCharArray(), 0, sVal.length());
        this.eE("TimeOut");
    }

    void sWorkdirectory(String jti) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "", "id", "String", "1");
        if (jti != null) {
            atts.addAttribute("", "", "jti", "String", jti);
        }
        this.sE("WorkDirectory", atts);
    }

    void eWorkdirectory() throws SAXException {
        this.eE("WorkDirectory");
    }

    void sTestResults() throws SAXException {
        this.sE("TestResults");
    }

    void eTestResults() throws SAXException {
        this.eE("TestResults");
    }

    void sTestResult(String url, Status st, int id) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "", "url", "String", url);
        atts.addAttribute("", "", "status", "String", XMLReport.Utils.statusToString(st));
        atts.addAttribute("", "", "workDirID", "Integer", Integer.toString(id));
        this.sE("TestResult", atts);
    }

    void eTestResult() throws SAXException {
        this.eE("TestResult");
    }

    void sDescriptionData() throws SAXException {
        this.sE("DescriptionData");
    }

    void eDescriptionData() throws SAXException {
        this.eE("DescriptionData");
    }

    void sTAnnotationData() throws SAXException {
        this.sE("TestAnnotation");
    }

    void eTAnnotationData() throws SAXException {
        this.eE("TestAnnotation");
    }

    void sKeyWords() throws SAXException {
        this.sE("Keywords");
    }

    void sKeyWords(String expr) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "", "expression", "String", expr);
        this.sE("Keywords", atts);
    }

    void eKeyWords() throws SAXException {
        this.eE("Keywords");
    }

    void sTestEnvironment() throws SAXException {
        this.sE("TestEnvironment");
    }

    void eTestEnvironment() throws SAXException {
        this.eE("TestEnvironment");
    }

    void sResultProps(String time) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        if (time != null) {
            try {
                time = XMLReport.Utils.dateToISO8601(XMLReport.Utils.jtrToDate(time));
            }
            catch (ParseException ex) {
                throw new SAXException(ex);
            }
            atts.addAttribute("", "", "endTime", "String", time);
        }
        this.sE("ResultProperties", atts);
    }

    void eResultProps() throws SAXException {
        this.eE("ResultProperties");
    }

    void sSections() throws SAXException {
        this.sE("Sections");
    }

    void eSections() throws SAXException {
        this.eE("Sections");
    }

    void sStdValues() throws SAXException {
        this.sE("StandardValues");
    }

    void eStdValues() throws SAXException {
        this.eE("StandardValues");
    }

    void sPriorStatusList() throws SAXException {
        this.sE("PriorStatusList");
    }

    void ePriorStatusList() throws SAXException {
        this.eE("PriorStatusList");
    }

    void sExclList() throws SAXException {
        this.sE("ExcludeList");
    }

    void eExclList() throws SAXException {
        this.eE("ExcludeList");
    }

    void sTests() throws SAXException {
        this.sE("Tests");
    }

    void eTests() throws SAXException {
        this.eE("Tests");
    }

    void sInterview() throws SAXException {
        this.sE("Interview");
    }

    void eInterview() throws SAXException {
        this.eE("Interview");
    }

    void sQuestion(String value, String text, String summary) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        if (summary != null) {
            atts.addAttribute("", "", "summary", "String", summary);
        }
        if (value != null) {
            atts.addAttribute("", "", "value", "String", value);
        }
        if (value != null) {
            atts.addAttribute("", "", "text", "String", text);
        }
        this.sE("Question", atts);
    }

    void eQuestion() throws SAXException {
        this.eE("Question");
    }

    void sListQuestion() throws SAXException {
        this.sE("ListQuestion");
    }

    void eListQuestion() throws SAXException {
        this.eE("ListQuestion");
    }

    void sChoiceQuestion() throws SAXException {
        this.sE("ChoiceQuestion");
    }

    void eChoiceQuestion() throws SAXException {
        this.eE("ChoiceQuestion");
    }

    void sPropertiesQuestion() throws SAXException {
        this.sE("PropertiesQuestion");
    }

    void ePropertiesQuestion() throws SAXException {
        this.eE("PropertiesQuestion");
    }

    void sGroup(String name, String hd1, String hd2) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        if (name != null) {
            atts.addAttribute("", "", "name", "String", name);
        }
        if (hd1 != null) {
            atts.addAttribute("", "", "header1", "String", hd1);
        }
        if (hd2 != null) {
            atts.addAttribute("", "", "header2", "String", hd2);
        }
        this.sE("Group", atts);
    }

    void eGroup(String name, String h1, String h2) throws SAXException {
        this.eE("Group");
    }

    void makeRow(String key, String val) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        if (key != null) {
            atts.addAttribute("", "", "key", "String", key);
        }
        if (val != null) {
            atts.addAttribute("", "", "value", "String", val);
        }
        this.sE("Row", atts);
        this.eE("Row");
    }

    void makeChoices(String[] ch, String[] dispCh) throws SAXException {
        if (ch != null) {
            for (int i = 0; i < ch.length; ++i) {
                this.makeChoice(ch[i], i < dispCh.length ? dispCh[i] : null);
            }
        }
    }

    void makeChoices(String[] ch, String[] dispCh, boolean[] values) throws SAXException {
        if (ch != null) {
            for (int i = 0; i < ch.length; ++i) {
                this.makeChoice(ch[i], i < dispCh.length ? dispCh[i] : null, i < values.length ? values[i] : false);
            }
        }
    }

    private void makeChoice(String ch, String di) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        if (ch != null) {
            atts.addAttribute("", "", "choice", "String", ch);
        }
        if (di != null) {
            atts.addAttribute("", "", "displayChoice", "String", di);
        }
        this.sE("Choice", atts);
        this.eE("Choice");
    }

    private void makeChoice(String ch, String di, boolean val) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "", "choice", "String", ch);
        if (di != null) {
            atts.addAttribute("", "", "displayChoice", "String", di);
        }
        atts.addAttribute("", "", "value", "String", Boolean.toString(val));
        this.sE("Choice", atts);
        this.eE("Choice");
    }

    void makeEntireTestTree() throws SAXException {
        this.sE("EntireTestTree");
        this.eE("EntireTestTree");
    }

    void sSection(String title, Status st) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "", "title", "String", title);
        if (st != null) {
            atts.addAttribute("", "", "status", "String", XMLReport.Utils.statusToString(st));
        }
        this.sE("Section", atts);
    }

    void eSection() throws SAXException {
        this.eE("Section");
    }

    void sOutput(String title, String content) throws SAXException, IOException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "", "title", "String", title);
        this.sE("Output", atts);
        if (content != null && content.length() > 0) {
            XMLReportMaker.writeCDATA(this.ser, this.ser, content);
        }
    }

    void eOutput() throws SAXException {
        this.eE("Output");
    }

    void makeTemplateInfo(String tPath, String name, String descr) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        if (tPath != null) {
            atts.addAttribute("", "", "fileName", "String", tPath);
        }
        if (name != null) {
            atts.addAttribute("", "", "name", "String", name);
        }
        if (descr != null) {
            atts.addAttribute("", "", "description", "String", descr);
        }
        this.sE("Template", atts);
        this.eE("Template");
    }

    void makeProperty(String key, String val) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "", "name", "String", key);
        atts.addAttribute("", "", "value", "CDATA", val);
        this.sE("Property", atts);
        this.eE("Property");
    }

    void makeItem(String val) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "", "value", "CDATA", val);
        this.sE("Item", atts);
        this.eE("Item");
    }

    void makeItems(String[] vals) throws SAXException {
        if (vals != null) {
            for (int i = 0; i < vals.length; ++i) {
                if (vals[i] == null) continue;
                this.makeItem(vals[i]);
            }
        }
    }

    void makeItems(File[] files) throws SAXException {
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                this.makeItem(files[i].getPath());
            }
        }
    }

    private void sE(String name) throws SAXException {
        this.ser.startElement("", "", name, this.emptyAttr);
    }

    private void sE(String name, Attributes atts) throws SAXException {
        this.ser.startElement("", "", name, atts);
    }

    private void eE(String name) throws SAXException {
        this.ser.endElement("", "", name);
    }

    public static void writeCDATA(LexicalHandler lh, ContentHandler ser, String cdata) throws IOException, SAXException {
        cdata = XMLReportMaker.convertProhibitedChars(cdata);
        if (lh != null) {
            int start = 0;
            while (start < cdata.length()) {
                int end = cdata.length();
                int xpos = cdata.indexOf("]]>", start);
                if (xpos != -1) {
                    end = xpos + 1;
                }
                lh.startCDATA();
                String fragment = cdata.substring(start, end);
                ser.characters(fragment.toCharArray(), 0, fragment.length());
                lh.endCDATA();
                start = end;
            }
        }
    }

    public static String convertProhibitedChars(String cdata) {
        StringBuffer sb = new StringBuffer();
        char[] data = cdata.toCharArray();
        for (int i = 0; i < data.length; ++i) {
            if (XMLReportMaker.prohibited(data[i])) {
                sb.append("\\u");
                String rX = Integer.toHexString(data[i]);
                for (int ii = rX.length(); ii < 4; ++ii) {
                    sb.append("0");
                }
                sb.append(rX);
                continue;
            }
            sb.append(data[i]);
        }
        return sb.toString();
    }

    public static boolean prohibited(int c) {
        if (c == 9 || c == 10 || c == 13) {
            return false;
        }
        if (c >= 32 && c <= 55295) {
            return false;
        }
        if (c >= 57344 && c <= 65533) {
            return false;
        }
        return c < 65536 || c > 0x10FFFF;
    }

    private static class Scheme {
        private static final String REPORT = "Report";
        private static final String SUMMARY = "Summary";
        private static final String WDS = "WorkDirectories";
        private static final String WD = "WorkDirectory";
        private static final String TRS = "TestResults";
        private static final String TR = "TestResult";
        private static final String INT = "Interview";
        private static final String Q = "Question";
        private static final String DESCR_DATA = "DescriptionData";
        private static final String KEY_WORDS = "Keywords";
        private static final String TEST_ENV = "TestEnvironment";
        private static final String RES_PROP = "ResultProperties";
        private static final String TANNOT_DATA = "TestAnnotation";
        private static final String SES = "Sections";
        private static final String SE = "Section";
        private static final String OU = "Output";
        private static final String PR = "Property";
        private static final String IT = "Item";
        private static final String ENV = "Environment";
        private static final String CONC = "Concurrency";
        private static final String TIMO = "TimeOut";
        private static final String PRIOS = "PriorStatusList";
        private static final String EXCL_LIST = "ExcludeList";
        private static final String STD_VALS = "StandardValues";
        private static final String TESTS = "Tests";
        private static final String ENTTREE = "EntireTestTree";
        private static final String QUEST = "Question";
        private static final String LIST_QUEST = "ListQuestion";
        private static final String CHOICE_QUEST = "ChoiceQuestion";
        private static final String CHOICE = "Choice";
        private static final String PROP_QUEST = "PropertiesQuestion";
        private static final String GROUP = "Group";
        private static final String ROW = "Row";
        private static final String TEMPLATE = "Template";
        private static final String TR_URL = "url";
        private static final String TR_STATUS = "status";
        private static final String TR_WDID = "workDirID";
        private static final String PR_NAME = "name";
        private static final String PR_VAL = "value";
        private static final String IT_VAL = "value";
        private static final String SE_TIT = "title";
        private static final String SE_ST = "status";
        private static final String OU_TIT = "title";
        private static final String RES_PROP_TIM = "endTime";
        private static final String WD_ID = "id";
        private static final String WD_JTI = "jti";
        private static final String KEYWORDS_EXPR = "expression";
        private static final String REPORT_FORMST = "formatVersion";
        private static final String REPORT_GENTIME = "generatedTime";
        private static final String XSI = "xmlns:xsi";
        private static final String SCH_LOC = "xsi:noNamespaceSchemaLocation";
        private static final String QUEST_VALUE = "value";
        private static final String QUEST_TEXT = "text";
        private static final String QUEST_SUMM = "summary";
        private static final String CHOICE_CH = "choice";
        private static final String CHOICE_DCH = "displayChoice";
        private static final String CHOICE_VAL = "value";
        private static final String GROUP_NAME = "name";
        private static final String GROUP_HD1 = "header1";
        private static final String GROUP_HD2 = "header2";
        private static final String ROW_KEY = "key";
        private static final String ROW_VAL = "value";
        private static final String ENV_NAME = "name";
        private static final String ENV_DESCR = "description";
        private static final String TEM_NAME = "name";
        private static final String TEM_DESCRIPTION = "description";
        private static final String TEM_FILE = "fileName";
        private static final String XSI_VAL = "http://www.w3.org/2001/XMLSchema-instance";
        private static final String SCH_LOC_VAL = "Report.xsd";

        private Scheme() {
        }
    }
}

