/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.services;

import com.sun.javatest.TestSuite;
import com.sun.javatest.services.LocalConnector;
import com.sun.javatest.services.Service;
import com.sun.javatest.services.ServiceProperties;
import com.sun.javatest.services.ServiceReader;
import com.sun.javatest.services.TestPath;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLServiceReader
implements ServiceReader {
    private File xml;
    private Document doc;
    private TestSuite ts;
    public static final String SERVICES_XML = File.separator + "lib" + File.separator + "services.xml";

    @Override
    public void init(TestSuite ts, String[] args) {
        this.ts = ts;
        File tsRoot = ts.getRootDir();
        if (args == null || args.length == 0) {
            this.xml = new File(tsRoot, SERVICES_XML);
        } else {
            String path = args[0].replace("/", File.separator);
            this.xml = new File(tsRoot, path);
        }
        try {
            DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = domFactory.newDocumentBuilder();
            this.doc = parser.parse(this.xml);
        }
        catch (SAXException ex) {
        }
        catch (ParserConfigurationException ex) {
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    @Override
    public Map<String, Service> readServices() {
        ServiceProperties common = this.readProperties(this.doc);
        return this.readServices(this.doc, common);
    }

    @Override
    public Set<TestPath> readTestServiceMap() {
        HashSet<TestPath> result = new HashSet<TestPath>();
        NodeList paths = this.doc.getElementsByTagName("testpath");
        for (int i = 0; i < paths.getLength(); ++i) {
            Element path = (Element)paths.item(i);
            String regexp = null;
            String matcher = null;
            if (path.hasAttribute("path")) {
                regexp = path.getAttribute("path");
            }
            if (path.hasAttribute("matcher")) {
                matcher = path.getAttribute("matcher");
            }
            TestPath tPath = new TestPath(this.ts, regexp, matcher);
            NodeList refs = path.getElementsByTagName("service");
            for (int j = 0; j < refs.getLength(); ++j) {
                Element ref = (Element)refs.item(j);
                tPath.addService(ref.getAttribute("refid"));
            }
            result.add(tPath);
        }
        return result;
    }

    private ServiceProperties readProperties(Document doc) {
        ServiceProperties res = new ServiceProperties(null);
        NodeList imports = doc.getElementsByTagName("propertyfile");
        for (int i = 0; i < imports.getLength(); ++i) {
            try {
                Element elem = (Element)imports.item(i);
                String path = elem.getAttribute("file");
                File propFile = new File(this.xml.getAbsolutePath() + path);
                Properties props = new Properties();
                props.load(new FileInputStream(propFile));
                for (Object key : props.keySet()) {
                    String skey = (String)key;
                    res.addProperty(skey, props.getProperty(skey));
                }
                continue;
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        NodeList defs = doc.getElementsByTagName("property");
        for (int i = 0; i < defs.getLength(); ++i) {
            Element elem = (Element)defs.item(i);
            String key = elem.getAttribute("name");
            String value = null;
            if (elem.hasAttribute("value")) {
                value = elem.getAttribute("value");
            }
            res.addProperty(key, value);
        }
        if (res.isEmpty()) {
            return null;
        }
        return res;
    }

    private Map<String, Service> readServices(Document doc, ServiceProperties common) {
        TreeMap<String, Service> result = new TreeMap<String, Service>();
        Element root = doc.getDocumentElement();
        for (Node child = root.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element) || !((Element)child).getNodeName().equals("service")) continue;
            try {
                Element elem = (Element)child;
                String id = elem.getAttribute("id");
                String svClassName = elem.getAttribute("class");
                String descr = elem.getAttribute("description");
                Service service = (Service)this.ts.loadClass(svClassName).newInstance();
                service.setId(id);
                service.setDescription(descr);
                LocalConnector conn = new LocalConnector(service.getDefaultServiceExecutor());
                service.setConnector(conn);
                ServiceProperties servProps = new ServiceProperties(common);
                NodeList args = elem.getElementsByTagName("arg");
                for (int j = 0; j < args.getLength(); ++j) {
                    Element arg = (Element)args.item(j);
                    String key = arg.getAttribute("name");
                    String value = null;
                    if (arg.hasAttribute("value")) {
                        value = arg.getAttribute("value");
                    }
                    servProps.addProperty(key, value);
                }
                service.setProperties(servProps);
                result.put(service.getId(), service);
                continue;
            }
            catch (TestSuite.Fault ex) {
                continue;
            }
            catch (InstantiationException ex) {
                continue;
            }
            catch (IllegalAccessException ex) {
                // empty catch block
            }
        }
        return result;
    }
}

