/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.tool.Desktop;
import com.sun.javatest.tool.Preferences;
import com.sun.javatest.tool.UIFactory;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

class DesktopPrefsPane
extends Preferences.Pane {
    private Desktop desktop;
    private UIFactory uif;
    private ButtonGroup styleGrp;
    private JCheckBox ttipsCheck;
    private JComboBox ttDelay;
    private JComboBox ttDuration;
    private JCheckBox saveCheck;
    private JCheckBox restoreCheck;
    private Integer[] tooltipDurations;
    private Integer[] tooltipDelays;
    private static String TIP_SHOW_FOREVER;

    DesktopPrefsPane(Desktop desktop, UIFactory uif) {
        this.desktop = desktop;
        this.uif = uif;
        this.setHelp("ui.prefs.appearance.csh");
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.insets.bottom = 10;
        this.styleGrp = new ButtonGroup();
        this.add(this.createToolTipsPanel(), c);
        this.add(this.createShutdownPanel(), c);
        c.fill = 1;
        c.weighty = 1.0;
        this.add(Box.createVerticalGlue(), c);
    }

    public String getText() {
        return this.uif.getI18NString("dt.prefs.name");
    }

    public void load(Map m) {
        String tipState;
        String styleName = (String)m.get("tool.appearance.style");
        if (styleName == null) {
            styleName = Desktop.styleNames[this.desktop.getStyle()];
        }
        Enumeration<AbstractButton> e = this.styleGrp.getElements();
        while (e.hasMoreElements()) {
            JRadioButton rb = (JRadioButton)e.nextElement();
            if (!rb.getActionCommand().equals(styleName)) continue;
            rb.setSelected(true);
            break;
        }
        this.ttipsCheck.setSelected((tipState = (String)m.get("tool.appearance.ttipToggle")) == null || tipState.equalsIgnoreCase("true"));
        boolean complete = false;
        String tipDelay = (String)m.get("tool.appearance.ttipDelay");
        try {
            int delay = Integer.parseInt(tipDelay);
            if (delay == 0) {
                this.ttDelay.setSelectedItem(this.tooltipDelays[0]);
                complete = true;
            } else {
                for (int i = 1; i < this.ttDelay.getItemCount(); ++i) {
                    if ((Integer)this.ttDelay.getItemAt(i) != delay) continue;
                    this.ttDelay.setSelectedIndex(i);
                    i = this.ttDelay.getItemCount();
                    complete = true;
                }
            }
        }
        catch (NumberFormatException e2) {
            complete = false;
        }
        this.ttDelay.setEnabled(this.ttipsCheck.isSelected());
        this.ttDuration.setEnabled(this.ttipsCheck.isSelected());
        if (!complete) {
            this.ttDelay.setSelectedIndex(1);
        }
        complete = false;
        String tipDuration = (String)m.get("tool.appearance.ttipDuration");
        try {
            int duration = Integer.parseInt(tipDuration);
            if (duration == -1) {
                this.ttDuration.setSelectedItem(this.tooltipDurations[this.tooltipDurations.length - 1]);
                complete = true;
            } else {
                for (int i = 0; i < this.tooltipDurations.length - 1; ++i) {
                    if (duration != this.tooltipDurations[i]) continue;
                    this.ttDuration.setSelectedItem(this.tooltipDurations[i]);
                    complete = true;
                    i = this.tooltipDurations.length;
                }
            }
        }
        catch (NumberFormatException e3) {
            complete = false;
        }
        if (!complete) {
            this.ttDuration.setSelectedItem(this.tooltipDurations[1]);
        }
        this.syncTooltipPrefs();
        String saveState = (String)m.get("tool.appearance.saveOnExit");
        this.saveCheck.setSelected(saveState == null || "true".equalsIgnoreCase(saveState));
        String restoreState = (String)m.get("tool.appearance.restoreOnStart");
        this.restoreCheck.setSelected(restoreState == null || "true".equalsIgnoreCase(restoreState));
    }

    public void save(Map m) {
        ButtonModel bm = this.styleGrp.getSelection();
        if (bm != null) {
            String styleName = bm.getActionCommand();
            for (int i = 0; i < Desktop.styleNames.length; ++i) {
                if (!styleName.equals(Desktop.styleNames[i])) continue;
                this.desktop.setStyle(i);
                m.put("tool.appearance.style", styleName);
                break;
            }
        }
        boolean tips = this.ttipsCheck.isSelected();
        m.put("tool.appearance.ttipToggle", String.valueOf(tips));
        this.desktop.setTooltipsEnabled(tips);
        int delay = this.getTooltipDelay();
        m.put("tool.appearance.ttipDelay", Integer.toString(delay));
        this.desktop.setTooltipDelay(delay);
        int duration = this.getTooltipDuration();
        m.put("tool.appearance.ttipDuration", Integer.toString(duration));
        this.desktop.setTooltipDuration(duration);
        m.put("tool.appearance.saveOnExit", String.valueOf(this.saveCheck.isSelected()));
        this.desktop.setSaveOnExit(this.saveCheck.isSelected());
        m.put("tool.appearance.restoreOnStart", String.valueOf(this.restoreCheck.isSelected()));
        this.desktop.setRestoreOnStart(this.restoreCheck.isSelected());
        this.syncTooltipPrefs();
    }

    private void syncTooltipPrefs() {
        boolean tips = this.ttipsCheck.isSelected();
        this.desktop.setTooltipsEnabled(tips);
        int delay = this.getTooltipDelay();
        this.desktop.setTooltipDelay(delay);
        int duration = this.getTooltipDuration();
        this.desktop.setTooltipDuration(duration);
    }

    private Component createShutdownPanel() {
        Box p = Box.createVerticalBox();
        p.setBorder(this.uif.createTitledBorder("dt.prefs.shutdown"));
        this.saveCheck = this.uif.createCheckBox("dt.prefs.saveOnExit");
        p.add(this.saveCheck);
        this.restoreCheck = this.uif.createCheckBox("dt.prefs.restoreOnStart");
        p.add(this.restoreCheck);
        p.add(Box.createVerticalGlue());
        return p;
    }

    private Component createToolTipsPanel() {
        int i;
        JPanel p = this.uif.createPanel("dt.prefs.tt", false);
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.ipadx = 3;
        c.ipady = 5;
        c.fill = 3;
        c.insets.left = 3;
        c.insets.right = 3;
        c.insets.top = 2;
        c.insets.bottom = 2;
        p.setBorder(this.uif.createTitledBorder("dt.prefs.ttips"));
        this.ttipsCheck = this.uif.createCheckBox("dt.prefs.ttips");
        this.uif.setAccessibleName(this.ttipsCheck, "dt.prefs.ttips");
        this.ttipsCheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean state = DesktopPrefsPane.this.ttipsCheck.isSelected();
                DesktopPrefsPane.this.ttDelay.setEnabled(state);
                DesktopPrefsPane.this.ttDuration.setEnabled(state);
            }
        });
        c.gridwidth = 0;
        c.weightx = 1.0;
        p.add((Component)this.ttipsCheck, c);
        this.loadTooltipResources();
        JLabel l = this.uif.createLabel("dt.prefs.ttDelay", true);
        this.ttDelay = this.uif.createChoice("dt.prefs.ttDelay", l);
        for (i = 0; i < this.tooltipDelays.length; ++i) {
            this.ttDelay.addItem(this.tooltipDelays[i]);
        }
        this.ttDelay.setSelectedItem(this.tooltipDelays[0]);
        this.ttDelay.setRenderer(new TipDelayRenderer());
        c.gridwidth = 1;
        c.weightx = 0.0;
        p.add((Component)l, c);
        c.gridwidth = 0;
        c.weightx = 1.0;
        p.add((Component)this.ttDelay, c);
        l = this.uif.createLabel("dt.prefs.ttDuration", true);
        this.ttDuration = this.uif.createChoice("dt.prefs.ttDuration", l);
        for (i = 0; i < this.tooltipDurations.length; ++i) {
            this.ttDuration.addItem(this.tooltipDurations[i]);
        }
        this.ttDuration.setRenderer(new TipDurationRenderer());
        this.ttDuration.setSelectedItem(this.tooltipDurations[Math.max(this.tooltipDurations.length - 2, 0)]);
        c.gridwidth = 1;
        c.weightx = 0.0;
        p.add((Component)l, c);
        c.gridwidth = 0;
        c.weightx = 1.0;
        p.add((Component)this.ttDuration, c);
        return p;
    }

    private void loadTooltipResources() {
        this.tooltipDurations = new Integer[]{new Integer(1000), new Integer(2000), new Integer(3000), new Integer(5000), new Integer(10000), new Integer(15000), new Integer(-1)};
        this.tooltipDelays = new Integer[]{new Integer(0), new Integer(1000), new Integer(2000), new Integer(3000), new Integer(5000), new Integer(10000)};
    }

    private int getTooltipDelay() {
        Integer value = (Integer)this.ttDelay.getSelectedItem();
        return value;
    }

    private int getTooltipDuration() {
        int value = (Integer)this.ttDuration.getSelectedItem();
        return value < 0 ? -1 : value;
    }

    private class TipDurationRenderer
    extends BasicComboBoxRenderer {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        TipDurationRenderer() {
            DesktopPrefsPane desktopPrefsPane2 = DesktopPrefsPane.this;
            synchronized (desktopPrefsPane2) {
                if (TIP_SHOW_FOREVER == null) {
                    TIP_SHOW_FOREVER = DesktopPrefsPane.this.uif.getI18NString("dt.prefs.ttDuration.forev");
                }
            }
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            int val;
            Object theVal = value instanceof Integer ? ((val = ((Integer)value).intValue()) > 0 ? DesktopPrefsPane.this.uif.getI18NString("dt.prefs.ttDuration.sec", new Integer(val / 1000)) : TIP_SHOW_FOREVER) : value;
            return super.getListCellRendererComponent((JList<?>)list, theVal, index, isSelected, cellHasFocus);
        }
    }

    private class TipDelayRenderer
    extends BasicComboBoxRenderer {
        private TipDelayRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Object theVal;
            if (value instanceof Integer) {
                int val = (Integer)value;
                theVal = DesktopPrefsPane.this.uif.getI18NString("dt.prefs.ttDelay", new Integer(val / 1000));
            } else {
                theVal = value;
            }
            return super.getListCellRendererComponent((JList<?>)list, theVal, index, isSelected, cellHasFocus);
        }
    }
}

