/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.tool.EditableList;
import java.io.File;
import javax.swing.JFileChooser;

public class EditableFileList
extends EditableList {
    private JFileChooser chooser;
    private File baseDir;

    public EditableFileList() {
    }

    public EditableFileList(JFileChooser c) {
        this.setChooser(c);
    }

    public void setBaseDirectory(File dir) {
        this.baseDir = dir;
        if (this.chooser != null) {
            if (dir == null) {
                dir = new File(System.getProperty("user.dir"));
            }
            this.chooser.setCurrentDirectory(dir);
        }
    }

    public void setChooser(JFileChooser c) {
        if (c == null) {
            throw new NullPointerException();
        }
        this.chooser = c;
    }

    public void setItems(Object[] items) {
        this.listModel.clear();
        if (items == null) {
            return;
        }
        for (int i = 0; i < items.length; ++i) {
            Object o = items[i];
            if (o instanceof File) {
                this.listModel.addElement(o);
                continue;
            }
            if (o instanceof String) {
                this.listModel.addElement(new File((String)o));
                continue;
            }
            throw new IllegalArgumentException(o.toString());
        }
    }

    public File[] getFiles() {
        Object[] files = new File[this.listModel.size()];
        this.listModel.copyInto(files);
        return files;
    }

    public void setFiles(File[] files) {
        this.setItems(files);
    }

    protected Object getNewItem() {
        int opt;
        if (this.chooser == null) {
            this.chooser = new JFileChooser();
        }
        if ((opt = this.chooser.showDialog(this, this.uif.getI18NString("list.add.select.txt"))) != 0) {
            return null;
        }
        File f = this.chooser.getSelectedFile();
        if (this.baseDir != null) {
            String bp = this.baseDir.getPath();
            if (f.getPath().startsWith(bp + File.separatorChar)) {
                f = new File(f.getPath().substring(bp.length() + 1));
            }
        }
        return f;
    }
}

