/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool.selectiontree;

import com.sun.javatest.tool.Main;
import com.sun.javatest.tool.selectiontree.SelectionTreeFilter;
import com.sun.javatest.tool.selectiontree.SelectionTreeListener;
import com.sun.javatest.tool.selectiontree.SelectionTreeNode;
import com.sun.javatest.tool.selectiontree.selection.SelectionElement;
import com.sun.javatest.tool.selectiontree.selection.SelectionType;
import com.sun.javatest.tool.selectiontree.selection.StyledSelectionElement;
import com.sun.javatest.util.I18NResourceBundle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectionTree
extends JTree {
    private static final int TOOLTIP_UI_TEXT_GAP = 3;
    private static final I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(SelectionTree.class);
    private static final Icon selectedIcon = SelectionTree.getIcon("SelectAll.icon");
    private static final Icon unselectedIcon = SelectionTree.getIcon("DeselectAll.icon");
    private static final Icon partiallySelectedIcon = SelectionTree.getIcon("partial.icon");
    private static final int checkSize = selectedIcon.getIconWidth();
    private static final int checkBorderSize = 1;
    private final Action selectAllAction = this.createAction("SelectAll");
    private final Action deselectAllAction = this.createAction("DeselectAll");
    private final Action expandAllAction = this.createAction("ExpandAll");
    private final Action collapseAllAction = this.createAction("CollapseAll");
    private List<SelectionTreeListener> listeners = new ArrayList<SelectionTreeListener>();
    private SelectionTreeFilter filter = null;

    public SelectionTree(SelectionElement rootObject) {
        this(rootObject, null, true);
    }

    public SelectionTree(SelectionElement rootObject, SelectionTreeFilter filter) {
        this(rootObject, filter, true);
    }

    public SelectionTree(SelectionElement rootObject, boolean rootIsVisible) {
        this(rootObject, null, rootIsVisible);
    }

    public SelectionTree(SelectionElement rootObject, SelectionTreeFilter filter, boolean rootIsVisible) {
        this.filter = filter;
        this.setModel(new DefaultTreeModel(new SelectionTreeNode(this, filter, rootObject, null)));
        this.setRootVisible(rootIsVisible);
        this.getSelectionModel().setSelectionMode(1);
        this.setCellRenderer(new SelectionTreeCellRenderer());
        this.addMouseListener(new SelectionTreeMouseListener());
        this.addKeyListener(new SelectionTreeKeyListener());
        this.setLargeModel(true);
        ToolTipManager.sharedInstance().registerComponent(this);
        AbstractAction popupMenuAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Rectangle nodeRect;
                if (!this.isEnabled()) {
                    return;
                }
                TreePath treePath = SelectionTree.this.getSelectionPath();
                if (treePath != null && (nodeRect = SelectionTree.this.getPathBounds(treePath)) != null) {
                    SelectionTree.this.showPopupMenu(nodeRect.x, nodeRect.y + nodeRect.height);
                }
            }
        };
        this.addActionAccelerator(KeyStroke.getKeyStroke(525, 0), popupMenuAction);
        this.addActionAccelerator(KeyStroke.getKeyStroke(121, 64), popupMenuAction);
    }

    private static Icon getIcon(String iconResource) {
        try {
            return new ImageIcon(ImageIO.read(Main.class.getResourceAsStream(i18n.getString(iconResource))));
        }
        catch (IOException e) {
            return null;
        }
    }

    private Action createAction(String actionID) {
        return this.createAction(actionID, i18n, null);
    }

    protected Action createAction(String actionID, I18NResourceBundle i18n, ActionListener actionListener) {
        SelectionTreeAction action = new SelectionTreeAction(actionListener);
        action.putValue("Name", i18n.getString(actionID + ".name"));
        try {
            String mnemonic = i18n.getString(actionID + ".mnemonic");
            Field field = KeyEvent.class.getField(mnemonic);
            action.putValue("MnemonicKey", new Integer(field.getInt(null)));
        }
        catch (Exception ex) {
            // empty catch block
        }
        action.putValue("ShortDescription", i18n.getString(actionID + ".tooltip"));
        String acceleratorKey = i18n.getOptionalString(actionID + ".accelerator");
        if (acceleratorKey != null) {
            this.addActionAccelerator(KeyStroke.getKeyStroke(acceleratorKey), action);
        }
        return action;
    }

    private void addActionAccelerator(KeyStroke keyStroke, Action action) {
        action.putValue("AcceleratorKey", keyStroke);
        this.getInputMap(1).put(keyStroke, keyStroke);
        this.getActionMap().put(keyStroke, action);
    }

    public void resetData(SelectionElement newRootObject) {
        this.setModel(new DefaultTreeModel(new SelectionTreeNode(this, this.filter, newRootObject, null)));
    }

    public boolean isParentDependsOnChildren() {
        return true;
    }

    private void fireAction(SelectionTreeAction action) {
        if (action == this.selectAllAction) {
            this.selectAll(true);
        } else if (action == this.deselectAllAction) {
            this.deselectAll(true);
        } else if (action == this.expandAllAction) {
            this.expandAll(true);
        } else if (action == this.collapseAllAction) {
            this.collapseAll(true);
        }
    }

    private boolean isRowDescendsFromSelected(int row) {
        for (TreePath path = this.getPathForRow(row); path != null; path = path.getParentPath()) {
            if (!this.isPathSelected(path)) continue;
            return true;
        }
        return false;
    }

    public void expandAll() {
        this.expandAll(false);
    }

    public void expandAll(boolean considerSelection) {
        boolean hasSelection = this.getSelectionCount() > 0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (considerSelection && hasSelection && !this.isRowDescendsFromSelected(i)) continue;
            this.expandRow(i);
        }
    }

    public void collapseAll() {
        this.collapseAll(false);
    }

    public void collapseAll(boolean considerSelection) {
        boolean hasSelection = this.getSelectionCount() > 0;
        for (int i = this.getRowCount() - 1; i >= 0; --i) {
            TreePath path = this.getPathForRow(i);
            if (path.getPath().length <= 1 || considerSelection && hasSelection && !this.isRowDescendsFromSelected(i)) continue;
            this.collapseRow(i);
        }
    }

    private void deselectNodeWithChildren(SelectionTreeNode node) {
        node.changeSelection(SelectionType.UNSELECTED);
        Enumeration<SelectionTreeNode> childrenEnum = node.children();
        while (childrenEnum.hasMoreElements()) {
            this.deselectNodeWithChildren(childrenEnum.nextElement());
        }
    }

    private void selectNodeWithChildren(SelectionTreeNode node) {
        node.changeSelection(SelectionType.SELECTED);
        Enumeration<SelectionTreeNode> childrenEnum = node.children();
        while (childrenEnum.hasMoreElements()) {
            this.selectNodeWithChildren(childrenEnum.nextElement());
        }
    }

    public void selectAll() {
        this.selectAll(false);
    }

    public void selectAll(boolean considerSelection) {
        ArrayList<SelectionTreeNode> selNodes = new ArrayList<SelectionTreeNode>();
        if (considerSelection) {
            selNodes.addAll(this.getSelectedNodes());
        }
        if (selNodes.isEmpty()) {
            selNodes.add((SelectionTreeNode)this.getModel().getRoot());
        }
        this.fireSelectionChangeStarted(null);
        for (SelectionTreeNode selNode : selNodes) {
            this.selectNodeWithChildren(selNode);
        }
        this.fireSelectionChangeFinished(null);
    }

    public void deselectAll() {
        this.deselectAll(false);
    }

    public void deselectAll(boolean considerSelection) {
        ArrayList<SelectionTreeNode> selNodes = new ArrayList<SelectionTreeNode>();
        if (considerSelection) {
            selNodes.addAll(this.getSelectedNodes());
        }
        if (selNodes.isEmpty()) {
            selNodes.add((SelectionTreeNode)this.getModel().getRoot());
        }
        this.fireSelectionChangeStarted(null);
        for (SelectionTreeNode selNode : selNodes) {
            this.deselectNodeWithChildren(selNode);
        }
        this.fireSelectionChangeFinished(null);
    }

    private int getDeep(SelectionTreeNode node) {
        int childrenDeep = 0;
        Enumeration<SelectionTreeNode> childrenEnum = node.children();
        while (childrenEnum.hasMoreElements()) {
            childrenDeep = Math.max(childrenDeep, this.getDeep(childrenEnum.nextElement()));
        }
        return childrenDeep + 1;
    }

    private int getDeep() {
        return this.getDeep((SelectionTreeNode)this.getModel().getRoot());
    }

    protected void addActionsToPopupMenu(JPopupMenu popupMenu) {
        popupMenu.add(this.selectAllAction);
        popupMenu.add(this.deselectAllAction);
        if (this.getDeep() > 2) {
            popupMenu.addSeparator();
            popupMenu.add(this.expandAllAction);
            popupMenu.add(this.collapseAllAction);
        }
    }

    public SelectionTreeNode getSelectedNode() {
        Object obj;
        TreePath treePath = this.getSelectionPath();
        if (treePath != null && (obj = treePath.getLastPathComponent()) instanceof SelectionTreeNode) {
            return (SelectionTreeNode)obj;
        }
        return null;
    }

    public Collection<SelectionTreeNode> getSelectedNodes() {
        TreePath[] paths = this.getSelectionPaths();
        ArrayList<SelectionTreeNode> result = new ArrayList<SelectionTreeNode>();
        if (paths != null) {
            for (int i = 0; i < paths.length; ++i) {
                Object obj;
                TreePath treePath = paths[i];
                if (treePath == null || !((obj = treePath.getLastPathComponent()) instanceof SelectionTreeNode)) continue;
                result.add((SelectionTreeNode)obj);
            }
        }
        return result;
    }

    public void refreshContents() {
        Map<SelectionElement, Object> expanded = this.getExpandedElementsHierarchy();
        SelectionTreeNode sel = this.getSelectedNode();
        SelectionElement[] selPath = null;
        if (sel != null) {
            Object[] path = sel.getPath().getPath();
            selPath = new SelectionElement[path.length];
            for (int i = 0; i < path.length; ++i) {
                SelectionTreeNode node = (SelectionTreeNode)path[i];
                selPath[i] = node.getSelectionElement();
            }
        }
        this.setModel(new DefaultTreeModel(new SelectionTreeNode(this, this.filter, ((SelectionTreeNode)this.getModel().getRoot()).getSelectionElement(), null)));
        if (this.isParentDependsOnChildren()) {
            this.updateSelection((SelectionTreeNode)this.getModel().getRoot());
        }
        List<SelectionTreeNode> firstLevel = Collections.singletonList((SelectionTreeNode)this.getModel().getRoot());
        this.expandHierarchyMap(firstLevel, expanded);
        Enumeration<SelectionTreeNode> curLevel = Collections.enumeration(firstLevel);
        SelectionTreeNode newSel = null;
        if (selPath != null) {
            for (int i = 0; i < selPath.length && curLevel != null; ++i) {
                SelectionElement selected = selPath[i];
                SelectionTreeNode levelSel = null;
                while (curLevel.hasMoreElements() && levelSel == null) {
                    SelectionTreeNode node = curLevel.nextElement();
                    SelectionElement nodeElement = node.getSelectionElement();
                    if (nodeElement != selected && !nodeElement.equals(selected)) continue;
                    levelSel = node;
                }
                if (levelSel == null) {
                    curLevel = null;
                    continue;
                }
                if (i == selPath.length - 1) {
                    newSel = levelSel;
                    continue;
                }
                curLevel = levelSel.children();
            }
        }
        if (newSel != null) {
            TreePath toSelect = newSel.getPath();
            this.scrollPathToVisible(toSelect);
            this.setSelectionPath(toSelect);
        }
    }

    public void expandElementsHierarchy(Map<SelectionElement, Object> expanded) {
        if (expanded == null) {
            return;
        }
        List<SelectionTreeNode> firstLevel = Collections.singletonList((SelectionTreeNode)this.getModel().getRoot());
        this.expandHierarchyMap(firstLevel, expanded);
    }

    public Map<SelectionElement, Object> getExpandedElementsHierarchy() {
        HashMap<SelectionElement, Object> expanded = new HashMap<SelectionElement, Object>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            TreePath path = this.getPathForRow(i);
            Object[] toExpand = path.getPath();
            Map<SelectionElement, Object> curExMap = expanded;
            for (int j = 0; j < toExpand.length - 1; ++j) {
                SelectionTreeNode node = (SelectionTreeNode)toExpand[j];
                SelectionElement nodeObject = node.getSelectionElement();
                if (!curExMap.containsKey(nodeObject)) {
                    curExMap.put(nodeObject, new HashMap());
                }
                curExMap = (Map)curExMap.get(nodeObject);
            }
        }
        return expanded;
    }

    private void updateSelection(SelectionTreeNode node) {
        Enumeration<SelectionTreeNode> children = node.children();
        if (children.hasMoreElements()) {
            while (children.hasMoreElements()) {
                this.updateSelection(children.nextElement());
            }
        } else {
            node.updateSelection(true);
        }
    }

    public void updateView() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            TreePath path = this.getPathForRow(i);
            ((SelectionTreeNode)path.getLastPathComponent()).updateNode();
        }
    }

    public SelectionTreeNode findNodeByObject(final SelectionElement nodeObject, SelectionTreeNode startingFrom, boolean forward) {
        if (nodeObject == null) {
            return null;
        }
        return this.findNodeByObjectFilter(new SelectionTreeFilter(){

            public boolean accept(SelectionElement candidateNodeObject) {
                return candidateNodeObject == nodeObject;
            }
        }, startingFrom, forward);
    }

    public SelectionTreeNode findNodeByObjectFilter(SelectionTreeFilter objectFilter, SelectionTreeNode startingFrom, boolean forward) {
        SelectionTreeNode firstNode;
        SelectionTreeNode lastNode = firstNode = (SelectionTreeNode)this.getModel().getRoot();
        while (lastNode.getChildCount() > 0) {
            lastNode = lastNode.getChildAt(lastNode.getChildCount() - 1);
        }
        if (!this.isRootVisible()) {
            firstNode = firstNode.getNextNode();
            if (lastNode == this.getModel().getRoot()) {
                return null;
            }
        }
        if (startingFrom == null) {
            startingFrom = forward ? firstNode : lastNode;
        }
        SelectionTreeNode node = startingFrom;
        while (node != (forward ? lastNode.getNextNode() : firstNode.getPreviousNode())) {
            if (objectFilter.accept(node.getSelectionElement())) {
                return node;
            }
            node = forward ? node.getNextNode() : node.getPreviousNode();
        }
        SelectionTreeNode selectionTreeNode = node = forward ? firstNode : lastNode;
        while (node != startingFrom) {
            if (objectFilter.accept(node.getSelectionElement())) {
                return node;
            }
            node = forward ? node.getNextNode() : node.getPreviousNode();
        }
        return null;
    }

    private void expandHierarchyMap(List<SelectionTreeNode> curLevelNodes, Map<SelectionElement, Object> expanded) {
        for (Map.Entry<SelectionElement, Object> entry : expanded.entrySet()) {
            SelectionElement nodeObject = entry.getKey();
            SelectionTreeNode nodeToExpand = null;
            for (SelectionTreeNode node : curLevelNodes) {
                SelectionElement nodeElement = node.getSelectionElement();
                if (nodeElement != nodeObject && !nodeElement.equals(nodeObject)) continue;
                nodeToExpand = node;
            }
            if (nodeToExpand == null) continue;
            this.expandPath(nodeToExpand.getPath());
            ArrayList<SelectionTreeNode> subLevel = new ArrayList<SelectionTreeNode>();
            Enumeration<SelectionTreeNode> children = nodeToExpand.children();
            while (children.hasMoreElements()) {
                subLevel.add(children.nextElement());
            }
            this.expandHierarchyMap(subLevel, (Map)entry.getValue());
        }
    }

    public synchronized void addSelectionTreeListener(SelectionTreeListener selectionTreeListener) {
        this.listeners.add(selectionTreeListener);
    }

    public synchronized void removeSelectionTreeListener(SelectionTreeListener selectionTreeListener) {
        this.listeners.remove(selectionTreeListener);
    }

    protected void fireSelectionTypeChanged(SelectionTreeNode node, SelectionType oldType, SelectionType newType) {
        if (this.listeners != null) {
            Iterator<SelectionTreeListener> iter = this.listeners.iterator();
            while (iter.hasNext()) {
                iter.next().selectionTypeChanged(node, oldType, newType);
            }
        }
    }

    protected void fireSelectionChangeStarted(SelectionTreeNode node) {
        if (this.listeners != null) {
            Iterator<SelectionTreeListener> iter = this.listeners.iterator();
            while (iter.hasNext()) {
                iter.next().selectionChangeStarted(node);
            }
        }
    }

    protected void fireSelectionChangeFinished(SelectionTreeNode node) {
        if (this.listeners != null) {
            Iterator<SelectionTreeListener> iter = this.listeners.iterator();
            while (iter.hasNext()) {
                iter.next().selectionChangeFinished(node);
            }
        }
    }

    protected boolean isRootSelectable() {
        return true;
    }

    public String[] getSelection() {
        Vector v = new Vector();
        this.getSelection((SelectionTreeNode)this.getModel().getRoot(), v);
        Object[] paths = new String[v.size()];
        v.copyInto(paths);
        return paths;
    }

    private void getSelection(SelectionTreeNode node, Vector v) {
        switch (node.getSelectionType()) {
            case UNSELECTED: {
                break;
            }
            case PARTIALLY_SELECTED: {
                for (int i = 0; i < node.getChildCount(); ++i) {
                    this.getSelection(node.getChildAt(i), v);
                }
                break;
            }
            case SELECTED: {
                v.add(this.getPath(node));
            }
        }
    }

    protected String getPath(SelectionTreeNode node) {
        return this.getPath(node, 0).toString();
    }

    private StringBuffer getPath(SelectionTreeNode node, int length) {
        if (node.getParent() == null) {
            return new StringBuffer(length);
        }
        String nodeName = node.getSelectionElement().getDisplayableName();
        StringBuffer sb = this.getPath(node.getParent(), 1 + nodeName.length() + length);
        if (sb.length() > 0) {
            sb.append("/");
        }
        sb.append(nodeName);
        return sb;
    }

    @Override
    public boolean isSelectionEmpty() {
        return ((SelectionTreeNode)this.getModel().getRoot()).getSelectionType() == SelectionType.UNSELECTED;
    }

    public void setSelection(String[] paths) {
        if (paths == null || paths.length == 0) {
            ((SelectionTreeNode)this.getModel().getRoot()).changeSelection(SelectionType.SELECTED);
        } else {
            ((SelectionTreeNode)this.getModel().getRoot()).changeSelection(SelectionType.UNSELECTED);
            if (paths != null) {
                for (int i = 0; i < paths.length; ++i) {
                    SelectionTreeNode node = this.getNode((SelectionTreeNode)this.getModel().getRoot(), paths[i]);
                    if (node == null) continue;
                    node.changeSelection(SelectionType.SELECTED);
                }
            }
        }
    }

    private SelectionTreeNode getNode(SelectionTreeNode node, String path) {
        String tail;
        String head;
        if (node == null) {
            throw new NullPointerException();
        }
        if (path.length() == 0) {
            return node;
        }
        int sep = path.indexOf("/");
        if (sep == -1) {
            head = path;
            tail = null;
        } else {
            head = path.substring(0, sep);
            tail = path.substring(sep + 1);
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            SelectionTreeNode c = node.getChildAt(i);
            if (!c.getSelectionElement().getDisplayableName().equals(head)) continue;
            return tail == null ? c : this.getNode(c, tail);
        }
        return null;
    }

    @Override
    public Point getToolTipLocation(MouseEvent event) {
        return ((SelectionTreeCellRenderer)this.getCellRenderer()).getToolTipLocation(event);
    }

    private void showPopupMenu(int x, int y) {
        JPopupMenu popupMenu = new JPopupMenu();
        this.addActionsToPopupMenu(popupMenu);
        popupMenu.show(this, x, y);
    }

    private class SelectionTreeAction
    extends AbstractAction {
        private ActionListener actionListener;

        public SelectionTreeAction(ActionListener actionListener) {
            this.actionListener = actionListener;
        }

        public void actionPerformed(final ActionEvent e) {
            new Thread(new Runnable(){

                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (SelectionTreeAction.this.actionListener != null) {
                                SelectionTreeAction.this.actionListener.actionPerformed(e);
                            } else {
                                SelectionTree.this.fireAction(SelectionTreeAction.this);
                            }
                        }
                    });
                }
            }, "Selection Tree Action Thread").start();
        }
    }

    private class SelectionTreeKeyListener
    extends KeyAdapter {
        private SelectionTreeKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            Object obj;
            TreePath treePath;
            if (SelectionTree.this.isEnabled() && e.getKeyCode() == 32 && (treePath = SelectionTree.this.getSelectionPath()) != null && (obj = treePath.getLastPathComponent()) instanceof SelectionTreeNode) {
                SelectionTreeNode node = (SelectionTreeNode)obj;
                node.changeSelection();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        SelectionTree.this.setSelectionPath(treePath);
                    }
                });
                return;
            }
        }
    }

    private class SelectionTreeMouseListener
    extends MouseAdapter {
        private TreePath treePath = null;

        private SelectionTreeMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            this.treePath = SelectionTree.this.getPathForLocation(e.getX(), e.getY());
        }

        public void mouseClicked(MouseEvent e) {
            if (SelectionTree.this.isEnabled() && e.getClickCount() == 1) {
                if (e.getButton() == 1) {
                    Object obj;
                    if (this.treePath != null && (obj = this.treePath.getLastPathComponent()) instanceof SelectionTreeNode) {
                        SelectionTreeNode node = (SelectionTreeNode)obj;
                        int checkAreaSize = checkSize - 2;
                        Rectangle r = SelectionTree.this.getPathBounds(this.treePath);
                        if (r != null) {
                            int yPos = (r.height - checkAreaSize) / 2 + (int)r.getY();
                            Rectangle btn = new Rectangle((int)r.getX() + 1, yPos, checkAreaSize, checkAreaSize);
                            if (btn.contains(e.getX(), e.getY())) {
                                node.changeSelection();
                                return;
                            }
                        }
                    }
                } else if (e.getButton() == 3) {
                    this.treePath = SelectionTree.this.getPathForLocation(e.getX(), e.getY());
                    if (e.isControlDown()) {
                        if (SelectionTree.this.isPathSelected(this.treePath)) {
                            SelectionTree.this.removeSelectionPath(this.treePath);
                        } else {
                            SelectionTree.this.addSelectionPath(this.treePath);
                            SelectionTree.this.setAnchorSelectionPath(this.treePath);
                            SelectionTree.this.setLeadSelectionPath(this.treePath);
                        }
                    } else if (e.isShiftDown()) {
                        int anchorRow;
                        TreePath anchor = SelectionTree.this.getAnchorSelectionPath();
                        int n = anchorRow = anchor == null ? -1 : SelectionTree.this.getRowForPath(anchor);
                        if (anchorRow == -1 || SelectionTree.this.getSelectionModel().getSelectionMode() == 1) {
                            SelectionTree.this.setSelectionPath(this.treePath);
                        } else {
                            int row = SelectionTree.this.getRowForPath(this.treePath);
                            TreePath lastAnchorPath = anchor;
                            if (row < anchorRow) {
                                SelectionTree.this.setSelectionInterval(row, anchorRow);
                            } else {
                                SelectionTree.this.setSelectionInterval(anchorRow, row);
                            }
                            SelectionTree.this.setAnchorSelectionPath(lastAnchorPath);
                            SelectionTree.this.setLeadSelectionPath(this.treePath);
                        }
                    } else {
                        SelectionTree.this.setSelectionPath(this.treePath);
                    }
                    SelectionTree.this.showPopupMenu(e.getX(), e.getY());
                    return;
                }
            }
        }
    }

    private class SelectionTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private boolean ignoreToolTip = false;

        private SelectionTreeCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Icon icon;
            boolean isRootNode;
            SelectionTreeNode node = (SelectionTreeNode)value;
            SelectionElement selectionElement = node.getSelectionElement();
            Object rootNode = SelectionTree.this.getModel().getRoot();
            boolean bl = isRootNode = node == rootNode || !SelectionTree.this.isRootVisible() && node.getParent() == rootNode;
            if (isRootNode && !SelectionTree.this.isRootSelectable()) {
                icon = null;
            } else {
                switch (selectionElement.getSelectionType()) {
                    case SELECTED: {
                        icon = selectedIcon;
                        break;
                    }
                    case PARTIALLY_SELECTED: {
                        icon = partiallySelectedIcon;
                        break;
                    }
                    default: {
                        icon = unselectedIcon;
                    }
                }
            }
            this.setIcon(icon);
            if (!this.ignoreToolTip) {
                this.ignoreToolTip = true;
                this.setToolTipText(null);
                Rectangle rect = SelectionTree.this.getPathBounds(node.getPath());
                if (rect != null && (!tree.getVisibleRect().contains(rect) || selectionElement.isToolTipAlwaysShown())) {
                    this.setToolTipText(selectionElement.getToolTip());
                }
                this.ignoreToolTip = false;
            }
            this.setText(selectionElement.getDisplayableName());
            Font oldFont = this.getFont();
            if (oldFont != null) {
                this.setFont(oldFont.deriveFont(selectionElement instanceof StyledSelectionElement ? ((StyledSelectionElement)selectionElement).getFontStyle() : 0));
            }
            this.hasFocus = hasFocus;
            this.selected = sel;
            this.setVerticalTextPosition(0);
            Color foregroundColor = null;
            if (selectionElement instanceof StyledSelectionElement) {
                foregroundColor = ((StyledSelectionElement)selectionElement).getColor();
            }
            if (foregroundColor == null) {
                foregroundColor = sel ? this.getTextSelectionColor() : this.getTextNonSelectionColor();
            }
            this.setForeground(foregroundColor);
            this.setEnabled(tree.isEnabled());
            this.setComponentOrientation(tree.getComponentOrientation());
            return this;
        }

        public Point getToolTipLocation(MouseEvent e) {
            Rectangle r;
            TreePath treePath = SelectionTree.this.getPathForLocation(e.getX(), e.getY());
            if (treePath != null && (r = SelectionTree.this.getPathBounds(treePath)) != null) {
                Insets tooltipInsets = SelectionTree.this.createToolTip().getInsets();
                Object rootNode = SelectionTree.this.getModel().getRoot();
                TreeNode node = (TreeNode)treePath.getLastPathComponent();
                boolean isRootNode = node == rootNode || !SelectionTree.this.isRootVisible() && node.getParent() == rootNode;
                int iconSpace = 0;
                if (!isRootNode || SelectionTree.this.isRootSelectable()) {
                    iconSpace = checkSize + this.getIconTextGap();
                }
                return new Point(r.x + iconSpace - tooltipInsets.left - 3, r.y);
            }
            return super.getToolTipLocation(e);
        }
    }
}

