/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool.selectiontree;

import com.sun.javatest.tool.selectiontree.SelectionTree;
import com.sun.javatest.tool.selectiontree.SelectionTreeFilter;
import com.sun.javatest.tool.selectiontree.selection.SelectionElement;
import com.sun.javatest.tool.selectiontree.selection.SelectionType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectionTreeNode
implements TreeNode {
    private List<SelectionTreeNode> children;
    private SelectionTreeNode parent;
    private SelectionElement element;
    private SelectionTree tree = null;
    private SelectionTreeNode nextNode;
    private SelectionTreeNode previousNode;

    public SelectionTreeNode(SelectionTree tree, SelectionTreeFilter filter, SelectionElement element, SelectionTreeNode previousNode) {
        this(tree, element, filter, null, previousNode);
    }

    public SelectionTreeNode(SelectionTree tree, SelectionElement element, SelectionTreeFilter filter, SelectionTreeNode parent, SelectionTreeNode previousNode) {
        this.parent = parent;
        this.element = element;
        this.tree = tree;
        this.previousNode = previousNode;
        if (previousNode != null) {
            previousNode.nextNode = this;
        }
        this.createChildren(filter);
    }

    private void createChildren(SelectionTreeFilter filter) {
        ArrayList<SelectionTreeNode> children = new ArrayList<SelectionTreeNode>();
        SelectionTreeNode prevNode = this;
        if (this.element.getChildren() != null) {
            ListIterator<SelectionElement> iter = this.element.getChildren().listIterator();
            while (iter.hasNext()) {
                int childCount;
                SelectionTreeNode node;
                SelectionElement child = iter.next();
                if (filter != null && !filter.accept(child)) continue;
                prevNode = node = new SelectionTreeNode(this.tree, child, filter, this, prevNode);
                while ((childCount = prevNode.getChildCount()) > 0) {
                    prevNode = prevNode.getChildAt(childCount - 1);
                }
                children.add(node);
            }
        }
        this.children = children;
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public boolean getAllowsChildren() {
        return !this.children.isEmpty();
    }

    @Override
    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public Enumeration<SelectionTreeNode> children() {
        return Collections.enumeration(this.children);
    }

    @Override
    public SelectionTreeNode getParent() {
        return this.parent;
    }

    @Override
    public SelectionTreeNode getChildAt(int childIndex) {
        return this.children.get(childIndex);
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.children.indexOf(node);
    }

    protected void changeSelection() {
        SelectionType newType;
        if (this.getSelectionType().equals((Object)SelectionType.PARTIALLY_SELECTED) || this.getSelectionType().equals((Object)SelectionType.SELECTED)) {
            newType = SelectionType.UNSELECTED;
        } else if (this.getSelectionType().equals((Object)SelectionType.UNSELECTED)) {
            newType = SelectionType.SELECTED;
        } else {
            return;
        }
        this.changeSelection(newType);
    }

    public SelectionTreeNode getNextNode() {
        return this.nextNode;
    }

    public SelectionTreeNode getPreviousNode() {
        return this.previousNode;
    }

    protected void changeSelection(SelectionType newType) {
        this.tree.fireSelectionChangeStarted(this);
        if (this.setSelectionType(newType) && this.tree.isParentDependsOnChildren()) {
            this.updateChildren();
            if (this.parent != null) {
                this.parent.updateSelection();
            }
        }
        this.tree.fireSelectionChangeFinished(this);
    }

    protected void updateSelection() {
        this.updateSelection(false);
    }

    protected void updateSelection(boolean forceParentUpdate) {
        boolean selected = false;
        boolean unselected = false;
        Iterator<SelectionTreeNode> it = this.children.iterator();
        while (it.hasNext()) {
            SelectionType selectionType = it.next().getSelectionType();
            switch (selectionType) {
                case UNSELECTED: {
                    unselected = true;
                    break;
                }
                case SELECTED: {
                    selected = true;
                    break;
                }
                case PARTIALLY_SELECTED: {
                    selected = true;
                    unselected = true;
                }
            }
        }
        boolean changed = true;
        if (selected && !unselected) {
            changed = this.setSelectionType(SelectionType.SELECTED);
        } else if (unselected && !selected) {
            changed = this.setSelectionType(SelectionType.UNSELECTED);
        } else if (selected && unselected) {
            changed = this.setSelectionType(SelectionType.PARTIALLY_SELECTED);
        }
        if (this.parent != null && (changed || forceParentUpdate)) {
            this.parent.updateSelection(forceParentUpdate);
        }
    }

    private void updateChildren() {
        SelectionType selectionType = this.element.getSelectionType();
        if (SelectionType.SELECTED.equals((Object)selectionType) || SelectionType.UNSELECTED.equals((Object)selectionType)) {
            for (SelectionTreeNode child : this.children) {
                if (!child.setSelectionType(selectionType)) continue;
                child.updateChildren();
            }
        }
    }

    protected SelectionType getSelectionType() {
        return this.element.getSelectionType();
    }

    private boolean setSelectionType(SelectionType selectionType) {
        SelectionType oldType = this.getSelectionType();
        this.element.setSelectionType(selectionType);
        if (!selectionType.equals((Object)oldType)) {
            this.updateNode();
            this.tree.fireSelectionTypeChanged(this, oldType, selectionType);
            return true;
        }
        return false;
    }

    public void updateNode() {
        ((DefaultTreeModel)this.tree.getModel()).nodeChanged(this);
    }

    public String toString() {
        return this.element.getDisplayableName();
    }

    public SelectionElement getSelectionElement() {
        return this.element;
    }

    private SelectionTreeNode[] getPathToRoot(SelectionTreeNode aNode, int depth) {
        SelectionTreeNode[] result;
        if (aNode == null) {
            if (depth == 0) {
                return null;
            }
            result = new SelectionTreeNode[depth];
        } else {
            result = this.getPathToRoot(aNode.getParent(), ++depth);
            result[result.length - depth] = aNode;
        }
        return result;
    }

    public TreePath getPath() {
        return new TreePath(this.getPathToRoot(this, 0));
    }

    public SelectionTree getTree() {
        return this.tree;
    }
}

