/*
 * Decompiled with CFR 0.152.
 */
package com.sun.demots.tests.bignum;

import com.sun.demoapi.BigNum;
import com.sun.javatest.Status;
import com.sun.javatest.Test;
import java.io.PrintWriter;

public class AddTest
implements Test {
    private PrintWriter err;

    public static void main(String[] args) {
        PrintWriter err = new PrintWriter(System.err, true);
        AddTest t = new AddTest();
        Status s = t.run(args, null, err);
        s.exit();
    }

    public Status run(String[] args, PrintWriter out, PrintWriter err) {
        this.err = err;
        boolean ok = true;
        ok &= this.test("-12345678901234567890", "-12345678901234567890", "-24691357802469135780");
        ok &= this.test("-12345678901234567890", "-1234567890", "-12345678902469135780");
        ok &= this.test("-12345678901234567890", "-123", "-12345678901234568013");
        ok &= this.test("-12345678901234567890", "0", "-12345678901234567890");
        ok &= this.test("-12345678901234567890", "123", "-12345678901234567767");
        ok &= this.test("-12345678901234567890", "1234567890", "-12345678900000000000");
        ok &= this.test("-12345678901234567890", "12345678901234567890", "0");
        ok &= this.test("-1234567890", "-12345678901234567890", "-12345678902469135780");
        ok &= this.test("-1234567890", "-1234567890", "-2469135780");
        ok &= this.test("-1234567890", "-123", "-1234568013");
        ok &= this.test("-1234567890", "0", "-1234567890");
        ok &= this.test("-1234567890", "123", "-1234567767");
        ok &= this.test("-1234567890", "1234567890", "0");
        ok &= this.test("-1234567890", "12345678901234567890", "12345678900000000000");
        ok &= this.test("-123", "-12345678901234567890", "-12345678901234568013");
        ok &= this.test("-123", "-1234567890", "-1234568013");
        ok &= this.test("-123", "-123", "-246");
        ok &= this.test("-123", "0", "-123");
        ok &= this.test("-123", "123", "0");
        ok &= this.test("-123", "1234567890", "1234567767");
        ok &= this.test("-123", "12345678901234567890", "12345678901234567767");
        ok &= this.test("0", "-12345678901234567890", "-12345678901234567890");
        ok &= this.test("0", "-1234567890", "-1234567890");
        ok &= this.test("0", "-123", "-123");
        ok &= this.test("0", "0", "0");
        ok &= this.test("0", "123", "123");
        ok &= this.test("0", "1234567890", "1234567890");
        ok &= this.test("0", "12345678901234567890", "12345678901234567890");
        ok &= this.test("123", "-12345678901234567890", "-12345678901234567767");
        ok &= this.test("123", "-1234567890", "-1234567767");
        ok &= this.test("123", "-123", "0");
        ok &= this.test("123", "0", "123");
        ok &= this.test("123", "123", "246");
        ok &= this.test("123", "1234567890", "1234568013");
        ok &= this.test("123", "12345678901234567890", "12345678901234568013");
        ok &= this.test("1234567890", "-12345678901234567890", "-12345678900000000000");
        ok &= this.test("1234567890", "-1234567890", "0");
        ok &= this.test("1234567890", "-123", "1234567767");
        ok &= this.test("1234567890", "0", "1234567890");
        ok &= this.test("1234567890", "123", "1234568013");
        ok &= this.test("1234567890", "1234567890", "2469135780");
        ok &= this.test("1234567890", "12345678901234567890", "12345678902469135780");
        ok &= this.test("12345678901234567890", "-12345678901234567890", "0");
        ok &= this.test("12345678901234567890", "-1234567890", "12345678900000000000");
        ok &= this.test("12345678901234567890", "-123", "12345678901234567767");
        ok &= this.test("12345678901234567890", "0", "12345678901234567890");
        ok &= this.test("12345678901234567890", "123", "12345678901234568013");
        ok &= this.test("12345678901234567890", "1234567890", "12345678902469135780");
        if (ok &= this.test("12345678901234567890", "12345678901234567890", "24691357802469135780")) {
            return Status.passed((String)"OK");
        }
        return Status.failed((String)"one or more test cases failed");
    }

    boolean test(String s1, String s2, String expectedResult) {
        BigNum bn1 = new BigNum(s1);
        BigNum bn2 = new BigNum(s2);
        BigNum sum = bn1.add(bn2);
        if (sum.toString().equals(expectedResult)) {
            return true;
        }
        this.err.println("s1: " + s1 + " s2: " + s2 + " expected result: " + expectedResult + " actual result: " + sum);
        return false;
    }
}

