/*
 * Decompiled with CFR 0.152.
 */
package com.sun.demots.tests.lists.LinkedList;

import com.sun.demoapi.lists.LinkedList;
import com.sun.javatest.Status;
import com.sun.javatest.Test;
import java.io.PrintWriter;

public class EqualsTest
implements Test {
    private PrintWriter err;

    public static void main(String[] args) {
        PrintWriter err = new PrintWriter(System.err, true);
        EqualsTest t = new EqualsTest();
        Status s = t.run(args, null, err);
        s.exit();
    }

    public Status run(String[] args, PrintWriter out, PrintWriter err) {
        this.err = err;
        boolean ok = true;
        Integer one = new Integer(1);
        Integer two = new Integer(2);
        Integer three = new Integer(3);
        ok &= this.positive_test(new Object[0]);
        ok &= this.positive_test(new Object[]{null});
        ok &= this.positive_test(new Object[]{"a"});
        ok &= this.positive_test(new Object[]{one, "a"});
        ok &= this.positive_test(new Object[]{one, null, "a"});
        ok &= this.positive_test(new Object[]{"a", "b", "c", "d"});
        ok &= this.positive_test(new Object[]{one, two, three});
        ok &= this.positive_test(new Object[]{one, "a", null, two});
        ok &= this.positive_test(new Object[]{"a", "a", "a", "a"});
        ok &= this.positive_test(new Object[]{"a", "a", one, one});
        ok &= this.positive_test(new Object[]{"a", one, "a", one});
        ok &= this.negative_test(new Object[0], new Object[]{"a"});
        ok &= this.negative_test(new Object[]{"a"}, new Object[]{"b"});
        ok &= this.negative_test(new Object[]{"a"}, new Object[]{one});
        ok &= this.negative_test(new Object[]{"a"}, new Object[]{null});
        ok &= this.negative_test(new Object[]{"a", one}, new Object[]{"b", one});
        ok &= this.negative_test(new Object[]{"a", one}, new Object[]{one, one});
        ok &= this.negative_test(new Object[]{"a", one}, new Object[]{null, one});
        ok &= this.negative_test(new Object[]{"a", one}, new Object[]{"a", one, "b"});
        ok &= this.negative_test(new Object[]{"a", one}, one);
        if (ok &= this.negative_test(new Object[]{"a", one}, "a")) {
            return Status.passed((String)"OK");
        }
        return Status.failed((String)"one or more test cases failed");
    }

    boolean positive_test(Object[] data) {
        LinkedList list1 = new LinkedList();
        LinkedList list2 = new LinkedList();
        for (int i = 0; i < data.length; ++i) {
            list1.insert(data[data.length - i - 1]);
            list2.append(data[i]);
        }
        if (!list1.equals((Object)list2)) {
            this.err.println("mismatch:");
            this.err.println("  list1: " + list1);
            this.err.println("  list2: " + list2);
            return false;
        }
        return true;
    }

    boolean negative_test(Object[] data1, Object[] data2) {
        LinkedList list1 = new LinkedList();
        for (int i = 0; i < data1.length; ++i) {
            list1.insert(data1[data1.length - i - 1]);
        }
        LinkedList list2 = new LinkedList();
        for (int i = 0; i < data2.length; ++i) {
            list2.insert(data2[data2.length - i - 1]);
        }
        if (list1.equals((Object)list2)) {
            this.err.println("lists matched unexpectedly:");
            this.err.println("  list1: " + list1);
            this.err.println("  list2: " + list2);
            return false;
        }
        return true;
    }

    boolean negative_test(Object[] data1, Object data2) {
        LinkedList list1 = new LinkedList();
        for (int i = 0; i < data1.length; ++i) {
            list1.insert(data1[data1.length - i - 1]);
        }
        if (list1.equals(data2)) {
            this.err.println("lists matched unexpectedly:");
            this.err.println("  list1: " + list1);
            this.err.println("  data2: " + data2);
            return false;
        }
        return true;
    }
}

