/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview.wizard;

import java.awt.Color;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

class I18NResourceBundle
extends ResourceBundle {
    private static I18NResourceBundle defaultBundle;
    private String name;
    private ResourceBundle delegate;
    private ClassLoader classLoader;
    private boolean logging;
    private static String logClassPrefix;

    static I18NResourceBundle getDefaultBundle() {
        if (defaultBundle == null) {
            defaultBundle = I18NResourceBundle.getBundleForClass(I18NResourceBundle.class);
        }
        return defaultBundle;
    }

    public static I18NResourceBundle getBundleForClass(Class c) {
        String cn = c.getName();
        int dot = cn.lastIndexOf(46);
        String rn = dot == -1 ? "i18n" : cn.substring(0, dot) + ".i18n";
        boolean logging = logClassPrefix == null ? false : cn.startsWith(logClassPrefix);
        return new I18NResourceBundle(rn, logging, c.getClassLoader());
    }

    public String getString(String key, Object arg) {
        return this.getString(key, new Object[]{arg});
    }

    public String getString(String key, Object[] args) {
        try {
            return MessageFormat.format(this.getString(key), args);
        }
        catch (MissingResourceException e) {
            this.showError(key, this.name);
            return key;
        }
    }

    public Color getColor(String key, int dflt) {
        String value = this.getString(key + ".clr");
        try {
            if (value != null) {
                return Color.decode(value);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return new Color(dflt);
    }

    public Color getErrorColor() {
        return this.getColor("i18n.error", 0xFF0000);
    }

    private I18NResourceBundle(String name, boolean logging, ClassLoader cl) {
        this.name = name;
        this.logging = logging;
        this.classLoader = cl;
    }

    protected Object handleGetObject(String key) throws MissingResourceException {
        if (this.logging) {
            System.out.println("i18n: " + key);
        }
        try {
            if (this.delegate == null) {
                this.delegate = ResourceBundle.getBundle(this.name, Locale.getDefault(), this.classLoader);
            }
            return this.delegate.getObject(key);
        }
        catch (MissingResourceException e) {
            this.showError(key, this.name);
            return key;
        }
    }

    public Enumeration getKeys() {
        if (this.delegate == null) {
            this.delegate = ResourceBundle.getBundle(this.name, Locale.getDefault(), this.classLoader);
        }
        return this.delegate.getKeys();
    }

    private void showError(String key, String name) {
        System.err.println("WARNING: missing resource: " + key + " for " + name);
    }

    static {
        logClassPrefix = System.getProperty("i18n.log");
    }
}

