/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.NewJavaTestSecurityManager;
import java.io.FileDescriptor;
import java.net.InetAddress;

public class JavaTestSecurityManager
extends SecurityManager {
    private static boolean allowExit = false;
    private static boolean allowPropertiesAccess = true;
    private static boolean verbose = Boolean.getBoolean("javatest.security.verbose");

    public JavaTestSecurityManager() {
        String s = System.getProperty("javatest.security.allowPropertiesAccess");
        if (s != null) {
            allowPropertiesAccess = Boolean.valueOf(s);
        }
    }

    public static void install() {
        block6: {
            try {
                String noSecurityMgr = "javatest.security.noSecurityManager";
                if (Boolean.getBoolean("javatest.security.noSecurityManager")) {
                    System.err.println();
                    System.err.println("     ---- WARNING -----");
                    System.err.println();
                    System.err.println("JT Harness did not install its own Security Manager");
                    System.err.println("because the property javatest.security.noSecurityManager was set.");
                    System.err.println("This is not a fatal error, but it may affect the");
                    System.err.println("execution of sameJVM tests");
                    System.err.println();
                } else {
                    try {
                        Class.forName("java.security.Permission");
                        System.setSecurityManager(new NewJavaTestSecurityManager());
                    }
                    catch (ClassNotFoundException e) {
                        System.setSecurityManager(new JavaTestSecurityManager());
                    }
                }
            }
            catch (SecurityException e) {
                SecurityManager sm = System.getSecurityManager();
                if (sm instanceof JavaTestSecurityManager) break block6;
                System.err.println();
                System.err.println("     ---- WARNING -----");
                System.err.println();
                System.err.println("JT Harness could not install its own Security Manager");
                System.err.println("because of the following exception:");
                System.err.println("     " + e);
                System.err.println("This is not a fatal error, but it may affect the");
                System.err.println("execution of sameJVM tests");
                System.err.println();
            }
        }
    }

    public void checkAccept(String host, int port) {
    }

    public void checkAccess(Thread g) {
    }

    public void checkAccess(ThreadGroup g) {
    }

    public void checkConnect(String host, int port) {
    }

    public void checkConnect(String host, int port, Object context) {
    }

    public void checkCreateClassLoader() {
    }

    public void checkDelete(String file) {
    }

    public void checkExec(String cmd) {
    }

    public void checkExit(int status) {
        if (!allowExit) {
            if (verbose) {
                System.err.println(this.getClass().getName() + ": System.exit() forbidden");
                new Throwable().printStackTrace();
            }
            throw new SecurityException("System.exit() forbidden by JT Harness");
        }
    }

    public void checkLink(String lib) {
    }

    public void checkListen(int port) {
    }

    public void checkPackageAccess(String pkg) {
    }

    public void checkPackageDefinition(String pkg) {
    }

    public synchronized void checkPropertiesAccess() {
        if (!allowPropertiesAccess) {
            if (verbose) {
                System.err.println(this.getClass().getName() + ": properties access forbidden");
                new Throwable().printStackTrace();
            }
            throw new SecurityException("Action forbidden by JT Harness: checkPropertiesAccess");
        }
    }

    public void checkPropertyAccess(String key) {
    }

    public void checkRead(FileDescriptor fd) {
    }

    public void checkRead(String file) {
    }

    public void checkRead(String file, Object context) {
    }

    public void checkSetFactory() {
    }

    public boolean checkTopLevelWindow(Object window) {
        return true;
    }

    public void checkWrite(FileDescriptor fd) {
    }

    public void checkWrite(String file) {
    }

    public void checkAwtEventQueueAccess() {
    }

    public void checkMemberAccess(Class clazz, int which) {
    }

    public void checkMulticast(InetAddress maddr) {
    }

    public void checkMulticast(InetAddress maddr, byte ttl) {
    }

    public void checkPrintJobAccess() {
    }

    public void checkSecurityAccess(String provider) {
    }

    public void checkSystemClipboardAccess() {
    }

    public boolean setAllowExit(boolean bool) {
        boolean prev = allowExit;
        allowExit = bool;
        return prev;
    }

    public boolean setAllowPropertiesAccess(boolean bool) {
        boolean prev = allowPropertiesAccess;
        allowPropertiesAccess = bool;
        return prev;
    }
}

