/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class ResourceLoader {
    private static final String EXT_DIR_NAME = "jtExt";
    private static File ext = null;
    private static ClassLoader altClassLoader;

    public static Enumeration getResources(String name, Class ownClass) throws IOException {
        URL extResource = ResourceLoader.getExtResource(name, null);
        if (extResource != null) {
            Vector<URL> r = new Vector<URL>();
            r.add(extResource);
            return r.elements();
        }
        return ownClass.getClassLoader().getResources(name);
    }

    public static InputStream getResourceAsStream(String name, Class ownClass) {
        URL url = ResourceLoader.getExtResource(name, ownClass);
        try {
            if (url != null) {
                return url.openStream();
            }
            return ownClass.getResourceAsStream(name);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static File getResourceFile(String name, Class ownClass) {
        File f = ResourceLoader.getExtResourceFile(name, ownClass);
        if (f != null) {
            return f;
        }
        return new File(ownClass.getResource(name).getFile());
    }

    private static URL getExtResource(String name, Class ownClass) {
        URL ret = null;
        File rf = ResourceLoader.getExtResourceFile(name, ownClass);
        if (rf != null) {
            try {
                ret = rf.toURI().toURL();
            }
            catch (MalformedURLException ex) {
                // empty catch block
            }
        }
        return ret;
    }

    private static File getExtResourceFile(String name, Class ownClass) {
        if (ext != null) {
            String relName = ownClass == null ? name : ResourceLoader.resolveName(name, ownClass);
            File resFile = new File(ResourceLoader.getExt(), relName);
            if (resFile.exists()) {
                return resFile;
            }
        }
        return null;
    }

    private static String resolveName(String name, Class baseClass) {
        if (name == null || baseClass == null) {
            return name;
        }
        if (!name.startsWith("/")) {
            String baseName = baseClass.getName();
            int index = baseName.lastIndexOf(46);
            if (index != -1) {
                name = baseName.substring(0, index).replace('.', '/') + "/" + name;
            }
        } else {
            name = name.substring(1);
        }
        return name;
    }

    static File getExt() {
        return ext;
    }

    static void setExt(File aExt) {
        ext = aExt;
    }

    public static ResourceBundle getBundle(String name, Locale aDefault, ClassLoader classLoader) {
        if (ext != null) {
            ResourceLoader.initAltClassLoader();
            ResourceBundle altB = ResourceBundle.getBundle(name, aDefault, altClassLoader);
            if (altB.getKeys().hasMoreElements()) {
                return altB;
            }
        }
        return ResourceBundle.getBundle(name, aDefault, classLoader);
    }

    public static ResourceBundle getBundle(String name) {
        if (ext != null) {
            ResourceLoader.initAltClassLoader();
            ResourceBundle altB = ResourceBundle.getBundle(name, Locale.getDefault(), altClassLoader);
            if (altB.getKeys().hasMoreElements()) {
                return altB;
            }
        }
        return ResourceBundle.getBundle(name);
    }

    private static synchronized void initAltClassLoader() {
        if (ext != null && altClassLoader == null) {
            try {
                altClassLoader = new URLClassLoader(new URL[]{ext.toURI().toURL()});
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    static {
        String jcp = System.getProperty("java.class.path");
        String psep = System.getProperty("path.separator");
        File altRoot = null;
        if (jcp != null && psep != null) {
            StringTokenizer tokenizer = new StringTokenizer(jcp, psep);
            while (tokenizer.hasMoreTokens()) {
                File extTmp;
                File component = new File(tokenizer.nextToken());
                if (!component.exists() || !(extTmp = new File(altRoot = component.isDirectory() ? component : component.getParentFile(), EXT_DIR_NAME)).exists()) continue;
                ext = extTmp;
                break;
            }
        }
    }
}

