/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.agent;

import com.sun.javatest.agent.Agent;
import com.sun.javatest.agent.BadValue;
import com.sun.javatest.agent.ConnectionFactory;
import com.sun.javatest.agent.ModeOptions;
import com.sun.javatest.agent.PassiveConnectionFactory;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Label;
import java.awt.TextField;
import java.io.IOException;

class PassiveModeOptions
extends ModeOptions {
    private Label portLabel;
    private TextField portField;

    PassiveModeOptions() {
        super("passive");
        GridBagConstraints c = new GridBagConstraints();
        this.portLabel = new Label("port:");
        c.weightx = 0.0;
        this.add((Component)this.portLabel, c);
        String defPassPort = Integer.toString(1908);
        this.portField = new TextField(defPassPort, 5);
        c.weightx = 1.0;
        c.anchor = 17;
        this.add((Component)this.portField, c);
    }

    ConnectionFactory createConnectionFactory(int concurrency) throws BadValue, ConnectionFactory.Fault {
        try {
            int port = ModeOptions.getInt("port", this.portField);
            if (port < 0) {
                throw new BadValue("port may not be negative");
            }
            if (!Agent.isValidConcurrency(concurrency)) {
                throw new BadValue("concurrency may not be negative");
            }
            return new PassiveConnectionFactory(port, concurrency);
        }
        catch (IOException e) {
            throw new ConnectionFactory.Fault(e, true);
        }
    }

    void setPort(int port) {
        this.portField.setText(Integer.toString(port));
    }
}

