/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.agent;

import com.sun.javatest.JavaTestSecurityManager;
import com.sun.javatest.agent.Connection;
import com.sun.javatest.util.Timer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Hashtable;

public class SocketConnection
implements Connection {
    private final Socket socket;
    protected final InputStream socketInput;
    private final OutputStream socketOutput;
    private String name;
    private boolean closed;
    private Thread waitThread;
    private static Timer timer = new Timer();
    private static Hashtable addressCache = new Hashtable();

    public SocketConnection(Socket socket) throws IOException {
        if (socket == null) {
            throw new NullPointerException();
        }
        this.socket = socket;
        this.socketInput = socket.getInputStream();
        this.socketOutput = socket.getOutputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketConnection(String host, int port) throws IOException {
        if (host == null) {
            throw new NullPointerException();
        }
        SecurityManager sm = System.getSecurityManager();
        JavaTestSecurityManager jtSm = null;
        boolean prev = false;
        if (sm != null && sm instanceof JavaTestSecurityManager) {
            jtSm = (JavaTestSecurityManager)sm;
            prev = jtSm.setAllowPropertiesAccess(true);
        }
        try {
            this.socket = new Socket(host, port);
        }
        finally {
            if (jtSm != null) {
                jtSm.setAllowPropertiesAccess(prev);
            }
        }
        this.socketInput = this.socket.getInputStream();
        this.socketOutput = this.socket.getOutputStream();
    }

    public String getName() {
        if (this.name == null) {
            StringBuffer sb = new StringBuffer(32);
            sb.append(SocketConnection.getHostName(this.socket.getInetAddress()));
            sb.append(",port=");
            sb.append(this.socket.getPort());
            sb.append(",localport=");
            sb.append(this.socket.getLocalPort());
            this.name = sb.toString();
        }
        return this.name;
    }

    public InputStream getInputStream() {
        return this.socketInput;
    }

    public OutputStream getOutputStream() {
        return this.socketOutput;
    }

    public synchronized void close() throws IOException {
        this.socket.close();
        this.socketInput.close();
        this.socketOutput.close();
        this.closed = true;
        if (this.waitThread != null) {
            this.waitThread.interrupt();
        }
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilClosed(int timeout) throws InterruptedException {
        SocketConnection socketConnection = this;
        synchronized (socketConnection) {
            this.waitThread = Thread.currentThread();
        }
        Timer.Timeable cb = new Timer.Timeable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void timeout() {
                SocketConnection socketConnection = SocketConnection.this;
                synchronized (socketConnection) {
                    if (SocketConnection.this.waitThread != null) {
                        SocketConnection.this.waitThread.interrupt();
                    }
                    try {
                        SocketConnection.this.socketInput.close();
                    }
                    catch (IOException ignore) {
                        // empty catch block
                    }
                    try {
                        SocketConnection.this.socketOutput.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        };
        Timer.Entry e = timer.requestDelayedCallback(cb, timeout);
        try {
            try {
                int i;
                while ((i = this.socketInput.read()) != -1) {
                }
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
        finally {
            timer.cancel(e);
            SocketConnection socketConnection2 = this;
            synchronized (socketConnection2) {
                this.waitThread = null;
            }
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
        }
    }

    private static String getHostName(InetAddress addr) {
        String s = (String)addressCache.get(addr);
        if (s == null) {
            s = addr.getHostName();
            addressCache.put(addr, s);
        }
        return s;
    }

    public static ServerSocket createServerSocket(int port) throws IOException {
        return SocketConnection.createServerSocket(port, 50);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized ServerSocket createServerSocket(int port, int backlog) throws IOException {
        SecurityManager sm = System.getSecurityManager();
        JavaTestSecurityManager jtSm = null;
        boolean prev = false;
        if (sm != null && sm instanceof JavaTestSecurityManager) {
            jtSm = (JavaTestSecurityManager)sm;
            prev = jtSm.setAllowPropertiesAccess(true);
        }
        try {
            ServerSocket serverSocket;
            ServerSocket serverSocket2 = serverSocket = new ServerSocket(port, backlog);
            return serverSocket2;
        }
        finally {
            if (jtSm != null) {
                jtSm.setAllowPropertiesAccess(prev);
            }
        }
    }
}

