/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.exec.BranchPanel;
import com.sun.javatest.exec.Monitor;
import com.sun.javatest.exec.MonitorState;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.I18NResourceBundle;
import java.awt.EventQueue;
import javax.accessibility.AccessibleContext;
import javax.help.CSH;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTextField;

class ElapsedTimeMonitor
extends Monitor
implements MonitorState.Observer {
    private SmallTimer smTimer;
    private ThreadGroup activeThreads = new ThreadGroup("elapsed time monitors");
    private boolean isRunning;
    private static I18NResourceBundle i18n;

    ElapsedTimeMonitor(MonitorState ms, UIFactory uif) {
        super(ms, uif);
        ms.addObserver(this);
    }

    public String getSmallMonitorName() {
        return this.uif.getI18NString("et.sm.Name");
    }

    public Icon getSmallMonitorIcon() {
        return null;
    }

    public JComponent getSmallMonitor() {
        if (this.smTimer == null) {
            this.smTimer = new SmallTimer(this.uif, this.state);
        }
        if (this.isRunning) {
            this.smTimer.start();
        } else {
            this.smTimer.update();
        }
        return this.smTimer;
    }

    public String getLargeMonitorName() {
        return this.uif.getI18NString("et.lg.Name");
    }

    public Icon getLargeMonitorIcon() {
        return null;
    }

    public JComponent getLargeMonitor() {
        return null;
    }

    public void starting() {
        this.isRunning = true;
        if (this.smTimer != null) {
            this.smTimer.start();
        }
    }

    public void postProcessing() {
        if (this.smTimer != null) {
            this.smTimer.stop();
        }
    }

    public void stopping() {
    }

    public void finished(boolean allOk) {
        this.isRunning = false;
        this.stopAll();
    }

    private void stopAll() {
        if (this.smTimer != null) {
            this.smTimer.stop();
        }
    }

    static final String millisToString(long millis) {
        if (i18n == null) {
            i18n = I18NResourceBundle.getBundleForClass(ElapsedTimeMonitor.class);
        }
        int seconds = (int)(millis / 1000L % 60L);
        int minutes = (int)(millis / 60000L % 60L);
        int hours = (int)(millis / 3600000L);
        String h = hours < 10 ? "0" + Integer.toString(hours) : Integer.toString(hours);
        String m = minutes < 10 ? "0" + Integer.toString(minutes) : Integer.toString(minutes);
        String s = seconds < 10 ? "0" + Integer.toString(seconds) : Integer.toString(seconds);
        Object[] args = new String[]{h, m, s};
        return i18n.getString("etm.hms", args);
    }

    static class SmallTimer
    extends JTextField {
        private String prefix;
        private MonitorState state;
        private UIFactory uif;
        private volatile Thread myThread;

        SmallTimer(UIFactory uif, MonitorState ms) {
            super("et.sm");
            this.state = ms;
            this.uif = uif;
            this.setHorizontalAlignment(2);
            this.setOpaque(false);
            this.setBackground(UIFactory.Colors.TRANSPARENT.getValue());
            this.setEnabled(true);
            this.setVisible(true);
            this.setEditable(false);
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setText("00:00:00");
            uif.setToolTip(this, "et.sm");
            AccessibleContext ac = this.getAccessibleContext();
            ac.setAccessibleName(uif.getI18NString("et.sm.name"));
            CSH.setHelpIDString(this, "run.testProgress");
            this.update();
        }

        public void start() {
            this.myThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    while (SmallTimer.this.myThread == 1.currentThread()) {
                        try {
                            Thread thread = SmallTimer.this.myThread;
                            synchronized (thread) {
                                SmallTimer.this.myThread.wait(1000L);
                                SmallTimer.this.update();
                            }
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                    SmallTimer.this.update();
                }
            };
            this.myThread.setPriority(4);
            this.myThread.start();
        }

        public void stop() {
            this.myThread = null;
        }

        private void update() {
            if (!EventQueue.isDispatchThread()) {
                EventQueue.invokeLater(new BranchPanel.TextUpdater(this, ElapsedTimeMonitor.millisToString(this.state.getElapsedTime()), this.uif));
            } else {
                this.setText(ElapsedTimeMonitor.millisToString(this.state.getElapsedTime()));
            }
        }
    }
}

